/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public final class CharUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private CharUtils() {
    }

    public static String unicodeEscapeInvalidChars(String s, String encoding) {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            return CharUtils.unicodeEscapeNonASCIIChars(s);
        }
        Charset cs = Charset.forName(encoding);
        if (cs == null) {
            return CharUtils.unicodeEscapeNonASCIIChars(s);
        }
        CharsetEncoder cse = cs.newEncoder();
        StringBuilder sb = new StringBuilder(s);
        int length = sb.length();
        for (int i = 0; i < length; ++i) {
            char c = sb.charAt(i);
            if (cse.canEncode(c)) continue;
            i = CharUtils.escapeChar(sb, i);
        }
        return sb.toString();
    }

    private static String unicodeEscapeNonASCIIChars(String s) {
        StringBuilder sb = new StringBuilder(s);
        int length = sb.length();
        for (int i = 0; i < length; ++i) {
            char c = sb.charAt(i);
            if (c <= '\u007f') continue;
            i = CharUtils.escapeChar(sb, i);
        }
        return sb.toString();
    }

    private static int escapeChar(StringBuilder sb, int offset) {
        char c = sb.charAt(offset);
        sb.setCharAt(offset++, '\\');
        char[] ci = new char[]{'u', HEX_CHARS[c >> 12 & 0xF], HEX_CHARS[c >> 8 & 0xF], HEX_CHARS[c >> 4 & 0xF], HEX_CHARS[c & 0xF]};
        sb.insert(offset, ci);
        return offset + 4;
    }
}

