/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionRolledbackException;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.rmi.spi.Interceptor;
import weblogic.transaction.CoordinatorService;
import weblogic.transaction.InterposedTransactionManager;
import weblogic.transaction.RollbackException;
import weblogic.transaction.ServerTransactionInterceptor;
import weblogic.transaction.TMXAResourceInterface;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionInterceptor;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TransactionSystemException;
import weblogic.transaction.UserTransaction;
import weblogic.transaction.internal.AbortRequestedException;
import weblogic.transaction.internal.AppSetRollbackOnlyException;
import weblogic.transaction.internal.ClientTransactionManagerImpl;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.InterposedTransactionManagerXAResource;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.PropagationContext;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TimedOutException;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XAResourceHelper;
import weblogic.transaction.internal.XidImpl;
import weblogic.transaction.loggingresource.LoggingResource;
import weblogic.transaction.nonxa.NonXAResource;

public abstract class TransactionManagerImpl
implements Serializable,
Interceptor,
InterposedTransactionManager,
UserTransaction,
TransactionManager,
ServerTransactionInterceptor,
TransactionSynchronizationRegistry {
    private static final long serialVersionUID = 6667343049945344440L;
    protected static final Object singletonLock = new Object();
    public transient ConcurrentHashMap<Xid, TransactionImpl> txMap = null;
    protected volatile int defaultTimeoutSec = 30;
    protected int abandonTimeoutSec = 86400;
    protected int completionTimeoutSec = 0;
    public List<TransactionImpl> timedOutTransactions = Collections.synchronizedList(new ArrayList(250));
    protected boolean isTwoPhaseCommitEnabled = true;
    protected boolean isClusterwideRecoveryEnabled;
    protected boolean isTightlyCoupledTransactionsEnabled;
    protected boolean isTLOGWriteWhenDeterminerExistsEnabled;
    protected int shutdownGracePeriod;
    protected volatile String siteName;
    protected volatile String recoverySiteName;
    protected String[] determiners;
    public ConcurrentHashMap<String, String[]> partitionDeterminersMap = new ConcurrentHashMap(1);
    protected int maxRetrySecondsBeforeDeterminerFail;
    protected int crossDomainRecoveryRetryInterval;
    protected int crossSiteRecoveryRetryInterval;
    protected int crossSiteRecoveryLeaseExpiration;
    protected int crossSiteRecoveryLeaseUpdate;
    protected boolean isJdbcTLogEnabled;
    protected String jdbcTLogPrefixName;
    protected int jdbcTLogMaxRetrySecondsBeforeTLOGFail;
    protected int jdbcTLogMaxRetrySecondsBeforeTXException;
    protected int jdbcTLogRetryIntervalSeconds;
    protected String jdbcTLogDataSource;
    protected boolean isJdbcTLogInitialized;
    private volatile List<String> unRegisteredDeterminerList = new ArrayList<String>();
    private boolean isAnyDeterminerUnregistered;
    protected static final byte[] MIGRATION_TXID_PREFIX = new byte[]{109, 105, 103, 114, 97, 116, 105, 111, 110};
    public static final String CLUSTERCOMMIT = "CLUSTERCOMMIT";
    public static final String CLUSTERROLLBACK = "CLUSTERROLLBACK";
    public static final String CLUSTERFORGET = "CLUSTERFORGET";
    protected long lastTimerFire;
    protected long lastWakeUpDuration;
    private static Throwable timerFailureReason;
    public static boolean initialized;
    protected static final Object txThreadLocal;
    protected TMXAResource tmXARes = null;
    public boolean isReturnTransactionThreadStateAwareITMXAResource = false;
    protected static volatile TransactionManagerImpl singleton;

    protected static void setTimerFailureReason(Throwable reason) {
        timerFailureReason = reason;
    }

    protected TxThreadProperty getThreadProp() {
        return (TxThreadProperty)PlatformHelper.getPlatformHelper().getTxThreadPropertyFromTxThreadLocal(txThreadLocal);
    }

    protected TransactionManagerImpl() {
        TransactionManagerImpl.setTransactionManager(this);
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.internalBegin(null, 0);
    }

    @Override
    public void begin(String name) throws NotSupportedException, SystemException {
        this.internalBegin(name, 0);
    }

    @Override
    public void begin(int timeoutseconds) throws NotSupportedException, SystemException {
        this.internalBegin(null, timeoutseconds);
    }

    @Override
    public void begin(String name, int timeoutseconds) throws NotSupportedException, SystemException {
        this.internalBegin(name, timeoutseconds);
    }

    @Override
    public void begin(Map properties) throws NotSupportedException, SystemException {
        boolean isCompletionTimeoutPropertySet;
        boolean isNamePropertySet = properties != null && properties.get("name") != null && properties.get("name") instanceof String;
        boolean isTimeoutPropertySet = properties != null && properties.get("transaction-timeout") != null && properties.get("transaction-timeout") instanceof Integer;
        this.internalBegin(isNamePropertySet ? (String)properties.get("name") : null, isTimeoutPropertySet ? (Integer)properties.get("transaction-timeout") : 0);
        boolean bl = isCompletionTimeoutPropertySet = properties != null && properties.get("completion-timeout-seconds") != null && properties.get("completion-timeout-seconds") instanceof Integer;
        if (isCompletionTimeoutPropertySet) {
            ((TransactionImpl)this.getTransaction()).setProperty("completion-timeout-seconds", (Serializable)((Object)((Integer)properties.get("completion-timeout-seconds")).toString()));
        }
    }

    private int getTxnTimeoutSeconds() {
        int txTimeout = TransactionManagerImpl.getTM().getDefaultTimeoutSeconds();
        int timeoutForPartition = PlatformHelper.getPlatformHelper().getTimeoutPartition();
        if (timeoutForPartition != -1) {
            txTimeout = timeoutForPartition;
        }
        return txTimeout;
    }

    protected void internalBegin(String name, int timeoutseconds) throws NotSupportedException, SystemException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().begin(name, timeoutseconds);
            return;
        }
        if (!this.isRunning()) {
            throw new SystemException("The server is being suspended or shut down.  Cannot begin new transactions.");
        }
        try {
            TxThreadProperty txp = this.getThreadProp();
            if (txp.current != null && !txp.current.isOver()) {
                if (!txp.isUserTransactionAllowed) {
                    throw new IllegalStateException("Another transaction is associated with this thread. Existing transaction " + txp.current);
                }
                throw new NotSupportedException("Another transaction is associated with this thread. Existing transaction " + txp.current);
            }
            int timeout = timeoutseconds > 0 ? timeoutseconds : (txp.timeoutSec == 0 ? this.getTxnTimeoutSeconds() : txp.timeoutSec);
            TransactionImpl tx = this.createTransaction(TransactionManagerImpl.getNewXID(), timeout, timeout);
            this.associateTxWithThread(tx);
            tx.setOwnerTransactionManager(TransactionManagerImpl.getTM());
            if (name != null) {
                tx.setName(name);
            }
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (NotSupportedException nse) {
            throw nse;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            TXLogger.logBeginUnexpectedException(PlatformHelper.getPlatformHelper().throwable2StackTrace(e));
            throw new SystemException(e.toString());
        }
    }

    @Override
    public final int getStatus() throws SystemException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            return TransactionManagerImpl.getTransactionManager().getStatus();
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        return tx == null ? 6 : tx.getStatus();
    }

    @Override
    public final void commit() throws jakarta.transaction.RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().commit();
            return;
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        if (tx == null) {
            throw new IllegalStateException("A transaction has not been begun in this thread");
        }
        tx.commit();
    }

    @Override
    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().rollback();
            return;
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        if (tx == null) {
            throw new IllegalStateException("Transaction does not exist");
        }
        tx.rollback();
    }

    @Override
    public final void setRollbackOnly() throws IllegalStateException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().setRollbackOnly();
            return;
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        if (tx == null) {
            throw new IllegalStateException("Transaction does not exist");
        }
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException se) {
            throw new IllegalStateException(PlatformHelper.getPlatformHelper().throwable2StackTrace(se));
        }
    }

    @Override
    public jakarta.transaction.Transaction suspend() throws SystemException {
        return this != TransactionManagerImpl.getTransactionManager() ? TransactionManagerImpl.getTransactionManager().suspend() : this.internalSuspend();
    }

    @Override
    public void resume(jakarta.transaction.Transaction atx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().resume(atx);
            return;
        }
        if (atx == null) {
            throw new InvalidTransactionException("Cannot resume a null transaction");
        }
        if (!(atx instanceof TransactionImpl)) {
            throw new InvalidTransactionException("Cannot resume transaction: " + atx.getClass());
        }
        TransactionImpl tx = (TransactionImpl)atx;
        if (tx.isOver() || tx.isCancelled()) {
            throw new InvalidTransactionException("Attempt to resume an inactive transaction: " + tx.getXid().toString());
        }
        if (!tx.isResumePossible()) {
            throw new InvalidTransactionException("Attempt to resume transaction after response(s) sent back to Coordinator");
        }
        TransactionImpl existingTx = this.getTxAssociatedWithThread();
        if (!(existingTx == null || existingTx.equals(tx) || existingTx.isOver() || existingTx.isCancelled())) {
            throw new IllegalStateException("Thread is already associated with another transaction" + PlatformHelper.getPlatformHelper().getEOLConstant() + "{" + existingTx.getXid().toString() + "}");
        }
        this.internalResume(tx);
    }

    @Override
    public final void setTransactionTimeout(int seconds) throws SystemException {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().setTransactionTimeout(seconds);
            return;
        }
        if (seconds < 0) {
            throw new SystemException("Invalid value " + seconds + " passed to setTransactionTimeout(int)");
        }
        TxThreadProperty txp = this.getThreadProp();
        txp.timeoutSec = seconds;
    }

    @Override
    public jakarta.transaction.Transaction getTransaction(Xid xid) {
        jakarta.transaction.Transaction nativeTx;
        if (xid == null) {
            return null;
        }
        if (this.txMap != null && (nativeTx = (jakarta.transaction.Transaction)this.txMap.get(xid)) != null) {
            return nativeTx;
        }
        XidImpl foreignXid = XidImpl.create(xid);
        TransactionImpl transaction = this.tmXARes.get(foreignXid);
        if (transaction == null && TransactionManagerImpl.getTM().isTightlyCoupledTransactionsEnabled) {
            return this.tmXARes.getWithoutBranchqualEquals(foreignXid);
        }
        return transaction;
    }

    @Override
    public void registerStaticResource(String name, XAResource xar) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerStaticResource(String name, XAResource xar, Hashtable properties) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerDynamicResource(String name, XAResource xar) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerDynamicResource(String name, XAResource xar, Hashtable properties) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerDynamicResource(String name, NonXAResource nxar) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerResource(String name, XAResource xar) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerResource(String name, XAResource xar, Hashtable properties) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerResource(String name, XAResource xar, boolean localResourceAssignment) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void registerResource(String name, XAResource xar, Hashtable properties, boolean localResourceAssignment) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be registered only in a server process");
    }

    @Override
    public void unregisterResource(String name) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be unregistered only in a server process");
    }

    @Override
    public void unregisterResource(String name, boolean blocking) throws SystemException {
        throw new SystemException("Resource '" + name + "'can be unregistered only in a server process");
    }

    @Override
    public void registerLoggingResourceTransactions(LoggingResource lr) throws SystemException {
        throw new SystemException("Logging resource transactions can only be registered in a server process");
    }

    @Override
    public void registerFailedLoggingResource(Throwable t) {
        throw new RuntimeException("Failed logging resources can only be registered in a server process");
    }

    @Override
    public void registerCoordinatorService(String serviceName, CoordinatorService cs) {
        throw new AssertionError((Object)"Coordinator services can only be registered in a server process");
    }

    @Override
    public TransactionInterceptor getInterceptor() {
        return TransactionManagerImpl.getTransactionManager();
    }

    @Override
    public jakarta.transaction.Transaction forceSuspend() {
        TransactionManagerImpl tm = TransactionManagerImpl.getTransactionManager();
        return this != tm ? tm.forceSuspend() : this.internalSuspend();
    }

    @Override
    public void forceResume(jakarta.transaction.Transaction atx) {
        TransactionManagerImpl tm = TransactionManagerImpl.getTransactionManager();
        if (this != tm) {
            tm.forceResume(atx);
            return;
        }
        this.internalResume((TransactionImpl)atx);
    }

    public void internalForceSuspend() {
    }

    public void setReturnTransactionThreadStateAwareITMXAResource(boolean isReturnTransactionThreadStateAwareITMXAResource) {
        this.isReturnTransactionThreadStateAwareITMXAResource = isReturnTransactionThreadStateAwareITMXAResource;
    }

    @Override
    public XAResource getXAResource() {
        return this.isReturnTransactionThreadStateAwareITMXAResource ? new InterposedTransactionManagerXAResource(this, this.tmXARes) : this.tmXARes;
    }

    @Override
    public final jakarta.transaction.Transaction getTransaction() {
        if (TransactionManagerImpl.getTransactionManager() != this) {
            return TransactionManagerImpl.getTransactionManager().getTransaction();
        }
        TxThreadProperty txp = this.getThreadProp();
        if (txp == null) {
            return null;
        }
        return txp.current;
    }

    @Override
    public final void setClusterwideRecoveryEnabled(boolean isClusterwideRecoveryEnabled) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setClusterwideRecoveryEnabled(isClusterwideRecoveryEnabled=" + isClusterwideRecoveryEnabled + ")");
        }
        this.isClusterwideRecoveryEnabled = isClusterwideRecoveryEnabled;
    }

    @Override
    public Object sendRequest(Object endPoint) throws RemoteException {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx == null) {
            return null;
        }
        if (tx.getProperty("LOCAL_ENTITY_TX") != null) {
            return null;
        }
        boolean infectCoordinatorFirstTime = PlatformHelper.getPlatformHelper().sendRequest(endPoint);
        if (TxDebug.JTAPropagate.isDebugEnabled()) {
            TxDebug.debugStack(TxDebug.JTAGatewayDetail, "sendRequest " + tx + "), infectCoordinatorFirstTime:" + infectCoordinatorFirstTime);
        }
        if (tx.getCoordinatorDescriptor() == null) {
            throw new RemoteException("Message was not sent because coordinator cannot be assigned");
        }
        if (!tx.isActive()) {
            throw new RemoteException("Message was not sent because transaction is not active. " + tx.getXid().toString());
        }
        tx.incrRepliesOwedMe();
        PropagationContext pctx = tx.getRequestPropagationContext();
        if (infectCoordinatorFirstTime) {
            pctx.infectCoordinatorFirstTime();
        }
        return pctx;
    }

    @Override
    public final void receiveRequest(Object aTxContext) throws RemoteException {
        if (aTxContext != null) {
            TransactionImpl tx = TransactionManagerImpl.getTransactionFromContext(aTxContext);
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAPropagate, "receiveRequest, tx=" + tx);
            }
            if (tx == null) {
                throw new TransactionRolledbackException("Current server is the coordinator and transaction is not found.  It was probably rolled back and forgotten already.");
            }
            if (tx.isCancelled() && !(tx.getRollbackReason() instanceof AppSetRollbackOnlyException)) {
                if (tx.getRollbackReason() == null) {
                    throw new TransactionRolledbackException();
                }
                throw new TransactionRolledbackException(tx.getRollbackReason().getMessage());
            }
            this.internalSuspend();
            tx.incrRepliesOwedOthers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object sendResponse(Object incomingContext) throws RemoteException {
        TransactionImpl tx = null;
        try {
            if (incomingContext == null) {
                Object var3_3 = null;
                return var3_3;
            }
            tx = TransactionManagerImpl.getTransactionFromContext(incomingContext);
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, "sendResponse, tx=" + tx);
            }
            if (tx == null) {
                throw new TransactionRolledbackException("Current server is the coordinator and transaction is not found.  It was probably rolled back and forgotten already.");
            }
            PropagationContext pctx = tx.getResponsePropagationContext();
            if (!tx.decrRepliesOwedOthers()) {
                TransactionRolledbackException rbex = new TransactionRolledbackException("Cannot reply to caller when there are outstanding replies due to this server");
                tx.setRollbackOnly(rbex);
                throw rbex;
            }
            PropagationContext propagationContext = pctx;
            return propagationContext;
        }
        finally {
            if (tx != null) {
                this.suspend(tx);
            } else {
                tx = (TransactionImpl)this.getTransaction();
                if (tx != null) {
                    if (TxDebug.JTAPropagate.isDebugEnabled()) {
                        TxDebug.JTAPropagate.debug("sendResponse, tx associated with thread:" + tx);
                    }
                    this.suspend(tx);
                }
            }
        }
    }

    @Override
    public void receiveAsyncResponse(Object aTxContext) throws RemoteException {
        if (aTxContext != null) {
            TransactionImpl tx = TransactionManagerImpl.getTransactionFromContext(aTxContext);
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAPropagate, "receiveAsyncResponse, tx=" + tx);
            }
            if (tx == null) {
                throw new TransactionRolledbackException("Current server is the coordinator and transaction is not found.  It was probably rolled back and forgotten already.");
            }
            tx.decrRepliesOwedMe();
        }
    }

    @Override
    public void receiveResponse(Object aTxContext) throws RemoteException {
        if (aTxContext != null) {
            TransactionImpl tx = TransactionManagerImpl.getTransactionFromContext(aTxContext);
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAPropagate, "receiveResponse, tx=" + tx);
            }
            if (tx == null) {
                throw new TransactionRolledbackException("Current server is the coordinator and transaction is not found.  It was probably rolled back and forgotten already.");
            }
            tx.decrRepliesOwedMe();
            this.internalResume(tx);
        }
    }

    @Override
    public boolean isParticipant(String serverName) {
        Set<String> allParticipants;
        Transaction tx = (Transaction)TransactionManagerImpl.getTM().getTransaction();
        if (tx != null && (allParticipants = tx.getServerParticipantNames()) != null) {
            return allParticipants.contains(serverName);
        }
        return false;
    }

    @Override
    public boolean needsInterception() {
        Transaction tx = (Transaction)TransactionManagerImpl.getTM().getTransaction();
        return tx != null;
    }

    @Override
    public void dispatchRequest(Object aTxContext) throws RemoteException {
        if (aTxContext != null) {
            TransactionImpl tx = TransactionManagerImpl.getTransactionFromContext(aTxContext);
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, "dispatchRequest, tx=" + tx);
            }
            if (tx == null) {
                return;
            }
            this.internalResume(tx);
            if (tx.isCancelled() && !(tx.getRollbackReason() instanceof AppSetRollbackOnlyException)) {
                if (tx.getRollbackReason() == null) {
                    throw new TransactionRolledbackException();
                }
                throw new TransactionRolledbackException(tx.getRollbackReason().getMessage());
            }
        }
    }

    @Override
    public int getTransactionTimeout(Object context) {
        if (context instanceof PropagationContext) {
            return ((PropagationContext)context).getTimeoutSecs() * 1000;
        }
        return 0;
    }

    protected static final TransactionImpl getTransactionFromContext(Object aTxContext) throws TransactionSystemException {
        if (aTxContext instanceof PropagationContext) {
            return ((PropagationContext)aTxContext).getTransaction();
        }
        if (aTxContext instanceof TransactionImpl) {
            return (TransactionImpl)TransactionManagerImpl.getTM().getTransaction(((TransactionImpl)aTxContext).getXID());
        }
        throw new AssertionError((Object)("Context not a PropagationContext or Transaction: " + aTxContext.getClass().getName()));
    }

    public static boolean isInitialized() {
        return singleton != null && initialized;
    }

    public void suspend(jakarta.transaction.Transaction tx) {
        TransactionImpl txThread = this.getTxAssociatedWithThread();
        if (txThread == null || txThread != tx) {
            return;
        }
        this.internalSuspend();
    }

    public TransactionImpl internalSuspend() {
        return this.associateTxWithThread(null);
    }

    public TransactionImpl internalResume(TransactionImpl tx) {
        return this.associateTxWithThread(tx);
    }

    public final int getTransactionTimeout() {
        TxThreadProperty txp = this.getThreadProp();
        if (txp.timeoutSec == 0) {
            return TransactionManagerImpl.getTM().getDefaultTimeoutSeconds();
        }
        return txp.timeoutSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTransactionManager(TransactionManagerImpl tm) {
        if (singleton == null) {
            Object object = singletonLock;
            synchronized (object) {
                if (singleton == null) {
                    tm.init();
                    singleton = tm;
                }
            }
        }
    }

    public synchronized boolean isXidInTxMap(Xid xid) {
        return this.txMap.containsKey(xid);
    }

    public CoordinatorDescriptor getLocalCoordinatorDescriptor() {
        return null;
    }

    public String getLocalCoordinatorURL() {
        return null;
    }

    public boolean isLocalCoordinator(CoordinatorDescriptor aCoDesc) {
        return false;
    }

    public boolean isLocalCoordinator(String scURL) {
        return false;
    }

    public int getNumTransactions() {
        return this.txMap.size();
    }

    public synchronized Iterator<TransactionImpl> getTransactions() {
        try {
            ArrayList<TransactionImpl> al = new ArrayList<TransactionImpl>(this.txMap.values());
            return al.iterator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized Iterator<TransactionImpl> getTransactions(String partitionName) {
        try {
            Iterator<TransactionImpl> itr = this.txMap.values().iterator();
            int mapSize = 0;
            while (itr.hasNext()) {
                TransactionImpl tx = itr.next();
                Map global = tx.getProperties();
                if (partitionName == null || !partitionName.equals(global.get("weblogic.transaction.partitionName"))) continue;
                ++mapSize;
            }
            ArrayList<TransactionImpl> al = new ArrayList<TransactionImpl>(mapSize);
            for (TransactionImpl tx : this.txMap.values()) {
                Map global = tx.getProperties();
                if (partitionName == null || !partitionName.equals(global.get("weblogic.transaction.partitionName"))) continue;
                al.add(tx);
            }
            return al.iterator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final void setDefaultTimeoutSeconds(int sec) {
        this.defaultTimeoutSec = sec;
    }

    public final int getDefaultTimeoutSeconds() {
        return this.defaultTimeoutSec;
    }

    public final void setAbandonTimeoutSeconds(int sec) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setAbandonTimeoutSeconds(sec=" + sec + ")");
        }
        this.abandonTimeoutSec = sec;
    }

    public final int getAbandonTimeoutSeconds() {
        return this.abandonTimeoutSec;
    }

    public final void setCompletionTimeoutSeconds(int sec) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setCompletionTimeoutSeconds(sec=" + sec + ")");
        }
        this.completionTimeoutSec = sec;
    }

    public final int getCompletionTimeoutSeconds() {
        return this.completionTimeoutSec;
    }

    public final void setTwoPhaseCommitEnabled(boolean twoPhaseCommitEnabled) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setTwoPhaseCommitEnabled(isTwoPhaseCommitEnabled=" + twoPhaseCommitEnabled + ")");
        }
        this.isTwoPhaseCommitEnabled = twoPhaseCommitEnabled;
    }

    public final boolean getTwoPhaseCommitEnabled() {
        return this.isTwoPhaseCommitEnabled;
    }

    public final void setJdbcTLogEnabled(boolean isJdbcTLogEnabled) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setJdbcTLogEnabled(isJdbcTLogEnabled=" + isJdbcTLogEnabled + ")");
        }
        this.isJdbcTLogEnabled = isJdbcTLogEnabled;
    }

    public final boolean getJdbcTLogEnabled() {
        return this.isJdbcTLogEnabled;
    }

    public final void setJdbcTLogPrefixName(String jdbcTLogPrefixName) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setJdbcTLogPrefixName(jdbcTLogPrefixName=" + jdbcTLogPrefixName + ")");
        }
        this.jdbcTLogPrefixName = jdbcTLogPrefixName;
    }

    public final String getJdbcTLogPrefixName() {
        return this.jdbcTLogPrefixName;
    }

    public final void setJdbcTLogMaxRetrySecondsBeforeTLOGFail(int jdbcTLogMaxRetrySecondsBeforeTLOGFail) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setJdbcTLogMaxRetrySecondsBeforeTLOGFail(jdbcTLogMaxRetrySecondsBeforeTLOGFail=" + jdbcTLogMaxRetrySecondsBeforeTLOGFail + ")");
        }
        this.jdbcTLogMaxRetrySecondsBeforeTLOGFail = jdbcTLogMaxRetrySecondsBeforeTLOGFail;
    }

    public final int getJdbcTLogMaxRetrySecondsBeforeTLOGFail() {
        return this.jdbcTLogMaxRetrySecondsBeforeTLOGFail;
    }

    public final void setJdbcTLogMaxRetrySecondsBeforeTXException(int jdbcTLogMaxRetrySecondsBeforeTXException) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setTwoPhaseCommitEnabled(jdbcTLogMaxRetrySecondsBeforeTXException=" + jdbcTLogMaxRetrySecondsBeforeTXException + ")");
        }
        this.jdbcTLogMaxRetrySecondsBeforeTXException = jdbcTLogMaxRetrySecondsBeforeTXException;
    }

    public final int getJdbcTLogMaxRetrySecondsBeforeTXException() {
        return this.jdbcTLogMaxRetrySecondsBeforeTXException;
    }

    public final void setJdbcTLogRetryIntervalSeconds(int jdbcTLogRetryIntervalSeconds) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setJdbcTLogRetryIntervalSeconds(jdbcTLogRetryIntervalSeconds=" + jdbcTLogRetryIntervalSeconds + ")");
        }
        this.jdbcTLogRetryIntervalSeconds = jdbcTLogRetryIntervalSeconds;
    }

    public final int getJdbcTLogRetryIntervalSeconds() {
        return this.jdbcTLogRetryIntervalSeconds;
    }

    public final void setJdbcTLogDataSource(String jdbcTLogDataSource) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setJdbcTLogDataSource(jdbcTLogDataSource=" + jdbcTLogDataSource + ")");
        }
        this.jdbcTLogDataSource = jdbcTLogDataSource;
    }

    public final String getJdbcTLogDataSource() {
        return this.jdbcTLogDataSource;
    }

    public final void setJdbcTLogInitialized(boolean isJdbcTLogInitialized) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setJdbcTLogInitialized(isJdbcTLogInitialized=" + isJdbcTLogInitialized + ")");
        }
        this.isJdbcTLogInitialized = isJdbcTLogInitialized;
    }

    public final boolean isClusterwideRecoveryEnabled() {
        return this.isClusterwideRecoveryEnabled;
    }

    public final boolean isTightlyCoupledTransactionsEnabled() {
        return this.isTightlyCoupledTransactionsEnabled;
    }

    public final void setTightlyCoupledTransactionsEnabled(boolean isTightlyCoupledTransactionsEnabled) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setTightlyCoupledTransactionsEnabled(isTightlyCoupledTransactionsEnabled=" + isTightlyCoupledTransactionsEnabled + ")");
        }
        this.isTightlyCoupledTransactionsEnabled = isTightlyCoupledTransactionsEnabled;
    }

    public final boolean isTLOGWriteWhenDeterminerExistsEnabled() {
        return this.isTLOGWriteWhenDeterminerExistsEnabled;
    }

    public final void setTLOGWriteWhenDeterminerExistsEnabled(boolean isTLOGWriteWhenDeterminerExistsEnabled) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setTLOGWriteWhenDeterminerExistsEnabled(isTLOGWriteWhenDeterminerExistsEnabled=" + isTLOGWriteWhenDeterminerExistsEnabled + ")");
        }
        this.isTLOGWriteWhenDeterminerExistsEnabled = isTLOGWriteWhenDeterminerExistsEnabled;
    }

    public final void setMaxRetrySecondsBeforeDeterminerFail(int maxRetrySecondsBeforeDeterminerFail) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setMaxRetrySecondsBeforeDeterminerFail(maxRetrySecondsBeforeDeterminerFail=" + maxRetrySecondsBeforeDeterminerFail + ")");
        }
        this.maxRetrySecondsBeforeDeterminerFail = maxRetrySecondsBeforeDeterminerFail;
    }

    public final int getMaxRetrySecondsBeforeDeterminerFail() {
        return this.maxRetrySecondsBeforeDeterminerFail;
    }

    public final void setCrossDomainRecoveryRetryInterval(int crossDomainRecoveryRetryInterval) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setCrossDomainRecoveryRetryInterval(crossDomainRecoveryRetryInterval=" + crossDomainRecoveryRetryInterval + ")");
        }
        this.crossDomainRecoveryRetryInterval = crossDomainRecoveryRetryInterval;
    }

    public final int getCrossDomainRecoveryRetryInterval() {
        return this.crossDomainRecoveryRetryInterval;
    }

    public final void setCrossSiteRecoveryRetryInterval(int crossSiteRecoveryRetryInterval) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setCrossSiteRecoveryRetryInterval(crossSiteRecoveryRetryInterval=" + crossSiteRecoveryRetryInterval + ")");
        }
        this.crossSiteRecoveryRetryInterval = crossSiteRecoveryRetryInterval;
    }

    public final int getCrossSiteRecoveryRetryInterval() {
        return this.crossSiteRecoveryRetryInterval;
    }

    public final void setCrossSiteRecoveryLeaseExpiration(int crossSiteRecoveryLeaseExpiration) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setCrossSiteRecoveryLeaseExpiration(crossSiteRecoveryLeaseExpiration=" + crossSiteRecoveryLeaseExpiration + ")");
        }
        this.crossSiteRecoveryLeaseExpiration = crossSiteRecoveryLeaseExpiration;
    }

    public final int getCrossSiteRecoveryLeaseUpdate() {
        return this.crossSiteRecoveryLeaseUpdate;
    }

    public final void setCrossSiteRecoveryLeaseUpdate(int crossSiteRecoveryLeaseUpdate) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setCrossSiteRecoveryLeaseUpdate(crossSiteRecoveryLeaseUpdate=" + crossSiteRecoveryLeaseUpdate + ")");
        }
        this.crossSiteRecoveryLeaseUpdate = crossSiteRecoveryLeaseUpdate;
    }

    public final int getCrossSiteRecoveryLeaseExpiration() {
        return this.crossSiteRecoveryLeaseExpiration;
    }

    public final int getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public final void setShutdownGracePeriod(int shutdownGracePeriod) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setShutdownGracePeriod(shutdownGracePeriod=" + shutdownGracePeriod + ")");
        }
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    public final String getSiteName() {
        return this.siteName;
    }

    public final void setSiteName(String siteName) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setSiteName(siteName=" + siteName + ")");
        }
        this.siteName = siteName;
    }

    public final String getRecoverySiteName() {
        return this.recoverySiteName;
    }

    public final void setRecoverySiteName(String recoverySiteName) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug(this + ".setRecoverySiteName(recoverySiteName=" + recoverySiteName + ")");
        }
        this.recoverySiteName = recoverySiteName;
    }

    public final String[] getDeterminers() {
        return this.determiners;
    }

    public void setPartitionDeterminers(String partitionName, String[] dtmnrs) {
        if (dtmnrs != null) {
            this.partitionDeterminersMap.put(partitionName, (String[])dtmnrs.clone());
        }
    }

    public void setDeterminers() {
        int detSize = 0;
        for (String[] det : this.partitionDeterminersMap.values()) {
            detSize += det.length;
        }
        if (detSize != 0) {
            String[] newDeterminers = new String[detSize];
            Iterator<String[]> it2 = this.partitionDeterminersMap.values().iterator();
            int startPos = 0;
            while (it2.hasNext()) {
                String[] det = it2.next();
                int inLength = det.length;
                if (inLength == 0) continue;
                System.arraycopy(det, 0, newDeterminers, startPos, inLength);
                startPos += inLength;
            }
            this.determiners = newDeterminers;
        } else {
            this.determiners = new String[0];
        }
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            String dtmrs = "";
            for (String s : this.determiners) {
                dtmrs = dtmrs + " " + s;
            }
            TxDebug.JTA2PC.debug(this + ".setDeterminers(determiners = " + dtmrs + ")");
        }
    }

    public final boolean isJdbcTLogInitialized() {
        return this.isJdbcTLogInitialized;
    }

    public String getServerName() {
        return null;
    }

    public boolean isTimerStarted() {
        return timerFailureReason == null;
    }

    public static Throwable getTimerFailureReason() {
        return timerFailureReason;
    }

    protected void processTimedOutTransactions(List timedOutTransactions, int nowSec) {
        int cnt = 100;
        Iterator iter = timedOutTransactions.iterator();
        while (iter.hasNext()) {
            TransactionImpl tx = (TransactionImpl)iter.next();
            iter.remove();
            tx.wakeUp(nowSec);
            if (cnt-- > 0) continue;
            break;
        }
    }

    protected void reset() {
        this.txMap = null;
    }

    protected static Xid getNewXID() {
        return XidImpl.create();
    }

    public final long getLastTimerFire() {
        return this.lastTimerFire;
    }

    public final long getTimeSinceLastTimerFire() {
        return System.currentTimeMillis() - this.lastTimerFire;
    }

    public final long getLastWakeUpDuration() {
        return this.lastWakeUpDuration;
    }

    protected final Object resetValue(Object currentValue) {
        TransactionManagerImpl.getTM().internalForceSuspend();
        TxThreadProperty txp = (TxThreadProperty)currentValue;
        txp.timeoutSec = 0;
        txp.current = null;
        txp.preferredHostSetForTx = false;
        txp.preTxPreferredHost = null;
        txp.isUserTransactionAllowed = true;
        return currentValue;
    }

    public void setCDIOnTxThreadProperty(boolean isUserTransactionAllowed) {
        TxThreadProperty txp = this.getThreadProp();
        txp.isUserTransactionAllowed = isUserTransactionAllowed;
    }

    void add(TransactionImpl tx) {
        this.add(tx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TransactionImpl tx, boolean migratedTx) {
        Xid xid = tx.getXID();
        xid.hashCode();
        if (!(migratedTx || !tx.isCancelled() && tx.isImportedTransaction() || this.txMap.putIfAbsent(xid, tx) != null)) {
            return;
        }
        TransactionManagerImpl transactionManagerImpl = this;
        synchronized (transactionManagerImpl) {
            TransactionImpl old = this.txMap.put(xid, tx);
            if (old != null && !migratedTx) {
                if (old == tx) {
                    TXLogger.logAddDuplicateTxToMap();
                    return;
                }
                SystemException se = new SystemException("Attempt to add transaction to TM when another existed. Both have been marked rollback");
                old.setRollbackOnly(se);
                tx.setRollbackOnly(se);
            }
            if (migratedTx) {
                this.txMap.put(tx.getXid(), tx);
                this.tmXARes.add(tx.getXid(), tx);
            } else if (!tx.isCancelled() && tx.isImportedTransaction()) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this + ".add(" + tx + ")");
                }
                this.tmXARes.add(tx.getForeignXid(), tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(TransactionImpl tx) {
        Xid xid = tx.getXID();
        xid.hashCode();
        boolean condition = tx.isImportedTransaction();
        if (!condition) {
            this.txMap.remove(xid);
            return;
        }
        TransactionManagerImpl transactionManagerImpl = this;
        synchronized (transactionManagerImpl) {
            this.txMap.remove(xid);
            if (condition) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this + ".remove(" + tx + ")");
                }
                this.tmXARes.remove(tx.getForeignXid());
            }
        }
    }

    jakarta.transaction.Transaction getTransactionUnsync(Xid xid) {
        if (xid == null) {
            return null;
        }
        jakarta.transaction.Transaction nativeTx = this.txMap.get(xid);
        if (nativeTx != null) {
            return nativeTx;
        }
        return this.tmXARes.get(xid);
    }

    public abstract TransactionImpl createTransaction(Xid var1, int var2, int var3) throws SystemException;

    public abstract TransactionImpl createTransaction(Xid var1, int var2, int var3, boolean var4) throws SystemException;

    public abstract TransactionImpl createTransaction(Xid var1, int var2, int var3, boolean var4, boolean var5) throws SystemException;

    public abstract TransactionImpl createImportedTransaction(Xid var1, Xid var2, int var3, int var4) throws SystemException;

    public abstract void commit(Xid var1) throws XAException;

    public abstract Xid[] gatherClusterRecoverXids(String var1, Xid var2) throws XAException;

    public abstract void rollback(Xid var1) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public abstract Xid[] recoverForeignXids(int var1) throws XAException;

    public abstract boolean isRunning();

    public abstract void addToListOfAckCommits(Xid var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionImpl getTxAssociatedWithThread() {
        TxThreadProperty txp = this.getThreadProp();
        if (txp == null) {
            return null;
        }
        TxThreadProperty txThreadProperty = txp;
        synchronized (txThreadProperty) {
            return txp.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void replaceTransactionManager(TransactionManagerImpl tm) {
        Object object = singletonLock;
        synchronized (object) {
            TransactionManagerImpl oldtm = singleton;
            if (oldtm != tm) {
                singleton = null;
                TransactionManagerImpl.setTransactionManager(tm);
                if (oldtm != null) {
                    oldtm.reset();
                }
            }
        }
    }

    public void init() {
        this.txMap = new ConcurrentHashMap(100);
        this.tmXARes = new TMXAResource();
        this.tmXARes.init();
        PlatformHelper.getPlatformHelper().registerRMITransactionInterceptor(this);
    }

    private TMXAResourceInterface getTMXAResource() {
        return (TMXAResourceInterface)TransactionManagerImpl.getTM().getXAResource();
    }

    @Override
    public void setSSLURLFromClientInfo(InterposedTransactionManager itm, Context initialContext) {
        PlatformHelper.getPlatformHelper().setSSLURLFromClientInfo((ClientTransactionManagerImpl)itm, initialContext);
    }

    private TransactionImpl associateTxWithThread(TransactionImpl tx) {
        TxThreadProperty txp = this.getThreadProp();
        if (txp == null) {
            return null;
        }
        TransactionImpl ret = txp.current;
        txp.current = tx;
        if (ret != null) {
            ret.setActiveThread(null);
        }
        PlatformHelper.getPlatformHelper().associateThreadPreferredHost(tx, txp);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        long nowMillis;
        this.lastTimerFire = nowMillis = System.currentTimeMillis();
        int nowSec = (int)(nowMillis / 1000L);
        if (nowMillis % 1000L > 500L) {
            ++nowSec;
        }
        if (this.timedOutTransactions.isEmpty()) {
            TransactionManagerImpl transactionManagerImpl = this;
            synchronized (transactionManagerImpl) {
                for (TransactionImpl tx : this.txMap.values()) {
                    if (tx.getWakeupTimeSeconds() > nowSec) continue;
                    this.timedOutTransactions.add(tx);
                }
            }
        }
        this.processTimedOutTransactions(this.timedOutTransactions, nowSec);
        this.lastWakeUpDuration = System.currentTimeMillis() - this.lastTimerFire;
    }

    public static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    @Override
    public Object getResource(Object key) {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            return TransactionManagerImpl.getTransactionManager().getResource(key);
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        if (tx == null) {
            throw new IllegalStateException("Transaction does not exist");
        }
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        return tx.getResource(key);
    }

    @Override
    public boolean getRollbackOnly() {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            return TransactionManagerImpl.getTransactionManager().getRollbackOnly();
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        if (tx == null) {
            throw new IllegalStateException("Transaction does not exist");
        }
        return tx.isMarkedRollback();
    }

    @Override
    public int getTransactionStatus() {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            return TransactionManagerImpl.getTransactionManager().getTransactionStatus();
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        try {
            return tx == null ? 6 : tx.getStatus();
        }
        catch (Exception e) {
            return 6;
        }
    }

    @Override
    public Object getTransactionKey() {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            return TransactionManagerImpl.getTransactionManager().getTransactionKey();
        }
        TransactionImpl tx = this.getTxAssociatedWithThread();
        if (tx == null) {
            return null;
        }
        return tx;
    }

    @Override
    public void putResource(Object key, Object value) {
        TransactionImpl tx;
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().putResource(key, value);
        }
        if ((tx = this.getTxAssociatedWithThread()) == null) {
            throw new IllegalStateException("Transaction does not exist");
        }
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        tx.putResource(key, value);
    }

    @Override
    public void registerInterposedSynchronization(Synchronization sync) {
        if (this != TransactionManagerImpl.getTransactionManager()) {
            TransactionManagerImpl.getTransactionManager().registerInterposedSynchronization(sync);
            return;
        }
        throw new IllegalStateException("registerInterposedSynchronization must be called on Server Transaction");
    }

    public void addToUnRegisteredDeterminerList(String rdName) {
        TxDebug.JTAXA.debug("addToUnRegisteredDeterminerList:" + rdName);
        this.unRegisteredDeterminerList.add(rdName);
        this.isAnyDeterminerUnregistered = true;
    }

    public void removeFromUnRegisteredDeterminerList(String rdName) {
        TxDebug.JTAXA.debug("removeFromUnRegisteredDeterminerList:" + rdName);
        this.unRegisteredDeterminerList.remove(rdName);
        if (this.unRegisteredDeterminerList.isEmpty()) {
            this.isAnyDeterminerUnregistered = false;
        }
    }

    public boolean isInUnRegisteredDeterminerList(String rdName) {
        boolean isIt = this.unRegisteredDeterminerList.contains(rdName);
        String debugString = "isInUnRegisteredDeterminerList:" + rdName + " : " + isIt + " unRegisteredDeterminerList.size()" + this.unRegisteredDeterminerList.size();
        for (String anUnRegisteredDeterminerList : this.unRegisteredDeterminerList) {
            debugString = debugString + anUnRegisteredDeterminerList + " ";
        }
        TxDebug.JTAXA.debug(debugString);
        return isIt;
    }

    public boolean isAnyDeterminerUnregistered() {
        return this.isAnyDeterminerUnregistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionManagerImpl getTransactionManager() {
        TransactionManagerImpl result = singleton;
        if (result != null) {
            return result;
        }
        Object object = singletonLock;
        synchronized (object) {
            TransactionManagerImpl.setTransactionManager(new ClientTransactionManagerImpl());
        }
        return singleton;
    }

    static {
        initialized = false;
        try {
            if (!PlatformHelper.getPlatformHelper().isServer()) {
                Constructor<?> cons = Class.forName("weblogic.transaction.internal.GenericTimer").getConstructor(new Class[0]);
                cons.newInstance(new Object[0]);
            }
        }
        catch (Throwable th) {
            TransactionManagerImpl.setTimerFailureReason(th);
        }
        txThreadLocal = AuditableThreadLocalFactory.createThreadLocal(new TxThreadLocal());
        singleton = null;
    }

    public static class TxThreadProperty {
        public TransactionImpl current;
        public static final int UNSPECIFIED_TIMEOUTSEC = 0;
        public int timeoutSec;
        public boolean isUserTransactionAllowed = true;
        public boolean preferredHostSetForTx;
        public Object preTxPreferredHost;
    }

    public class TMXAResource
    extends XAResourceHelper
    implements TMXAResourceInterface {
        private static final long serialVersionUID = -8889585500926470087L;
        protected ConcurrentHashMap<Xid, TransactionImpl> foreignXidMap = null;
        private int timeOutSecs;

        public TMXAResource() {
            this.timeOutSecs = TransactionManagerImpl.this.defaultTimeoutSec;
        }

        @Override
        public void start(Xid foreignXid, int flags) throws XAException {
            XidImpl fXid = XidImpl.create(foreignXid);
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.start(foreignXid=" + fXid + ", flags=" + TMXAResource.flagsToString(flags) + ")");
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.start(foreignXid=" + fXid + ", flags=" + TMXAResource.flagsToString(flags) + ")");
            }
            TransactionImpl importedTx = null;
            try {
                try {
                    importedTx = this.getOrCreate(fXid);
                }
                catch (SystemException ex) {
                    TMXAResource.throwXAException(-3, this.getErrMsg("start") + "Cannot create imported transaction, foreignXid=" + fXid + ".", ex);
                }
                if (importedTx.isCancelled()) {
                    Throwable reason = importedTx.getRollbackReason();
                    if (reason instanceof TimedOutException) {
                        TMXAResource.throwXAException(106, this.getErrMsg("start"), reason);
                    } else {
                        TMXAResource.throwXAException(100, this.getErrMsg("start"), reason);
                    }
                } else if (!importedTx.isStateActive()) {
                    TMXAResource.throwXAException(-3, this.getErrMsg("start") + "Illegal State (Expected: active).  " + importedTx.getXid().toString());
                }
                try {
                    if (TransactionManagerImpl.this.isClusterwideRecoveryEnabled()) {
                        TransactionManagerImpl.this.forceResume(importedTx);
                    } else {
                        TransactionManagerImpl.this.resume(importedTx);
                    }
                }
                catch (InvalidTransactionException ex) {
                    TMXAResource.throwXAException(-3, this.getErrMsg("start") + "Cannot resume transaction " + importedTx.getXid().toString(), ex);
                }
                catch (IllegalStateException ex) {
                    TMXAResource.throwXAException(-3, this.getErrMsg("start") + "Cannot resume transaction " + importedTx.getXid().toString(), ex);
                }
                catch (SystemException ex) {
                    TMXAResource.throwXAException(-3, this.getErrMsg("start") + "Cannot resume transaction " + importedTx.getXid().toString(), ex);
                }
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.start DONE, imported tx: " + importedTx);
                }
            }
            catch (XAException ex) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.start FAILED, imported tx: " + importedTx, ex);
                }
                throw ex;
            }
        }

        @Override
        public void end(Xid foreignXid, int flags) throws XAException {
            XidImpl fXid = XidImpl.create(foreignXid);
            boolean needTxInMap = false;
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.end(foreignXid=" + fXid + ", flags=" + TMXAResource.flagsToString(flags) + ")");
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.end(foreignXid=" + fXid + ", flags=" + TMXAResource.flagsToString(flags) + ")");
            }
            TransactionImpl importedTx = null;
            int txsts = 0;
            try {
                jakarta.transaction.Transaction curTx;
                importedTx = this.get(fXid);
                if (importedTx == null) {
                    jakarta.transaction.Transaction tx = TransactionManagerImpl.this.getTransaction();
                    if (tx != null) {
                        try {
                            txsts = tx.getStatus();
                        }
                        catch (SystemException se) {
                            se.printStackTrace();
                        }
                        if (txsts == 4 || txsts == 9 || txsts == 1) {
                            importedTx = (TransactionImpl)tx;
                            needTxInMap = true;
                        }
                    }
                    if (importedTx == null) {
                        TMXAResource.throwXAException(-4, this.getErrMsg("end") + "Foreign transaction not recognized, foreignXid=" + fXid + ".");
                    }
                }
                if ((curTx = TransactionManagerImpl.this.getTransaction()) != null) {
                    if (!curTx.equals(importedTx)) {
                        TMXAResource.throwXAException(-6, this.getErrMsg("end") + "Thread is currently associated with a different transaction.  Current transaction: " + curTx + ".  Foreign transaction: " + importedTx.getXid().toString());
                    }
                    TransactionImpl mappedTx = (TransactionImpl)curTx;
                    if (needTxInMap) {
                        TransactionManagerImpl.this.txMap.put(mappedTx.getXID(), mappedTx);
                        mappedTx.setProperty("IMP_TX_STATUS_ROLLEDBACK", (Serializable)((Object)"true"));
                    }
                    try {
                        TransactionManagerImpl.this.suspend();
                    }
                    catch (SystemException se) {
                        se.printStackTrace();
                    }
                    if (needTxInMap) {
                        TransactionManagerImpl.this.txMap.remove(mappedTx.getXID());
                    }
                    if (importedTx.isCancelled()) {
                        Throwable reason = importedTx.getRollbackReason();
                        TMXAResource.throwXAException(reason instanceof TimedOutException ? 106 : 100, this.getErrMsg("end") + "Transaction is cancelled " + importedTx.getXid().toString(), reason);
                    } else if (!importedTx.isStateActive()) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("start") + "Illegal State (Expected: active).  " + importedTx.getXid().toString());
                    }
                }
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.end DONE, imported tx: " + importedTx);
                }
            }
            catch (XAException ex) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.end FAILED, imported tx: " + importedTx, ex);
                }
                throw ex;
            }
        }

        @Override
        public int prepare(Xid foreignXid) throws XAException {
            return this.prepare(foreignXid, false);
        }

        /*
         * Exception decompiling
         */
        public int prepare(Xid foreignXid, boolean isClientTMCaller) throws XAException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void commit(Xid foreignXid, boolean onePhase) throws XAException {
            this.commit(foreignXid, onePhase, false);
        }

        public void commit(Xid foreignXid, boolean onePhase, boolean isClientTMCaller) throws XAException {
            XidImpl fXid = XidImpl.create(foreignXid);
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.commit(foreignXid=" + fXid + ", onePhase=" + onePhase + ")");
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.commit(foreignXid=" + fXid + ", onePhase=" + onePhase + ")");
            }
            TransactionImpl importedTx = null;
            TransactionImpl saveTx = null;
            try {
                saveTx = TransactionManagerImpl.getTM().internalSuspend();
                importedTx = this.get(fXid);
                if (importedTx == null) {
                    if (onePhase) {
                        TMXAResource.throwXAException(-4, "Foreign transaction not recognized, foreignXid=" + fXid + ".");
                    } else {
                        try {
                            this.curTM().commit(fXid);
                        }
                        catch (XAException xaException) {
                            this.executeCommandAgainstClusterIfEnabled(onePhase, isClientTMCaller, fXid, xaException, TransactionManagerImpl.CLUSTERCOMMIT);
                        }
                    }
                } else {
                    if (importedTx.hasHeuristics()) {
                        TMXAResource.throwXAException(importedTx.getHeuristicErrorCode(), this.getErrMsg("commit") + importedTx.getHeuristicErrorMessage());
                    }
                    try {
                        importedTx.internalCommit(onePhase);
                    }
                    catch (AbortRequestedException ex) {
                        try {
                            importedTx.globalRollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Throwable reason = importedTx.getRollbackReason();
                        int errCode = 100;
                        if (onePhase) {
                            int resErrCode;
                            if (reason instanceof TimedOutException) {
                                errCode = 106;
                            } else if (reason instanceof XAException && TMXAResource.isRollbackErrorCode(resErrCode = ((XAException)reason).errorCode)) {
                                errCode = resErrCode;
                            }
                        }
                        TMXAResource.throwXAException(errCode, this.getErrMsg("commit"), reason);
                    }
                    catch (jakarta.transaction.RollbackException ex) {
                        try {
                            importedTx.globalRollback();
                        }
                        catch (Exception reason) {
                            // empty catch block
                        }
                        Throwable reason = importedTx.getRollbackReason();
                        if (reason == null && ex instanceof RollbackException) {
                            reason = ((RollbackException)ex).getNested();
                            importedTx.setRollbackReason(reason);
                        }
                        int errCode = 6;
                        if (onePhase) {
                            int resErrCode;
                            errCode = 100;
                            if (reason instanceof TimedOutException) {
                                errCode = 106;
                            } else if (reason instanceof XAException && TMXAResource.isRollbackErrorCode(resErrCode = ((XAException)reason).errorCode)) {
                                errCode = resErrCode;
                            }
                        }
                        TMXAResource.throwXAException(errCode, this.getErrMsg("commit"), ex);
                    }
                    catch (HeuristicMixedException ex) {
                        TMXAResource.throwXAException(5, this.getErrMsg("commit"), ex);
                    }
                    catch (HeuristicRollbackException ex) {
                        int errCode = onePhase ? 100 : 6;
                        TMXAResource.throwXAException(errCode, this.getErrMsg("commit"), ex);
                    }
                    catch (SystemException ex) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("commit"), ex);
                    }
                    catch (IllegalStateException ex) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("commit"), ex);
                    }
                    catch (SecurityException ex) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("commit"), ex);
                    }
                    catch (XAException ex) {
                        throw ex;
                    }
                    catch (OutOfMemoryError ex) {
                        throw ex;
                    }
                    catch (ThreadDeath ex) {
                        throw ex;
                    }
                    catch (Throwable t) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("commit"), t);
                    }
                }
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.commit DONE, imported tx: " + importedTx);
                }
            }
            catch (XAException ex) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.commit FAILED, imported tx: " + importedTx, ex);
                }
                throw ex;
            }
            finally {
                TransactionManagerImpl.getTM().internalResume(saveTx);
            }
        }

        @Override
        public void rollback(Xid foreignXid) throws XAException {
            this.rollback(foreignXid, false);
        }

        public void rollback(Xid foreignXid, boolean isClientTMCaller) throws XAException {
            XidImpl fXid = XidImpl.create(foreignXid);
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.rollback(foreignXid=" + fXid + ")");
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.rollback(foreignXid=" + fXid + ")");
            }
            TransactionImpl importedTx = null;
            TransactionImpl saveTx = null;
            try {
                saveTx = TransactionManagerImpl.getTM().internalSuspend();
                importedTx = this.get(fXid);
                if (importedTx == null) {
                    try {
                        this.curTM().rollback(fXid);
                    }
                    catch (XAException xaException) {
                        this.executeCommandAgainstClusterIfEnabled(false, isClientTMCaller, fXid, xaException, TransactionManagerImpl.CLUSTERROLLBACK);
                    }
                } else {
                    if (importedTx.hasHeuristics()) {
                        TMXAResource.throwXAException(importedTx.getHeuristicErrorCode(), this.getErrMsg("rollback") + importedTx.getHeuristicErrorMessage());
                    }
                    try {
                        importedTx.internalRollback();
                    }
                    catch (SystemException ex) {
                        int errCode = -3;
                        if (importedTx.hasHeuristics()) {
                            errCode = importedTx.getHeuristicErrorCode();
                        }
                        TMXAResource.throwXAException(errCode, this.getErrMsg("rollback"), ex);
                    }
                    catch (OutOfMemoryError ex) {
                        throw ex;
                    }
                    catch (ThreadDeath ex) {
                        throw ex;
                    }
                    catch (Throwable t) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("rollback"), t);
                    }
                }
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.rollback DONE, imported tx: " + importedTx);
                }
            }
            catch (XAException ex) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.rollback FAILED, imported tx: " + importedTx, ex);
                }
                throw ex;
            }
            finally {
                TransactionManagerImpl.getTM().internalResume(saveTx);
            }
        }

        @Override
        public Xid[] recover(int recoveryFlag) throws XAException {
            Xid[] xids;
            block8: {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.recover(flag=" + TMXAResource.flagsToString(recoveryFlag) + ")");
                }
                if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                    TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.recover(flag=" + TMXAResource.flagsToString(recoveryFlag) + ")");
                }
                xids = null;
                try {
                    if (recoveryFlag == 1001001 || recoveryFlag == 1001002 || recoveryFlag == 1001003 || (recoveryFlag & 0x1000000) == 0x1000000) {
                        xids = this.curTM().recoverForeignXids(recoveryFlag);
                    } else {
                        if (TxDebug.JTAGateway.isDebugEnabled()) {
                            TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.recover returns 0 xids.  TMSTARTRSCAN is not specified.");
                        }
                        xids = new Xid[]{};
                    }
                    if (!TxDebug.JTAGateway.isDebugEnabled()) break block8;
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.recover returns " + (xids == null ? 0 : xids.length) + " xids.");
                }
                catch (Throwable throwable) {
                    if (TxDebug.JTAGateway.isDebugEnabled()) {
                        TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.recover returns " + (xids == null ? 0 : xids.length) + " xids.");
                    }
                    throw throwable;
                }
            }
            return xids;
        }

        @Override
        public void forget(Xid foreignXid) throws XAException {
            this.forget(foreignXid, false);
        }

        public void forget(Xid foreignXid, boolean isClientTMCaller) throws XAException {
            XidImpl fXid = XidImpl.create(foreignXid);
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.forget(foreignXid=" + fXid + ")");
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.forget(foreignXid=" + fXid + ")");
            }
            TransactionImpl importedTx = null;
            try {
                importedTx = this.get(fXid);
                if (importedTx == null) {
                    try {
                        this.curTM().forget(fXid);
                    }
                    catch (XAException xaException) {
                        this.executeCommandAgainstClusterIfEnabled(false, isClientTMCaller, fXid, xaException, TransactionManagerImpl.CLUSTERFORGET);
                    }
                } else {
                    try {
                        importedTx.internalForget();
                    }
                    catch (SystemException ex) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("forget"), ex);
                    }
                    catch (XAException ex) {
                        throw ex;
                    }
                    catch (OutOfMemoryError ex) {
                        throw ex;
                    }
                    catch (ThreadDeath ex) {
                        throw ex;
                    }
                    catch (Throwable t) {
                        TMXAResource.throwXAException(-3, this.getErrMsg("forget"), t);
                    }
                }
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.forget DONE, imported tx: " + importedTx);
                }
            }
            catch (XAException ex) {
                if (TxDebug.JTAGateway.isDebugEnabled()) {
                    TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.forget FAILED, imported tx: " + importedTx, ex);
                }
                throw ex;
            }
        }

        private void executeCommandAgainstClusterIfEnabled(boolean onePhase, boolean isClientTMCaller, XidImpl fXid, XAException xaException, String command) throws XAException {
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + "XAException during " + command + " xaException:" + xaException + " fXid.isClusterCall():" + fXid.isClusterCall() + " fXid.isClusterwideRecoveryEnabled():" + fXid.isClusterwideRecoveryEnabled() + " isClusterwideRecoveryEnabled():" + TransactionManagerImpl.this.isClusterwideRecoveryEnabled());
            }
            if (isClientTMCaller || xaException.errorCode != -4 || fXid.isClusterCall() || fXid.isClusterwideRecoveryEnabled() == 0 || !TransactionManagerImpl.this.isClusterwideRecoveryEnabled() && fXid.isClusterwideRecoveryEnabled() != 1) {
                throw xaException;
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + "commitAgainstClusterIfEnabled foreignXid=" + fXid + (command.equals(TransactionManagerImpl.CLUSTERCOMMIT) ? ", onePhase=" + onePhase : "") + ") resulted in XAER_NOTA XAException.  Attempting to " + command + " against cluster...");
            }
            fXid.setClusterCall(true);
            this.curTM().gatherClusterRecoverXids(command, fXid);
        }

        @Override
        public boolean isSameRM(XAResource xares) throws XAException {
            boolean rtn;
            if (this.curTM() != TransactionManagerImpl.getTM()) {
                return TransactionManagerImpl.getTM().getXAResource().isSameRM(xares);
            }
            boolean bl = rtn = xares == this;
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.isSameRM(xares=" + xares + ") returns " + rtn);
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.isSameRM(xares=" + xares + ") returns " + rtn);
            }
            return rtn;
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.setTransactionTimeout(seconds=" + seconds + ")");
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.setTransactionTimeout(seconds=" + seconds + ")");
            }
            this.timeOutSecs = seconds <= 0 ? this.curTM().getDefaultTimeoutSeconds() : seconds;
            return true;
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.JTAGateway.debug(this.curTM() + ".XAResource.getTransactionTimeout() returns " + this.timeOutSecs);
            }
            if (TxDebug.JTAGatewayDetail.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTAGatewayDetail, this.curTM() + ".XAResource.getTransactionTimeout() returns " + this.timeOutSecs);
            }
            return this.timeOutSecs;
        }

        @Override
        public String toString() {
            return this.curTM() + ".XAResource";
        }

        public boolean equals(Object obj) {
            try {
                return obj instanceof TMXAResource && this.isSameRM((TMXAResource)obj);
            }
            catch (XAException xAException) {
                return false;
            }
        }

        public int hashCode() {
            return this.curTM().toString().hashCode();
        }

        private TransactionManagerImpl curTM() {
            return TransactionManagerImpl.this;
        }

        protected String getErrMsg(String xaOp) {
            return this.curTM() + ".XAResource." + xaOp + "() fails.  ";
        }

        protected void init() {
            this.foreignXidMap = new ConcurrentHashMap(50);
        }

        @Override
        public void add(Xid foreignXid, TransactionImpl tx) {
            if (this.curTM() != TransactionManagerImpl.getTM()) {
                TransactionManagerImpl.this.getTMXAResource().add(foreignXid, tx);
                return;
            }
            this.foreignXidMap.put(foreignXid, tx);
        }

        @Override
        public void remove(Xid foreignXid) {
            if (this.curTM() != TransactionManagerImpl.getTM()) {
                TransactionManagerImpl.this.getTMXAResource().remove(foreignXid);
                return;
            }
            this.foreignXidMap.remove(foreignXid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TransactionImpl get(Xid foreignXid) {
            if (this.curTM() != TransactionManagerImpl.getTM()) {
                return TransactionManagerImpl.this.getTMXAResource().get(foreignXid);
            }
            TransactionManagerImpl transactionManagerImpl = TransactionManagerImpl.getTM();
            synchronized (transactionManagerImpl) {
                return this.foreignXidMap.get(foreignXid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionImpl getWithoutBranchqualEquals(Xid foreignXid) {
            if (this.curTM() != TransactionManagerImpl.getTM()) {
                return TransactionManagerImpl.this.getTMXAResource().get(foreignXid);
            }
            TransactionManagerImpl transactionManagerImpl = TransactionManagerImpl.getTM();
            synchronized (transactionManagerImpl) {
                Set<Map.Entry<Xid, TransactionImpl>> entries = this.foreignXidMap.entrySet();
                for (Map.Entry<Xid, TransactionImpl> next : entries) {
                    Xid xid = next.getKey();
                    if (xid.getFormatId() != foreignXid.getFormatId() || !Arrays.equals(xid.getGlobalTransactionId(), foreignXid.getGlobalTransactionId())) continue;
                    return next.getValue();
                }
            }
            return this.foreignXidMap.get(foreignXid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TransactionImpl getOrCreate(Xid foreignXid) throws SystemException, XAException {
            TransactionManagerImpl transactionManagerImpl = TransactionManagerImpl.getTM();
            synchronized (transactionManagerImpl) {
                TransactionImpl tx = TransactionManagerImpl.this.getTMXAResource().get(foreignXid);
                if (tx == null) {
                    tx = TransactionManagerImpl.this.createImportedTransaction(XidImpl.create(), foreignXid, this.getTransactionTimeout(), this.getTransactionTimeout());
                }
                return tx;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Xid[] getIndoubtXids() {
            if (this.curTM() != TransactionManagerImpl.getTM()) {
                return TransactionManagerImpl.this.getTMXAResource().getIndoubtXids();
            }
            ArrayList<Xid> list = null;
            TransactionManagerImpl transactionManagerImpl = TransactionManagerImpl.getTM();
            synchronized (transactionManagerImpl) {
                Collection<TransactionImpl> values = this.foreignXidMap.values();
                if (values != null) {
                    for (TransactionImpl tx : values) {
                        if (!tx.isPrepared() && !tx.hasHeuristics()) continue;
                        if (list == null) {
                            list = new ArrayList<Xid>(5);
                        }
                        list.add(tx.getForeignXid());
                    }
                }
            }
            if (list != null) {
                Xid[] xids = new Xid[list.size()];
                list.toArray(xids);
                return xids;
            }
            return null;
        }
    }

    static class TxThreadLocal
    extends ThreadLocalInitialValue {
        TxThreadLocal() {
        }

        @Override
        protected final Object initialValue() {
            TxThreadProperty txp = new TxThreadProperty();
            txp.timeoutSec = 0;
            return txp;
        }
    }
}

