/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.transaction.AppSetRollbackOnlyException;
import weblogic.transaction.ChannelInterface;
import weblogic.transaction.NestedException;
import weblogic.transaction.PeerExchangeTransaction;
import weblogic.transaction.RollbackException;
import weblogic.transaction.Transaction;
import weblogic.transaction.internal.AbortRequestedException;
import weblogic.transaction.internal.Coordinator;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorFactory;
import weblogic.transaction.internal.CoordinatorOneway;
import weblogic.transaction.internal.CoordinatorService;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.PropagationContext;
import weblogic.transaction.internal.ResourceInfo;
import weblogic.transaction.internal.SCInfo;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TimedOutException;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XAResourceHelper;
import weblogic.transaction.internal.XidImpl;
import weblogic.transaction.nonxa.NonXAResource;

public abstract class TransactionImpl
implements Transaction,
PeerExchangeTransaction {
    protected boolean useSecureURL = false;
    public boolean isReadOnly = false;
    private XidImpl xid;
    private volatile byte state = 1;
    protected static final byte STATE_ACTIVE = 1;
    protected static final byte STATE_PRE_PREPARING = 2;
    protected static final byte STATE_PRE_PREPARED = 3;
    protected static final byte STATE_PREPARING = 4;
    protected static final byte STATE_LOGGING = 5;
    protected static final byte STATE_PREPARED = 6;
    protected static final byte STATE_COMMITTING = 7;
    protected static final byte STATE_COMMITTED = 8;
    protected static final byte STATE_ROLLING_BACK = 9;
    protected static final byte STATE_ROLLED_BACK = 10;
    protected static final byte STATE_UNKNOWN = 11;
    protected static final byte STATE_ABANDONED = 12;
    private static final boolean IS_ISE_THROWN_DUE_TO_TIMEOUT_RB;
    private volatile boolean markedRollback;
    private short completionState;
    private Throwable rollbackReason;
    private boolean requestOverrideRollbackReason = false;
    private static final boolean ALLOW_OVERRIDE_SETROLLBACK_REASON;
    private String heuristicError;
    protected int heuristicErrorCode = -1;
    private long beginTimeMillis;
    private int timeoutSec;
    private volatile boolean txAsyncTimeout;
    private static int abandonGraceTimeEndSec;
    private CoordinatorDescriptor coordinatorDescriptor;
    private HashMap globalProperties;
    private ConcurrentHashMap localProperties;
    private volatile ConcurrentHashMap volatileLocalProperties;
    private Thread activeThread;
    private TransactionManagerImpl ownerTM;
    private int wakeUpTimeSec;
    private volatile CopyOnWriteArrayList scInfoList;
    private ArrayList resourceInfoList;
    private int numRepliesOwedMe;
    private int numRepliesOwedOthers;
    private Object preferredHost = null;
    private ResourceInfo nonXAResource;
    private boolean delayRemoveAfterRollback = false;
    boolean onePhase;
    boolean isLLR;
    boolean isOnlyOneResourceInTx;
    boolean isNoResourceInTx;
    boolean isAllEmulated;
    private HashMap resources;
    static final boolean islookupresourceonretryEnabled;
    static final int lookupresourceonretryCount;
    int rollbackRetryCount;
    int commitRetryCount;
    boolean useLLR = false;
    private boolean localConnCommittedOrRollback = false;
    Deque<String> debugMessages = new ConcurrentLinkedDeque<String>();
    volatile boolean printDebugMessagesOnCompletion = false;
    String ackCommitDebugMessages;
    Map<String, String> ackOrNakCommitMap = new ConcurrentHashMap<String, String>();
    private static final boolean INSTR_ENABLED;
    private static final Map<String, String> GLOBAL_PROPERTIES;
    private static final Map<String, String> LOCAL_PROPERTIES;

    protected TransactionImpl() {
    }

    protected TransactionImpl(Xid axid, int aTimeoutSec, int aTimeToLiveSec) {
        this(axid, aTimeoutSec, aTimeToLiveSec, false);
    }

    protected TransactionImpl(Xid axid, int aTimeoutSec, int aTimeToLiveSec, boolean isFromPropagationContext) {
        this.init(axid, aTimeoutSec, aTimeToLiveSec, isFromPropagationContext);
        this.getTM().add(this);
    }

    protected TransactionImpl(Xid xid, Xid foreignXid, int timeOutSecs, int timeToLiveSecs) {
        this.init(xid, timeOutSecs, timeToLiveSecs);
        this.setForeignXid(foreignXid);
        this.getTM().add(this);
    }

    protected void init(Xid axid, int aTimeoutSec, int aTimeToLiveSec) {
        this.init(axid, aTimeoutSec, aTimeToLiveSec, false);
    }

    protected void init(Xid axid, int aTimeoutSec, int aTimeToLiveSec, boolean isFromPropagationContext) {
        String partitionName = PlatformHelper.getPlatformHelper().getPartitionName();
        if (partitionName == null) {
            this.setProperty("weblogic.transaction.partitionName", (Serializable)((Object)"DOMAIN"));
        } else {
            this.setProperty("weblogic.transaction.partitionName", (Serializable)((Object)partitionName));
            this.setProperty("weblogic.transaction.initiator", (Serializable)((Object)this.getTM().getServerName()));
        }
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "init(t/o=" + aTimeoutSec + ",ttl=" + aTimeToLiveSec + ") GLOBAL_PROPERTIES.isEmpty()=" + GLOBAL_PROPERTIES.isEmpty());
        }
        this.xid = (XidImpl)axid;
        this.timeoutSec = aTimeoutSec;
        this.txAsyncTimeout = false;
        if (!isFromPropagationContext) {
            this.setPropertiesFromMap(aTimeoutSec, aTimeToLiveSec, GLOBAL_PROPERTIES, "GLOBAL_PROPERTIES", true);
        }
        if (!isFromPropagationContext) {
            this.setPropertiesFromMap(aTimeoutSec, aTimeToLiveSec, LOCAL_PROPERTIES, "LOCAL_PROPERTIES", false);
        }
        long sofar = (aTimeoutSec - aTimeToLiveSec) * 1000;
        this.setBeginTimeMillis(System.currentTimeMillis() - sofar);
        this.wakeUpAfterSeconds(aTimeToLiveSec);
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "init(t/o=" + aTimeoutSec + ",ttl=" + aTimeToLiveSec + ")", TxDebug.JTA2PCStackTrace.isDebugEnabled() ? new Exception("DEBUG") : null);
        }
    }

    private void setPropertiesFromMap(int aTimeoutSec, int aTimeToLiveSec, Map<String, String> map, String mapName, boolean isGlobal) {
        if (!map.isEmpty()) {
            for (String next : map.keySet()) {
                String value = map.get(next);
                next = next.replace("\"", "");
                if ((value = value.replace("\"", "")).trim().equalsIgnoreCase("true") || value.trim().equalsIgnoreCase("false")) {
                    if (TxDebug.JTA2PC.isDebugEnabled()) {
                        TxDebug.txdebug(TxDebug.JTA2PC, this, "init(t/o=" + aTimeoutSec + ",ttl=" + aTimeToLiveSec + ") " + mapName + " init boolean next:" + next + " value:" + value);
                    }
                    if (isGlobal) {
                        this.setProperty(next, Boolean.valueOf(value));
                        continue;
                    }
                    this.setLocalProperty(next, Boolean.valueOf(value));
                    continue;
                }
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "init(t/o=" + aTimeoutSec + ",ttl=" + aTimeToLiveSec + ") " + mapName + " init next:" + next + " value:" + value);
                }
                if (isGlobal) {
                    this.setProperty(next, (Serializable)((Object)value));
                    continue;
                }
                this.setLocalProperty(next, value);
            }
        }
    }

    @Override
    public void commit() throws jakarta.transaction.RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTA2PC, this, "commit");
            }
            if (this.isImportedTransaction()) {
                throw new SystemException("Cannot call commit on imported transaction directly.  Imported transactions should only be committed via XAResource.commit.  " + this.getXid().toString());
            }
            this.checkIfCommitPossible();
            if (this.getCoordinatorDescriptor() == null) {
                this.setCommitted();
            } else {
                final Coordinator co = (Coordinator)((Object)this.getCoordinator());
                if (co == null) {
                    throw new SystemException("Could not contact coordinator at " + this.getCoordinatorURL());
                }
                if (this.getState() == 1) {
                    this.setCommitting();
                }
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "co.commit");
                }
                if (PlatformHelper.getPlatformHelper().isServer()) {
                    PlatformHelper.getPlatformHelper().runAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            co.commit(TransactionImpl.this.getRequestPropagationContext());
                            return null;
                        }
                    }, this.getCoServerURL(), "co.commit");
                } else {
                    co.commit(this.getRequestPropagationContext());
                }
                this.setCommitted();
            }
        }
        catch (RollbackException wre) {
            try {
                this.globalRollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setRolledBack();
            Throwable rbReason = wre.getNested();
            if (rbReason != null) {
                this.setRollbackReason(rbReason);
            }
            throw wre;
        }
        catch (jakarta.transaction.RollbackException re) {
            try {
                this.globalRollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setRolledBack();
            throw re;
        }
        catch (HeuristicRollbackException hre) {
            this.setCommitted();
            this.addHeuristicErrorMessage(hre.getMessage());
            throw hre;
        }
        catch (HeuristicMixedException hme) {
            this.setCommitted();
            this.addHeuristicErrorMessage(hme.getMessage());
            throw hme;
        }
        catch (SecurityException see) {
            this.setState((byte)1);
            throw see;
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (SystemException se) {
            if (!PlatformHelper.getPlatformHelper().isServer()) {
                this.setUnknown();
            }
            throw se;
        }
        catch (RemoteException re) {
            if (PlatformHelper.getPlatformHelper().isServer()) {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "Lost connection to server while delegated commit was in progress.  Ignoring because initiating server is not the coordinating server.  Remote Exception received=" + re.toString());
                }
                throw new SystemException("Lost connection to server while commit was in progress, ignoring because initiating server is not coordinating server. Remote Exception received=" + re.toString());
            }
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTA2PC, this, "Lost connection to server while delegated commit was in progress.  Setting transaction state to unkown.  Remote Exception received=" + re.toString());
            }
            this.setUnknown();
            throw new SystemException("Lost connection to server while commit was in progress, so the local transaction is now in an unknown state. Remote Exception received=" + re.toString());
        }
        catch (AbortRequestedException tae) {
            try {
                this.globalRollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.throwRollbackException();
        }
        catch (Exception e) {
            if (PlatformHelper.getPlatformHelper().isServer()) {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "Unexpected exception while delegated commit was in progress.  Ignoring exception because initiating server is not the coordinating server.  Remote Exception received=" + e.toString());
                }
                throw new SystemException("Unexpected exception while commit was in progress, ignoring because initiating server is not coordinating server. Remote Exception received=" + e.toString());
            }
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTA2PC, this, "Unexpected exception while delegated commit was in progress.  Setting transaction state to unkown.  Remote Exception received=" + e.toString());
            }
            this.setUnknown();
            throw new SystemException("Unexpected exception while commit was in progress, so the local transaction is now in an unknown state. Remote Exception received=" + e.toString());
        }
        finally {
            this.getTM().suspend(this);
        }
    }

    void checkIfDeterminerIsUnregisteredFromThisServer() throws jakarta.transaction.RollbackException {
        ArrayList resList;
        if (this.getTM().isAnyDeterminerUnregistered() && (resList = this.getResourceInfoList()) != null) {
            for (Object aResList : resList) {
                ResourceInfo sri = (ResourceInfo)aResList;
                String name = sri.getName();
                boolean isMatch = name != null && this.getTM().isInUnRegisteredDeterminerList(name);
                if (!isMatch) continue;
                throw new jakarta.transaction.RollbackException("Determiner resource " + name + " was undeployed from this server and must be redeployed back to this server or the cluster in order to participate in transactions involving this server. Transaction : " + this);
            }
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "ClientTransactionImpl.rollback()");
        }
        if (this.isImportedTransaction()) {
            throw new SystemException("Cannot call rollback on imported transaction directly.  Imported transactions should only be rolled back via XAResource.rollback.  " + this.getXid().toString());
        }
        this.internalRollback();
    }

    public void internalRollback() throws IllegalStateException, SystemException {
        try {
            switch (this.getState()) {
                case 4: 
                case 9: {
                    return;
                }
                case 2: {
                    if (this.isImportedTransaction()) break;
                }
                case 3: 
                case 8: {
                    this.throwIllegalStateException("Transaction cannot be rolled back anymore, status=" + this.getStatusAsString());
                }
            }
            if (this.getCoordinatorDescriptor() == null) {
                this.setRolledBack();
                return;
            }
            try {
                this.globalRollback();
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SystemException(e.toString());
            }
        }
        finally {
            this.getTM().suspend(this);
        }
    }

    @Override
    public boolean enlistResource(XAResource xar) throws jakarta.transaction.RollbackException, IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    @Override
    public boolean enlistResource(XAResource xaRes, String resourceNameAlias) throws jakarta.transaction.RollbackException, IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    @Override
    public boolean enlistResourceWithProperties(XAResource xaRes, Map properties) throws jakarta.transaction.RollbackException, IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    @Override
    public boolean delistResource(XAResource xar, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    @Override
    public boolean delistResourceWithProperties(XAResource xaRes, int flags, Map delistmentProperties) throws IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    @Override
    public boolean enlistResource(NonXAResource nxar) throws jakarta.transaction.RollbackException, IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    @Override
    public int getStatus() {
        if (this.isMarkedRollback()) {
            return 1;
        }
        short st = this.getState();
        switch (st) {
            case 1: {
                return 0;
            }
            case 4: {
                return 7;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 12: {
                return 5;
            }
        }
        TXLogger.logUnknownGetStatusState(st);
        return 5;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws jakarta.transaction.RollbackException, IllegalStateException, SystemException {
        throw new SystemException("You may enlist a resource only on a server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "TX[" + this.getXID() + "] setRollbackOnly()", TxDebug.JTA2PCStackTrace.isDebugEnabled() ? new Exception("DEBUG") : null);
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.setRollbackReason(new weblogic.transaction.internal.AppSetRollbackOnlyException("setRollbackOnly called on transaction"));
            switch (this.getStatus()) {
                case 1: 
                case 9: {
                    return;
                }
                case 2: 
                case 3: 
                case 8: {
                    this.throwIllegalStateException("Cannot mark the transaction for rollback as it is committed.");
                    break;
                }
                case 4: {
                    if (!IS_ISE_THROWN_DUE_TO_TIMEOUT_RB && this.getRollbackReasonCode() == 1) break;
                    this.throwIllegalStateException("Cannot mark the transaction for rollback as it has been rolledback");
                    break;
                }
                case 0: 
                case 5: {
                    this.markRollback();
                    break;
                }
            }
        }
    }

    @Override
    public Xid getXID() {
        return this.xid;
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    @Override
    public final void setName(String n) {
        this.setProperty("weblogic.transaction.name", (Serializable)((Object)n));
    }

    @Override
    public final String getName() {
        return (String)((Object)this.getProperty("weblogic.transaction.name"));
    }

    @Override
    public String getStatusAsString() {
        Throwable rbrThr = this.getRollbackReason();
        String rbr = rbrThr == null ? "Unknown" : rbrThr.toString();
        switch (this.getStatus()) {
            case 0: {
                return "Active";
            }
            case 7: {
                return "Preparing";
            }
            case 2: {
                return "Prepared";
            }
            case 9: {
                return "Rolling Back. [Reason=" + rbr + "]";
            }
            case 1: {
                return "Marked rollback. [Reason=" + rbr + "]";
            }
            case 8: {
                return "Committing";
            }
            case 3: {
                return "Committed";
            }
            case 4: {
                return "Rolled back. [Reason=" + rbr + "]";
            }
            case 5: {
                return "Unknown";
            }
        }
        return "****** UNKNOWN STATE **** : " + this.getStatus();
    }

    @Override
    public final synchronized void setRollbackOnly(Throwable t) {
        this.setRollbackOnlyUnsync(t);
    }

    final void setRollbackOnlyUnsync(Throwable t) {
        if (this.isOver()) {
            return;
        }
        this.setRollbackReason(t);
        this.markRollback();
    }

    @Override
    public final synchronized void setRollbackOnly(String msg, Throwable t) {
        NestedException nestedEx = new NestedException(msg, t);
        this.setRollbackOnlyUnsync(nestedEx);
    }

    @Override
    public synchronized void setRollbackOnly(String msg) {
        Exception nestedEx = new Exception(msg);
        this.setRollbackOnlyUnsync(nestedEx);
    }

    @Override
    public final Throwable getRollbackReason() {
        if (this.rollbackReason instanceof NestedException) {
            NestedException ne = (NestedException)this.rollbackReason;
            return ne.getNestedException();
        }
        return this.rollbackReason;
    }

    @Override
    public synchronized void setProperty(String key, Serializable value) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "setProperty: " + key + "=" + value);
        }
        if (key == null) {
            return;
        }
        Map props = this.getOrCreateGlobalProperties();
        if (key.equals("weblogic.transaction.name")) {
            if (props.get(key) != null) {
                return;
            }
            if (value == null) {
                return;
            }
            String txname = value.toString();
            if (txname != null && txname.length() > 0) {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "setName: " + txname);
                }
                props.put(key, txname);
            }
            return;
        }
        if (key.equals("weblogic.transaction.timeoutSeconds")) {
            int newTimeoutSec;
            if (value != null && value instanceof Integer && (newTimeoutSec = ((Integer)value).intValue()) > this.timeoutSec) {
                this.wakeUpAfterSeconds(this.getTimeToLiveSeconds() + newTimeoutSec - this.timeoutSec);
            }
            return;
        }
        if (key.equals("weblogic.transaction.nonXAResource")) {
            if (props.get(key) != null) {
                return;
            }
            if (value == null) {
                return;
            }
            props.put(key, value);
            return;
        }
        if (value == null) {
            props.remove(key);
        } else {
            props.put(key, value);
        }
    }

    @Override
    public synchronized void addProperties(Map moreprops) {
        if (moreprops == null) {
            return;
        }
        for (Map.Entry me : moreprops.entrySet()) {
            try {
                this.setProperty((String)me.getKey(), (Serializable)me.getValue());
            }
            catch (ClassCastException cce) {
                TXLogger.logTxPropertyTypeError();
            }
        }
    }

    @Override
    public synchronized Serializable getProperty(String key) {
        if (key.equals("weblogic.transaction.timeoutSeconds")) {
            return Integer.valueOf(this.getTimeToLiveSeconds());
        }
        if (key != null && this.globalProperties != null) {
            return (Serializable)this.globalProperties.get(key);
        }
        return null;
    }

    @Override
    public synchronized Map getProperties() {
        if (this.globalProperties == null) {
            return null;
        }
        return (Map)this.globalProperties.clone();
    }

    @Override
    public void setLocalProperty(String key, Object value) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "setLocalProperty: " + (key == null ? "null" : key) + "=" + (value == null ? "null" : value.toString()));
        }
        if (key == null) {
            return;
        }
        ConcurrentHashMap props = this.getOrCreateLocalProperties();
        if (value == null) {
            props.remove(key);
        } else {
            props.put(key, value);
        }
        if (key.equals("weblogic.transaction.otsTransactionExport") || key.equals("weblogic.transaction.local.coordinator.assignment")) {
            this.setCoordinatorDescriptor(this.getTM().getLocalCoordinatorDescriptor());
            props.remove(key);
        }
    }

    @Override
    public void addLocalProperties(Map moreprops) {
        if (moreprops == null) {
            return;
        }
        for (Map.Entry me : moreprops.entrySet()) {
            try {
                this.setLocalProperty((String)me.getKey(), me.getValue());
            }
            catch (ClassCastException cce) {
                TXLogger.logTxLocalPropertyTypeError();
            }
        }
    }

    @Override
    public Object getLocalProperty(String key) {
        if (key != null && this.localProperties != null) {
            return this.localProperties.get(key);
        }
        return null;
    }

    @Override
    public Map getLocalProperties() {
        if (this.localProperties == null) {
            return null;
        }
        return new HashMap(this.localProperties);
    }

    @Override
    public final Object invokeCoordinatorService(String name, Object data) throws SystemException, RemoteException {
        return this.invokeCoordinatorService(name, data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object invokeCoordinatorService(String name, Object data, boolean useSSL) throws SystemException, RemoteException {
        if (this.getCoordinatorDescriptor() == null) {
            throw new SystemException("No assigned coordinator for transaction.");
        }
        Coordinator co = null;
        if (useSSL) {
            this.setSSLEnabled(useSSL);
            Serializable orgProt = null;
            try {
                String sslUrl;
                orgProt = this.getProperty("weblogic.transaction.protocol");
                CoordinatorDescriptor cd = this.getCoordinatorDescriptor();
                if (cd != null && (sslUrl = PlatformHelper.getPlatformHelper().findLocalSSLURL(this.getCoordinatorURL())) != null) {
                    this.getCoordinatorDescriptor().setSSLCoordinatorURL(sslUrl);
                    this.setProperty("weblogic.transaction.protocol", (Serializable)((Object)"t3s"));
                }
                co = (Coordinator)((Object)this.getCoordinator());
            }
            finally {
                this.setProperty("weblogic.transaction.protocol", orgProt);
            }
        } else {
            co = (Coordinator)((Object)this.getCoordinator());
        }
        if (co == null) {
            throw new SystemException("Could not reach server at " + this.getCoordinatorURL() + " for service " + name);
        }
        if (!(co instanceof CoordinatorService)) {
            throw new SystemException("Server at " + this.getCoordinatorURL() + " does not support service " + name);
        }
        return ((CoordinatorService)((Object)co)).invokeCoordinatorService(name, data);
    }

    @Override
    public final boolean isCoordinatorLocal() throws SystemException {
        CoordinatorDescriptor cd = this.getCoordinatorDescriptor();
        if (cd == null) {
            throw new SystemException("No assigned coordinator.");
        }
        return this.getTM().isLocalCoordinator(cd);
    }

    @Override
    public final boolean isCoordinatorAssigned() {
        return this.getCoordinatorDescriptor() != null;
    }

    @Override
    public long getMillisSinceBegin() {
        return System.currentTimeMillis() - this.beginTimeMillis;
    }

    @Override
    public long getTimeToLiveMillis() {
        return (long)this.getTimeToLiveSeconds() * 1000L;
    }

    @Override
    public String getHeuristicErrorMessage() {
        return this.heuristicError;
    }

    @Override
    public boolean isTimedOut() {
        return this.getRollbackReasonCode() == 1;
    }

    protected void setTxAsyncTimeout(boolean value) {
        this.loggerTransactionTimedOut();
        this.txAsyncTimeout = value;
    }

    @Override
    public boolean isTxAsyncTimeout() {
        return this.txAsyncTimeout;
    }

    public int hashCode() {
        return this.xid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TransactionImpl) {
            TransactionImpl tx = (TransactionImpl)obj;
            return tx.xid.equals(this.xid);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList resourceList;
        StringBuffer sb = new StringBuffer(100);
        String name = this.getName();
        if (name != null) {
            sb.append("Name=" + name + ",");
        }
        sb.append("Xid=").append(this.getXID()).append("(").append(System.identityHashCode(this)).append(")").append(",Status=").append(this.getStatusAsString());
        if (this.hasHeuristics()) {
            sb.append(",HeuristicErrorCode=").append(XAResourceHelper.xaErrorCodeToString(this.getHeuristicErrorCode(), false));
        }
        sb.append(",numRepliesOwedMe=").append(this.numRepliesOwedMe).append(",numRepliesOwedOthers=").append(this.numRepliesOwedOthers).append(",seconds since begin=" + this.getMillisSinceBegin() / 1000L).append(",seconds left=" + this.getTimeToLiveSeconds()).append(",useSecure=" + this.useSecureURL);
        if (this.activeThread != null) {
            sb.append(",activeThread=" + this.activeThread);
        }
        if ((resourceList = this.getResourceInfoList()) != null) {
            for (int i = 0; i < resourceList.size(); ++i) {
                if (resourceList.get(i) == null) continue;
                sb.append(",").append(resourceList.get(i).toString());
            }
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            List scList = this.getSCInfoList();
            if (scList != null) {
                for (Object aScList : scList) {
                    sb.append(",").append(aScList);
                }
            }
        }
        if (this.globalProperties != null) {
            sb.append(",properties=(" + this.getProperties() + ")");
        }
        if (this.localProperties != null) {
            sb.append(",local properties=(" + this.getLocalProperties() + ")");
        }
        if (this.getOwnerTransactionManager() != null) {
            sb.append(",OwnerTransactionManager=" + this.getOwnerTransactionManager());
        }
        if (this.getCoordinatorDescriptor() != null) {
            sb.append(",CoordinatorURL=" + this.getCoordinatorURL());
        }
        sb.append(")");
        return sb.toString();
    }

    void setPreferredHost(Object pref) {
        if (this.preferredHost == null) {
            this.preferredHost = pref;
        }
    }

    Object getPreferredHost() {
        return this.preferredHost;
    }

    synchronized String[] getSCNames() {
        List scList = this.getSCInfoList();
        if (scList == null) {
            return null;
        }
        String[] scNames = new String[scList.size()];
        for (int i = 0; i < scList.size(); ++i) {
            SCInfo sci = (SCInfo)scList.get(i);
            scNames[i] = sci.getName();
        }
        return scNames;
    }

    int getRollbackReasonCode() {
        Throwable t = this.getRollbackReason();
        if (t instanceof NestedException) {
            t = ((NestedException)t).getNestedException();
        }
        if (t == null) {
            return 2;
        }
        if (t instanceof TimedOutException) {
            return 1;
        }
        if (t instanceof AppSetRollbackOnlyException) {
            return 2;
        }
        if (t instanceof XAException) {
            return 3;
        }
        if (t instanceof SystemException) {
            return 4;
        }
        return 2;
    }

    public final synchronized void incrRepliesOwedMe() {
        ++this.numRepliesOwedMe;
        if (TxDebug.JTAPropagate.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.incrRepliesOwedMe(): numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers);
        }
    }

    public final synchronized void decrRepliesOwedMe() {
        if (this.numRepliesOwedMe > 0) {
            --this.numRepliesOwedMe;
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.decrRepliesOwedMe(): numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers);
            }
        } else if (TxDebug.JTAPropagate.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.decrRepliesOwedMe(): numRepliesOwedMe cannot be negative; numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers);
        }
    }

    public final synchronized void incrRepliesOwedOthers() {
        ++this.numRepliesOwedOthers;
        if (TxDebug.JTAPropagate.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.incrRepliesOwedOthers(): numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers);
        }
    }

    public final synchronized boolean decrRepliesOwedOthers() {
        if (this.numRepliesOwedOthers > 0) {
            --this.numRepliesOwedOthers;
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.decrRepliesOwedOthers(): numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers);
            }
        } else if (TxDebug.JTAPropagate.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.decrRepliesOwedOthers(): numRepliesOwedOthers cannot be negative; numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers);
        }
        if (this.numRepliesOwedOthers <= 0 && this.numRepliesOwedMe > 0 && this.getTM() != this.getOwnerTransactionManager()) {
            if (TxDebug.JTAPropagate.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTAPropagate, this, "TransactionImpl.decrRepliesOwedOthers(): checked behavior violation; numRepliesOwedMe=" + this.numRepliesOwedMe + ", numRepliesOwedOthers=" + this.numRepliesOwedOthers + ", TM=" + this.getTM() + ", ownerTransactionManager=" + this.getOwnerTransactionManager());
            }
            return false;
        }
        return true;
    }

    public final int getWakeupTimeSeconds() {
        return this.wakeUpTimeSec;
    }

    @Override
    public final int getTimeToLiveSeconds() {
        long t = (long)this.wakeUpTimeSec - System.currentTimeMillis() / 1000L;
        int ret = (int)(t > Integer.MAX_VALUE ? Integer.MAX_VALUE : t);
        return ret;
    }

    int getNumRepliesOwedMe() {
        return this.numRepliesOwedMe;
    }

    int getNumRepliesOwedOthers() {
        return this.numRepliesOwedOthers;
    }

    void abort() throws AbortRequestedException {
        throw new AbortRequestedException();
    }

    void abort(String msg) throws AbortRequestedException {
        this.setRollbackOnly(new SystemException(msg));
        this.abort();
    }

    void abortUnsync(String msg) throws AbortRequestedException {
        this.setRollbackOnlyUnsync(new SystemException(msg));
        this.abort();
    }

    void abort(Throwable t) throws AbortRequestedException {
        this.setRollbackOnly(t);
        this.abort();
    }

    void abort(String msg, Throwable t) throws AbortRequestedException {
        this.setRollbackOnly(new NestedException(msg, t));
        this.abort();
    }

    void abort(String msg, Throwable t, boolean overrideReason) throws AbortRequestedException {
        if (ALLOW_OVERRIDE_SETROLLBACK_REASON) {
            this.requestOverrideRollbackReason = overrideReason;
        }
        this.abort(msg, t);
    }

    SCInfo createSCInfo(String scURL) {
        return new SCInfo(scURL);
    }

    synchronized SCInfo getOrCreateSCInfo(String scURL) {
        String ascURL = scURL;
        if (this.scInfoList != null) {
            for (int i = 0; i < this.scInfoList.size(); ++i) {
                SCInfo sci = (SCInfo)this.scInfoList.get(i);
                CoordinatorDescriptor cd = sci.getCoordinatorDescriptor();
                if (!cd.representsCoordinatorURL(ascURL)) continue;
                return sci;
            }
        }
        SCInfo sci = this.createSCInfo(ascURL);
        this.addSC(sci);
        return sci;
    }

    synchronized List getAndRemoveSCInfo(SCInfo migSci) {
        CoordinatorDescriptor migCoorDesc = migSci.getCoordinatorDescriptor();
        if (this.scInfoList != null) {
            for (int i = 0; i < this.scInfoList.size(); ++i) {
                SCInfo sci = (SCInfo)this.scInfoList.get(i);
                if (!sci.getCoordinatorDescriptor().equals(migCoorDesc)) continue;
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "getAndRemoveSCInfo remove sci = " + sci);
                }
                this.scInfoList.remove(sci);
            }
        }
        return this.scInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List getSCInfoList() {
        if (this.isResourceNotFound()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                return this.scInfoList;
            }
        }
        return this.scInfoList;
    }

    synchronized List getAndSubstituteSCInfo(List setSCInfoList) {
        SCInfo sciadd = null;
        this.scInfoList = new CopyOnWriteArrayList();
        if (setSCInfoList != null) {
            for (int i = 0; i < setSCInfoList.size(); ++i) {
                sciadd = (SCInfo)setSCInfoList.get(i);
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "getAndSubstituteSCInfoList add sciadd = " + sciadd);
                }
                this.scInfoList.add(sciadd);
            }
        }
        return this.scInfoList;
    }

    ArrayList getResourceInfoList() {
        return this.resourceInfoList;
    }

    public PropagationContext getRequestPropagationContext() {
        return new PropagationContext(this);
    }

    public PropagationContext getResponsePropagationContext() {
        return new PropagationContext(this);
    }

    public final synchronized boolean isCancelled() {
        return this.isCancelledUnsync();
    }

    final boolean isCancelledUnsync() {
        if (this.isMarkedRollback() && this.getProperty("DISABLE_TX_STATUS_CHECK") == null) {
            return true;
        }
        switch (this.getState()) {
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public final boolean isOver() {
        switch (this.getState()) {
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    final void markRollback() {
        this.markedRollback = true;
        this.wakeUpAfterSeconds(this.getNormalizedTimeoutSeconds());
        if (TxDebug.isIsDebugConditionalSetRollbackOnly) {
            this.printDebugMessages();
        }
        this.notify();
    }

    void addHeuristicErrorMessage(String heur) {
        this.heuristicError = this.heuristicError == null ? heur : this.heuristicError + ", " + heur;
    }

    void addackOrNakCommitDebugMessage(String debugmessage, String scURL) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            this.ackCommitDebugMessages = this.ackCommitDebugMessages + debugmessage;
            this.ackOrNakCommitMap.put(scURL, debugmessage);
        }
    }

    void addResourceCompletionState(short st, String scURL) {
        if (st == 4) {
            this.getTM().addToListOfAckCommits(this.xid, scURL);
        }
        this.addXAResourceCompletionState(st, scURL);
    }

    void addXAResourceCompletionState(short st, String scURL) {
        if ((st == 2 || st == 1) && this.getProperty("ackCommitSCs") != null && ((Map)((Object)this.getProperty("ackCommitSCs"))).get(scURL) != null) {
            st = (short)4;
        }
        this.completionState = (short)(this.completionState | st);
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(50);
            if ((this.completionState & 1) != 0) {
                sb.append(" C_HEURISTIC_MIXED");
            }
            if ((this.completionState & 2) != 0) {
                sb.append(" C_HEURISTIC_HAZARD");
            }
            if ((this.completionState & 4) != 0) {
                sb.append(" C_COMMITTED");
            }
            if ((this.completionState & 8) != 0) {
                sb.append(" C_ROLLEDBACK");
            }
            TxDebug.txdebug(TxDebug.JTA2PC, this, "setResourceOrSCCompletionState:" + sb.toString() + " scURL:" + scURL);
        }
    }

    void setTimeoutSeconds(int seconds) {
        this.timeoutSec = seconds;
    }

    public void setActiveThread(Thread t) {
        this.activeThread = t;
    }

    Thread getActiveThread() {
        return this.activeThread;
    }

    public void setOwnerTransactionManager(TransactionManagerImpl atm) {
        this.ownerTM = atm;
    }

    ResourceInfo createResourceInfo(String resourceName, boolean enlistedElsewhere) {
        return new ResourceInfo(resourceName);
    }

    ResourceInfo getOrCreateResourceInfo(String resourceName) {
        return this.getOrCreateResourceInfo(resourceName, false);
    }

    synchronized ResourceInfo getOrCreateResourceInfo(String resourceName, boolean enlistedElsewhere) {
        ResourceInfo ri = this.getResourceInfo(resourceName);
        if (ri == null) {
            ri = this.createResourceInfo(resourceName, enlistedElsewhere);
            this.addResourceInfoUnsync(ri);
        }
        return ri;
    }

    public final CoordinatorDescriptor getCoordinatorDescriptor() {
        return this.coordinatorDescriptor;
    }

    final String getCoordinatorURL() {
        if (this.coordinatorDescriptor == null) {
            return null;
        }
        return this.coordinatorDescriptor.getCoordinatorURL(this.useSecureURL);
    }

    final String getCoServerURL() {
        if (this.coordinatorDescriptor == null) {
            return null;
        }
        String coURL = this.coordinatorDescriptor.getCoordinatorURL(this.useSecureURL);
        return CoordinatorDescriptor.getServerURL(coURL);
    }

    abstract boolean setCoordinatorURL(String var1);

    final String updateCoordinatorDescriptor(String coUrl) {
        String handoffURL = null;
        if (this.coordinatorDescriptor != null && !this.getTM().isLocalCoordinator(coUrl) && this.coordinatorDescriptor.getServerID().equals(CoordinatorDescriptor.getServerID(coUrl)) && !this.coordinatorDescriptor.getCoordinatorURL().equals(coUrl)) {
            handoffURL = this.coordinatorDescriptor.getCoordinatorURL();
            this.coordinatorDescriptor.reinitialize(coUrl);
        }
        return handoffURL;
    }

    final synchronized boolean setCoordinatorDescriptor(CoordinatorDescriptor aCo) {
        return this.setCoordinatorDescriptor(aCo, false);
    }

    final synchronized boolean setCoordinatorDescriptor(CoordinatorDescriptor aCo, boolean isCrossSiteRecovery) {
        if (!this.isCoordinatorDescriptorAssignable()) {
            return false;
        }
        if (aCo == null) {
            return false;
        }
        assert (aCo.getServerName() != null && aCo.getDomainName() != null);
        this.coordinatorDescriptor = PlatformHelper.getPlatformHelper().isServer() && this.getTM().isLocalCoordinator(aCo) ? this.getTM().getLocalCoordinatorDescriptor() : aCo;
        String siteName = this.getTM().getSiteName();
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            String coURLHash = new String(aCo.getURLHash());
            TxDebug.txdebug(TxDebug.JTA2PC, this, "setCoordinatorURL =>" + aCo.getCoordinatorURL() + " URLHash:" + coURLHash + " site-name:" + siteName);
        }
        if (siteName != null && !siteName.trim().equals("")) {
            if (this.coordinatorDescriptor.getSiteNameHash() == null) {
                this.coordinatorDescriptor.setSiteName(siteName);
            }
            if (!isCrossSiteRecovery) {
                this.xid.setCoordinatorURL(this.coordinatorDescriptor.getURLHash(), this.coordinatorDescriptor.getSiteNameHash());
            }
        } else {
            this.xid.setCoordinatorURL(this.coordinatorDescriptor.getURLHash());
        }
        return true;
    }

    boolean setCoordinatorDescriptor(String coordinatorURL) {
        CoordinatorDescriptor cd;
        if (this.isCoordinatorDescriptorAssignable() && (cd = CoordinatorDescriptor.getOrCreate(coordinatorURL)) != null) {
            return this.setCoordinatorDescriptor(cd);
        }
        return false;
    }

    boolean setCoordinatorDescriptor(Object id, ChannelInterface channel) {
        CoordinatorDescriptor cd;
        this.setSSLEnabled(PlatformHelper.getPlatformHelper().isSSLEnabled(id, channel));
        if (this.isCoordinatorDescriptorAssignable() && (cd = CoordinatorDescriptor.getOrCreate(id, channel)) != null) {
            return this.setCoordinatorDescriptor(cd);
        }
        return false;
    }

    @Override
    public boolean isSSLEnabled() {
        return this.useSecureURL;
    }

    public void setSSLEnabled(boolean enabled) {
        this.useSecureURL = enabled;
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "setSSLEnabled(" + enabled + ")", TxDebug.JTA2PCStackTrace.isDebugEnabled() ? new Exception("DEBUG") : null);
        }
    }

    public final boolean isActive() {
        switch (this.getState()) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    final boolean isCommittingOrRollingback() {
        return this.isCommitting() || this.isRollingBack();
    }

    public final boolean isStateActive() {
        return this.getState() == 1;
    }

    final int getTimeoutSeconds() {
        return this.timeoutSec;
    }

    int getNormalizedTimeoutSeconds() {
        int timeoutSec = this.getTimeoutSeconds();
        if (timeoutSec < 10) {
            timeoutSec = 10;
        } else if (timeoutSec > 60) {
            timeoutSec = 60;
        }
        return timeoutSec;
    }

    final int getAbandonTimeoutSeconds() {
        int timeoutSec;
        int tmAbandonSec = this.getTM().getAbandonTimeoutSeconds();
        return tmAbandonSec < (timeoutSec = this.getTimeoutSeconds()) ? timeoutSec : tmAbandonSec;
    }

    int getCompletionTimeoutSeconds() {
        String tmTimeout = (String)((Object)this.getProperty("completion-timeout-seconds"));
        int tmCompletionSec = 0;
        if (tmTimeout != null) {
            try {
                tmCompletionSec = Integer.parseInt(tmTimeout);
            }
            catch (NumberFormatException nfe) {
                TXLogger.logTxCompletionTimeoutSecondsError();
            }
            if (tmCompletionSec < -1) {
                TXLogger.logTxCompletionTimeoutSecondsError();
                tmCompletionSec = 0;
            }
        } else {
            tmCompletionSec = this.getTM().getCompletionTimeoutSeconds();
        }
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "completion-timeout =" + tmCompletionSec);
        }
        int tmAbandonSec = this.getTM().getAbandonTimeoutSeconds();
        if (tmCompletionSec == 0) {
            return 2 * this.getNormalizedTimeoutSeconds();
        }
        if (tmCompletionSec == -1) {
            return Integer.MAX_VALUE;
        }
        if (tmAbandonSec < tmCompletionSec) {
            return tmAbandonSec;
        }
        return tmCompletionSec;
    }

    public void wakeUp(int nowSec) {
        try {
            if (this.isAbandoned(nowSec)) {
                return;
            }
            this.wakeUpAfterSeconds(this.getNormalizedTimeoutSeconds());
            if (this.isMarkedRollback()) {
                try {
                    this.setRollbackOnly(new TimedOutException(this.getXid().toString()));
                    this.asyncRollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (this.getState()) {
                case 1: {
                    this.setRollbackOnly(new TimedOutException(this));
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 8: {
                    TXLogger.logWakeupForCommittedTx(this.toString());
                    break;
                }
                case 10: 
                case 11: {
                    this.getTM().remove(this);
                    break;
                }
                default: {
                    this.setRolledBack();
                    this.getTM().remove(this);
                    TXLogger.logWakeupStateErrorForceRB(this.toString());
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final byte getState() {
        return this.state;
    }

    static void setAbandonGraceTimeEndSec(int sec) {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("setAbandonGraceTimeEndSec(" + sec + ")");
        }
        abandonGraceTimeEndSec = sec;
    }

    final void setNonXAResource(ResourceInfo nxar) {
        this.nonXAResource = nxar;
    }

    final ResourceInfo getNonXAResource() {
        return this.nonXAResource;
    }

    public Xid getForeignXid() {
        return (Xid)((Object)this.getProperty("weblogic.transaction.foreignXid"));
    }

    void setForeignXid(Xid foreignXid) {
        this.setProperty("weblogic.transaction.foreignXid", XidImpl.create(foreignXid));
    }

    public boolean isImportedTransaction() {
        return this.getProperty("weblogic.transaction.foreignXid") != null;
    }

    void setForeignOnePhase(boolean onePhase) {
        if (onePhase) {
            this.setProperty("weblogic.transaction.foreignOnePhase", (Serializable)((Object)"true"));
        } else {
            this.setProperty("weblogic.transaction.foreignOnePhase", null);
        }
    }

    boolean isForeignOnePhase() {
        return this.getProperty("weblogic.transaction.foreignOnePhase") != null;
    }

    public int getHeuristicErrorCode() {
        return this.heuristicErrorCode;
    }

    public boolean hasHeuristics() {
        return this.heuristicErrorCode != -1 && this.heuristicErrorCode != 0;
    }

    protected final boolean isCoordinatorDescriptorAssignable() {
        return this.coordinatorDescriptor == null || this.isOTSExport();
    }

    protected final void setXID(XidImpl axid) {
        this.xid = axid;
    }

    protected final void unmarkRollback() {
        this.markedRollback = false;
    }

    protected final short getCompletionState() {
        return this.completionState;
    }

    protected final int getNumResources() {
        if (this.resourceInfoList != null) {
            return this.resourceInfoList.size();
        }
        return 0;
    }

    public final boolean isMarkedRollback() {
        return this.markedRollback;
    }

    protected synchronized SCInfo getSCInfo(String scURL) {
        if (this.scInfoList != null) {
            for (int i = 0; i < this.scInfoList.size(); ++i) {
                SCInfo sci = (SCInfo)this.scInfoList.get(i);
                if (!sci.getCoordinatorDescriptor().representsCoordinatorURL(scURL)) continue;
                return sci;
            }
        }
        return null;
    }

    public void globalRollback() throws SystemException, IllegalStateException {
        this.localRollback();
        if (this.getCoordinatorURL() != null) {
            try {
                final Coordinator co = (Coordinator)((Object)this.getCoordinator());
                if (co == null) {
                    throw new SystemException("Could not contact coordinator at " + this.getCoordinatorURL());
                }
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "co.rollback");
                }
                try {
                    if (PlatformHelper.getPlatformHelper().isServer()) {
                        PlatformHelper.getPlatformHelper().runAction(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                co.rollback(TransactionImpl.this.getRequestPropagationContext());
                                return null;
                            }
                        }, this.getCoServerURL(), "co.rollback");
                    } else {
                        co.rollback(this.getRequestPropagationContext());
                    }
                }
                catch (Exception e) {
                    if (e instanceof SystemException) {
                        throw (SystemException)e;
                    }
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    if (e instanceof RemoteException) {
                        throw (RemoteException)e;
                    }
                    throw new AssertionError((Object)e);
                }
            }
            catch (RemoteException re) {
                String msg = "Coordinator.rollback. Unable to contact coordinator";
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "co.rollback failed", re);
                }
                throw new SystemException(msg + ": " + re);
            }
        }
    }

    protected void localRollback() {
        this.setRolledBack();
    }

    public void setRollbackReason(Throwable t) {
        if (t != null && (this.requestOverrideRollbackReason && this.rollbackReason != null && this.rollbackReason instanceof AppSetRollbackOnlyException || this.rollbackReason == null)) {
            this.rollbackReason = t;
        }
    }

    protected final String getRollbackReasonMessage() {
        NestedException ne;
        Throwable t;
        String unknown = "Unknown reason";
        String nestedMsg = null;
        if (this.rollbackReason == null) {
            return unknown;
        }
        String msg = this.rollbackReason.getMessage();
        if (this.rollbackReason instanceof NestedException && (t = (ne = (NestedException)this.rollbackReason).getNestedException()) != null) {
            nestedMsg = t.getMessage();
        }
        if (nestedMsg != null) {
            if (msg != null) {
                msg = msg + PlatformHelper.getPlatformHelper().getEOLConstant();
            }
            msg = msg + nestedMsg;
        }
        if (msg != null) {
            return msg;
        }
        return unknown;
    }

    protected final void setState(byte newState) {
        if (TxDebug.JTA2PC.isDebugEnabled() && this.state != newState) {
            TxDebug.txdebug(TxDebug.JTA2PC, this, "TX[" + this.getXID() + "] " + this.getStateAsString(this.state) + "-->" + this.getStateAsString(newState), TxDebug.JTA2PCStackTrace.isDebugEnabled() ? new Exception("DEBUG") : null);
        }
        this.state = newState;
    }

    protected final synchronized void checkIfCommitPossible() throws jakarta.transaction.RollbackException, AbortRequestedException, IllegalStateException {
        switch (this.getStatus()) {
            case 4: 
            case 9: {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "TransactionImpl.checkIfCommitPossible(): " + this.getStatusAsString());
                }
                this.setRollbackReason(new SystemException("The transaction has been rolled back"));
                this.throwRollbackException();
            }
            case 1: {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.txdebug(TxDebug.JTA2PC, this, "TransactionImpl.checkIfCommitPossible(): " + this.getStatusAsString());
                }
                this.setRollbackReason(new SystemException("The transaction has been marked rollback"));
                throw new AbortRequestedException();
            }
        }
        this.checkOwner();
        if (!this.isActive()) {
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTA2PC, this, "TransactionImpl.checkIfCommitPossible(): not active");
            }
            this.throwIllegalStateException("Cannot commit transaction");
        }
        this.enforceCheckedTransaction();
        this.checkIfDeterminerIsUnregisteredFromThisServer();
    }

    protected void checkOwner() throws SecurityException {
        if (this.getTM() != this.getOwnerTransactionManager()) {
            String msg = "Attempt to commit in a different server from the one in which this transaction was begun.  " + this.getXid().toString();
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTA2PC, this, "TransactionImpl.checkIfCommitPossible(): " + msg);
            }
            throw new SecurityException(msg);
        }
    }

    protected void enforceCheckedTransaction() throws AbortRequestedException {
        if (this.numRepliesOwedMe != 0) {
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTA2PC, this, "TransactionImpl.checkIfCommitPossible(): " + this.numRepliesOwedMe + " replies outstanding");
            }
            String trailer = this.numRepliesOwedMe == 1 ? "is one such request" : "are " + this.numRepliesOwedMe + " such requests";
            this.abort("Commit can be issued only when there are no requests awaiting responses. Currently there " + trailer);
        }
    }

    public final synchronized boolean isResumePossible() {
        if (this.getTM() == this.getOwnerTransactionManager()) {
            return true;
        }
        return this.numRepliesOwedOthers > 0;
    }

    protected final boolean isAbandoned() {
        return this.getState() == 12;
    }

    protected boolean isAbandoned(int nowSec) {
        if (nowSec < abandonGraceTimeEndSec) {
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.JTA2PC.debug("Still within transaction abandon grace period.  Will start abandoning transactions after " + (abandonGraceTimeEndSec - nowSec) + " seconds.  " + this);
            }
            return false;
        }
        int abortSec = this.getAbandonTimeoutSeconds();
        int beginSec = (int)(this.getBeginTimeMillis() / 1000L);
        if (nowSec - beginSec > abortSec) {
            TXLogger.logAbandoningTx(nowSec - beginSec, this.toString());
            this.abandon();
            return true;
        }
        return false;
    }

    protected void abandon() {
        this.setAbandoned();
        this.getTM().remove(this);
    }

    protected int getSecondsToAbandon() {
        int timeToAbandon = this.getAbandonTimeoutSeconds() - (int)((System.currentTimeMillis() - this.getBeginTimeMillis()) / 1000L);
        int abandonGrace = abandonGraceTimeEndSec - (int)(System.currentTimeMillis() / 1000L);
        return Math.max(timeToAbandon, abandonGrace);
    }

    protected final void throwRollbackException() throws jakarta.transaction.RollbackException {
        Throwable rr = this.getRollbackReason();
        String msg = this.getRollbackReasonMessage();
        throw new RollbackException(msg, rr);
    }

    protected final void throwIllegalStateException(String msg) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(msg).append(". xid=").append(this.getXID()).append(", status=").append(this.getStatusAsString());
        msg = sb.toString();
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("Illegal State exception" + msg);
        }
        throw new IllegalStateException(sb.toString());
    }

    final CoordinatorOneway getCoordinator() {
        CoordinatorDescriptor coDesc = this.getCoordinatorDescriptor();
        return coDesc == null ? null : CoordinatorFactory.getCoordinator(coDesc, this);
    }

    protected final void setPreparing() {
        this.setState((byte)4);
    }

    protected final boolean isPreparing() {
        return this.getState() == 4;
    }

    protected void setPrepared() {
        this.setState((byte)6);
    }

    public final boolean isPrepared() {
        return this.getState() == 6;
    }

    protected final void setCommitting() {
        this.setState((byte)7);
    }

    protected final boolean isCommitting() {
        return this.getState() == 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCommitted() {
        this.getTM().remove(this);
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (!this.isOver()) {
                this.setState((byte)8);
            }
        }
    }

    protected final synchronized void setRollingBack() {
        this.setRollingBackUnsync();
    }

    protected final void setRollingBackUnsync() {
        this.unmarkRollback();
        this.setState((byte)9);
    }

    protected final boolean isRollingBack() {
        return this.getState() == 9;
    }

    protected synchronized void setRolledBack() {
        this.getTM().remove(this);
        this.unmarkRollback();
        this.wakeUpAfterSeconds(10);
        if (!this.isOver()) {
            this.setState((byte)10);
        }
    }

    protected synchronized void setUnknown() {
        this.setUnknownUnsync();
    }

    protected void setUnknownUnsync() {
        this.unmarkRollback();
        if (!this.isOver()) {
            this.setState((byte)11);
        }
    }

    protected synchronized void setAbandoned() {
        this.unmarkRollback();
        if (!this.isOver()) {
            this.setState((byte)12);
        }
    }

    protected synchronized void addResourceInfo(ResourceInfo ri) {
        this.addResourceInfoUnsync(ri);
    }

    protected void addResourceInfoUnsync(ResourceInfo ri) {
        if (this.resourceInfoList == null) {
            this.resourceInfoList = new ArrayList(2);
        }
        this.resourceInfoList.add(ri);
        if (this.checkNonXAResourceProperty(ri.getName())) {
            this.setNonXAResource(ri);
        }
        ri.incrementTxRefCount();
    }

    protected boolean checkNonXAResourceProperty(String name) {
        String nxarName = (String)((Object)this.getProperty("weblogic.transaction.nonXAResource"));
        return nxarName != null && nxarName.equals(name);
    }

    protected final synchronized void addSC(SCInfo sci) {
        if (this.scInfoList == null) {
            this.scInfoList = new CopyOnWriteArrayList();
        }
        this.scInfoList.add(sci);
    }

    protected final void asyncRollback() {
        Runnable work = new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionImpl.this.globalRollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        PlatformHelper.getPlatformHelper().scheduleWork(work);
    }

    protected final void wakeUpAfterSeconds(int interval) {
        long t;
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            String msg = this.toString() + " wakeUpAfterSeconds(" + interval + ")";
            if (TxDebug.JTA2PCStackTrace.isDebugEnabled()) {
                TxDebug.debugStack(TxDebug.JTA2PC, msg);
            } else {
                TxDebug.JTA2PC.debug(msg);
            }
        }
        this.wakeUpTimeSec = (int)((t = System.currentTimeMillis() / 1000L + (long)interval) > Integer.MAX_VALUE ? Integer.MAX_VALUE : t);
    }

    protected final long getBeginTimeMillis() {
        return this.beginTimeMillis;
    }

    protected final void setBeginTimeMillis(long t) {
        this.beginTimeMillis = t;
    }

    protected final ResourceInfo getResourceInfo(String resourceName) {
        ArrayList resourceList = this.getResourceInfoList();
        if (resourceList == null) {
            return null;
        }
        for (int i = 0; i < resourceList.size(); ++i) {
            ResourceInfo ri = (ResourceInfo)resourceList.get(i);
            if (!ri.getName().equals(resourceName)) continue;
            return ri;
        }
        return null;
    }

    protected TransactionManagerImpl getOwnerTransactionManager() {
        return this.ownerTM;
    }

    void setDelayRemoveAfterRollback(boolean b) {
        this.delayRemoveAfterRollback = b;
    }

    protected boolean getDelayRemoveAfterRollback() {
        return this.delayRemoveAfterRollback;
    }

    public abstract int internalPrepare() throws AbortRequestedException, jakarta.transaction.RollbackException, SystemException, XAException;

    public abstract void internalCommit(boolean var1) throws AbortRequestedException, jakarta.transaction.RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, XAException;

    public abstract void internalForget() throws SystemException, XAException;

    private TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    private Map getOrCreateGlobalProperties() {
        if (this.globalProperties == null) {
            this.globalProperties = new HashMap();
        }
        return this.globalProperties;
    }

    private ConcurrentHashMap getOrCreateLocalProperties() {
        if (this.localProperties == null) {
            this.localProperties = this.createLocalProperties();
        }
        return this.localProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap createLocalProperties() {
        if (this.volatileLocalProperties == null) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.volatileLocalProperties == null) {
                    this.volatileLocalProperties = new ConcurrentHashMap();
                }
            }
        }
        return this.volatileLocalProperties;
    }

    protected String getStateAsString(int st) {
        switch (st) {
            case 1: {
                return "active";
            }
            case 2: {
                return "pre_preparing";
            }
            case 3: {
                return "pre_prepared";
            }
            case 4: {
                return "preparing";
            }
            case 5: {
                return "logging";
            }
            case 6: {
                return "prepared";
            }
            case 7: {
                return "committing";
            }
            case 8: {
                return "committed";
            }
            case 9: {
                return "rolling back";
            }
            case 10: {
                return "rolled back";
            }
            case 12: {
                return "abandoned";
            }
        }
        return "UNKNOWN";
    }

    private boolean isOTSExport() {
        return this.getLocalProperty("weblogic.transaction.otsTransactionExport") != null;
    }

    public Object getResource(Object key) {
        if (this.resources == null) {
            return null;
        }
        return this.resources.get(key);
    }

    public Object putResource(Object key, Object value) {
        if (this.resources == null) {
            this.resources = new HashMap();
        }
        return this.resources.put(key, value);
    }

    void check(String location) {
        this.check(location, null, null);
    }

    void check(String location, String server) {
        this.check(location, server, null);
    }

    void check(String location, String server, String resource) {
        if (!INSTR_ENABLED) {
            return;
        }
        System.out.println("*** Instrumented location:" + location + " server:" + server + " resource:" + resource);
        try {
            Runnable runnable;
            Boolean doExit;
            Integer millis;
            String prop = location + "SleepMillis";
            if (server != null) {
                prop = prop + "." + server;
                if (resource != null) {
                    prop = prop + "." + resource;
                }
            }
            if ((millis = (Integer)this.getProperty(prop)) != null && millis > 0) {
                System.out.println("*** Instrumented '" + prop + "'=" + millis + " xid=" + this.getXid() + " start sleeping.");
                try {
                    Thread.currentThread();
                    Thread.sleep(millis.intValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("*** Instrumented '" + prop + "'=" + millis + " xid=" + this.getXid() + " done sleeping.");
            }
            prop = location + "Exit";
            if (server != null) {
                prop = prop + "." + server;
                if (resource != null) {
                    prop = prop + "." + resource;
                }
            }
            if ((doExit = (Boolean)this.getProperty(prop)) != null && doExit.booleanValue()) {
                System.out.println("*** Instrumented '" + prop + "' xid=" + this.getXid());
                Runtime.getRuntime().halt(-1);
            }
            prop = location + "Invoke";
            if (server != null) {
                prop = prop + "." + server;
                if (resource != null) {
                    prop = prop + "." + resource;
                }
            }
            if ((runnable = (Runnable)((Object)this.getProperty(prop))) != null) {
                System.out.println("*** Instrumented '" + prop + "'=" + runnable + ", xid=" + this.getXid() + " invoking Runnable.");
                runnable.run();
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
    }

    public void checkLLR(String location) throws SystemException {
        if (!INSTR_ENABLED) {
            return;
        }
        Boolean doThrow = (Boolean)this.getProperty(location);
        if (doThrow != null && doThrow.booleanValue()) {
            System.out.println("*** Instrumented '" + location + "' xid=" + this.getXid());
            throw new SystemException(location);
        }
    }

    public void checkLLRRetry() throws SystemException {
        if (!INSTR_ENABLED) {
            return;
        }
        Integer retry = (Integer)this.getProperty("LLRFailRetry");
        if (retry == null) {
            return;
        }
        Boolean throwBeforeLogWrite = (Boolean)this.getProperty("LLRFailBeforeLogWrite");
        Boolean throwAfterLogWrite = (Boolean)this.getProperty("LLRFailAfterLogWrite");
        Boolean throwBeforeCommit = (Boolean)this.getProperty("LLRFailBeforeCommit");
        Boolean throwAfterCommit = (Boolean)this.getProperty("LLRFailAfterCommit");
        if (throwBeforeLogWrite == null && throwAfterLogWrite == null && throwBeforeCommit == null && throwAfterCommit == null) {
            return;
        }
        int retryCount = 0;
        String countProp = "LLRFailRetry.count";
        Integer count = (Integer)this.getProperty(countProp);
        if (count != null) {
            retryCount = count;
        }
        if (retryCount >= retry) {
            return;
        }
        this.setProperty(countProp, Integer.valueOf(retryCount + 1));
        System.out.println("*** Instrumented 'LLRFailRetry' xid=" + this.getXid() + " retry=" + retryCount);
        throw new SystemException("LLRFailRetry, retry count " + retryCount);
    }

    void loggerTransactionTimedOut() {
        TXLogger.logTransactionTimedOut(this.getXID().toString(), this.getMillisSinceBegin() / 1000L);
    }

    @Override
    public synchronized Set<String> getServerParticipantNames() {
        if (this.scInfoList == null) {
            return null;
        }
        HashSet<String> serverParticipantNames = new HashSet<String>();
        for (int i = 0; i < this.scInfoList.size(); ++i) {
            String serverName = ((SCInfo)this.scInfoList.get(i)).getCoordinatorDescriptor().getServerName();
            if (serverParticipantNames.contains(serverName)) continue;
            serverParticipantNames.add(serverName);
        }
        return serverParticipantNames;
    }

    void setUseLLR(boolean aUseLLR) {
        this.useLLR = aUseLLR;
    }

    boolean getUseLLR() {
        return this.useLLR;
    }

    void setLocalConnCommittedOrRollback(boolean localConnCommittedOrRollback) {
        this.localConnCommittedOrRollback = localConnCommittedOrRollback;
    }

    boolean getLocalConnCommittedOrRollback() {
        return this.localConnCommittedOrRollback;
    }

    boolean isResourceNotFound() {
        return this.getProperty("weblogic.transaction.resourceNotFound") != null && this.getProperty("weblogic.transaction.resourceNotFound").equals(true);
    }

    void setResourceNotFoundTrue() {
        this.setProperty("weblogic.transaction.resourceNotFound", Boolean.valueOf(true));
    }

    boolean isAllResourcesAssigned() {
        return this.getProperty("weblogic.transaction.allResourcesAssigned") != null && this.getProperty("weblogic.transaction.allResourcesAssigned").equals(true);
    }

    void setAllResourcesAssignedTrue() {
        this.setProperty("weblogic.transaction.allResourcesAssigned", Boolean.valueOf(true));
    }

    void addDebugMessage(String s) {
        this.debugMessages.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDebugMessages() {
        System.out.println("Printing debug messages for condition(s) defined from thread " + Thread.currentThread() + "...");
        Deque<String> deque = this.debugMessages;
        synchronized (deque) {
            for (String debugMessage : this.debugMessages) {
                System.out.println((Object)debugMessage);
            }
            this.debugMessages.clear();
        }
        this.printDebugMessagesOnCompletion = true;
        this.setProperty("printDebugMessagesOnCompletion", Boolean.TRUE);
    }

    static {
        String value;
        String key;
        int equalsLocation;
        List<String> nameValuePairs;
        IS_ISE_THROWN_DUE_TO_TIMEOUT_RB = Boolean.parseBoolean(System.getProperty("weblogic.transaction.ise.timeout.rb", "false"));
        String allowOverride = System.getProperty("weblogic.transaction.allowOverrideSetRollbackReason");
        ALLOW_OVERRIDE_SETROLLBACK_REASON = allowOverride == null ? false : allowOverride.equalsIgnoreCase("true");
        abandonGraceTimeEndSec = (int)(System.currentTimeMillis() / 1000L) + 3600;
        islookupresourceonretryEnabled = new Boolean(System.getProperty("weblogic.transaction.internal.lookupresourceonretry", "true"));
        lookupresourceonretryCount = Integer.parseInt(System.getProperty("weblogic.transaction.internal.lookupresourceonretrycount", "3"));
        GLOBAL_PROPERTIES = new HashMap<String, String>();
        LOCAL_PROPERTIES = new HashMap<String, String>();
        String propVal = System.getProperty("weblogic.transaction.EnableInstrumentedTM");
        INSTR_ENABLED = propVal != null && propVal.equals("true");
        propVal = System.getProperty("weblogic.transaction.global.properties");
        if (propVal != null) {
            nameValuePairs = Arrays.asList(propVal.split("\\s*,\\s*"));
            for (String nameValuePair : nameValuePairs) {
                equalsLocation = nameValuePair.indexOf("=");
                key = nameValuePair.substring(0, equalsLocation);
                value = nameValuePair.substring(equalsLocation + 1, propVal.length());
                GLOBAL_PROPERTIES.put(key, value);
            }
        }
        if ((propVal = System.getProperty("weblogic.transaction.local.properties")) != null) {
            nameValuePairs = Arrays.asList(propVal.split("\\s*,\\s*"));
            for (String nameValuePair : nameValuePairs) {
                equalsLocation = nameValuePair.indexOf("=");
                key = nameValuePair.substring(0, equalsLocation);
                value = nameValuePair.substring(equalsLocation + 1, propVal.length());
                LOCAL_PROPERTIES.put(key, value);
            }
        }
    }
}

