/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import weblogic.transaction.internal.AbortRequestedException;
import weblogic.transaction.internal.Coordinator;
import weblogic.transaction.internal.Coordinator2;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XAResourceHelper;

public final class ClientTransactionImpl
extends TransactionImpl {
    ClientTransactionImpl(Xid axid, int aTimeoutSec, int aTimeToLiveSec) {
        super(axid, aTimeoutSec, aTimeToLiveSec);
    }

    ClientTransactionImpl(Xid xid, Xid foreignXid, int timeOutSecs, int timeToLiveSecs) {
        super(xid, foreignXid, timeOutSecs, timeToLiveSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int internalPrepare() throws AbortRequestedException, RollbackException, SystemException, XAException {
        if (TxDebug.JTAGateway.isDebugEnabled()) {
            TxDebug.txdebug(TxDebug.JTAGateway, this, "internalPrepare");
        }
        this.checkOwner();
        this.enforceCheckedTransaction();
        ClientTransactionImpl clientTransactionImpl = this;
        synchronized (clientTransactionImpl) {
            switch (this.getState()) {
                case 1: {
                    if (this.isMarkedRollback()) {
                        this.abort();
                    } else {
                        this.setPreparing();
                        break;
                    }
                }
                case 9: 
                case 10: {
                    this.throwRollbackException();
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: {
                    throw new IllegalStateException("Cannot prepare imported transaction.  " + this.getXid().toString());
                }
            }
        }
        int vote = 0;
        Coordinator co = (Coordinator)((Object)this.getCoordinator());
        if (co == null) {
            this.setUnknown();
            throw new SystemException("No coordinator is assigned.  Make sure that the InterposedTransactionManager is looked up from a server's JNDI.");
        }
        if (co instanceof Coordinator2) {
            try {
                vote = ((Coordinator2)co).xaPrepare(this.getRequestPropagationContext());
                this.setPrepared();
            }
            catch (RemoteException ex) {
                String msg = "Cannot prepare imported transaction " + this.getXid().toString() + ".  Unable to contact coordinator " + this.getCoordinatorURL() + ".";
                if (ClientTransactionImpl.isRecoverablePreInvokeFailure(ex)) {
                    this.setRolledBack();
                    XAResourceHelper.throwXAException(101, msg, ex);
                }
                throw new SystemException(msg);
            }
            catch (XAException ex) {
                if (XAResourceHelper.isRollbackErrorCode(ex.errorCode)) {
                    this.setRolledBack();
                }
                throw ex;
            }
            finally {
                if (this.isPreparing()) {
                    this.setUnknown();
                }
            }
        } else {
            String msg = "Cannot prepare imported transaction " + this.getXid().toString() + ".  Server does not support importing transactions.";
            this.abort(msg);
        }
        return vote;
    }

    private static boolean isRecoverablePreInvokeFailure(RemoteException e) {
        if (e instanceof UnknownHostException || e instanceof ConnectException || e instanceof ConnectIOException || e instanceof NoSuchObjectException) {
            return true;
        }
        if (e instanceof MarshalException) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalCommit(boolean onePhase) throws AbortRequestedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, XAException {
        block33: {
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTAGateway, this, "internalCommit");
            }
            this.checkOwner();
            ClientTransactionImpl clientTransactionImpl = this;
            synchronized (clientTransactionImpl) {
                switch (this.getState()) {
                    case 1: {
                        if (this.isMarkedRollback()) {
                            this.abort();
                            break;
                        }
                        if (onePhase) {
                            this.setCommitting();
                            break;
                        }
                        String msg = "commit(onePhase=false).  Illegal State (Expected: prepared).  Please make sure that prepare is called if it is not a one phase commit.  " + this.getXid().toString();
                        XAResourceHelper.throwXAException(-6, msg);
                        break;
                    }
                    case 6: {
                        if (!onePhase) {
                            this.setCommitting();
                            break;
                        }
                        String msg = "commit(onePhase=true).  Illegal State (Expected: active).  Please make sure that commit is called with onePhase=false if it is not a one phase commit.  " + this.getXid().toString();
                        XAResourceHelper.throwXAException(-6, msg);
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.throwRollbackException();
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: {
                        String msg = "commit(onePhase=" + onePhase + ").  Illegal State (Expected: " + (onePhase ? "active" : "prepared") + ").  " + this.getXid().toString();
                        throw new IllegalStateException(msg);
                    }
                }
            }
            Coordinator co = (Coordinator)((Object)this.getCoordinator());
            if (co == null) {
                this.setUnknown();
                throw new SystemException("No coordinator is assigned.  Make sure that the InterposedTransactionManager is looked up from a server's JNDI.");
            }
            try {
                if (onePhase) {
                    co.commit(this.getRequestPropagationContext());
                } else if (!this.isReadOnly) {
                    ((Coordinator2)co).xaCommit(this.getForeignXid());
                }
                this.setCommitted();
            }
            catch (RemoteException ex) {
                String msg = "Cannot commit imported transaction " + this.getXid().toString() + ".  Unable to contact coordinator " + this.getCoordinatorURL() + ".";
                if (onePhase && ClientTransactionImpl.isRecoverablePreInvokeFailure(ex)) {
                    this.setRolledBack();
                    XAResourceHelper.throwXAException(101, msg, ex);
                    break block33;
                }
                throw new SystemException(msg);
            }
            catch (RollbackException ex) {
                this.setRolledBack();
                throw ex;
            }
            catch (HeuristicMixedException ex) {
                this.setCommitted();
                throw ex;
            }
            catch (HeuristicRollbackException ex) {
                this.setCommitted();
                throw ex;
            }
            catch (SystemException ex) {
                throw ex;
            }
            catch (XAException ex) {
                if (XAResourceHelper.isRollbackErrorCode(ex.errorCode)) {
                    this.setRolledBack();
                } else if (XAResourceHelper.isHeuristicErrorCode(ex.errorCode)) {
                    this.setCommitted();
                }
                throw ex;
            }
            finally {
                if (this.isCommitting()) {
                    this.setUnknown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalForget() throws SystemException, XAException {
        block8: {
            if (TxDebug.JTAGateway.isDebugEnabled()) {
                TxDebug.txdebug(TxDebug.JTAGateway, this, "internalForget");
            }
            this.checkOwner();
            Coordinator co = (Coordinator)((Object)this.getCoordinator());
            if (co == null) {
                this.setUnknown();
                throw new SystemException("No coordinator is assigned.  Make sure that the InterposedTransactionManager is looked up from a server's JNDI.");
            }
            try {
                if (co instanceof Coordinator2) {
                    try {
                        ((Coordinator2)co).xaForget(this.getForeignXid());
                        break block8;
                    }
                    catch (RemoteException ex) {
                        String msg = "Cannot forget imported transaction " + this.getXid().toString() + ".  Unable to contact coordinator.";
                        throw new SystemException(msg);
                    }
                }
                String msg = "Cannot forget imported transaction " + this.getXid().toString() + ".  Coordinator does not support importing transactions.";
                throw new SystemException(msg);
            }
            finally {
                ClientTransactionImpl.getTM().remove(this);
            }
        }
    }

    @Override
    synchronized boolean setCoordinatorURL(String url) {
        CoordinatorDescriptor cd = CoordinatorDescriptor.getOrCreate(url);
        String handoffCoURL = this.updateCoordinatorDescriptor(url);
        if (handoffCoURL != null) {
            this.setLocalProperty("weblogic.client.handoffCoURL", handoffCoURL);
        }
        cd.setAdminCoordinatorURL(url);
        return this.setCoordinatorDescriptor(cd);
    }

    @Override
    protected final synchronized void setRolledBack() {
        super.setRolledBack();
        ClientTransactionImpl.getTM().remove(this);
    }

    private static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }
}

