/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.tests;

import java.util.TimerTask;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public class RateTest
extends TimerTask
implements TimerListener {
    int count;
    long lastTime;

    public static void main(String[] args) throws InterruptedException {
        if (args.length > 0) {
            java.util.Timer timer = new java.util.Timer();
            timer.scheduleAtFixedRate((TimerTask)new RateTest(), 0L, 1000L);
            System.out.println("USING JAVA UTIL TIMER ...");
        } else {
            System.out.println("USING WEBLOGIC TIMER ...");
            TimerManager manager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("TEST", WorkManagerFactory.getInstance().getDefault());
            manager.scheduleAtFixedRate((TimerListener)new RateTest(), 0L, 1000L);
        }
        Thread.sleep(100000L);
    }

    @Override
    public void timerExpired(Timer timer) {
        System.out.println("Timer fired after " + (System.currentTimeMillis() - this.lastTime) + "ms");
        ++this.count;
        try {
            if (this.count % 5 == 0) {
                Thread.sleep(1800L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.lastTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.timerExpired(null);
    }
}

