/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import weblogic.timers.internal.TimerImpl;

class TimerSet {
    private ArrayList<TimerImpl> timers = new ArrayList();
    private ArrayList<TimerImpl> borrow = new ArrayList();
    private volatile long min = -1L;

    TimerSet() {
    }

    public long peakMin() {
        return this.min;
    }

    public synchronized boolean add(TimerImpl t) {
        t.idx = this.timers.size();
        this.timers.add(t);
        return this.update(t);
    }

    public synchronized boolean remove(TimerImpl t) {
        if (t.idx < 0) {
            return false;
        }
        int size = this.timers.size();
        if (size == 0) {
            t.idx = -1;
            return false;
        }
        TimerImpl last = this.timers.remove(size - 1);
        if (last != t) {
            last.idx = t.idx;
            TimerImpl prev = this.timers.set(last.idx, last);
            assert (t == prev);
        }
        t.idx = -1;
        if (this.timers.isEmpty()) {
            this.min = -1L;
        }
        return true;
    }

    public synchronized boolean update(TimerImpl t) {
        if (t.idx == -1) {
            return false;
        }
        t.running = false;
        long timeout = t.getTimeout();
        if (timeout >= this.min && this.min >= 0L || timeout < 0L) {
            return false;
        }
        this.min = timeout;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerImpl[] getNotAfter(long timeout) {
        TimerSet timerSet = this;
        synchronized (timerSet) {
            long m = -1L;
            int i = this.timers.size();
            while (i-- > 0) {
                TimerImpl t = this.timers.get(i);
                assert (t.idx != -1);
                if (t.running) continue;
                long wakeup = t.getTimeout();
                if (wakeup <= timeout) {
                    t.running = true;
                    this.borrow.add(t);
                    continue;
                }
                if (m >= 0L && m <= wakeup) continue;
                m = wakeup;
            }
            this.min = m;
        }
        Object[] ts = new TimerImpl[this.borrow.size()];
        this.borrow.toArray(ts);
        this.borrow.clear();
        Arrays.sort(ts);
        return ts;
    }

    public synchronized TimerImpl[] getAll() {
        TimerImpl[] ts = new TimerImpl[this.timers.size()];
        return this.timers.toArray(ts);
    }

    public synchronized void clear() {
        this.timers.clear();
    }

    public synchronized boolean isEmpty() {
        return this.timers.isEmpty();
    }
}

