/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import weblogic.timers.ScheduleExpression;
import weblogic.timers.internal.ScheduleExpressionUtil;

public class ScheduleExpressionWrapper
implements Serializable {
    private static final long serialVersionUID = 6415430167817860137L;
    private final ScheduleExpression schedule;
    private byte[] seconds = new byte[60];
    private byte[] minutes = new byte[60];
    private byte[] hours = new byte[24];
    private boolean[] months = new boolean[12];
    private byte[] daysInMonth = new byte[32];
    int daysInMonthArrayMonth = -1;
    int daysInMonthArrayYear = -1;
    TimeZone timezone = null;
    boolean wildCardYearAttribute = false;
    int firstValidYearUpdated = -1;
    int firstValidYear = -1;

    private ScheduleExpressionWrapper(ScheduleExpression schedule) {
        this.schedule = schedule;
    }

    public static ScheduleExpressionWrapper create(ScheduleExpression schedule) throws IllegalArgumentException {
        if (schedule == null) {
            throw new IllegalArgumentException("ScheduleExpression cannot be null");
        }
        ScheduleExpressionWrapper wrapper = new ScheduleExpressionWrapper(schedule);
        if (!ScheduleExpressionUtil.parseHHMMSSvalue(schedule.getSecond(), wrapper.seconds, "second")) {
            wrapper.seconds = null;
        }
        if (!ScheduleExpressionUtil.parseHHMMSSvalue(schedule.getMinute(), wrapper.minutes, "minute")) {
            wrapper.minutes = null;
        }
        if (!ScheduleExpressionUtil.parseHHMMSSvalue(schedule.getHour(), wrapper.hours, "hour")) {
            wrapper.hours = null;
        }
        if (!ScheduleExpressionUtil.parseMonthValue(schedule.getMonth(), wrapper.months)) {
            wrapper.months = null;
        }
        wrapper.timezone = ScheduleExpressionUtil.parseTimeZoneValue(schedule.getTimezone());
        Calendar aCal = wrapper.timezone == null ? Calendar.getInstance() : Calendar.getInstance(wrapper.timezone);
        int forMonth = aCal.get(2);
        if (!wrapper.isMonthValid(forMonth)) {
            forMonth = wrapper.getNextValidMonth(forMonth);
        }
        int forYear = aCal.get(1);
        forYear = wrapper.updateFirstValidYear(forYear);
        wrapper.wildCardYearAttribute = ScheduleExpressionUtil.isWildCardYearAttribute(schedule.getYear());
        wrapper.updateDaysInMonthArrayIfNeeded(forYear, forMonth);
        return wrapper;
    }

    public ScheduleExpression getSchedule() {
        return this.schedule;
    }

    public long getFirstTimeout() {
        long nextTimeout = this.getNextTimeout();
        Date firstTimeout = this.schedule.getFirstTimeout();
        if (firstTimeout != null && (firstTimeout.getTime() < nextTimeout || nextTimeout == -1L && firstTimeout.getTime() < System.currentTimeMillis())) {
            return firstTimeout.getTime();
        }
        return nextTimeout;
    }

    public long getNextTimeout() {
        Date endDate;
        Calendar now = this.timezone == null ? Calendar.getInstance() : Calendar.getInstance(this.timezone);
        int year = now.get(1);
        if (!this.wildCardYearAttribute && year > this.firstValidYearUpdated) {
            this.updateFirstValidYear(year);
        }
        if ((endDate = this.schedule.getEnd()) != null && endDate.getTime() < System.currentTimeMillis()) {
            return -1L;
        }
        Date startDate = this.schedule.getStart();
        if (startDate != null && startDate.getTime() > System.currentTimeMillis()) {
            now.setTimeInMillis(startDate.getTime() - 1000L);
        }
        Calendar next = this.findNextTimeout(now.get(1), now.get(2), now.get(5), now.get(11), now.get(12), now.get(13), now.get(16), now.toInstant());
        long nextTimeout = next.getTimeInMillis();
        if (endDate != null && endDate.getTime() < nextTimeout) {
            return -1L;
        }
        return nextTimeout;
    }

    Calendar findNextTimeout(int currYear, int currMonth, int currDay, int currHour, int currMinute, int currSecond, int dstOffset, Instant nowInstant) {
        boolean isCurrHourValid;
        boolean isCurrMinuteValid;
        if (this.findFirstValidYear(currYear) != currYear || !this.isMonthValid(currMonth)) {
            return this.findFirstTimeoutInMonthAfter(currYear, currMonth);
        }
        this.updateDaysInMonthArrayIfNeeded(currYear, currMonth);
        boolean bl = this.minutes == null ? currMinute == 0 : (isCurrMinuteValid = currMinute == this.minutes[(currMinute + 59) % 60]);
        boolean bl2 = this.hours == null ? currHour == 0 : (isCurrHourValid = currHour == this.hours[(currHour + 23) % 24]);
        boolean isCurrDayValid = this.daysInMonth == null ? true : currDay == this.daysInMonth[(currDay + 31) % 32];
        byte nextS = this.seconds == null ? (byte)0 : this.seconds[currSecond];
        int nextM = currMinute;
        int nextH = currHour;
        int nextDay = currDay;
        if (!(nextS > currSecond && isCurrMinuteValid && isCurrHourValid && isCurrDayValid)) {
            nextS = this.seconds == null ? (byte)0 : this.seconds[59];
            int n = nextM = this.minutes == null ? 0 : this.minutes[currMinute];
            if (nextM <= currMinute || !isCurrHourValid || !isCurrDayValid) {
                nextM = this.minutes == null ? 0 : this.minutes[59];
                int n2 = nextH = this.hours == null ? 0 : this.hours[currHour];
                if (nextH <= currHour || !isCurrDayValid) {
                    nextH = this.hours == null ? 0 : this.hours[23];
                    nextDay = this.getNextValidDay(currDay, currMonth, currYear);
                    if (nextDay <= currDay) {
                        return this.findFirstTimeoutInMonthAfter(currYear, currMonth);
                    }
                }
            }
        }
        Calendar next = this.timezone == null ? Calendar.getInstance() : Calendar.getInstance(this.timezone);
        next.set(1, currYear);
        next.set(2, currMonth);
        next.set(5, nextDay);
        next.set(11, nextH);
        next.set(12, nextM);
        next.set(13, nextS);
        if (dstOffset > 0 && this.isTimeInDSTTransitionOverlapPeriod(dstOffset, next.get(16), nowInstant, currYear, currMonth, nextDay, nextH)) {
            next.set(16, dstOffset);
        }
        return next;
    }

    private boolean isTimeInDSTTransitionOverlapPeriod(int currTimeDSTOffset, int propTimeDSTOffset, Instant nowInstant, int currYear, int currMonth, int nextDay, int nextHour) {
        if (currTimeDSTOffset == propTimeDSTOffset) {
            return false;
        }
        try {
            String timezoneId = this.timezone == null ? TimeZone.getDefault().getID() : this.timezone.getID();
            ZoneRules rules = ZoneId.of(timezoneId).getRules();
            ZoneOffsetTransition nextTransition = rules.nextTransition(nowInstant);
            if (nextTransition == null || !nextTransition.isOverlap()) {
                return false;
            }
            LocalDateTime before = nextTransition.getDateTimeBefore();
            LocalDateTime after = nextTransition.getDateTimeAfter();
            if (currYear != before.getYear()) {
                return false;
            }
            if (currMonth != before.getMonthValue() - 1) {
                return false;
            }
            if (nextDay != before.getDayOfMonth()) {
                return false;
            }
            if (nextHour >= after.getHour()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private Calendar findFirstTimeoutInMonthAfter(int year, int month) {
        int numYearAdvances = 0;
        int nextMonth = month;
        int nextYear = this.findFirstValidYear(year);
        if (nextYear > year) {
            nextMonth = 0;
            if (!this.isMonthValid(nextMonth)) {
                nextMonth = this.getNextValidMonth(nextMonth);
            }
        } else {
            nextMonth = this.getNextValidMonth(month);
            if (nextMonth <= month) {
                nextYear = this.findFirstValidYear(year + 1);
                nextMonth = 0;
                if (!this.isMonthValid(nextMonth)) {
                    nextMonth = this.getNextValidMonth(nextMonth);
                }
            }
        }
        if (nextYear == -100) {
            return this.createExpiredCalendar();
        }
        int nextDay = this.getNextValidDay(0, nextMonth, nextYear);
        while (nextDay == -1) {
            month = nextMonth;
            if ((nextMonth = this.getNextValidMonth(month)) <= month) {
                if (this.wildCardYearAttribute) {
                    ++numYearAdvances;
                }
                if ((nextYear = ScheduleExpressionUtil.getNextValidYear(this.schedule.getYear(), nextYear + 1)) == -100 || numYearAdvances > 8) {
                    return this.createExpiredCalendar();
                }
            }
            nextDay = this.getNextValidDay(0, nextMonth, nextYear);
        }
        Calendar next = this.timezone == null ? Calendar.getInstance() : Calendar.getInstance(this.timezone);
        next.set(1, nextYear);
        next.set(2, nextMonth);
        next.set(5, nextDay);
        next.set(11, this.hours == null ? 0 : this.hours[23]);
        next.set(12, this.minutes == null ? 0 : this.minutes[59]);
        next.set(13, this.seconds == null ? 0 : this.seconds[59]);
        return next;
    }

    private Calendar createExpiredCalendar() {
        Calendar next = Calendar.getInstance();
        next.setTimeInMillis(-1L);
        return next;
    }

    private int findFirstValidYear(int startYear) {
        if (this.wildCardYearAttribute) {
            return startYear;
        }
        if (startYear >= this.firstValidYearUpdated && startYear == this.firstValidYear) {
            return this.firstValidYear;
        }
        return ScheduleExpressionUtil.getNextValidYear(this.schedule.getYear(), startYear);
    }

    private int updateFirstValidYear(int startYear) {
        int nextYear = ScheduleExpressionUtil.getNextValidYear(this.schedule.getYear(), startYear);
        this.firstValidYearUpdated = startYear;
        this.firstValidYear = nextYear;
        return nextYear;
    }

    private boolean isMonthValid(int monthIndex) {
        return this.months == null || this.months[monthIndex];
    }

    private int getNextValidMonth(int currMonthIndex) {
        if (this.months == null) {
            return (currMonthIndex + 1) % 12;
        }
        int i = (currMonthIndex + 1) % 12;
        while (i != currMonthIndex) {
            if (this.months[i]) {
                return i;
            }
            i = (i + 1) % 12;
        }
        return currMonthIndex;
    }

    private int getNextValidDay(int currDayIndex, int month, int year) {
        if (this.daysInMonth == null) {
            int result = currDayIndex + 1;
            Calendar aCal = Calendar.getInstance();
            aCal.set(2, month);
            int daysInMonth = aCal.getActualMaximum(5);
            if (result > daysInMonth) {
                result = 1;
            }
            return result;
        }
        this.updateDaysInMonthArrayIfNeeded(year, month);
        return this.daysInMonth[currDayIndex];
    }

    private void updateDaysInMonthArrayIfNeeded(int year, int month) {
        if (this.daysInMonthArrayMonth != month || this.daysInMonthArrayYear != year) {
            if (!ScheduleExpressionUtil.parseDayValues(this.schedule.getDayOfMonth(), this.schedule.getDayOfWeek(), this.daysInMonth, year, month)) {
                this.daysInMonth = null;
            } else {
                this.daysInMonthArrayMonth = month;
                this.daysInMonthArrayYear = year;
            }
        }
    }

    public String toString() {
        return "ScheduleExpressionWrapper for " + this.schedule;
    }
}

