/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers;

public abstract class RuntimeDomainSelector {
    public static final RuntimeDomainSelector NULL;
    public static final String DEFAULT_DOMAIN = "weblogic.timers.defaultDomain";
    private static RuntimeDomainSelector selector;

    public static String getDomain() {
        String domainId = selector.getRuntimeDomain();
        if (domainId == null) {
            return DEFAULT_DOMAIN;
        }
        return domainId;
    }

    public static boolean isDefaultDomain(String domainId) {
        return DEFAULT_DOMAIN.equals(domainId);
    }

    public static void setSelector(RuntimeDomainSelector selector) {
        RuntimeDomainSelector.selector = selector;
    }

    public abstract String getRuntimeDomain();

    static {
        selector = NULL = new NullRuntimeDomainSelector();
    }

    private static class NullRuntimeDomainSelector
    extends RuntimeDomainSelector {
        private NullRuntimeDomainSelector() {
        }

        @Override
        public String getRuntimeDomain() {
            return "global";
        }
    }
}

