/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file.direct;

import java.io.IOException;
import java.nio.ByteBuffer;
import weblogic.store.PersistentStoreException;
import weblogic.store.common.StoreDebug;
import weblogic.store.io.file.direct.DirectIOManager;
import weblogic.store.io.file.direct.DirectIONativeImpl;
import weblogic.store.io.file.direct.IONative;
import weblogic.store.io.file.direct.ReplicatedIONative;

public final class ReplicatedIONativeImpl
implements IONative {
    private static final String REP_STORE_LIB_NAME = "wlrepstore1";
    private static ReplicatedIONativeImpl singleton = new ReplicatedIONativeImpl();
    private static final DirectIOManager managerSingleton = new DirectIOManager(true, "wlrepstore1", singleton);
    private static final Object bigLock = new Object();
    private static final int HANDLE_NATIVE_SIZE = 10000;
    private static final Object handleLock = new Object();
    private static int handleCircularIndex = 9998;
    private static final long[] handleAvailableTime = new long[10000];
    private static final String[] handleName = new String[10000];
    private static final long HANDLE_DRAIN_TIME = 90000L;

    private ReplicatedIONativeImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int allocateNativeHandle(String name) throws IOException {
        if (name == null) {
            throw new IOException("attempt to reserve handle without a name");
        }
        long now = System.currentTimeMillis();
        Object object = handleLock;
        synchronized (object) {
            for (int lcv = 0; lcv < 10000; ++lcv) {
                int handle = handleCircularIndex = (handleCircularIndex + 1) % 10000;
                if (handleName[handle] != null || handleAvailableTime[handle] != 0L && now < handleAvailableTime[handle]) continue;
                ReplicatedIONativeImpl.handleName[handle] = name;
                return handle;
            }
        }
        throw new IOException("could not allocate for " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeNativeHandle(long longHandle) throws IOException {
        int handle = (int)longHandle;
        Object object = handleLock;
        synchronized (object) {
            if (handleName[handle] == null) {
                throw new IOException("free of free handle=" + handle);
            }
            ReplicatedIONativeImpl.handleAvailableTime[handle] = System.currentTimeMillis() + 90000L;
            ReplicatedIONativeImpl.handleName[handle] = null;
        }
    }

    private static Object getLockInstance() {
        return bigLock;
    }

    private static Object getLockInstance(long handle) {
        return bigLock;
    }

    public static DirectIOManager getDirectIOManagerSingletonPersistentStoreException() throws PersistentStoreException {
        return managerSingleton.checkNativePersistentStoreException();
    }

    public static DirectIOManager getDirectIOManagerSingletonIOException() throws IOException {
        return managerSingleton.checkNativeIOException();
    }

    public static void loadReplicatedLib() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkAlignment(String testFileName) throws IOException {
        Object object = ReplicatedIONativeImpl.getLockInstance();
        synchronized (object) {
            return DirectIONativeImpl.getSingleton().checkAlignment(testFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer allocate(int size) {
        Object object = ReplicatedIONativeImpl.getLockInstance();
        synchronized (object) {
            return DirectIONativeImpl.getSingleton().allocate(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(ByteBuffer buf) {
        Object object = ReplicatedIONativeImpl.getLockInstance();
        synchronized (object) {
            ReplicatedIONative.free(buf);
        }
    }

    @Override
    public long openConsiderLock(String fileName, String mode, boolean exclusive) throws IOException {
        IOException ioe = new IOException("not avail for replicated store");
        throw ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openConsiderLock(String fileName, String mode, boolean exclusive, String[] configurationKeys, String[] configurationValues) throws IOException {
        if (configurationKeys == null || configurationValues == null) {
            IOException ioe = new IOException("not avail for replicated store");
            throw ioe;
        }
        Object object = ReplicatedIONativeImpl.getLockInstance();
        synchronized (object) {
            return ReplicatedIONative.openConsiderLock(fileName, mode, exclusive, configurationKeys, configurationValues);
        }
    }

    @Override
    public long openBasic(String fileName, String mode) throws IOException {
        IOException ioe = new IOException("not avail for replicated store");
        throw ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openEnhanced(String fileName, String mode, String[] configurationKeys, String[] configurationValues) throws IOException {
        if (configurationKeys == null || configurationValues == null) {
            IOException ioe = new IOException("not avail for replicated store");
            throw ioe;
        }
        Object object = ReplicatedIONativeImpl.getLockInstance();
        synchronized (object) {
            return ReplicatedIONative.open(fileName, mode, configurationKeys, configurationValues);
        }
    }

    private static void checkHandle(long handle) throws IOException {
        if (handle >= 10000L || handle < 0L) {
            IOException ioe = new IOException("illegal handle=" + handle);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long handle) throws IOException {
        try {
            ReplicatedIONativeImpl.checkHandle(handle);
            Object object = ReplicatedIONativeImpl.getLockInstance(handle);
            synchronized (object) {
                ReplicatedIONative.close(handle);
            }
        }
        catch (IOException ioe) {
            if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedIONativeImpl close unthrown ", ioe);
            }
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("ReplicatedIONativeImpl close unthrown ", ioe);
            }
        }
        finally {
            if (handle >= 0L && handle < 10000L) {
                ReplicatedIONativeImpl.freeNativeHandle(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize(long handle) throws IOException {
        ReplicatedIONativeImpl.checkHandle(handle);
        Object object = ReplicatedIONativeImpl.getLockInstance(handle);
        synchronized (object) {
            return ReplicatedIONative.getSize(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDeviceLimit(long handle) throws IOException {
        ReplicatedIONativeImpl.checkHandle(handle);
        Object object = ReplicatedIONativeImpl.getLockInstance(handle);
        synchronized (object) {
            return ReplicatedIONative.getDeviceLimit(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDeviceUsed(long handle) throws IOException {
        ReplicatedIONativeImpl.checkHandle(handle);
        Object object = ReplicatedIONativeImpl.getLockInstance(handle);
        synchronized (object) {
            return ReplicatedIONative.getDeviceUsed(handle);
        }
    }

    @Override
    public void truncate(long handle, long newSize) throws IOException {
        ReplicatedIONativeImpl.checkHandle(handle);
        ReplicatedIONative.truncate(handle, newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long handle, long filePosition, ByteBuffer buf, int bufPosition, int bufLength) throws IOException {
        ReplicatedIONativeImpl.checkHandle(handle);
        Object object = ReplicatedIONativeImpl.getLockInstance(handle);
        synchronized (object) {
            return ReplicatedIONative.read(handle, filePosition, buf, bufPosition, bufLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(long handle, long filePosition, ByteBuffer buf, int bufPosition, int bufLength) throws IOException {
        ReplicatedIONativeImpl.checkHandle(handle);
        Object object = ReplicatedIONativeImpl.getLockInstance(handle);
        synchronized (object) {
            return ReplicatedIONative.write(handle, filePosition, buf, bufPosition, bufLength);
        }
    }

    @Override
    public void force(long handle, boolean metaData) throws IOException {
    }

    @Override
    public long createMapping(long fileHandle, long size) throws IOException {
        throw new IOException("ReplicatedIONativeImpl createMapping handle=" + fileHandle);
    }

    @Override
    public ByteBuffer mapFile(long handle, long offset, int size, boolean prefetched) throws IOException {
        throw new IOException("ReplicatedIONativeImpl mapFile handle=" + handle + ", offset=" + offset + ", size=" + size + ", prefetched=" + prefetched);
    }

    @Override
    public void unmapFile(ByteBuffer buf) throws IOException {
        throw new IOException("ReplicatedIONativeImpl unmapFile ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMemoryMapGranularity() {
        Object object = ReplicatedIONativeImpl.getLockInstance();
        synchronized (object) {
            return ReplicatedIONative.getMemoryMapGranularity();
        }
    }

    @Override
    public void fillBuffer(ByteBuffer buf, int position, int size, byte value) {
        DirectIONativeImpl.getSingleton().fillBuffer(buf, position, size, value);
    }
}

