/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file.direct;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import weblogic.store.common.StoreRCMUtils;
import weblogic.store.io.file.direct.DirectIONative;
import weblogic.store.io.file.direct.IONative;

final class DirectIONativeImpl
implements IONative {
    static DirectIONativeImpl singleton = new DirectIONativeImpl();

    private DirectIONativeImpl() {
    }

    static IONative getSingleton() {
        return singleton;
    }

    @Override
    public int checkAlignment(String testFileName) throws IOException {
        return DirectIONative.checkAlignment(testFileName);
    }

    @Override
    public ByteBuffer allocate(int size) {
        return DirectIONative.allocate(size);
    }

    @Override
    public void free(ByteBuffer buf) {
        DirectIONative.free(buf);
    }

    @Override
    public long openConsiderLock(final String fileName, final String mode, final boolean exclusive) throws IOException {
        long ret = -1L;
        try {
            class OpenConsiderLockCallable
            implements Callable<Long> {
                OpenConsiderLockCallable() {
                }

                @Override
                public Long call() throws IOException {
                    return DirectIONative.openConsiderLock(fileName, mode, exclusive);
                }
            }
            ret = StoreRCMUtils.accountAsGlobal(new OpenConsiderLockCallable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
        return ret;
    }

    @Override
    public long openConsiderLock(String fileName, String mode, boolean exclusive, String[] configurationKeys, String[] configurationValues) throws IOException {
        IOException ioe = new IOException("not avail for file store");
        throw ioe;
    }

    @Override
    public long openBasic(final String fileName, final String mode) throws IOException {
        long ret = -1L;
        try {
            class OpenBasicCallable
            implements Callable<Long> {
                OpenBasicCallable() {
                }

                @Override
                public Long call() throws IOException {
                    return DirectIONative.open(fileName, mode);
                }
            }
            ret = StoreRCMUtils.accountAsGlobal(new OpenBasicCallable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
        return ret;
    }

    @Override
    public long openEnhanced(String fileName, String mode, String[] configurationKeys, String[] configurationValues) throws IOException {
        IOException ioe = new IOException("not avail for file store");
        throw ioe;
    }

    @Override
    public void close(final long handle) throws IOException {
        try {
            class CloseRunnable
            implements Runnable {
                CloseRunnable() {
                }

                @Override
                public void run() {
                    try {
                        DirectIONative.close(handle);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            StoreRCMUtils.accountAsGlobal(new CloseRunnable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
    }

    @Override
    public long getSize(long handle) throws IOException {
        return DirectIONative.getSize(handle);
    }

    @Override
    public long getDeviceLimit(long handle) throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getDeviceUsed(long handle) throws IOException {
        return 0L;
    }

    @Override
    public void truncate(long handle, long newSize) throws IOException {
        DirectIONative.truncate(handle, newSize);
    }

    @Override
    public int read(long handle, long filePosition, ByteBuffer buf, int bufPosition, int bufLength) throws IOException {
        return DirectIONative.read(handle, filePosition, buf, bufPosition, bufLength);
    }

    @Override
    public int write(long handle, long filePosition, ByteBuffer buf, int bufPosition, int bufLength) throws IOException {
        return DirectIONative.write(handle, filePosition, buf, bufPosition, bufLength);
    }

    @Override
    public void force(long handle, boolean metaData) throws IOException {
        DirectIONative.force(handle, metaData);
    }

    @Override
    public long createMapping(long fileHandle, long size) throws IOException {
        return DirectIONative.createMapping(fileHandle, size);
    }

    @Override
    public ByteBuffer mapFile(long handle, long offset, int size, boolean prefetched) throws IOException {
        return DirectIONative.mapFile(handle, offset, size, prefetched);
    }

    @Override
    public void unmapFile(ByteBuffer buf) throws IOException {
        DirectIONative.unmapFile(buf);
    }

    @Override
    public long getMemoryMapGranularity() {
        return DirectIONative.getMemoryMapGranularity();
    }

    @Override
    public void fillBuffer(ByteBuffer buf, int position, int size, byte value) {
        DirectIONative.fillBuffer(buf, position, size, value);
    }
}

