/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file.direct;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.Callable;
import weblogic.store.PersistentStoreException;
import weblogic.store.common.StoreDebug;
import weblogic.store.common.StoreRCMUtils;
import weblogic.store.io.file.direct.DirectFileChannel;
import weblogic.store.io.file.direct.DirectIONativeImpl;
import weblogic.store.io.file.direct.IONative;

public final class DirectIOManager {
    private static final String FILE_STORE_LIB_NAME = "wlfileio3";
    private static final String JDK_IO_NAME = "NIO";
    public String libraryName;
    private ByteBuffer zeroPage;
    private final IONative ioNative;
    private final boolean nativeRequired;
    private static final DirectIOManager fileSingleton = new DirectIOManager(false, "wlfileio3", DirectIONativeImpl.getSingleton());
    private final boolean nativeFileAvailable;
    private final UnsatisfiedLinkError unsatisfiedLinkError;

    DirectIOManager(boolean nativeRequired, String library, IONative ioNative) {
        UnsatisfiedLinkError tempULE;
        boolean tempNative;
        block2: {
            this.ioNative = ioNative;
            this.libraryName = library;
            this.nativeRequired = nativeRequired;
            boolean debug = StoreDebug.cacheDebug.isDebugEnabled();
            tempNative = false;
            tempULE = null;
            try {
                System.loadLibrary(this.libraryName);
                tempNative = true;
            }
            catch (UnsatisfiedLinkError ule) {
                tempULE = ule;
                if (!debug) break block2;
                StoreDebug.cacheDebug.debug(this.libraryName, ule);
            }
        }
        this.nativeFileAvailable = tempNative;
        this.unsatisfiedLinkError = tempULE;
    }

    DirectIOManager checkNativePersistentStoreException() throws PersistentStoreException {
        if (this.nativeRequired && !this.nativeFileAvailable) {
            throw new PersistentStoreException("failed to load " + this.libraryName, (Throwable)this.unsatisfiedLinkError);
        }
        return this;
    }

    DirectIOManager checkNativeIOException() throws IOException {
        if (this.nativeRequired && !this.nativeFileAvailable) {
            throw new IOException("failed to load " + this.libraryName, this.unsatisfiedLinkError);
        }
        return this;
    }

    public static DirectIOManager getManager() {
        return fileSingleton;
    }

    public static DirectIOManager getMemMapManager() {
        return fileSingleton;
    }

    public static DirectIOManager getFileManager() {
        return fileSingleton;
    }

    public static IONative getFileMappingNative() {
        return DirectIONativeImpl.getSingleton();
    }

    public static DirectIOManager getOpenFileManager() {
        return fileSingleton;
    }

    public static DirectIOManager getFileMemoryManager() {
        return fileSingleton;
    }

    public boolean nativeFileCodeAvailable() {
        return this.nativeFileAvailable;
    }

    public int checkAlignment(File testFile) {
        if (!this.nativeFileAvailable) {
            return -1;
        }
        try {
            return this.ioNative.checkAlignment(testFile.getCanonicalPath());
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public ByteBuffer allocateDirectBuffer(int size) {
        if (this.nativeFileAvailable) {
            return this.ioNative.allocate(size);
        }
        return ByteBuffer.allocateDirect(size);
    }

    public void zeroBuffer(ByteBuffer buf) {
        this.zeroBuffer(buf, buf.remaining());
    }

    public void zeroBuffer(ByteBuffer buf, int length) {
        if (this.nativeFileAvailable) {
            this.ioNative.fillBuffer(buf, buf.position(), length, (byte)0);
            buf.position(buf.position() + length);
        } else {
            int chunk;
            ByteBuffer zeroBuf = this.getZeroBuffer(8192);
            for (int remaining = length; remaining > 0; remaining -= chunk) {
                chunk = Math.min(8192, remaining);
                zeroBuf.limit(chunk);
                zeroBuf.position(0);
                buf.put(zeroBuf);
            }
        }
    }

    public void freeDirectBuffer(ByteBuffer buf) {
        if (this.nativeFileAvailable) {
            this.ioNative.free(buf);
        }
    }

    public FileChannel openBasic(final File file, final String mode, boolean exclusive) throws IOException {
        FileLock lock;
        FileChannel channel;
        if (this.nativeFileAvailable) {
            return new DirectFileChannel(this.ioNative, file, mode, exclusive);
        }
        if (this.nativeRequired) {
            throw new IOException("can not open " + file.getCanonicalPath() + " failed to load " + this.libraryName, this.unsatisfiedLinkError);
        }
        if (mode.equals("rwD")) {
            throw new IOException("Direct I/O is not supported on this platform");
        }
        try {
            class OpenBasicCallable
            implements Callable<FileChannel> {
                OpenBasicCallable() {
                }

                @Override
                public FileChannel call() throws FileNotFoundException {
                    return new RandomAccessFile(file, mode).getChannel();
                }
            }
            channel = StoreRCMUtils.accountAsGlobal(new OpenBasicCallable());
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw e;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        if (exclusive && (lock = channel.tryLock()) == null) {
            try {
                class OpenBasicCloseRunable
                implements Runnable {
                    OpenBasicCloseRunable() {
                    }

                    @Override
                    public void run() {
                        try {
                            channel.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                StoreRCMUtils.accountAsGlobal(new OpenBasicCloseRunable());
            }
            catch (Exception e) {
                StoreRCMUtils.throwIOorRuntimeException(e);
            }
            throw new IOException("Could not acquire an NIO lock for " + file + ". A file store running in another process may be holding the lock.");
        }
        return channel;
    }

    public FileChannel openEnhanced(final File file, final String mode, final boolean exclusive, final String[] configurationKeys, final String[] configurationValues) throws IOException {
        if (!this.nativeFileAvailable) {
            if (this.nativeRequired) {
                throw new IOException("can not open " + file.getCanonicalPath() + " failed to load " + this.libraryName, this.unsatisfiedLinkError);
            }
            throw new IOException("Direct I/O is not supported on this platform");
        }
        FileChannel channel = null;
        try {
            class OpenEnhancedCallable
            implements Callable<FileChannel> {
                OpenEnhancedCallable() {
                }

                @Override
                public FileChannel call() throws IOException {
                    return new DirectFileChannel(DirectIOManager.this.ioNative, file, mode, exclusive, configurationKeys, configurationValues);
                }
            }
            channel = StoreRCMUtils.accountAsGlobal(new OpenEnhancedCallable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
        return channel;
    }

    public String getDriver() {
        if (this.nativeFileAvailable) {
            return this.libraryName;
        }
        return JDK_IO_NAME;
    }

    public String toString() {
        if (this.nativeFileAvailable) {
            return this.libraryName + " nativeRequired=" + this.nativeRequired + (this.ioNative == null ? " null ioNative!" : this.ioNative.getClass().getName());
        }
        return "NIO nativeRequired=" + this.nativeRequired + (this.ioNative == null ? " null ioNative!" : this.ioNative.getClass().getName());
    }

    public synchronized ByteBuffer getZeroBuffer(int blockSize) {
        if (this.zeroPage == null) {
            this.zeroPage = this.allocateDirectBuffer(8192);
        }
        this.zeroPage.limit(blockSize);
        this.zeroPage.position(0);
        return this.zeroPage.slice();
    }
}

