/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import weblogic.logging.Loggable;
import weblogic.store.StoreLogger;
import weblogic.store.common.StoreDebug;
import weblogic.store.common.StoreRCMUtils;
import weblogic.store.io.file.BaseStoreIO;
import weblogic.store.io.file.DirectBufferPool;
import weblogic.store.io.file.Heap;
import weblogic.store.io.file.StoreFile;

public final class StoreDir
implements FilenameFilter {
    private final File dir;
    private long bytesUsed;
    final String filePrefix;
    private final String fileSuffix;
    private final String dirName;
    private DirectBufferPool bufferPool;
    private final List<StoreFile> files = new ArrayList<StoreFile>(1);
    private final Heap heap;

    public StoreDir(String dirName, String storeName, String fileSuffix) {
        this(null, dirName, storeName, fileSuffix);
    }

    StoreDir(Heap heap, String dirName, String storeName, String fileSuffix) {
        this.heap = heap;
        this.dir = new File(dirName);
        this.filePrefix = storeName.toUpperCase();
        this.fileSuffix = fileSuffix.toUpperCase();
        this.dirName = dirName;
    }

    List<StoreFile> open(DirectBufferPool bufferPool, boolean autoCreateDir) throws IOException {
        this.checkOK(autoCreateDir);
        this.bufferPool = bufferPool;
        try {
            this.findFiles();
        }
        catch (IOException ioe) {
            StoreDir.throwIOException(StoreLogger.logCantAccessDirectoryLoggable(this.getDirAbsolutePath()), ioe);
        }
        for (short i = 0; i < this.files.size(); i = (short)((short)(i + 1))) {
            if (this.files.get(i) != null) continue;
            if (this.heap.isReplicatedStore) {
                StoreDir.throwIOException(StoreLogger.logMissingRegionLoggable(this.heap.getName(), this.fileNumToFileName(this.filePrefix, i)));
                continue;
            }
            StoreDir.throwIOException(StoreLogger.logMissingFileLoggable(this.fileNumToFileName(this.filePrefix, i), this.getDirAbsolutePath()));
        }
        return this.files;
    }

    public void changePrefix(String nuPrefix) throws IOException {
        final String newPrefix = nuPrefix.toUpperCase();
        this.files.clear();
        this.findFiles();
        try {
            class ChangePrefixRunnable
            implements Runnable {
                ChangePrefixRunnable() {
                }

                @Override
                public void run() {
                    for (StoreFile file : StoreDir.this.files) {
                        String newName = StoreDir.this.fileNumToFileName(newPrefix, file.getFileNum());
                        file.rename(new File(StoreDir.this.dir, newName));
                    }
                }
            }
            StoreRCMUtils.accountAsGlobal(new ChangePrefixRunnable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
    }

    public void deleteFiles() throws IOException {
        final File[] fa = this.dir.listFiles(this);
        try {
            class DeleteFilesRunnable
            implements Runnable {
                DeleteFilesRunnable() {
                }

                @Override
                public void run() {
                    try {
                        if (fa == null) {
                            return;
                        }
                        for (int i = 0; i < fa.length; ++i) {
                            fa[i].delete();
                        }
                    }
                    catch (SecurityException se) {
                        throw new RuntimeException(new IOException(se.toString(), se));
                    }
                }
            }
            StoreRCMUtils.accountAsGlobal(new DeleteFilesRunnable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
    }

    public void close() throws IOException {
        IOException firstException = null;
        ListIterator<StoreFile> iter = this.files.listIterator();
        while (iter.hasNext()) {
            block4: {
                StoreFile sf = (StoreFile)iter.next();
                try {
                    sf.close();
                }
                catch (IOException e) {
                    if (firstException != null) break block4;
                    firstException = e;
                }
            }
            iter.remove();
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public int numFiles() {
        return this.files.size();
    }

    public StoreFile get(int index) {
        return this.files.get(index);
    }

    public List<StoreFile> getFiles() {
        return this.files;
    }

    public void addNewFile(StoreFile file) {
        this.files.add(file);
    }

    public String getDirName() {
        return this.dirName;
    }

    String getDirAbsolutePath() {
        return this.dir.getAbsolutePath();
    }

    private static void throwIOException(Loggable l) throws IOException {
        throw new IOException(l.getMessage());
    }

    private static void throwIOException(Throwable linked) throws IOException {
        IOException ioe = new IOException(linked.toString());
        ioe.initCause(linked);
        throw ioe;
    }

    private static void throwIOException(Loggable l, Throwable linked) throws IOException {
        IOException ioe = new IOException(l.getMessage());
        ioe.initCause(linked);
        throw ioe;
    }

    boolean checkOK(boolean autoCreateOK) throws IOException {
        return this.checkOK(autoCreateOK, this.dir.getPath().length());
    }

    boolean checkOK(boolean autoCreateOK, int length) throws IOException {
        StoreDir.createDirectory(this.dir, length, autoCreateOK);
        final File storeFile = new File(this.dir, this.fileNumToFileName(this.filePrefix, (short)0));
        boolean itExists = false;
        try {
            class CheckOkCallable
            implements Callable<Boolean> {
                CheckOkCallable() {
                }

                @Override
                public Boolean call() {
                    return storeFile.exists();
                }
            }
            itExists = StoreRCMUtils.accountAsGlobal(new CheckOkCallable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
        return itExists;
    }

    public static void createDirectory(File dir, boolean autoCreateOK) throws IOException {
        StoreDir.createDirectory(dir, dir.getPath().length(), autoCreateOK);
    }

    public static void createDirectory(File dir, final int length, final boolean autoCreateOK) throws IOException {
        final File theDir = dir;
        try {
            class CreateDirectoryCallable
            implements Callable<File> {
                CreateDirectoryCallable() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File call() throws IOException {
                    boolean autoCreateDir = false;
                    boolean isSuccess = false;
                    File tmpDir = new File(theDir.getPath().substring(0, length));
                    try {
                        if (!tmpDir.exists()) {
                            if (!autoCreateOK) {
                                StoreDir.throwIOException(StoreLogger.logDirectoryNotFoundLoggable(tmpDir.getPath()));
                            } else {
                                try {
                                    tmpDir.mkdirs();
                                    autoCreateDir = true;
                                }
                                catch (SecurityException se) {
                                    StoreDir.throwIOException(se);
                                }
                            }
                        }
                        StoreDir.checkDirectory(tmpDir);
                        isSuccess = true;
                    }
                    catch (SecurityException se) {
                        StoreDir.throwIOException(se);
                    }
                    finally {
                        if (autoCreateDir && !isSuccess) {
                            try {
                                tmpDir.delete();
                            }
                            catch (SecurityException securityException) {}
                        }
                    }
                    return tmpDir;
                }
            }
            StoreRCMUtils.accountAsGlobal(new CreateDirectoryCallable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
    }

    public File createFile(final short fileNum) throws IOException {
        File createdFile;
        try {
            class CreateFileCallable
            implements Callable<File> {
                CreateFileCallable() {
                }

                @Override
                public File call() throws IOException {
                    File file = new File(StoreDir.this.dir, StoreDir.this.fileNumToFileName(StoreDir.this.filePrefix, fileNum));
                    if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                        StoreDebug.storeIOPhysicalVerbose.debug("About to create new file " + file.getPath());
                    }
                    try {
                        if (!file.createNewFile()) {
                            if (((StoreDir)StoreDir.this).heap.isReplicatedStore) {
                                if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                                    StoreDebug.storeIOPhysicalVerbose.debug("StoreDir Replicated Store could not create " + file.getCanonicalPath());
                                }
                                if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                                    StoreDebug.storeIOPhysicalVerbose.debug("StoreDir Replicated Store could not create " + file.getCanonicalPath());
                                }
                            } else {
                                StoreDir.throwIOException(StoreLogger.logErrorCreatingFileLoggable(file.getPath()));
                            }
                        }
                    }
                    catch (SecurityException se) {
                        StoreDir.throwIOException(se);
                    }
                    return file;
                }
            }
            createdFile = StoreRCMUtils.accountAsGlobal(new CreateFileCallable());
        }
        catch (IOException e) {
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("StoreDir.createFile: ", e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("StoreDir.createFile: ", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("StoreDir.createFile: ", e);
            }
            throw new RuntimeException(e);
        }
        catch (Error e) {
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("StoreDir.createFile: ", e);
            }
            throw e;
        }
        return createdFile;
    }

    private void findFiles() throws IOException {
        BaseStoreIO baseStoreIO = this.heap.getBaseStoreIO();
        File[] f = new File[]{};
        if (baseStoreIO == null) {
            final StoreDir filter = this;
            try {
                class FindFilesCallable
                implements Callable<File[]> {
                    FindFilesCallable() {
                    }

                    @Override
                    public File[] call() throws IOException, SecurityException {
                        return StoreDir.this.dir.listFiles(filter);
                    }
                }
                f = StoreRCMUtils.accountAsGlobal(new FindFilesCallable());
            }
            catch (Exception e) {
                StoreDir.throwIOException(e);
            }
        } else {
            f = baseStoreIO.listRegionsOrFiles(this.heap, this.dir, this);
        }
        try {
            for (int i = 0; i < f.length; ++i) {
                String fileName = f[i].getName();
                short fileNum = this.fileNameToFileNum(this.filePrefix, fileName);
                if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                    StoreDebug.storeIOPhysicalVerbose.debug("StoreDir.findFiles fileNum=" + fileNum + " for " + fileName);
                }
                while (fileNum >= this.files.size()) {
                    this.files.add(null);
                }
                this.files.set(fileNum, new StoreFile(this.heap, this, f[i], fileNum, this.bufferPool));
            }
        }
        catch (SecurityException se) {
            StoreDir.throwIOException(se);
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.fileNameToFileNum(this.filePrefix, name) >= 0;
    }

    public void incBytesUsed(long amt) {
        this.bytesUsed += amt;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    private String fileNumToFileName(String prefix, short n) {
        String str = Integer.toString(n);
        int len = str.length();
        return prefix + new StringBuffer("000000").replace(6 - len, 6, str).toString() + "." + this.fileSuffix;
    }

    private short fileNameToFileNum(String prefix, String fileName) {
        fileName = fileName.toUpperCase();
        if (prefix.length() + this.fileSuffix.length() + 6 + 1 == fileName.length() && fileName.startsWith(prefix) && fileName.endsWith(this.fileSuffix.toUpperCase())) {
            try {
                return Short.parseShort(fileName.substring(prefix.length(), prefix.length() + 6));
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    public static void checkFile(File file) throws IOException {
        try {
            class CheckFileRunnable
            implements Runnable {
                final /* synthetic */ File val$file;

                CheckFileRunnable(File file) {
                    this.val$file = file;
                }

                @Override
                public void run() {
                    try {
                        if (this.val$file.isDirectory()) {
                            StoreDir.throwIOException(StoreLogger.logFileIsADirectoryLoggable(this.val$file.getPath()));
                        }
                        if (!this.val$file.canRead() || !this.val$file.canWrite()) {
                            StoreDir.throwIOException(StoreLogger.logNoAccessToFileLoggable(this.val$file.getPath()));
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
            StoreRCMUtils.accountAsGlobal(new CheckFileRunnable(file));
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
    }

    public static void checkDirectory(File dir) throws IOException {
        try {
            class CheckDirectoryRunnable
            implements Runnable {
                final /* synthetic */ File val$dir;

                CheckDirectoryRunnable(File file) {
                    this.val$dir = file;
                }

                @Override
                public void run() {
                    try {
                        if (!this.val$dir.isDirectory()) {
                            StoreDir.throwIOException(StoreLogger.logDirectoryNotADirectoryLoggable(this.val$dir.getPath()));
                        }
                        if (!this.val$dir.canRead() || !this.val$dir.canWrite()) {
                            StoreDir.throwIOException(StoreLogger.logNoAccessToDirectoryLoggable(this.val$dir.getPath()));
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
            StoreRCMUtils.accountAsGlobal(new CheckDirectoryRunnable(dir));
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
    }
}

