/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.StoreLogger;
import weblogic.store.StoreWritePolicy;
import weblogic.store.common.StoreDebug;
import weblogic.store.io.IOListener;
import weblogic.store.io.file.BaseStoreIO;
import weblogic.store.io.file.Heap;
import weblogic.store.io.file.ReplicatedStoreAdmin;
import weblogic.store.io.file.StoreHeap;
import weblogic.store.io.file.direct.ReplicatedIONativeImpl;

public class ReplicatedStoreIO
extends BaseStoreIO {
    private int localIndex;

    public ReplicatedStoreIO(String filePrefix, String dirName) throws PersistentStoreException {
        this(filePrefix, dirName, true);
    }

    public ReplicatedStoreIO(String filePrefix, String dirName, boolean autoCreateDir) throws PersistentStoreException {
        super(ReplicatedIONativeImpl.getDirectIOManagerSingletonPersistentStoreException(), filePrefix, dirName, autoCreateDir, true);
    }

    public static int getIntConfiguration(HashMap config, String configName, String myStoreName, String localPropName, int defaultValue) {
        Object cp;
        if (config != null && (cp = config.get(configName)) != null && cp instanceof Integer) {
            defaultValue = (Integer)cp;
        }
        return Integer.getInteger("weblogic.store.replicated." + myStoreName + localPropName, Integer.getInteger("weblogic.store.replicated" + localPropName, defaultValue));
    }

    @Override
    HashMap<String, Object> adjustConfig(HashMap<String, Object> config) {
        Boolean lockingConfig;
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("adjustConfig begin");
        }
        this.writePolicy = StoreWritePolicy.DIRECT_WRITE;
        Object tmp = config.get("SynchronousWritePolicy");
        if (this.writePolicy != tmp) {
            config.put("SynchronousWritePolicy", this.writePolicy);
        }
        int blockSize = 8192;
        Integer configuredBlockSize = (Integer)config.get("BlockSize");
        if (configuredBlockSize < 512) {
            if (configuredBlockSize != -1 && StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("ReplicatedStoreIO: " + this.heap.getName() + ", Invalid block-size value configured:" + configuredBlockSize + ", overridding with: " + blockSize);
            }
            config.put("BlockSize", blockSize);
        }
        if ((lockingConfig = (Boolean)config.get("FileLockingEnabled")) != null && !lockingConfig.booleanValue()) {
            config.put("FileLockingEnabled", Boolean.TRUE);
        }
        this.heap.setSynchronousWritePolicy(this.writePolicy);
        this.localIndex = ReplicatedStoreIO.getIntConfiguration(config, "LocalIndex", this.heap.getName(), ".LocalIndex", 0);
        if (this.localIndex < 0) {
            StoreLogger.logInvalidIntegerProperty("LocalIndex", String.valueOf(this.localIndex), 0);
            this.localIndex = 0;
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("ReplicatedStoreIO: " + this.heap.getName() + ".LocalIndex:" + this.localIndex);
        }
        config.put("LocalIndex", this.localIndex);
        int maximumMessageSizePercent = Math.abs(ReplicatedStoreIO.getIntConfiguration(config, "MaximumMessageSizePercent", this.heap.getName(), ".MaximumMessageSizePercent", 1));
        if (maximumMessageSizePercent > 100) {
            maximumMessageSizePercent = 100;
        }
        if (maximumMessageSizePercent != 1) {
            System.out.println(" *** -D.MaximumMessageSizePercentis set to " + maximumMessageSizePercent);
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("ReplicatedStoreIO: " + this.heap.getName() + ".MaximumMessageSizePercent:" + maximumMessageSizePercent);
        }
        config.put("MaximumMessageSizePercent", maximumMessageSizePercent);
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("adjustConfig end. config map=" + config.toString());
        }
        return config;
    }

    @Override
    public int open(HashMap config) throws PersistentStoreException {
        config = this.adjustConfig(config);
        return this.openInternal(config);
    }

    static String convertToString(File file, Map<String, Object> config, String key) throws IOException {
        Object result = config.get(key);
        try {
            String s = (String)result;
            s.charAt(1);
            return s;
        }
        catch (Throwable t) {
            throw new IOException("expected Replicated Store configuration " + key + " as positive number, have " + result + " for PersistentStore " + file.getCanonicalPath(), t);
        }
    }

    static long convertToLong(File file, Map<String, Object> config, String key) throws IOException {
        Object result = config.get(key);
        try {
            return ((Number)result).longValue();
        }
        catch (Throwable t) {
            throw new IOException("expected Replicated Store configuration " + key + " as positive number, have " + result + " for PersistentStore " + file.getCanonicalPath(), t);
        }
    }

    static String validatePositiveConfig(File file, Map<String, Object> config, String key) throws IOException {
        long val = ReplicatedStoreIO.convertToLong(file, config, key);
        if (val < 1L) {
            throw new IOException("expected value greater than 0 for " + key + " for PersistentStore " + file.getCanonicalPath());
        }
        return Long.toString(val);
    }

    static String validateRealConfig(File file, Map<String, Object> config, String key) throws IOException {
        long val = ReplicatedStoreIO.convertToLong(file, config, key);
        if (val < 0L) {
            throw new IOException("expected value at least 0 for " + key + " for PersistentStore " + file.getCanonicalPath());
        }
        return Long.toString(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    FileChannel fileChannelFactory(Map<String, Object> config, File file, String mode, boolean exclusive) throws IOException {
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("fileChannelFactory begin");
        }
        if (!exclusive) {
            throw new IOException("must always be exclusive access");
        }
        if (!"rwd".equalsIgnoreCase(mode)) {
            throw new IOException("mode must be 'rwd' but is " + mode);
        }
        Object requestedPolicy = config.get("SynchronousWritePolicy");
        StoreWritePolicy targetPolicy = StoreWritePolicy.DIRECT_WRITE;
        if (requestedPolicy == null || !requestedPolicy.equals(targetPolicy)) {
            throw new IOException("policy must be " + targetPolicy + " but is " + requestedPolicy);
        }
        HashMap<String, String> localConfig = new HashMap<String, String>();
        HashMap<String, Object> remaining = new HashMap<String, Object>(config);
        int handle = ReplicatedIONativeImpl.allocateNativeHandle(this.heap.getRegionName());
        remaining.put("CandidateHandle", new Integer(handle).toString());
        remaining.put("LocalIndex", new Integer(this.localIndex).toString());
        remaining.remove("SynchronousWritePolicy");
        remaining.remove("DomainName");
        for (String k : PersistentStore.VALID_REPLICATED_IO_KEYS) {
            Object v = remaining.remove(k);
            if (null == v) {
                String d = "ReplicatedStoreIO: " + this.heap.getName() + ". has unpopulated config " + k;
                if (!StoreDebug.storeIOPhysical.isDebugEnabled()) continue;
                StoreDebug.storeIOPhysical.debug(d);
                continue;
            }
            localConfig.put(k, v.toString());
        }
        if (!remaining.isEmpty()) {
            String d = "skip configurable " + remaining.toString();
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug(d);
            }
        }
        int size = localConfig.size();
        String[] keys = new String[size];
        String[] values = new String[size];
        int valueIndex = 0;
        for (String k : PersistentStore.VALID_REPLICATED_IO_KEYS) {
            String v = (String)localConfig.get(k);
            if (null == v) continue;
            values[valueIndex] = v;
            keys[valueIndex++] = k;
        }
        boolean problem = true;
        try {
            FileChannel fc = this.directIOManager.openEnhanced(file, mode, exclusive, keys, values);
            problem = false;
            FileChannel fileChannel = fc;
            return fileChannel;
        }
        finally {
            if (problem) {
                ReplicatedIONativeImpl.freeNativeHandle(handle);
            }
        }
    }

    @Override
    public void flush(IOListener listener) throws PersistentStoreException {
        throw new UnsupportedOperationException("the asynchrounous flush should not be called on ReplicatedStoreIO");
    }

    public void poll() {
        block2: {
            try {
                this.heap.pollDevice();
            }
            catch (IOException ioe) {
                if (!StoreHeap.DEBUG_SPACE_UPDATES) break block2;
                System.out.println("Failed to poll a daemon from a replicated store for status");
            }
        }
    }

    @Override
    File[] listRegionsOrFiles(Heap heap, File configuredDirectory, FilenameFilter filenameFilter) throws IOException {
        int redPercent;
        HashMap<String, ReplicatedStoreAdmin.RegionInfo> regionInfoMap;
        String daemonConfigFile = heap.getStringConfig("ConfigFileName");
        String regionprefix = heap.getRegionName();
        if (regionprefix == null || daemonConfigFile == null) {
            throw new IOException("unexpected missing value: prefix=" + regionprefix + " configFile=" + daemonConfigFile);
        }
        ReplicatedStoreAdmin rsa = ReplicatedStoreAdmin.getRecoveryInstance();
        ReplicatedStoreAdmin.DaemonInfo localDaemon = rsa.populateRecoveryInfo(regionInfoMap = new HashMap<String, ReplicatedStoreAdmin.RegionInfo>(), this.localIndex, daemonConfigFile, regionprefix);
        if (localDaemon == null) {
            throw new IOException("unexpected local daemon");
        }
        if (localDaemon.getIndex() < 0) {
            throw new IOException("unexpected local daemon index is " + localDaemon.getIndex());
        }
        if (localDaemon.getTotalMemory() < 0L) {
            throw new IOException("unexpected local getTotalMemory is " + localDaemon.getTotalMemory());
        }
        if (localDaemon.getUsedMemory() < 0L) {
            throw new IOException("unexpected local getUsedMemory is " + localDaemon.getUsedMemory());
        }
        long daemonBitMask = 1 << localDaemon.getIndex();
        long daemonTotalMemory = localDaemon.getTotalMemory();
        long daemonUsedMemory = localDaemon.getUsedMemory();
        ArrayList<File> files = new ArrayList<File>();
        long moreLocalDaemonMemory = 0L;
        ReplicatedStoreAdmin.RegionInfo lastRegion = null;
        int prefixSize = regionprefix.length();
        int digits = 6;
        for (ReplicatedStoreAdmin.RegionInfo regionInfo : regionInfoMap.values()) {
            String name = regionInfo.getName();
            if (name == null || name.length() != prefixSize + 6 || !name.startsWith(regionprefix)) {
                if (!StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) continue;
                StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles skip " + name + " does not start with " + regionprefix);
                continue;
            }
            String suffix = name.substring(prefixSize, prefixSize + 6);
            boolean skip = false;
            for (int offset = 0; offset < 6; ++offset) {
                char one = suffix.charAt(offset);
                if (one >= '0' && '9' >= one) continue;
                skip = true;
                if (!StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) break;
                StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles skip " + name + " has non numeric character " + one);
                break;
            }
            if (skip) continue;
            lastRegion = regionInfo;
            if ((regionInfo.getNodes() & daemonBitMask) == 0L) {
                moreLocalDaemonMemory += (long)(regionInfo.getSize() + 1024);
                if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                    StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles remote size=" + regionInfo.getSize() + "/" + regionInfo.getUsed() + " " + name);
                }
            } else if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles LOCAL! size=" + regionInfo.getSize() + "/" + regionInfo.getUsed() + " " + name);
            }
            File oneFile = new File(configuredDirectory, name + "." + Heap.DEFAULT_REPLICATED_SUFFIX);
            files.add(oneFile);
            if (!StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) continue;
            StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles name=" + oneFile.getName() + " as " + oneFile.getCanonicalPath());
        }
        if (lastRegion == null) {
            int maxRegionSize = (Integer)heap.getConfig().get("RegionSize");
            if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles create file maxRegionSize=" + maxRegionSize);
            }
            moreLocalDaemonMemory += (long)(maxRegionSize + 1024);
        }
        long percentUsed = 100L * (daemonUsedMemory + moreLocalDaemonMemory) / daemonTotalMemory;
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("ReplicatedStoreIO.listRegionsOrFiles percentUsed=" + percentUsed + " daemonUsedMemory=" + daemonUsedMemory + " moreLocalDaemonMemory=" + moreLocalDaemonMemory + " daemonTotalMemory=" + daemonTotalMemory);
        }
        if (moreLocalDaemonMemory > 0L && percentUsed >= (long)(redPercent = ((Integer)heap.getConfig().get("SpaceOverloadRedPercent")).intValue())) {
            throw new IOException("opening replicated store will increase memory on local daemon by " + moreLocalDaemonMemory + ". Memory will be (" + percentUsed + "%) exceeding allowed (" + redPercent + "%) with local daemon index=" + localDaemon.getIndex() + " for replicated store " + regionprefix);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public void dump(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("ReplicatedStore");
        this.dumpInternal(xsw);
    }
}

