/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.store.PersistentStoreException;
import weblogic.store.StoreWritePolicy;
import weblogic.store.common.StoreDebug;
import weblogic.store.common.StoreRCMUtils;
import weblogic.store.io.IOListener;
import weblogic.store.io.file.BaseStoreIO;
import weblogic.store.io.file.Heap;
import weblogic.store.io.file.direct.DirectIOManager;

public class FileStoreIO
extends BaseStoreIO {
    public FileStoreIO(String filePrefix, String dirName) throws PersistentStoreException {
        this(filePrefix, dirName, true);
    }

    public FileStoreIO(String filePrefix, String dirName, boolean autoCreateDir) throws PersistentStoreException {
        super(DirectIOManager.getOpenFileManager(), filePrefix, dirName, autoCreateDir, false);
    }

    @Override
    @Deprecated
    public int open(StoreWritePolicy wp, int ignored) throws PersistentStoreException {
        HashMap<String, StoreWritePolicy> config = new HashMap<String, StoreWritePolicy>();
        config.put("SynchronousWritePolicy", wp);
        return this.open(config);
    }

    @Override
    HashMap<String, Object> adjustConfig(HashMap<String, Object> config) {
        return config;
    }

    @Override
    public int open(HashMap config) throws PersistentStoreException {
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("Opening store: " + this.heap.getName());
        }
        return this.openInternal(config);
    }

    @Override
    FileChannel fileChannelFactory(Map<String, Object> config, File file, String mode, boolean exclusive) throws IOException {
        return FileStoreIO.staticOpen(this.heap, file, mode, exclusive);
    }

    static FileChannel staticOpen(Heap optional, File file, String mode, boolean exclusive) throws IOException {
        int optHashCode = optional == null ? -1 : System.identityHashCode(optional);
        return DirectIOManager.getFileManager().openBasic(file, mode, exclusive);
    }

    @Override
    public void flush(IOListener listener) throws PersistentStoreException {
        throw new UnsupportedOperationException("the asynchrounous flush should not be called on FileStoreIO");
    }

    @Override
    public void dump(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("FileStore");
        this.dumpInternal(xsw);
    }

    @Override
    File[] listRegionsOrFiles(Heap heap, final File configuredDirectory, final FilenameFilter filenameFilter) throws IOException {
        File[] files = new File[]{};
        try {
            class ListRegionsOrFileCallable
            implements Callable<File[]> {
                ListRegionsOrFileCallable() {
                }

                @Override
                public File[] call() throws IOException {
                    return configuredDirectory.listFiles(filenameFilter);
                }
            }
            files = StoreRCMUtils.accountAsGlobal(new ListRegionsOrFileCallable());
        }
        catch (Exception e) {
            StoreRCMUtils.throwIOorRuntimeException(e);
        }
        return files;
    }
}

