/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import weblogic.common.CompletionRequest;
import weblogic.store.PersistentHandle;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentStoreImpl;
import weblogic.store.internal.PersistentTransactionImpl;
import weblogic.store.internal.StoreRequest;

public final class PersistentStoreTransactionImpl
extends PersistentTransactionImpl {
    private final PersistentStoreImpl store;
    private final HashMap pending = new HashMap();
    private final List handleList = new ArrayList();

    public PersistentStoreTransactionImpl(PersistentStoreImpl store) {
        this.store = store;
    }

    @Override
    synchronized boolean hasPendingWorkInternal() {
        return this.handleList.size() != 0;
    }

    @Override
    synchronized void commitInternal(CompletionRequest userCompReq) {
        this.store.schedule(this.handleList, userCompReq);
    }

    @Override
    synchronized void rollbackInternal(CompletionRequest cr) {
        for (int i = 0; i < this.handleList.size(); ++i) {
            StoreRequest req = (StoreRequest)this.handleList.get(i);
            if (req.getType() != 1) continue;
            PersistentHandleImpl handle = req.getHandle();
            this.store.releaseHandle(req.getTypeCode(), handle);
        }
        cr.setResult(Boolean.TRUE);
    }

    synchronized StoreRequest put(PersistentHandle handle, StoreRequest req) {
        this.handleList.add(req);
        StoreRequest oldStoreRequest = this.pending.put(handle, req);
        return oldStoreRequest;
    }

    synchronized StoreRequest get(PersistentHandle handle) {
        return (StoreRequest)this.pending.get(handle);
    }
}

