/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import weblogic.common.CompletionRequest;
import weblogic.store.ByteBufferObjectHandler;
import weblogic.store.DefaultObjectHandler;
import weblogic.store.ObjectHandler;
import weblogic.store.OperationStatistics;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreRuntimeException;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.StoreLogger;
import weblogic.store.StoreWritePolicy;
import weblogic.store.TestStoreException;
import weblogic.store.common.StoreDebug;
import weblogic.store.internal.CreateRequest;
import weblogic.store.internal.CursorRequest;
import weblogic.store.internal.DeleteRequest;
import weblogic.store.internal.OperationStatisticsImpl;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentStoreImpl;
import weblogic.store.internal.PersistentStoreOutputStreamImpl;
import weblogic.store.internal.PersistentStoreRecordImpl;
import weblogic.store.internal.PersistentStoreTransactionImpl;
import weblogic.store.internal.ReadRequest;
import weblogic.store.internal.StoreRequest;
import weblogic.store.internal.UpdateRequest;
import weblogic.store.io.IORecord;
import weblogic.store.io.PersistentStoreIO;
import weblogic.utils.Debug;

public final class PersistentStoreConnectionImpl
implements PersistentStoreConnection {
    private static final int DYNAMC_CURSOR_BATCH_SIZE = Integer.getInteger("weblogic.store.CursorBatchSize", 512);
    private static final boolean TRACK_CONCURRENT_MODIFICATIONS = Debug.getCategory("weblogic.store.TrackConcurrentModifications").isEnabled();
    private final PersistentStoreImpl.ConnectionKey key;
    private final String name;
    private final PersistentStoreImpl store;
    private final int typeCode;
    private final OperationStatisticsImpl statistics;
    private volatile int modCount;
    private ObjectHandler handler;
    private boolean isHandlerStoreExceptionTest;
    private Throwable lastModification;
    volatile boolean onlineDeserializationPossible;

    PersistentStoreConnectionImpl(PersistentStoreImpl.ConnectionKey key, PersistentStoreImpl store, int typeCode) {
        this.key = key;
        this.name = key.getName();
        this.store = store;
        this.typeCode = typeCode;
        this.statistics = new OperationStatisticsImpl(this.name, store.getStatisticsImpl());
        this.setObjectHandler(DefaultObjectHandler.THE_ONE);
    }

    @Override
    public PersistentHandle create(PersistentStoreTransaction tx, Object data, int flags) {
        return this.createInternal(tx, null, data, flags, -1L, -1L);
    }

    public void create(PersistentStoreTransaction tx, PersistentHandle ph, Object data, int flags) {
        this.createInternal(tx, ph, data, flags, -1L, -1L);
    }

    @Override
    public PersistentHandle create(PersistentStoreTransaction tx, Object data, int flags, long flushGroup, long liveSequence) {
        return this.createInternal(tx, null, data, flags, flushGroup, liveSequence);
    }

    private PersistentHandle createInternal(PersistentStoreTransaction tx, PersistentHandle ph, Object data, int flags) {
        return this.createInternal(tx, ph, data, flags, -1L, -1L);
    }

    private PersistentHandle createInternal(PersistentStoreTransaction tx, PersistentHandle ph, Object data, int flags, long flushGroup, long liveSequence) {
        StoreRequest pending;
        PersistentStoreException error;
        PersistentHandleImpl handle;
        PersistentStoreTransactionImpl ptx = (PersistentStoreTransactionImpl)tx;
        ByteBuffer[] body = this.serialize(data);
        if (ph == null) {
            handle = this.store.allocateHandle(this.typeCode);
            assert (handle.getTypeCode() == this.typeCode);
        } else {
            handle = (PersistentHandleImpl)ph;
            handle.setTypeCode(this.typeCode);
            this.store.ensureHandleAllocated(handle);
            handle.setDeleted(false);
        }
        CreateRequest req = new CreateRequest(handle, this, body, flags, flushGroup, liveSequence);
        if (this.isHandlerStoreExceptionTest && data instanceof TestStoreException && (error = ((TestStoreException)data).getTestException()) != null) {
            req.setCrashTestException(error);
        }
        if ((pending = ptx.put(handle, req)) != null) {
            if (pending.getType() != 4) {
                throw new PersistentStoreRuntimeException(StoreLogger.logStoreRecordAlreadyExistsLoggable(handle.getStoreHandle(), this.name, this.store.getName()));
            }
            pending.getHandle().setDeleted(false);
        }
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("create, tcd=" + this.typeCode + ", hdl=" + handle + ", ptx=" + tx + ", cls=" + data.getClass().getName() + ", obj=[" + data + "]");
        }
        this.mod();
        return handle;
    }

    @Override
    public void read(PersistentStoreTransaction tx, PersistentHandle handle, CompletionRequest cr) {
        this.read(tx, handle, cr, true);
    }

    @Override
    public void read(PersistentStoreTransaction tx, PersistentHandle handle, CompletionRequest cr, boolean isReadFailureFatal) {
        StoreRequest pending;
        PersistentHandleImpl h = PersistentHandleImpl.check(this, handle);
        h.setTypeCode(this.typeCode);
        ReadRequest req = new ReadRequest(h, this, this.handler, isReadFailureFatal);
        if (tx instanceof PersistentStoreTransactionImpl && (pending = ((PersistentStoreTransactionImpl)tx).get(handle)) != null) {
            pending.coalesce(req);
        }
        req.setCompletionRequest(cr);
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("read, tcd=" + this.typeCode + ", hdl=" + handle + ", ptx=" + tx);
        }
        this.store.schedule(req);
    }

    @Override
    public void update(PersistentStoreTransaction tx, PersistentHandle handle, Object data, int flags) {
        this.update(tx, handle, data, flags, -1L, -1L);
    }

    @Override
    public void update(PersistentStoreTransaction tx, PersistentHandle handle, Object data, int flags, long flushGroup, long liveSequence) {
        StoreRequest pending;
        PersistentHandleImpl h = PersistentHandleImpl.check(this, handle);
        h.setTypeCode(this.typeCode);
        ByteBuffer[] bufs = this.serialize(data);
        UpdateRequest req = new UpdateRequest(h, this, bufs, flags, flushGroup, liveSequence);
        PersistentStoreTransactionImpl ptx = (PersistentStoreTransactionImpl)tx;
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("update, tcd=" + this.typeCode + ", hdl=" + handle + ", ptx=" + tx + ", cls=" + data.getClass().getName() + ", obj=[" + data + "]");
        }
        if ((pending = ptx.get(handle)) != null) {
            pending.coalesce(req);
        } else {
            ptx.put(handle, req);
        }
        this.mod();
    }

    @Override
    public void delete(PersistentStoreTransaction tx, PersistentHandle handle, int flags) {
        this.delete(tx, handle, flags, -1L, -1L);
    }

    @Override
    public void delete(PersistentStoreTransaction tx, PersistentHandle handle, int flags, long flushGroup, long liveSequence) {
        PersistentHandleImpl h = PersistentHandleImpl.check(this, handle);
        h.setTypeCode(this.typeCode);
        DeleteRequest req = new DeleteRequest(h, this, flags, flushGroup, liveSequence);
        PersistentStoreTransactionImpl ptx = (PersistentStoreTransactionImpl)tx;
        StoreRequest pending = ptx.put(handle, req);
        if (pending != null) {
            pending.coalesce(req);
        }
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("delete, tcd=" + this.typeCode + ", hdl=" + handle + ", ptx=" + tx);
        }
        h.setDeleted(true);
        this.mod();
    }

    @Override
    public boolean isHandleReadable(PersistentHandle handle) {
        PersistentHandleImpl hi = (PersistentHandleImpl)handle;
        PersistentHandleImpl hcopy = new PersistentHandleImpl(hi.getTypeCode() == 0 ? this.typeCode : hi.getTypeCode(), hi.getStoreHandle());
        return hcopy.getTypeCode() == this.typeCode && !hcopy.isDeleted() && this.store.isHandleReadable(hcopy);
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public void delete() throws PersistentStoreException {
        this.close();
        this.store.delete(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PersistentStoreConnection.Cursor createCursor(int flags) throws PersistentStoreException {
        if (this.store.supportsFastReads() && (flags & 0x40) == 0 || (flags & 0x20) == 32) {
            return new DynamicCursorImpl(flags);
        }
        return new CursorImpl(this.store.createCursor(this.typeCode, flags));
    }

    PersistentStoreImpl.ConnectionKey getKey() {
        return this.key;
    }

    private void mod() {
        ++this.modCount;
        if (TRACK_CONCURRENT_MODIFICATIONS) {
            this.lastModification = new Throwable();
        }
    }

    public ByteBuffer[] serialize(Object o) {
        if (this.handler instanceof ByteBufferObjectHandler) {
            return new ByteBuffer[]{(ByteBuffer)o};
        }
        try {
            PersistentStoreOutputStreamImpl psos = new PersistentStoreOutputStreamImpl();
            this.handler.writeObject(psos, o);
            return psos.getBuffers();
        }
        catch (IOException ioe) {
            throw new PersistentStoreRuntimeException(StoreLogger.logCreateFailedLoggable(), (Throwable)ioe);
        }
    }

    boolean deserializationDeferred() throws PersistentStoreException {
        if (!this.onlineDeserializationPossible) {
            return true;
        }
        if (this.store == null) {
            return false;
        }
        StoreWritePolicy swp = (StoreWritePolicy)this.store.getConfigValue("SynchronousWritePolicy");
        if (swp == null) {
            return false;
        }
        return !swp.mappedRead();
    }

    public void setObjectHandler(ObjectHandler handler) {
        this.isHandlerStoreExceptionTest = handler instanceof TestStoreException;
        this.handler = handler;
    }

    @Override
    public PersistentStore getStore() {
        return this.store;
    }

    PersistentStoreImpl getStoreImpl() {
        return this.store;
    }

    int getTypeCode() {
        return this.typeCode;
    }

    @Override
    public OperationStatistics getStatistics() {
        return this.statistics;
    }

    OperationStatisticsImpl getStatisticsImpl() {
        return this.statistics;
    }

    public String toString() {
        return "[ name=" + this.name + " store=" + this.store.getName() + " typeCode=" + this.typeCode + " ]";
    }

    private final class DynamicCursorImpl
    implements PersistentStoreConnection.Cursor {
        private ArrayList<PersistentStoreRecord> recList;
        private int flags;
        private PersistentStoreIO.Cursor cursor;
        private boolean cursordone;

        public DynamicCursorImpl(int flags) {
            this.flags = flags;
        }

        @Override
        public PersistentStoreRecord next() throws PersistentStoreException {
            PersistentStoreRecord ret;
            if (this.cursordone) {
                return null;
            }
            if (this.recList == null || this.recList.isEmpty()) {
                CursorRequest cursorReq = new CursorRequest(PersistentStoreConnectionImpl.this, DYNAMC_CURSOR_BATCH_SIZE, this.cursor, PersistentStoreConnectionImpl.this.handler, this.flags);
                CompletionRequest cr = new CompletionRequest();
                cursorReq.setCompletionRequest(cr);
                PersistentStoreConnectionImpl.this.store.schedule(cursorReq);
                try {
                    this.recList = (ArrayList)cr.getResult();
                    this.cursor = cursorReq.getCursor();
                }
                catch (PersistentStoreException pse) {
                    throw pse;
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable thr) {
                    throw new AssertionError((Object)thr);
                }
            }
            if ((ret = this.recList.remove(0)) == null) {
                this.cursordone = true;
            }
            return ret;
        }
    }

    private final class CursorImpl
    implements PersistentStoreConnection.Cursor {
        private final PersistentStoreIO.Cursor cursor;
        private final int expectedModCount;

        public CursorImpl(PersistentStoreIO.Cursor cursor) {
            this.cursor = cursor;
            this.expectedModCount = PersistentStoreConnectionImpl.this.modCount;
        }

        @Override
        public PersistentStoreRecord next() throws PersistentStoreException {
            if (this.expectedModCount != PersistentStoreConnectionImpl.this.modCount) {
                ConcurrentModificationException cme = new ConcurrentModificationException();
                if (TRACK_CONCURRENT_MODIFICATIONS && PersistentStoreConnectionImpl.this.lastModification != null) {
                    cme.initCause(PersistentStoreConnectionImpl.this.lastModification);
                }
                throw cme;
            }
            IORecord next = this.cursor.next();
            if (next == null) {
                return null;
            }
            PersistentStoreRecordImpl psr = new PersistentStoreRecordImpl(next, PersistentStoreConnectionImpl.this.handler, PersistentStoreConnectionImpl.this, false);
            if (psr != null && StoreDebug.storeIOLogicalBoot.isDebugEnabled()) {
                Object data = psr.getData();
                if (data != null) {
                    StoreDebug.storeIOLogicalBoot.debug("boot, tcd=" + next.getTypeCode() + ", hdl=" + next.getHandle() + ", cls=" + data.getClass().getName() + ", obj=[" + data + "]");
                } else {
                    StoreDebug.storeIOLogicalBoot.debug("boot, tcd=" + next.getTypeCode() + ", hdl=" + next.getHandle() + ", obj=[" + data + "]");
                }
            }
            return psr;
        }
    }
}

