/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.store.DefaultObjectHandler;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentMapAsyncTX;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.StoreWritePolicy;
import weblogic.store.internal.LockManager;
import weblogic.store.internal.LockManagerImpl;
import weblogic.store.internal.PersistentMapTransactionImpl;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.PersistentStoreImpl;
import weblogic.store.internal.PersistentStoreTransactionImpl;
import weblogic.store.internal.PersistentTransactionImpl;
import weblogic.store.io.file.FileStoreIO;

public final class PersistentMapImpl
implements PersistentMapAsyncTX {
    private static final int NO_FLAGS = 0;
    private static final Object REMOVE_OBJECT = new Object();
    private PersistentStoreConnectionImpl keyConn;
    private PersistentStoreConnectionImpl valueConn;
    private final Map keyMap = Collections.synchronizedMap(new HashMap());
    private PersistentStoreImpl store;
    private LockManager lockManager = new LockManagerImpl();
    private boolean deleteBad;
    private boolean instrBad;

    PersistentMapImpl(PersistentStoreConnection keys, PersistentStoreConnection values) throws PersistentStoreException {
        this.keyConn = (PersistentStoreConnectionImpl)keys;
        this.keyConn.setObjectHandler(new PersistentMapObjectHandler());
        this.valueConn = (PersistentStoreConnectionImpl)values;
        this.init();
    }

    PersistentMapImpl(PersistentStoreConnection keys, PersistentStoreConnection values, ObjectHandler handler) throws PersistentStoreException {
        this.keyConn = (PersistentStoreConnectionImpl)keys;
        this.keyConn.setObjectHandler(new PersistentMapObjectHandler(handler));
        this.valueConn = (PersistentStoreConnectionImpl)values;
        this.valueConn.setObjectHandler(handler);
        this.init();
    }

    private void init() throws PersistentStoreException {
        PersistentStoreTransaction tran;
        ArrayList<PersistentHandle> badHandles = new ArrayList<PersistentHandle>();
        this.store = (PersistentStoreImpl)this.keyConn.getStore();
        if (this.store != this.valueConn.getStore()) {
            throw new PersistentStoreException("keyConn.store != valueConn.store");
        }
        this.deleteBad = this.isSet("weblogic.store.DeleteBadPMapKeys");
        this.instrBad = this.isSet("weblogic.store.DeleteBadInstrTest");
        PersistentStoreConnection.Cursor cursor = this.keyConn.createCursor(0);
        PersistentStoreRecord rec = cursor.next();
        while (rec != null) {
            Entry entry = (Entry)rec.getData();
            entry.handle = rec.getHandle();
            if (this.deleteBad && entry.valueHandle != null && !this.valueConn.isHandleReadable(entry.valueHandle)) {
                badHandles.add(entry.handle);
            } else {
                if (this.instrBad && ((String)entry.key).contains("CORRUPTME") && this.valueConn.isHandleReadable(entry.valueHandle)) {
                    tran = this.store.begin();
                    this.valueConn.delete(tran, entry.valueHandle, 0);
                    tran.commit();
                }
                this.keyMap.put(entry.key, entry);
            }
            rec = cursor.next();
        }
        for (PersistentHandle ph : badHandles) {
            tran = this.store.begin();
            this.keyConn.delete(tran, ph, 0);
            tran.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Object key, Object value) throws PersistentStoreException {
        PersistentStoreTransactionImpl ptx = new PersistentStoreTransactionImpl(this.store);
        ptx.lock(this.lockManager, key);
        boolean success = false;
        try {
            boolean ret = this.apply(ptx, key, value);
            success = true;
            boolean bl = ret;
            return bl;
        }
        finally {
            if (success) {
                ptx.commit();
            } else {
                ptx.rollback();
            }
        }
    }

    @Override
    public void put(final Object key, final Object value, final CompletionRequest cr) {
        final PersistentStoreTransactionImpl ptx = new PersistentStoreTransactionImpl(this.store);
        ptx.lock(this.lockManager, key, new LockManager.Listener(){

            @Override
            public void onLock() {
                Boolean retValue = Boolean.FALSE;
                try {
                    if (PersistentMapImpl.this.apply(ptx, key, value)) {
                        retValue = Boolean.TRUE;
                    }
                }
                finally {
                    PersistentMapImpl.this.commitSetValueNeedThread(ptx, cr, retValue);
                }
            }
        });
    }

    @Override
    public final boolean put(Object key, Object value, PersistentStoreTransaction ptx) throws PersistentStoreException {
        PersistentMapTransactionImpl tx = PersistentMapTransactionImpl.check(ptx);
        tx.lock(this.lockManager, key);
        return tx.put(key, value) != null;
    }

    @Override
    public final void put(final Object key, final Object value, PersistentStoreTransaction ptx, final CompletionRequest cr) {
        PersistentMapTransactionImpl tx;
        try {
            tx = PersistentMapTransactionImpl.check(ptx);
        }
        catch (PersistentStoreException pse) {
            cr.setResult(pse);
            return;
        }
        tx.lock(this.lockManager, key, new LockManager.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLock() {
                boolean replace;
                Object old = tx.put(key, value);
                boolean bl = replace = old != null;
                if (!replace) {
                    Map map = PersistentMapImpl.this.keyMap;
                    synchronized (map) {
                        replace = PersistentMapImpl.this.keyMap.containsKey(key);
                    }
                }
                cr.setResult(replace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) throws PersistentStoreException {
        CompletionRequest cr = new CompletionRequest();
        PersistentStoreTransaction ptx = this.store.begin();
        Map map = this.keyMap;
        synchronized (map) {
            Entry entry = (Entry)this.keyMap.get(key);
            if (entry == null) {
                return null;
            }
            this.valueConn.read(ptx, entry.valueHandle, cr);
        }
        try {
            return ((PersistentStoreRecord)cr.getResult()).getData();
        }
        catch (PersistentStoreException pse) {
            try {
                Object object = this.getForUpdate(key, ptx);
                return object;
            }
            finally {
                ptx.commit();
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thr) {
            throw new AssertionError((Object)thr);
        }
    }

    @Override
    public void get(Object key, CompletionRequest userCompletionRequest) {
        PersistentStoreTransaction ptx = this.store.begin();
        this.getInternal(key, ptx, userCompletionRequest, false);
    }

    private static void setResultInSameThread(CompletionRequest userCompletionRequest, Object value) {
        boolean oldValue = userCompletionRequest.runListenersInSetResult(true);
        try {
            userCompletionRequest.setResult(value);
        }
        finally {
            if (!oldValue) {
                userCompletionRequest.runListenersInSetResult(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInternal(Object key, PersistentStoreTransaction ptx, CompletionRequest userCompletionRequest, boolean withKeyLock) {
        Map map = this.keyMap;
        synchronized (map) {
            try {
                Entry entry = (Entry)this.keyMap.get(key);
                if (entry == null || entry.valueHandle == null) {
                    userCompletionRequest.setResult(null);
                } else if (withKeyLock) {
                    this.valueConn.read(ptx, entry.valueHandle, new ReadCompletionWithKeyLock(userCompletionRequest));
                } else {
                    this.valueConn.read(ptx, entry.valueHandle, new ReadCompletionWithoutKeyLock(key, ptx, userCompletionRequest));
                }
            }
            catch (RuntimeException rte) {
                PersistentMapImpl.setResultInSameThread(userCompletionRequest, rte);
                throw rte;
            }
            catch (Error error) {
                PersistentMapImpl.setResultInSameThread(userCompletionRequest, error);
                throw error;
            }
        }
    }

    @Override
    public final Object get(Object key, PersistentStoreTransaction ptx) throws PersistentStoreException {
        PersistentMapTransactionImpl tx = PersistentMapTransactionImpl.check(ptx);
        Object val = tx.get(key);
        if (val != null) {
            return val;
        }
        CompletionRequest cr = new CompletionRequest();
        this.getInternal(key, ptx, cr, false);
        return PersistentMapImpl.waitForCompletion(cr);
    }

    @Override
    public final void get(Object key, PersistentStoreTransaction ptx, CompletionRequest cr) {
        PersistentMapTransactionImpl tx;
        try {
            tx = PersistentMapTransactionImpl.check(ptx);
            Object val = tx.get(key);
            if (val != null) {
                cr.setResult(val);
                return;
            }
        }
        catch (PersistentStoreException pse) {
            cr.setResult(pse);
            return;
        }
        this.getInternal(key, tx, cr, false);
    }

    @Override
    public final Object getForUpdate(Object key, PersistentStoreTransaction tx) throws PersistentStoreException {
        CompletionRequest cr = new CompletionRequest();
        PersistentTransactionImpl ptx = PersistentMapImpl.checkPersistentTransactionImpl(tx);
        ptx.lock(this.lockManager, key);
        this.getInternal(key, ptx, cr, true);
        return PersistentMapImpl.waitForCompletion(cr);
    }

    @Override
    public final void getForUpdate(final Object key, PersistentStoreTransaction tx, final CompletionRequest cr) {
        PersistentMapTransactionImpl ptx;
        try {
            ptx = PersistentMapTransactionImpl.check(tx);
        }
        catch (PersistentStoreException pse) {
            cr.setResult(pse);
            return;
        }
        catch (RuntimeException rte) {
            cr.setResult(rte);
            throw rte;
        }
        catch (Error error) {
            cr.setResult(error);
            throw error;
        }
        catch (Throwable thr) {
            cr.setResult(thr);
            throw new AssertionError((Object)thr);
        }
        ptx.lock(this.lockManager, key, new LockManager.Listener(){

            @Override
            public void onLock() {
                PersistentMapImpl.this.getInternal(key, ptx, cr, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) throws PersistentStoreException {
        PersistentStoreTransactionImpl ptx = new PersistentStoreTransactionImpl(this.store);
        ptx.lock(this.lockManager, key);
        boolean success = false;
        try {
            boolean ret = this.apply(ptx, key, REMOVE_OBJECT);
            success = true;
            boolean bl = ret;
            return bl;
        }
        finally {
            if (success) {
                ptx.commit();
            } else {
                ptx.rollback();
            }
        }
    }

    @Override
    public void remove(final Object key, final CompletionRequest userCompReq) {
        final PersistentStoreTransactionImpl ptx = new PersistentStoreTransactionImpl(this.store);
        ptx.lock(this.lockManager, key, new LockManager.Listener(){

            @Override
            public void onLock() {
                Boolean retValue = PersistentMapImpl.this.apply(ptx, key, REMOVE_OBJECT);
                PersistentMapImpl.this.commitSetValueNeedThread(ptx, userCompReq, retValue);
            }
        });
    }

    @Override
    public final boolean remove(Object key, PersistentStoreTransaction ptx) throws PersistentStoreException {
        PersistentMapTransactionImpl tx = PersistentMapTransactionImpl.check(ptx);
        tx.lock(this.lockManager, key);
        return tx.put(key, REMOVE_OBJECT) != null;
    }

    @Override
    public final void remove(final Object key, PersistentStoreTransaction ptx, final CompletionRequest cr) {
        PersistentMapTransactionImpl tx;
        try {
            tx = PersistentMapTransactionImpl.check(ptx);
        }
        catch (PersistentStoreException pse) {
            cr.setResult(pse);
            return;
        }
        tx.lock(this.lockManager, key, new LockManager.Listener(){

            @Override
            public void onLock() {
                if (tx.put(key, REMOVE_OBJECT) != null) {
                    cr.setResult(Boolean.TRUE);
                } else {
                    cr.setResult(Boolean.FALSE);
                }
            }
        });
    }

    @Override
    public void remove(Object key, Object value, CompletionRequest userCompletionRequest) {
        if (value == null) {
            this.remove(key, userCompletionRequest);
            return;
        }
        PersistentMapTransactionImpl ptx = new PersistentMapTransactionImpl(this);
        ptx.lock(this.lockManager, key, new RemoveMatchCompletion(key, value, ptx, userCompletionRequest));
    }

    @Override
    public final PersistentStoreTransaction begin() {
        return new PersistentMapTransactionImpl(this);
    }

    public final void commit(final PersistentMapTransactionImpl tx, final CompletionRequest userCompletionRequest) {
        PersistentStoreTransaction ptx = this.store.begin();
        for (Map.Entry entry : tx.entrySet()) {
            this.apply(ptx, entry.getKey(), entry.getValue());
        }
        ptx.commit(new CompReqListener(){

            @Override
            public void onCompletion(CompletionRequest completionRequest, Object result) {
                tx.unlockAll();
                PersistentMapImpl.setResultInSameThread(userCompletionRequest, result);
            }

            @Override
            public void onException(CompletionRequest completionRequest, Throwable reason) {
                tx.unlockAll();
                PersistentMapImpl.setResultInSameThread(userCompletionRequest, reason);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apply(PersistentStoreTransaction ptx, Object key, Object val) {
        Map map = this.keyMap;
        synchronized (map) {
            Entry entry;
            Entry entry2 = entry = val == REMOVE_OBJECT ? (Entry)this.keyMap.remove(key) : (Entry)this.keyMap.get(key);
            if (entry == null) {
                if (val != REMOVE_OBJECT) {
                    PersistentHandle valueHandle = this.valueConn.create(ptx, val, 0);
                    Entry newEntry = new Entry(key, valueHandle);
                    PersistentHandle handle = this.keyConn.create(ptx, newEntry, 0);
                    newEntry.handle = handle;
                    this.keyMap.put(key, newEntry);
                }
            } else if (val == REMOVE_OBJECT) {
                this.keyConn.delete(ptx, entry.handle, 0);
                this.valueConn.delete(ptx, entry.valueHandle, 0);
            } else {
                this.valueConn.update(ptx, entry.valueHandle, val, 0);
            }
            return entry != null;
        }
    }

    public final void rollback(PersistentMapTransactionImpl tx, CompletionRequest cr) {
        tx.unlockAll();
    }

    @Override
    public void putIfAbsent(Object key, Object val, CompletionRequest cr) {
        PersistentStoreTransactionImpl tx = new PersistentStoreTransactionImpl(this.store);
        tx.lock(this.lockManager, key, this.putIfAbsentLockListener(key, val, true, tx, cr));
    }

    private static PersistentTransactionImpl checkPersistentTransactionImpl(PersistentStoreTransaction ptx) throws PersistentStoreException {
        if (ptx instanceof PersistentTransactionImpl) {
            return (PersistentTransactionImpl)ptx;
        }
        throw new PersistentStoreException("Transaction invalid");
    }

    @Override
    public void putIfAbsent(Object key, Object val, PersistentStoreTransaction ptx, CompletionRequest cr) {
        PersistentTransactionImpl tx;
        try {
            tx = PersistentMapImpl.checkPersistentTransactionImpl(ptx);
        }
        catch (PersistentStoreException pse) {
            cr.setResult(pse);
            return;
        }
        tx.lock(this.lockManager, key, this.putIfAbsentLockListener(key, val, false, tx, cr));
    }

    private LockManager.Listener putIfAbsentLockListener(final Object key, final Object val, final boolean commitInternalPtx, final PersistentTransactionImpl ptx, final CompletionRequest cr) {
        return new LockManager.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLock() {
                Entry entry;
                Map map = PersistentMapImpl.this.keyMap;
                synchronized (map) {
                    entry = (Entry)PersistentMapImpl.this.keyMap.get(key);
                }
                if (entry != null) {
                    CompReqListener readListener = new CompReqListener(){

                        @Override
                        public void onException(CompletionRequest completionRequest, Throwable reason) {
                            try {
                                if (commitInternalPtx) {
                                    ptx.unlockAll();
                                }
                            }
                            finally {
                                PersistentMapImpl.setResultInSameThread(cr, PersistentMapImpl.convertThrowable(reason));
                            }
                        }

                        @Override
                        public void onCompletion(CompletionRequest completionRequest, Object result) {
                            try {
                                if (commitInternalPtx) {
                                    ptx.unlockAll();
                                }
                                result = ((PersistentStoreRecord)result).getData();
                            }
                            catch (PersistentStoreException pse) {
                                result = pse;
                            }
                            PersistentMapImpl.setResultInSameThread(cr, result);
                        }
                    };
                    PersistentMapImpl.this.valueConn.read(null, entry.valueHandle, readListener);
                    return;
                }
                if (ptx instanceof PersistentStoreTransactionImpl) {
                    PersistentMapImpl.this.apply(ptx, key, val);
                } else if (ptx instanceof PersistentMapTransactionImpl) {
                    ((PersistentMapTransactionImpl)ptx).put(key, val);
                }
                if (commitInternalPtx) {
                    PersistentMapImpl.this.commitSetValueNeedThread(ptx, cr, val);
                } else {
                    cr.setResult(val);
                }
            }
        };
    }

    private static Throwable convertThrowable(Throwable reason) {
        if (reason instanceof PersistentStoreException) {
            return reason;
        }
        if (reason instanceof Error) {
            return reason;
        }
        if (reason instanceof RuntimeException) {
            return reason;
        }
        return new PersistentStoreException(reason);
    }

    @Override
    public final int size() {
        return this.keyMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.keyMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws PersistentStoreException {
        Map map = this.keyMap;
        synchronized (map) {
            try {
                this.keyConn.delete();
            }
            finally {
                this.valueConn.delete();
            }
            this.keyMap.clear();
        }
    }

    @Override
    public Set keySet() {
        return Collections.unmodifiableSet(this.keyMap.keySet());
    }

    private static final Object waitForCompletion(CompletionRequest cr) throws PersistentStoreException {
        try {
            return cr.getResult();
        }
        catch (PersistentStoreException pse) {
            throw pse;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thr) {
            throw new AssertionError((Object)thr);
        }
    }

    private void commitSetValueNeedThread(PersistentStoreTransaction ptx, CompletionRequest completionRequest, Object retVal) {
        ptx.commit(new SetResultCompReqListener(completionRequest, retVal, true, false));
    }

    private void commitSetValueHaveThread(PersistentStoreTransaction ptx, CompletionRequest completionRequest, Object retVal, boolean replaceRetValWithException) {
        ptx.commit(new SetResultCompReqListener(completionRequest, retVal, replaceRetValWithException, true));
    }

    private boolean isSet(String sysProp) {
        try {
            String val = System.getProperty(sysProp);
            if (val == null) {
                val = (String)this.store.getConfigValue(sysProp);
            }
            return val != null && val.equalsIgnoreCase("true");
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        InitialContext ctx = new InitialContext();
        FileStoreIO ios = new FileStoreIO("MyStoreName", "storedir");
        PersistentStoreImpl store = new PersistentStoreImpl("MyStoreName", ios);
        HashMap<String, StoreWritePolicy> config = new HashMap<String, StoreWritePolicy>();
        config.put("SynchronousWritePolicy", StoreWritePolicy.DIRECT_WRITE);
        store.open(config);
        ctx.bind("persistentmap", (Object)store.createPersistentMap("persistentMap"));
        System.err.println("\n\n*** Bound PersistentMapTX ***\n\n");
    }

    private static final class SetResultCompReqListener
    extends CompletionRequest
    implements CompletionListener {
        CompletionRequest userCompReq;
        Object userResult;
        boolean replaceRetValWithException;
        boolean haveThread;

        SetResultCompReqListener(CompletionRequest userCR, Object userRes, boolean replaceValWithException, boolean hasThread) {
            this.addListener(this);
            this.userCompReq = userCR;
            this.userResult = userRes;
            this.replaceRetValWithException = replaceValWithException;
            this.haveThread = hasThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(CompletionRequest completionRequest, Object result) {
            boolean oldValue = this.haveThread ? this.userCompReq.runListenersInSetResult(true) : true;
            try {
                this.userCompReq.setResult(this.userResult);
            }
            finally {
                if (this.haveThread && !oldValue) {
                    this.userCompReq.runListenersInSetResult(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(CompletionRequest completionRequest, Throwable reason) {
            boolean oldValue = this.haveThread ? this.userCompReq.runListenersInSetResult(true) : true;
            try {
                if (this.replaceRetValWithException) {
                    this.userCompReq.setResult(reason);
                } else {
                    this.userCompReq.setResult(this.userResult);
                }
            }
            finally {
                if (this.haveThread && !oldValue) {
                    this.userCompReq.runListenersInSetResult(false);
                }
            }
        }
    }

    private final class PersistentMapObjectHandler
    implements ObjectHandler {
        private static final int MAGIC = 1111834912;
        private final ObjectHandler delegate;

        PersistentMapObjectHandler() {
            this.delegate = DefaultObjectHandler.THE_ONE;
        }

        PersistentMapObjectHandler(ObjectHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj) throws IOException {
            if (!(obj instanceof Entry)) {
                throw new IOException("Cannot serialize: " + obj.getClass());
            }
            Entry entry = (Entry)obj;
            out.writeInt(1111834912);
            this.delegate.writeObject(out, entry.key);
            PersistentHandle h = entry.valueHandle;
            PersistentHandle.write(out, h);
        }

        @Override
        public Object readObject(ObjectInput in) throws ClassNotFoundException, IOException {
            int magic = in.readInt();
            if (1111834912 != magic) {
                throw new ClassNotFoundException("PersistentMap attempting to deserialize unknown object");
            }
            Object key = this.delegate.readObject(in);
            PersistentHandle valueHandle = PersistentHandle.read(in);
            return new Entry(key, valueHandle);
        }
    }

    private static final class Entry {
        private final Object key;
        private PersistentHandle handle;
        private final PersistentHandle valueHandle;

        public Entry(Object key, PersistentHandle valueHandle) {
            this.key = key;
            this.valueHandle = valueHandle;
        }
    }

    private final class RemoveMatchCompletion
    extends CompReqListener
    implements LockManager.Listener {
        final Object key;
        final Object value;
        final PersistentMapTransactionImpl ptx;
        final CompletionRequest userCompletionRequest;

        RemoveMatchCompletion(Object key, Object value, PersistentMapTransactionImpl ptx, CompletionRequest userCompletionRequest) {
            this.key = key;
            this.value = value;
            this.ptx = ptx;
            this.userCompletionRequest = userCompletionRequest;
        }

        @Override
        public void onLock() {
            PersistentMapImpl.this.getForUpdate(this.key, this.ptx, this);
        }

        @Override
        public void onException(CompletionRequest completionRequest, Throwable reportReason) {
            PersistentMapImpl.this.commitSetValueHaveThread(this.ptx, this.userCompletionRequest, reportReason, false);
        }

        @Override
        public void onCompletion(CompletionRequest completionRequest, Object result) {
            if (result == null || !this.value.equals(result)) {
                PersistentMapImpl.this.commitSetValueHaveThread(this.ptx, this.userCompletionRequest, Boolean.FALSE, true);
                return;
            }
            this.ptx.put(this.key, REMOVE_OBJECT);
            PersistentMapImpl.this.commitSetValueHaveThread(this.ptx, this.userCompletionRequest, Boolean.TRUE, true);
        }
    }

    private final class ReadCompletionWithoutKeyLock
    extends ReadCompletionWithKeyLock {
        private Object key;
        private PersistentStoreTransaction ptx;

        private ReadCompletionWithoutKeyLock(Object key, PersistentStoreTransaction ptx, CompletionRequest completionRequest) {
            super(completionRequest);
            this.key = key;
            this.ptx = ptx;
        }

        @Override
        public void onException(CompletionRequest request, Throwable reason) {
            try {
                PersistentTransactionImpl ptxi = PersistentMapImpl.checkPersistentTransactionImpl(this.ptx);
                ptxi.lock(PersistentMapImpl.this.lockManager, this.key);
                PersistentMapImpl.this.getInternal(this.key, ptxi, this.userCompletionRequest, true);
            }
            catch (PersistentStoreException e) {
                PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, reason);
            }
        }
    }

    private class ReadCompletionWithKeyLock
    extends CompReqListener {
        protected CompletionRequest userCompletionRequest;

        private ReadCompletionWithKeyLock(CompletionRequest completionRequest) {
            this.userCompletionRequest = completionRequest;
        }

        @Override
        public void onCompletion(CompletionRequest request, Object result) {
            try {
                PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, ((PersistentStoreRecord)result).getData());
            }
            catch (PersistentStoreException pse) {
                PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, pse);
            }
            catch (RuntimeException rte) {
                PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, rte);
                throw rte;
            }
            catch (Error error) {
                PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, error);
                throw error;
            }
            catch (Throwable thr) {
                AssertionError ae = new AssertionError((Object)thr);
                PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, ae);
                throw ae;
            }
        }

        @Override
        public void onException(CompletionRequest request, Throwable reason) {
            PersistentMapImpl.setResultInSameThread(this.userCompletionRequest, reason);
        }
    }

    private static abstract class CompReqListener
    extends CompletionRequest
    implements CompletionListener {
        CompReqListener() {
            this.addListener(this);
        }
    }
}

