/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import weblogic.store.internal.StoreRequest;
import weblogic.store.internal.TransactionUnit;

class FlushUnit {
    private final List<StoreRequest> requests = new LinkedList<StoreRequest>();
    private boolean containsTopicLoad = false;

    FlushUnit() {
    }

    boolean hasTopicLoad() {
        return this.containsTopicLoad;
    }

    void markTopicLoad() {
        this.containsTopicLoad = true;
    }

    void addTransactionUnit(TransactionUnit tu) {
        if (tu.getOneRequest() != null) {
            this.requests.add(tu.getOneRequestForAdding());
        } else {
            this.requests.addAll(tu.getRequestsForAdding());
        }
    }

    int size() {
        return this.requests.size();
    }

    List<StoreRequest> getRequests() {
        return this.requests;
    }

    void sortRequests() {
        Collections.sort(this.requests, new Comparator<StoreRequest>(){

            @Override
            public int compare(StoreRequest o1, StoreRequest o2) {
                long groupDifference = o1.getFlushGroup() - o2.getFlushGroup();
                if (groupDifference == 0L) {
                    return Long.signum(o1.getLiveSequence() - o2.getLiveSequence());
                }
                return Long.signum(groupDifference);
            }
        });
    }
}

