/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.helper;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.store.ObjectHandler;

public abstract class StoreObjectHandler
implements ObjectHandler {
    private static final short CODE_NULL = -1;
    protected short CODE_SERIALIZABLE = (short)-2;
    private static final short CODE_NOTFOUND = -3;
    protected boolean ALLOW_SERIALIZABLES = false;
    static final short CODE_STRING = 18;

    public abstract Short getIdForClass(Object var1);

    public abstract Class getClassForId(short var1);

    public abstract void checkIfClassRecognized(short var1) throws IOException;

    protected Externalizable newExternal(short s) throws IOException {
        throw new IOException("subclass not defined " + s);
    }

    protected abstract boolean haveExternal(short var1);

    @Override
    public final void writeObject(ObjectOutput out, Object obj) throws IOException {
        if (obj == null) {
            out.writeShort(-1);
            return;
        }
        Short s = this.getIdForClass(obj);
        if (s == null) {
            if (this.ALLOW_SERIALIZABLES && obj instanceof Serializable) {
                throw new IOException("Can't serialize class, type=" + obj.getClass().getName());
            }
            out.writeShort(this.CODE_SERIALIZABLE);
            out.writeObject((Serializable)obj);
            return;
        }
        short v = s;
        out.writeShort(v);
        if (v == 18) {
            StoreObjectHandler.writeUTF32((String)obj, out);
        } else {
            ((Externalizable)obj).writeExternal(out);
        }
    }

    public final short getCode(Object obj) {
        if (obj == null) {
            return -1;
        }
        Short s = this.getIdForClass(obj);
        if (s == null) {
            return -3;
        }
        return s;
    }

    @Override
    public final Object readObject(ObjectInput in) throws ClassNotFoundException, IOException {
        Externalizable ext;
        short typeNum = in.readShort();
        if (typeNum == -1) {
            return null;
        }
        if (typeNum == 18) {
            return StoreObjectHandler.readUTF32(in);
        }
        if (typeNum == this.CODE_SERIALIZABLE) {
            return in.readObject();
        }
        if (this.haveExternal(typeNum)) {
            ext = this.newExternal(typeNum);
        } else {
            this.checkIfClassRecognized(typeNum);
            Class c = this.getClassForId(typeNum);
            try {
                ext = (Externalizable)c.newInstance();
            }
            catch (InstantiationException ie) {
                throw new ClassNotFoundException(ie.toString() + ", " + c.getName());
            }
            catch (IllegalAccessException iae) {
                throw new ClassNotFoundException(iae.toString() + ", " + c.getName());
            }
            catch (SecurityException se) {
                throw new ClassNotFoundException(se.toString() + ", " + c.getName());
            }
        }
        ext.readExternal(in);
        return ext;
    }

    private static final void writeUTF32(String str, ObjectOutput out) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        long utflen = 0L;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3L;
                continue;
            }
            utflen += 2L;
        }
        if (utflen > Integer.MAX_VALUE) {
            throw new IOException("String to large to encode, encodes to " + utflen + " bytes but maximum is " + Integer.MAX_VALUE);
        }
        out.writeInt((int)utflen);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
    }

    private static final String readUTF32(ObjectInput in) throws IOException {
        int utflen = in.readInt();
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = in.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new IOException("Error decoding String.");
                    }
                    int char2 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new IOException("Error decoding String.");
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new IOException("Error decoding String.");
                    }
                    int char2 = in.readUnsignedByte();
                    int char3 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new IOException("Error decoding String.");
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new IOException("Error decoding String.");
        }
        return new String(str, 0, strlen);
    }
}

