/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.common;

public class PartitionNameUtilsClient {
    public static final String COMBINED_NAME_DELIMITER = "!@";
    public static final String PERSISTENTSTORE_CONNECTION_NAME_DELIMITER = ".";
    public static final String WORKMANAGER_NAME_DELIMITER = "@";
    public static final String PARTITION_NAME_DELIMITER = "$";

    public static String stripDecoratedPartitionName(String name, String partitionName) {
        String temp = name;
        if (partitionName == null) {
            return temp;
        }
        if (temp.endsWith(PARTITION_NAME_DELIMITER + partitionName)) {
            return temp.substring(0, temp.lastIndexOf(PARTITION_NAME_DELIMITER + partitionName));
        }
        return temp;
    }

    public static String stripDecoratedPartitionNamesFromCombinedName(String tokens, String str, String partitionName) {
        StringBuffer result = new StringBuffer(128);
        StringBuffer buf = new StringBuffer(128);
        char[] chStr = str.toCharArray();
        char[] delimiters = tokens.toCharArray();
        for (char c : chStr) {
            boolean found = false;
            for (char d : delimiters) {
                if (c != d) continue;
                found = true;
                break;
            }
            if (!found) {
                buf.append(c);
                continue;
            }
            if (buf.length() > 0) {
                result.append(PartitionNameUtilsClient.stripDecoratedPartitionName(buf.toString(), partitionName));
                buf.delete(0, buf.length());
            }
            result.append(c);
        }
        if (buf.length() > 0) {
            result.append(PartitionNameUtilsClient.stripDecoratedPartitionName(buf.toString(), partitionName));
        }
        return result.toString();
    }
}

