/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import weblogic.kernel.KernelStatus;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.common.PartitionNameUtilsClient;

public class PartitionNameUtils
extends PartitionNameUtilsClient {
    private static final String DEFAULT_PARTITION_NAME = "DOMAIN";
    private static final String NO_PARTITION_NAME = null;
    private static final String CIC_INTERFACE_CLASS = "weblogic.invocation.ComponentInvocationContext";
    private static final String CIC_MANAGER_CLASS = "weblogic.invocation.ComponentInvocationContextManager";
    private static final Method getPartitionNameMethod;
    private static final Object CICManagerInstance;
    private static final Method getCurrentComponentInvocationContextMethod;

    public static String getPartitionName() {
        String partitionName = null;
        try {
            if (KernelStatus.isServer() && CICManagerInstance != null && getCurrentComponentInvocationContextMethod != null && getPartitionNameMethod != null) {
                Object currentCIC = getCurrentComponentInvocationContextMethod.invoke(CICManagerInstance, new Object[0]);
                partitionName = (String)getPartitionNameMethod.invoke(currentCIC, new Object[0]);
            } else {
                partitionName = NO_PARTITION_NAME;
            }
        }
        catch (IllegalAccessException e) {
            RuntimeException rte = new RuntimeException(e);
            throw rte;
        }
        catch (InvocationTargetException e) {
            RuntimeException rte = new RuntimeException(e);
            throw rte;
        }
        return partitionName;
    }

    public static boolean isInPartition() {
        String partitionName = PartitionNameUtils.getPartitionName();
        return partitionName != null && !partitionName.isEmpty() && !partitionName.equals(DEFAULT_PARTITION_NAME);
    }

    public static String stripDecoratedPartitionName(String name) {
        if (!PartitionNameUtils.isInPartition()) {
            return name;
        }
        return PartitionNameUtils.stripDecoratedPartitionName(name, PartitionNameUtils.getPartitionName());
    }

    public static String stripDecoratedPartitionNamesFromCombinedName(String tokens, String str) {
        if (!PartitionNameUtils.isInPartition()) {
            return str;
        }
        return PartitionNameUtils.stripDecoratedPartitionNamesFromCombinedName(tokens, str, PartitionNameUtils.getPartitionName());
    }

    static {
        Class<?> cicManagerClass = null;
        Class<?> tCicInterfaceClass = null;
        Method tGetPartitionNameMethod = null;
        Method tGetCurrentComponentInvocationContextMethod = null;
        Object tCICManagerInstance = null;
        if (KernelStatus.isServer()) {
            try {
                tCicInterfaceClass = Class.forName(CIC_INTERFACE_CLASS);
                cicManagerClass = Class.forName(CIC_MANAGER_CLASS);
                if (cicManagerClass != null && tCicInterfaceClass != null) {
                    AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    Method getManagerInstanceMethod = cicManagerClass.getMethod("getInstance", Principal.class);
                    tCICManagerInstance = getManagerInstanceMethod.invoke(cicManagerClass, KERNEL_ID);
                    tGetCurrentComponentInvocationContextMethod = cicManagerClass.getMethod("getCurrentComponentInvocationContext", new Class[0]);
                    tGetPartitionNameMethod = tCicInterfaceClass.getMethod("getPartitionName", new Class[0]);
                }
            }
            catch (Exception e) {
                tCicInterfaceClass = null;
                tCICManagerInstance = null;
                tGetPartitionNameMethod = null;
                tGetCurrentComponentInvocationContextMethod = null;
            }
        }
        CICManagerInstance = tCICManagerInstance;
        getPartitionNameMethod = tGetPartitionNameMethod;
        getCurrentComponentInvocationContextMethod = tGetCurrentComponentInvocationContextMethod;
    }
}

