/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RegexpPool {
    private static final String STAR = "*";
    private boolean matchAll = false;
    private volatile List<String> prefixes = null;
    private volatile List<String> suffixes = null;
    private volatile Map<String, String> strings = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String expr) {
        if (expr == null) {
            throw new NullPointerException("null expression string");
        }
        boolean alreadyExists = false;
        if (expr.equals(STAR)) {
            alreadyExists = this.matchAll;
            this.matchAll = true;
        } else if (expr.startsWith(STAR)) {
            String suffix = expr.substring(1);
            if (this.suffixes == null) {
                RegexpPool regexpPool = this;
                synchronized (regexpPool) {
                    if (this.suffixes == null) {
                        this.suffixes = new CopyOnWriteArrayList<String>();
                    }
                }
            } else {
                alreadyExists = this.suffixes.contains(suffix);
            }
            if (!alreadyExists) {
                this.suffixes.add(suffix);
            }
        } else if (expr.endsWith(STAR)) {
            String prefix = expr.substring(0, expr.length() - 1);
            if (this.prefixes == null) {
                RegexpPool regexpPool = this;
                synchronized (regexpPool) {
                    if (this.prefixes == null) {
                        this.prefixes = new CopyOnWriteArrayList<String>();
                    }
                }
            } else {
                alreadyExists = this.prefixes.contains(prefix);
            }
            if (!alreadyExists) {
                this.prefixes.add(prefix);
            }
        } else {
            if (this.strings == null) {
                RegexpPool regexpPool = this;
                synchronized (regexpPool) {
                    if (this.strings == null) {
                        this.strings = new ConcurrentHashMap<String, String>();
                    }
                }
            }
            alreadyExists = this.strings.put(expr, expr) != null;
        }
        return !alreadyExists;
    }

    public boolean remove(String expr) {
        if (expr == null) {
            throw new NullPointerException("null expression string");
        }
        if (expr.equals(STAR)) {
            boolean existed = this.matchAll;
            this.matchAll = false;
            return existed;
        }
        if (expr.startsWith(STAR)) {
            return this.suffixes != null && this.suffixes.remove(expr.substring(1));
        }
        if (expr.endsWith(STAR)) {
            return this.prefixes != null && this.prefixes.remove(expr.substring(0, expr.length() - 1));
        }
        return this.strings.remove(expr) != null;
    }

    public boolean match(String string) {
        if (this.matchAll) {
            return true;
        }
        if (this.strings != null && this.strings.containsKey(string)) {
            return true;
        }
        if (this.suffixes != null) {
            for (String suffix : this.suffixes) {
                if (!string.endsWith(suffix)) continue;
                return true;
            }
        }
        if (this.prefixes != null) {
            for (String prefix : this.prefixes) {
                if (!string.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }
}

