/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.StringTokenizer;
import weblogic.common.ProxyAuthenticator;
import weblogic.kernel.KernelStatus;
import weblogic.socket.SocketMuxer;
import weblogic.socket.utils.RegexpPool;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Encoder;

public final class ProxyUtils {
    private static final int MAX_TRIES = 3;
    private static String proxyHost = null;
    private static int proxyPort = -1;
    private static String SSLProxyHost = null;
    private static int SSLProxyPort = -1;
    private static String proxyAuthStr = null;
    private static String proxyAuthClassName;
    private static RegexpPool sslDontProxy;
    private static RegexpPool dontProxy;

    public static InetAddress getProxyHost() throws UnknownHostException {
        return InetAddress.getByName(proxyHost);
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static InetAddress getSSLProxyHost() throws UnknownHostException {
        return InetAddress.getByName(SSLProxyHost);
    }

    public static int getSSLProxyPort() {
        return SSLProxyPort;
    }

    public static String getProxyAuthStr() {
        return proxyAuthStr;
    }

    public static String getProxyAuthClassName() {
        return proxyAuthClassName;
    }

    public static RegexpPool getSSLDontProxy() {
        return sslDontProxy;
    }

    public static RegexpPool getDontProxy() {
        return dontProxy;
    }

    public static void resetSSLProperties() {
        try {
            String rawList;
            try {
                String pnum = System.getProperty("https.proxyPort");
                if (pnum == null) {
                    pnum = System.getProperty("ssl.proxyPort");
                }
                if (pnum == null) {
                    return;
                }
                SSLProxyPort = Integer.parseInt(pnum);
            }
            catch (NumberFormatException e) {
                return;
            }
            SSLProxyHost = System.getProperty("https.proxyHost");
            if (SSLProxyHost == null) {
                SSLProxyHost = System.getProperty("ssl.proxyHost");
            }
            if ((rawList = System.getProperty("https.nonProxyHosts")) != null) {
                sslDontProxy = new RegexpPool();
                StringTokenizer st = new StringTokenizer(rawList, "|", false);
                while (st.hasMoreTokens()) {
                    if (sslDontProxy.add(st.nextToken().toLowerCase(Locale.ENGLISH))) continue;
                }
            }
        }
        catch (SecurityException se) {
            SSLProxyPort = -1;
            SSLProxyHost = null;
        }
    }

    public static synchronized void resetProperties() {
        try {
            String rawList;
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = Integer.getInteger("http.proxyPort", 80);
            if (proxyHost == null) {
                proxyHost = System.getProperty("proxyHost");
                proxyPort = Integer.getInteger("proxyPort", 80);
            }
            if (proxyHost != null && proxyHost.length() == 0) {
                proxyHost = null;
            }
            if ((rawList = System.getProperty("http.nonProxyHosts")) == null) {
                rawList = System.getProperty("nonProxyHosts");
            }
            if (rawList != null) {
                dontProxy = new RegexpPool();
                StringTokenizer st = new StringTokenizer(rawList, "|", false);
                while (st.hasMoreTokens()) {
                    if (dontProxy.add(st.nextToken().toLowerCase())) continue;
                }
            }
        }
        catch (SecurityException e) {
            proxyHost = null;
            proxyPort = 80;
        }
    }

    public static Socket getProxySocket(Socket s, String host, int port, String proxyHost, int proxyPort) throws IOException {
        String firstLine;
        int maxTries = 0;
        while (true) {
            String line;
            s.setTcpNoDelay(true);
            String connStr = null;
            connStr = proxyAuthStr == null ? "CONNECT " + host + ':' + port + " HTTP/1.0\r\n\r\n" : "CONNECT " + host + ':' + port + " HTTP/1.0\r\n" + proxyAuthStr + "\r\n\r\n";
            OutputStream os = s.getOutputStream();
            os.write(connStr.getBytes());
            DataInputStream dis = new DataInputStream(s.getInputStream());
            firstLine = dis.readLine();
            if (firstLine == null) {
                s.close();
                throw new ProtocolException("Empty or no response from proxy");
            }
            String[] rsp = StringUtils.splitCompletely(firstLine);
            if (rsp.length < 2 || !rsp[0].equals("HTTP/1.0") && !rsp[0].equals("HTTP/1.1")) continue;
            if (rsp[1].equals("200")) {
                while ((firstLine = dis.readLine()) != null && firstLine.length() > 0) {
                }
                return s;
            }
            if (!rsp[1].equals("407")) break;
            if (maxTries > 3) {
                throw new ProtocolException("Server redirected too many times (" + maxTries + ")");
            }
            while ((line = dis.readLine()) != null && line.length() > 0) {
                String[] hdrs = StringUtils.split(line, ':');
                if (!hdrs[0].equalsIgnoreCase("Proxy-Authenticate")) continue;
                proxyAuthStr = ProxyUtils.getAuthInfo(proxyHost, proxyPort, hdrs[1]);
                if (proxyAuthStr == null) {
                    throw new ProtocolException("Proxy Authentication required (407)");
                }
                proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
            }
            ++maxTries;
        }
        s.close();
        throw new ProtocolException("unrecognized response from proxy: '" + firstLine + "'");
    }

    public static Socket getClientProxy(String host, int port, int timeout) throws IOException {
        Socket s = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(proxyHost), proxyPort, timeout);
        return ProxyUtils.getProxySocket(s, host, port, proxyHost, proxyPort);
    }

    public static Socket getClientProxy(String host, int port, InetAddress localHost, int localPort, int timeout) throws IOException {
        Socket s = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(proxyHost), proxyPort, localHost, localPort, timeout);
        return ProxyUtils.getProxySocket(s, host, port, proxyHost, proxyPort);
    }

    public static Socket getSSLClientProxy(String host, int port, int timeout) throws IOException {
        Socket s = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(SSLProxyHost), SSLProxyPort, timeout);
        return ProxyUtils.getProxySocket(s, host, port, SSLProxyHost, SSLProxyPort);
    }

    public static Socket getSSLClientProxy(String host, int port, String localHost, int localPort, int timeout) throws IOException {
        Socket s = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(SSLProxyHost), SSLProxyPort, InetAddress.getByName(localHost), localPort, timeout);
        return ProxyUtils.getProxySocket(s, host, port, SSLProxyHost, SSLProxyPort);
    }

    public static boolean canProxy(InetAddress host, boolean isSSL) {
        if (isSSL) {
            if (SSLProxyHost == null) {
                return false;
            }
            String hostname = host.getHostName().toLowerCase();
            if (SSLProxyHost.equals(hostname) || SSLProxyHost.equals(host.getHostAddress())) {
                return false;
            }
            if (sslDontProxy == null) {
                return true;
            }
            return !sslDontProxy.match(hostname);
        }
        if (proxyHost == null) {
            return false;
        }
        String hostname = host.getHostName().toLowerCase();
        if (proxyHost.equals(hostname) || proxyHost.equals(host.getHostAddress())) {
            return false;
        }
        if (dontProxy == null) {
            return true;
        }
        return !dontProxy.match(hostname);
    }

    public static String getAuthInfo(String host, int port, String header) throws IOException {
        if (proxyAuthClassName == null || header == null) {
            throw new ProtocolException("Proxy or Server Authentication Required");
        }
        ProxyAuthenticator pauth = null;
        String authType = null;
        String authPrompt = null;
        String authHeader = header.trim();
        int ind = authHeader.indexOf(32);
        if (ind == -1) {
            authType = authHeader;
            authPrompt = "Login to Proxy";
        } else {
            authType = authHeader.substring(0, ind);
            authPrompt = authHeader.substring(ind + 1);
            if ((ind = authPrompt.indexOf(61)) != -1) {
                authPrompt = authPrompt.substring(ind + 1);
            }
        }
        try {
            pauth = (ProxyAuthenticator)Class.forName(proxyAuthClassName).newInstance();
        }
        catch (Exception e) {
            throw new ProtocolException("Proxy authenticator " + proxyAuthClassName + " failed: " + e);
        }
        pauth.init(host, port, authType, authPrompt);
        String[] unp = pauth.getLoginAndPassword();
        if (unp == null || unp.length != 2) {
            throw new ProtocolException("Proxy authentication failed");
        }
        String unpstr = unp[0] + ':' + unp[1];
        byte[] buf = unpstr.getBytes();
        BASE64Encoder benc = new BASE64Encoder();
        String ret = "Basic " + benc.encodeBuffer(buf);
        return ret;
    }

    static {
        if (!KernelStatus.isApplet()) {
            ProxyUtils.resetSSLProperties();
            ProxyUtils.resetProperties();
            proxyAuthClassName = System.getProperty("weblogic.net.proxyAuthenticatorClassName");
        }
    }
}

