/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import weblogic.socket.utils.QueueDef;
import weblogic.socket.utils.QueueFullException;

public final class DynaQueue<E>
implements QueueDef<E> {
    private static final boolean DEBUG = false;
    private boolean verbose = false;
    private Object[] q;
    private int count = 0;
    private int getPos = 0;
    private int putPos = 0;
    private Object[] qput;
    private Object[] qlast;
    private int blockCount = 0;
    private int maxBlockCount = 0;
    private int blockSize = 256;
    private boolean cancelled = false;
    private String name = "(unknown)";
    private int departures = 0;

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public String toString() {
        return this.name;
    }

    public DynaQueue(String name, int blockSize) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Illegal block size: " + blockSize);
        }
        this.q = new Object[blockSize + 1];
        this.name = name;
        this.blockSize = blockSize;
        this.qlast = this.q;
        this.qput = this.q;
        this.q[blockSize] = this.q;
        this.blockCount = 1;
        this.resize(1);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int size() {
        return this.maxBlockCount == 0 ? Integer.MAX_VALUE : this.maxBlockCount * this.blockSize;
    }

    public int departures() {
        return this.departures;
    }

    @Override
    public synchronized void put(E o) throws QueueFullException {
        if (this.putPos == this.blockSize) {
            if (this.qput == this.qlast) {
                if (this.blockCount == this.maxBlockCount) {
                    throw new QueueFullException();
                }
                this.resize(1);
            }
            this.qput = (Object[])this.qput[this.blockSize];
            this.putPos = 0;
        }
        ++this.count;
        this.qput[this.putPos++] = o;
        this.notify();
    }

    private final boolean full() {
        return this.blockCount == this.maxBlockCount && this.putPos == this.blockSize;
    }

    @Override
    public synchronized void putW(E o) {
        while (this.full() && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.full()) {
            try {
                this.put(o);
            }
            catch (QueueFullException queueFullException) {
                // empty catch block
            }
            return;
        }
        if (this.cancelled) {
            if (!this.full()) {
                System.out.println(this + "******!!!!!!!!!! QUEUE2 " + this.cancelled + " count = " + this.count);
            }
            this.cancelled = false;
            return;
        }
        throw new AssertionError((Object)("Queue invariant failed count=" + this.count + "; cancel = " + this.cancelled));
    }

    @Override
    public synchronized void cancelWait() {
        this.cancelled = true;
        this.notifyAll();
    }

    @Override
    public void resetCancel() {
        this.cancelled = false;
    }

    @Override
    public synchronized boolean empty() {
        return this.count == 0;
    }

    @Override
    public E peek() {
        if (this.count <= 0) {
            return null;
        }
        return this.q(this.getPos);
    }

    @Override
    public synchronized E get() {
        E next = null;
        if (this.count <= 0) {
            return null;
        }
        --this.count;
        next = this.q(this.getPos);
        this.q[this.getPos] = null;
        if (++this.getPos == this.blockSize) {
            if (this.qput == this.q) {
                this.qput = (Object[])this.q[this.blockSize];
                this.putPos = 0;
            }
            if (this.count >= (this.blockCount - 2) * this.blockSize) {
                this.qlast = this.q;
                this.q = (Object[])this.q[this.blockSize];
            } else {
                --this.blockCount;
                Object[] qloser = this.q;
                this.q = (Object[])qloser[this.blockSize];
                qloser[this.blockSize] = null;
                this.qlast[this.blockSize] = this.q;
            }
            this.getPos = 0;
        }
        ++this.departures;
        return next;
    }

    @Override
    public synchronized E getW() {
        while (this.count <= 0 && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.count > 0) {
            return this.get();
        }
        if (this.cancelled) {
            if (this.count != 0) {
                System.out.println(this + "******!!!!!!!!!! QUEUE2 " + this.cancelled + " count = " + this.count);
            }
            this.cancelled = false;
            return null;
        }
        throw new AssertionError((Object)("Queue invarient failed count=" + this.count + "; cancel = " + this.cancelled));
    }

    @Override
    public synchronized E getW(int maxWaitMilliseconds) {
        long now;
        long start = System.currentTimeMillis();
        long toWait = maxWaitMilliseconds;
        while (this.count <= 0 && !this.cancelled && (toWait -= (now = System.currentTimeMillis()) - start) > 0L) {
            start = now;
            try {
                this.wait(toWait);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.count > 0) {
            return this.get();
        }
        if (this.cancelled) {
            if (this.count != 0) {
                System.out.println(this + "******!!!!!!!!!! QUEUE2 " + this.cancelled + " count = " + this.count);
            }
            this.cancelled = false;
        }
        return null;
    }

    public synchronized void resize(int delta) {
        this.blockCount += delta;
        while (delta > 0) {
            Object[] newBlock;
            this.qlast[this.blockSize] = newBlock = new Object[this.blockSize + 1];
            newBlock[this.blockSize] = this.q;
            this.qlast = newBlock;
            --delta;
        }
        while (delta < 0) {
            Object[] qnext = (Object[])this.qput[this.blockSize];
            this.qput[this.blockSize] = qnext[this.blockSize];
            qnext[this.blockSize] = null;
            ++delta;
        }
    }

    private E q(int index) {
        return (E)this.q[index];
    }
}

