/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.KernelMBean;
import weblogic.rjvm.HeartbeatMonitor;
import weblogic.socket.ClientSSLFilterImpl;
import weblogic.socket.MuxableSocket;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketMuxer;
import weblogic.socket.SocketReaderRequest;
import weblogic.socket.internal.SocketEnvironment;
import weblogic.socket.utils.DynaQueue;
import weblogic.socket.utils.QueueFullException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.concurrent.Latch;
import weblogic.work.WorkManagerFactory;

final class JavaSocketMuxer
extends ServerSocketMuxer {
    private static final boolean ASSERT = false;
    private static final int QUEUE_BLOCK_SIZE = 25;
    private static final int SOCKET_WAIT_TIMEOUT = 2000;
    private static final String CLIENT_SOCKET_READERS_QUEUE_NAME = "weblogic.JavaSocketReaders";
    private final Latch warningLock = new Latch();
    private final DynaQueue sockQueue = new DynaQueue("SockMuxQ", 25);
    private int numSocketReaders = 0;
    private int maxSocketReaders = -1;
    private int curSoTimeoutMillis = -1;
    private ExecuteThreadManager socketReaderQueue = null;
    private ExecuteThreadManager clientExecuteQueue;
    private int numClientSocketReaders = 0;
    private static final int MIN_CLIENT_EXECUTE_THREAD_COUNT = 0;
    private static final int MAX_CLIENT_EXECUTE_THREAD_COUNT = 15;
    private static final boolean jsse = SocketEnvironment.getSocketEnvironment().isJSSE();
    private static final int MAX_SLEEP_SUM = 1000;
    private static final int SLEEP_MULTIPLE = 100;
    private int prevNum = 0;
    private int curNum = 1;
    private KernelMBean config = Kernel.getConfig();

    protected JavaSocketMuxer() throws IOException {
        this.curSoTimeoutMillis = this.config.getSocketReaderTimeoutMaxMillis();
        this.init();
    }

    private void init() {
        ExecuteThreadManager queue = Kernel.getExecuteThreadManager("weblogic.socket.Muxer");
        if (queue != null && queue.getName().equalsIgnoreCase("weblogic.socket.Muxer")) {
            this.socketReaderQueue = queue;
            this.maxSocketReaders = queue.getExecuteThreadCount();
            SocketLogger.logAllocSocketReaders(this.maxSocketReaders);
            for (int i = 0; i < this.maxSocketReaders; ++i) {
                Kernel.execute((ExecuteRequest)new SocketReaderRequest(), "weblogic.socket.Muxer");
            }
        }
    }

    private int getMaxSocketReaders() {
        if (this.maxSocketReaders == -1) {
            int percent = this.config.getThreadPoolPercentSocketReaders();
            int rawNum = percent * this.config.getThreadPoolSize() / 100;
            this.maxSocketReaders = Math.max(2, rawNum);
        }
        return this.maxSocketReaders;
    }

    @Override
    public void read(MuxableSocket ms) {
        if (!this.initiateIO(ms.getSocketInfo())) {
            return;
        }
        this.internalRead(ms, false);
    }

    @Override
    public void read(Collection<MuxableSocket> muxableSockets) {
        for (MuxableSocket ms : muxableSockets) {
            this.read(ms);
        }
    }

    private void internalRead(MuxableSocket ms, Boolean previousReadTimeout) {
        try {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug("internalRead for: " + ms.getSocketInfo());
            }
            if (ms instanceof ClientSSLFilterImpl && jsse) {
                if (previousReadTimeout.booleanValue()) {
                    int sleepTime = this.calculateSleepTime() * 100;
                    try {
                        Thread.sleep(0L, sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.resetSleepTime();
                }
            }
            this.sockQueue.put(ms);
        }
        catch (QueueFullException qfe) {
            SocketLogger.logSocketQueueFull(qfe);
            this.closeSocket(ms);
        }
    }

    private int calculateSleepTime() {
        if (this.curNum >= 1000) {
            return 1000;
        }
        this.curNum += this.prevNum;
        this.prevNum = this.curNum - this.prevNum;
        if (this.curNum >= 1000) {
            return 1000;
        }
        return this.curNum;
    }

    private void resetSleepTime() {
        this.prevNum = 0;
        this.curNum = 1;
    }

    @Override
    protected void handleReadTimeout(MuxableSocket ms) {
        this.internalRead(ms, true);
    }

    @Override
    protected void readCompleted(MuxableSocket ms) {
        this.completeIO(ms, ms.getSocketInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Collection<MuxableSocket> muxableSockets) {
        for (MuxableSocket ms : muxableSockets) {
            ms.setSocketInfo(new SocketInfo(ms));
        }
        ConcurrentHashMap concurrentHashMap = this.sockets;
        synchronized (concurrentHashMap) {
            super.register(muxableSockets);
            if (this.socketReaderQueue != null) {
                return;
            }
            int numSockets = this.getNumSockets();
            while (numSockets > this.numSocketReaders + this.numClientSocketReaders) {
                if (this.numSocketReaders < this.getMaxSocketReaders()) {
                    WorkManagerFactory.getInstance().getSystem().schedule(new SocketReaderRequest());
                    ++this.numSocketReaders;
                    if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxer()) continue;
                    SocketLogger.logDebug("Starting socket reader: '" + this.numSocketReaders + "', sockets: '" + numSockets + "'");
                    continue;
                }
                if (!Kernel.isServer() && this.createClientThread()) {
                    Kernel.execute((ExecuteRequest)new SocketReaderRequest(), CLIENT_SOCKET_READERS_QUEUE_NAME);
                    continue;
                }
                if (!this.warningLock.tryLock()) break;
                SocketLogger.logSocketConfig(numSockets, this.getMaxSocketReaders());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MuxableSocket ms) throws IOException {
        ms.setSocketInfo(new SocketInfo(ms));
        ConcurrentHashMap concurrentHashMap = this.sockets;
        synchronized (concurrentHashMap) {
            super.register(ms);
            if (this.socketReaderQueue != null) {
                return;
            }
            int numSockets = this.getNumSockets();
            if (numSockets > this.numSocketReaders + this.numClientSocketReaders) {
                if (this.numSocketReaders < this.getMaxSocketReaders()) {
                    WorkManagerFactory.getInstance().getSystem().schedule(new SocketReaderRequest());
                    ++this.numSocketReaders;
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                        SocketLogger.logDebug("Starting socket reader: '" + this.numSocketReaders + "', sockets: '" + numSockets + "'");
                    }
                } else if (!Kernel.isServer() && this.createClientThread()) {
                    Kernel.execute((ExecuteRequest)new SocketReaderRequest(), CLIENT_SOCKET_READERS_QUEUE_NAME);
                } else if (this.warningLock.tryLock()) {
                    SocketLogger.logSocketConfig(numSockets, this.getMaxSocketReaders());
                }
            }
        }
    }

    private boolean createClientThread() {
        if (this.numClientSocketReaders == 15) {
            return false;
        }
        if (this.clientExecuteQueue == null) {
            this.createClientExecuteQueue();
        }
        if (++this.numClientSocketReaders > this.clientExecuteQueue.getExecuteThreadCount()) {
            this.clientExecuteQueue.setThreadCount(this.numClientSocketReaders);
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug("Created thread in extra client execute queue, total number of extra client threads: " + this.numClientSocketReaders);
            }
        }
        return true;
    }

    private void createClientExecuteQueue() {
        Kernel.addExecuteQueue(CLIENT_SOCKET_READERS_QUEUE_NAME, 0, 0, 15);
        this.clientExecuteQueue = Kernel.getExecuteThreadManager(CLIENT_SOCKET_READERS_QUEUE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBreakProcessSockets(boolean clientExecuteThread) {
        if (this.socketReaderQueue != null) {
            return false;
        }
        ConcurrentHashMap concurrentHashMap = this.sockets;
        synchronized (concurrentHashMap) {
            if (this.numSocketReaders + this.numClientSocketReaders > this.getNumSockets()) {
                if (clientExecuteThread) {
                    --this.numClientSocketReaders;
                } else {
                    --this.numSocketReaders;
                }
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebug("Decrementing socket reader: " + this.numSocketReaders + ", client socket reader: " + this.numClientSocketReaders + ", sockets: " + this.getNumSockets());
                }
                return true;
            }
        }
        return false;
    }

    private boolean isClientExecuteThread() {
        return !Kernel.isServer() && ((ExecuteThread)Thread.currentThread()).getExecuteThreadManager().getName().equalsIgnoreCase(CLIENT_SOCKET_READERS_QUEUE_NAME);
    }

    @Override
    protected void processSockets() {
        boolean clientExecuteThread = this.isClientExecuteThread();
        while (!this.shouldBreakProcessSockets(clientExecuteThread)) {
            MuxableSocket ms = null;
            SocketInfo info = null;
            try {
                ms = (MuxableSocket)this.sockQueue.get();
                while (ms == null) {
                    if (this.shouldBreakProcessSockets(clientExecuteThread)) {
                        return;
                    }
                    ms = (MuxableSocket)this.sockQueue.getW(2000);
                }
                info = ms.getSocketInfo();
                ms.setSoTimeout(this.getSoTimeout());
                this.readReadySocket(ms, info, this.getSoTimeout());
                continue;
            }
            catch (ThreadDeath td) {
                if (Kernel.isServer()) {
                    if (!Kernel.isIntentionalShutdown()) {
                        SocketLogger.logThreadDeath(td);
                    }
                    throw td;
                }
                if (ms == null || ms.getSocketInfo().isCloseOnly()) continue;
                this.internalRead(ms, false);
                continue;
            }
            catch (Throwable t) {
                this.deliverHasException(info.getMuxableSocket(), t);
                continue;
            }
            break;
        }
        return;
    }

    private int getSoTimeout() {
        return this.curSoTimeoutMillis;
    }

    private void updateSoTimeout() {
        int nsockets = this.getNumSockets();
        int nreaders = this.numSocketReaders;
        int minTimeoutMillis = this.config.getSocketReaderTimeoutMinMillis();
        int maxTimeoutMillis = this.config.getSocketReaderTimeoutMaxMillis();
        if (nreaders == 0 || nsockets == 0) {
            this.curSoTimeoutMillis = maxTimeoutMillis;
        } else {
            int period = HeartbeatMonitor.periodLengthMillis();
            this.curSoTimeoutMillis = period * nreaders / nsockets;
            this.curSoTimeoutMillis = Math.min(this.curSoTimeoutMillis, maxTimeoutMillis);
            this.curSoTimeoutMillis = Math.max(this.curSoTimeoutMillis, minTimeoutMillis);
        }
    }

    @Override
    protected TimerListener createTimeoutTrigger() {
        return new JavaTimerListenerImpl();
    }

    protected class JavaTimerListenerImpl
    extends SocketMuxer.TimerListenerImpl {
        protected JavaTimerListenerImpl() {
            super(JavaSocketMuxer.this);
        }

        @Override
        public void timerExpired(Timer timer) {
            super.timerExpired(timer);
            JavaSocketMuxer.this.updateSoTimeout();
        }
    }
}

