/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocket;
import weblogic.security.utils.SSLSetupLogging;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketMuxer;
import weblogic.utils.AssertionError;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;

public final class ClientSSLFilterImpl
implements SSLFilter {
    private static final boolean ASSERT = true;
    private static final boolean DEBUG = false;
    private boolean activated = false;
    private final InputStream in;
    private int pos;
    private int availBytes;
    private MuxableSocket delegate;
    private final SSLSocket sslSocket;
    private SocketInfo sockInfo;

    public ClientSSLFilterImpl(InputStream is, SSLSocket ssl) throws IOException {
        this.in = is;
        this.sslSocket = ssl;
        SSLSetupLogging.info("Filtering JSSE SSLSocket");
    }

    public String toString() {
        return "ClientSSLFilterImpl[" + this.getDelegate() + "]";
    }

    @Override
    public MuxableSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(MuxableSocket mx) {
        this.delegate = mx;
    }

    @Override
    public void asyncOn() {
        this.activated = true;
    }

    @Override
    public void asyncOff() {
        this.activated = false;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public int available() throws IOException {
        if (!this.activated) {
            return this.in.available();
        }
        return this.availBytes;
    }

    @Override
    public void activate() throws IOException {
        SSLSetupLogging.info("ClientSSLFilterImpl.activate()");
        this.activateNoRegister();
        if (this.delegate.isMessageComplete()) {
            SocketMuxer.getMuxer().register(this);
            this.delegate.dispatch();
        } else {
            SocketMuxer.getMuxer().register(this);
            SocketMuxer.getMuxer().read(this);
        }
    }

    @Override
    public void activateNoRegister() throws IOException {
        SSLSetupLogging.info("activateNoRegister()");
        this.activated = true;
        SSLSetupLogging.info("ClientSSLFilterImpl.activate(): activated: " + this.in.hashCode());
    }

    @Override
    public int getIdleTimeoutMillis() {
        return this.delegate.getIdleTimeoutMillis();
    }

    @Override
    public byte[] getBuffer() {
        return this.delegate.getBuffer();
    }

    @Override
    public int getBufferOffset() {
        return this.delegate.getBufferOffset();
    }

    private static void p(String s) {
        System.out.println("ClientSSLFilterImpl: " + s);
    }

    @Override
    public void incrementBufferOffset(int i) throws MaxMessageSizeExceededException {
        this.delegate.incrementBufferOffset(i);
    }

    @Override
    public boolean isMessageComplete() {
        return this.delegate.isMessageComplete();
    }

    @Override
    public void dispatch() {
        this.delegate.dispatch();
    }

    @Override
    public InputStream getSocketInputStream() {
        return this.in;
    }

    @Override
    public void setSoTimeout(int to) throws SocketException {
        this.delegate.setSoTimeout(to);
    }

    @Override
    public Socket getSocket() {
        return this.sslSocket;
    }

    @Override
    public boolean closeSocketOnError() {
        return true;
    }

    @Override
    public void hasException(Throwable t) {
        if (!(t instanceof SocketException)) {
            SSLSetupLogging.debug(3, t, "hasException");
        }
        this.delegate.hasException(t);
    }

    @Override
    public void endOfStream() {
        this.delegate.endOfStream();
    }

    @Override
    public boolean timeout() {
        return this.delegate.timeout();
    }

    @Override
    public boolean requestTimeout() {
        return this.delegate.requestTimeout();
    }

    @Override
    public int getCompleteMessageTimeoutMillis() {
        return this.delegate.getCompleteMessageTimeoutMillis();
    }

    @Override
    public void setSocketFilter(MuxableSocket remx) {
        throw new AssertionError("Re-register Muxer not allowed on ClientSSLFilterImpl");
    }

    @Override
    public MuxableSocket getSocketFilter() {
        return this;
    }

    @Override
    public void setSocketInfo(SocketInfo info) {
        this.sockInfo = info;
    }

    @Override
    public SocketInfo getSocketInfo() {
        return this.sockInfo;
    }

    @Override
    public void ensureForceClose() {
        try {
            this.sslSocket.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ChunkedInputStream getInputStream() {
        return null;
    }

    @Override
    public boolean supportsScatteredRead() {
        return false;
    }

    @Override
    public long read(NIOConnection connection) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementBufferOffset(Chunk c, int availBytes) throws MaxMessageSizeExceededException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.delegate.getByteBuffer();
    }
}

