/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ServerChannel;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketMuxer;
import weblogic.socket.WeblogicSocketFactory;

public final class ChannelSocketFactory
extends WeblogicSocketFactory {
    private ServerChannel channel;

    public ChannelSocketFactory(ServerChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel must not be null");
        }
        this.channel = channel;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port);
    }

    @Override
    public Socket createSocket(String address, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host, port, 0);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, int connectionTimeoutMillis) throws IOException {
        int timeout;
        int n = timeout = connectionTimeoutMillis > 0 ? connectionTimeoutMillis : this.channel.getConnectTimeout() * 1000;
        if (KernelStatus.isServer()) {
            block6: {
                if (this.channel.getProxyAddress() != null) {
                    return SocketMuxer.getMuxer().newProxySocket(host, port, this.getInetAddressFor(this.channel.getAddress()), 0, InetAddress.getByName(this.channel.getProxyAddress()), this.channel.getProxyPort(), timeout);
                }
                if (this.channel.isSDPEnabled()) {
                    return SocketMuxer.getMuxer().newSDPSocket(host, port, this.getInetAddressFor(this.channel.getAddress()), 0, timeout);
                }
                if (this.channel.isOutboundEnabled()) {
                    try {
                        return SocketMuxer.getMuxer().newSocket(host, port, this.getInetAddressFor(this.channel.getAddress()), 0, timeout);
                    }
                    catch (IOException ioe) {
                        if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxer()) break block6;
                        SocketLogger.logDebugThrowable("Unable to create new socket with local channel : '" + this.channel + "' due to IOException: ", ioe);
                    }
                }
            }
            return SocketMuxer.getMuxer().newSocket(host, port, timeout);
        }
        return SocketMuxer.getMuxer().newClientSocket(host, port, this.getInetAddressFor(this.channel.getAddress()), 0, timeout);
    }

    private InetAddress getInetAddressFor(String channelAddress) throws UnknownHostException {
        return channelAddress != null ? InetAddress.getByName(channelAddress) : null;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }
}

