/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;
import weblogic.server.GlobalServiceLocator;
import weblogic.socket.ChannelSocketFactory;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SocketAlreadyClosedException;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketMuxer;
import weblogic.socket.SocketRuntimeFactory;
import weblogic.socket.WeblogicSocketFactory;
import weblogic.utils.Debug;
import weblogic.utils.PropertyHelper;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.concurrent.Latch;
import weblogic.utils.io.Chunk;

public abstract class BaseAbstractMuxableSocket
implements MuxableSocket,
SocketRuntime,
ContextHandler,
Serializable {
    private static final long serialVersionUID = 7960171920400419300L;
    private static AtomicBoolean exceededDumpDone = new AtomicBoolean(false);
    private static final String DUMP_EXCEEDED_MESSAGE_FILE = PropertyHelper.getProperty("weblogic.socket.DumpExceedMessageFileName", "ExceededMessageBuffer.out");
    private static final boolean DUMP_EXCEEDED_MESSAGE = PropertyHelper.getBoolean("weblogic.socket.DumpExceedMessageToFile", false);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 0;
    private static final boolean DEBUG = false;
    protected final ServerChannel channel;
    protected Socket socket;
    protected int soTimeout;
    protected InputStream sis;
    protected OutputStream sos;
    protected SocketInfo info;
    protected MuxableSocket filter = null;
    protected SocketFactory socketFactory;
    protected final Latch closeLatch = new Latch();
    protected final int maxMessageSize;
    protected Chunk head;
    protected Chunk tail;
    protected int availBytes = 0;
    protected int msgLength = -1;
    private final long connectTime = System.currentTimeMillis();
    private long messagesReceived = 0L;
    private long bytesReceived = 0L;
    private transient boolean sawEndOfStream = false;
    private transient boolean timedOut = false;
    private transient Throwable hadException = null;
    private transient Throwable whoClosedMe = null;
    private static boolean gatherWhoClosedMe = false;
    private transient boolean isCleanup;
    private static final String[] KEYS = new String[]{"com.bea.contextelement.channel.Port", "com.bea.contextelement.channel.PublicPort", "com.bea.contextelement.channel.RemotePort", "com.bea.contextelement.channel.Protocol", "com.bea.contextelement.channel.Address", "com.bea.contextelement.channel.PublicAddress", "com.bea.contextelement.channel.RemoteAddress", "com.bea.contextelement.channel.ChannelName", "com.bea.contextelement.channel.Secure"};

    protected BaseAbstractMuxableSocket(Chunk headChunk, ServerChannel networkChannel) {
        this.channel = networkChannel;
        Debug.assertion(this.channel != null);
        this.socketFactory = new ChannelSocketFactory(this.channel);
        this.maxMessageSize = networkChannel.getMaxMessageSize();
        this.setSocketFilter(this);
        this.tail = this.head = headChunk;
    }

    protected BaseAbstractMuxableSocket(ServerChannel networkChannel) {
        this(Chunk.getChunk(), networkChannel);
    }

    public final void connect(Socket s) throws IOException {
        this.socket = s;
        this.sis = s.getInputStream();
        this.sos = s.getOutputStream();
    }

    public void connect(InetAddress address, int port) throws IOException {
        this.connect(this.createSocket(address, port));
    }

    public void connect(InetAddress address, int port, int connectionTimeoutMillis) throws IOException {
        this.connect(this.createSocket(address, port, connectionTimeoutMillis));
    }

    protected Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host, port, 0);
    }

    protected Socket createSocket(InetAddress host, int port, int connectionTimeout) throws IOException {
        try {
            WeblogicSocketFactory wlsSF = (WeblogicSocketFactory)this.socketFactory;
            return wlsSF.createSocket(host, port, connectionTimeout);
        }
        catch (ClassCastException cce) {
            return this.socketFactory.createSocket(host, port);
        }
    }

    protected static void p(String msg) {
        System.out.println("<BaseAbstractMuxableSocket>: " + msg);
    }

    protected void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public final Chunk getChunk() {
        return this.head;
    }

    @Override
    public byte[] getBuffer() {
        this.findAndSetTail();
        this.tail = Chunk.ensureCapacity(this.tail);
        return this.tail.buf;
    }

    @Override
    public int getBufferOffset() {
        this.findAndSetTail();
        return this.tail.end;
    }

    @Override
    public void incrementBufferOffset(int bytesRead) throws MaxMessageSizeExceededException {
        this.incrementBufferOffset(null, bytesRead);
    }

    @Override
    public void incrementBufferOffset(Chunk c, int bytesRead) throws MaxMessageSizeExceededException {
        this.findAndSetTail();
        this.availBytes += bytesRead;
        if (this.availBytes > this.maxMessageSize) {
            if (DUMP_EXCEEDED_MESSAGE && !exceededDumpDone.getAndSet(true)) {
                try (FileOutputStream fw = new FileOutputStream(DUMP_EXCEEDED_MESSAGE_FILE);){
                    Chunk current = this.head;
                    while (current != null) {
                        byte[] buf = current.buf;
                        current = current.next;
                        if (buf == null) continue;
                        fw.write(buf);
                        fw.flush();
                    }
                }
                catch (IOException ignore) {
                    ignore.printStackTrace();
                }
            }
            throw new MaxMessageSizeExceededException(this.availBytes, this.maxMessageSize, this.channel.getConfiguredProtocol());
        }
        if (c != null) {
            this.tail.end = Chunk.CHUNK_SIZE;
            this.tail.next = c;
        } else {
            this.tail.end += bytesRead;
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.findAndSetTail();
        this.tail = Chunk.ensureCapacity(this.tail);
        return this.tail.getReadByteBuffer();
    }

    private void findAndSetTail() {
        if (this.tail == null) {
            this.tail = this.head;
        }
        this.tail = Chunk.tail(this.tail);
    }

    protected Chunk makeChunkList() {
        Chunk oldhead = this.head;
        if (this.availBytes == this.msgLength) {
            this.head = this.tail = Chunk.getChunk();
        } else {
            this.head = Chunk.split(this.head, this.msgLength);
            this.tail = null;
        }
        ++this.messagesReceived;
        this.bytesReceived += (long)this.msgLength;
        this.availBytes -= this.msgLength;
        this.msgLength = -1;
        return oldhead;
    }

    public long getMessagesReceivedCount() {
        return this.messagesReceived;
    }

    public long getBytesReceivedCount() {
        return this.bytesReceived;
    }

    public final long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public final int getFileDescriptor() {
        if (this.isClosed()) {
            return -1;
        }
        SocketInfo sock = this.getSocketInfo();
        return sock == null ? -1 : sock.getFD();
    }

    @Override
    public final String getLocalAddress() {
        if (this.isClosed() || this.socket == null) {
            return "<closed>";
        }
        return this.socket.getLocalAddress().toString();
    }

    @Override
    public final int getLocalPort() {
        if (this.isClosed() || this.socket == null) {
            return -1;
        }
        return this.socket.getLocalPort();
    }

    @Override
    public final String getRemoteAddress() {
        if (this.isClosed() || this.socket == null) {
            return "<closed>";
        }
        return this.socket.getInetAddress().toString();
    }

    @Override
    public final int getRemotePort() {
        if (this.isClosed() || this.socket == null) {
            return -1;
        }
        return this.socket.getPort();
    }

    public final Protocol getProtocol() {
        return this.channel.getProtocol();
    }

    private Object writeReplace() {
        return ((SocketRuntimeFactory)GlobalServiceLocator.getServiceLocator().getService(SocketRuntimeFactory.class, new Annotation[0])).createSocketRuntimeImpl(this);
    }

    @Override
    public boolean isMessageComplete() {
        if (this.msgLength > -1) {
            return this.availBytes >= this.msgLength;
        }
        if (this.availBytes >= this.getHeaderLength()) {
            this.msgLength = this.getMessageLength();
            return this.availBytes >= this.msgLength && this.msgLength > -1;
        }
        return false;
    }

    protected final byte getHeaderByte(int index) {
        if (this.isCleanup) {
            throw new SocketAlreadyClosedException("Socket closed. Please check if it is due to network issues, or Denial of Service Manager's quota limit exceeded");
        }
        if (this.head.end > index) {
            return this.head.buf[index];
        }
        if (this.head.next != null && this.head.next.end > index - this.head.end) {
            return this.head.next.buf[index - this.head.end];
        }
        throw new ArrayIndexOutOfBoundsException("index out of buffer bounds :" + index);
    }

    @Override
    public void dispatch() {
        while (this.isMessageComplete()) {
            this.dispatch(this.makeChunkList());
        }
        SocketMuxer.getMuxer().read(this.getSocketFilter());
    }

    protected int getMessageLength() {
        throw new UnsupportedOperationException("getMessageLength()");
    }

    protected int getHeaderLength() {
        throw new UnsupportedOperationException("getHeaderLength()");
    }

    protected final int getAvailableBytes() {
        return this.availBytes;
    }

    protected void dispatch(Chunk chunk) {
        throw new UnsupportedOperationException("dispatch()");
    }

    public final ServerChannel getChannel() {
        return this.channel;
    }

    @Override
    public final Socket getSocket() {
        return this.socket;
    }

    @Override
    public boolean closeSocketOnError() {
        return true;
    }

    @Override
    public final InputStream getSocketInputStream() {
        return this.sis;
    }

    public final OutputStream getSocketOutputStream() {
        return this.sos;
    }

    @Override
    public final void setSoTimeout(int to) throws SocketException {
        if (to == this.soTimeout) {
            return;
        }
        this.soTimeout = to;
        this.socket.setSoTimeout(to);
    }

    protected final int getSoTimeout() {
        return this.soTimeout;
    }

    protected final boolean isClosed() {
        return this.closeLatch.isLocked();
    }

    public final void close() {
        if (this.closeLatch.tryLock()) {
            if (gatherWhoClosedMe) {
                this.whoClosedMe = new Exception("Debug for socket closures");
            }
            this.cleanup();
        }
    }

    protected String getCloseDebugReasonString() {
        if (this.timedOut) {
            return "reason: timed out";
        }
        if (this.sawEndOfStream) {
            return "reason: end of stream seen";
        }
        if (this.hadException != null) {
            return "reason exception: " + StackTraceUtils.throwable2StackTrace(this.hadException);
        }
        if (this.whoClosedMe != null) {
            gatherWhoClosedMe = false;
            return "reason undetermined, socket closure details: " + StackTraceUtils.throwable2StackTrace(this.whoClosedMe);
        }
        gatherWhoClosedMe = true;
        return "reason undetermined, enabling closure tracking to gain more insight";
    }

    protected void cleanup() {
        this.sis = null;
        this.sos = null;
        Chunk.releaseChunks(this.head);
        this.head = null;
        this.isCleanup = true;
    }

    @Override
    public void hasException(Throwable t) {
        this.close();
        this.hadException = t;
    }

    @Override
    public void endOfStream() {
        this.close();
        this.sawEndOfStream = true;
    }

    @Override
    public boolean timeout() {
        this.close();
        this.timedOut = true;
        return true;
    }

    @Override
    public boolean requestTimeout() {
        return true;
    }

    @Override
    public int getIdleTimeoutMillis() {
        return this.channel.getIdleConnectionTimeout() * 1000;
    }

    @Override
    public int getCompleteMessageTimeoutMillis() {
        return this.channel.getCompleteMessageTimeout() * 1000;
    }

    @Override
    public final MuxableSocket getSocketFilter() {
        return this.filter;
    }

    @Override
    public final void setSocketFilter(MuxableSocket f) {
        this.filter = f;
    }

    @Override
    public final SocketInfo getSocketInfo() {
        return this.info;
    }

    @Override
    public final void setSocketInfo(SocketInfo i) {
        this.info = i;
    }

    public String toString() {
        return super.toString() + ":" + this.socket;
    }

    @Override
    public int size() {
        return KEYS.length;
    }

    @Override
    public String[] getNames() {
        return KEYS;
    }

    @Override
    public Object getValue(String name) {
        if (name.equals("com.bea.contextelement.channel.Port")) {
            return new Integer(this.channel.getPort());
        }
        if (name.equals("com.bea.contextelement.channel.PublicPort")) {
            return new Integer(this.channel.getPublicPort());
        }
        if (name.equals("com.bea.contextelement.channel.RemotePort")) {
            return new Integer(this.getRemotePort());
        }
        if (name.equals("com.bea.contextelement.channel.Protocol")) {
            return this.getProtocol().getAsURLPrefix();
        }
        if (name.equals("com.bea.contextelement.channel.Address")) {
            return this.channel.getAddress();
        }
        if (name.equals("com.bea.contextelement.channel.PublicAddress")) {
            return this.channel.getPublicAddress();
        }
        if (name.equals("com.bea.contextelement.channel.RemoteAddress")) {
            return this.getRemoteAddress();
        }
        if (name.equals("com.bea.contextelement.channel.ChannelName")) {
            return this.channel.getChannelName();
        }
        if (name.equals("com.bea.contextelement.channel.Secure")) {
            return new Boolean(this.channel.supportsTLS());
        }
        return null;
    }

    @Override
    public ContextElement[] getValues(String[] names) {
        ContextElement[] ret = new ContextElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            ret[i] = new ContextElement(names[i], this.getValue(names[i]));
        }
        return ret;
    }

    protected void resetData() {
        this.tail = this.head = Chunk.getChunk();
        this.availBytes = 0;
        this.msgLength = -1;
        this.bytesReceived = 0L;
        this.messagesReceived = 0L;
        this.sawEndOfStream = false;
        this.timedOut = false;
        this.hadException = null;
        this.whoClosedMe = null;
        this.isCleanup = false;
    }

    @Override
    public boolean supportsScatteredRead() {
        return false;
    }

    @Override
    public long read(NIOConnection connection) throws IOException {
        throw new UnsupportedOperationException();
    }
}

