/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import weblogic.kernel.NetworkAccessPointMBeanStub;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerTemplateMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.UnknownProtocolException;
import weblogic.rmi.spi.Channel;
import weblogic.server.GlobalServiceLocator;
import weblogic.server.channels.ServerChannelConstants;
import weblogic.socket.SocketRuntimeFactory;
import weblogic.utils.net.AddressUtils;

public class BasicServerChannelImpl
implements Externalizable,
ServerChannel,
ServerChannelConstants {
    static final long serialVersionUID = 3682806476156685669L;
    private static final boolean DEBUG = false;
    protected byte flags;
    protected String address;
    private String resolvedAddress;
    protected String channelName;
    protected int listenPort = -1;
    protected int publicPort = -1;
    protected String publicAddress;
    protected int rawAddress;
    protected Protocol protocol;
    protected int priority;
    protected int weight;
    protected transient InetAddress inetAddress;
    protected transient InetSocketAddress inSockAddress;
    protected transient NetworkAccessPointMBean config;
    protected transient boolean implicitChannel;
    protected transient boolean isLocal;
    protected transient String displayName;
    private transient boolean t3SenderQueueDisabled;
    private String resolvedPublicAddr;
    private static final String PROTOCOL_T3 = "t3";
    private static final String PROTOCOL_T3S = "t3s";
    private static final String PROTOCOL_ADMIN = "admin";
    protected transient String associatedVirtualTargetName;
    protected transient String allowListViolationAction;
    private static int PORT_VALUE_NEED_TO_HANDLE = -1;

    public BasicServerChannelImpl() {
    }

    public int hashCode() {
        return this.channelName.hashCode() ^ this.rawAddress ^ this.listenPort ^ this.protocol.getAsURLPrefix().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BasicServerChannelImpl) {
            BasicServerChannelImpl other = (BasicServerChannelImpl)o;
            return other.channelName.equals(this.channelName) && other.rawAddress == this.rawAddress && other.listenPort == this.listenPort && other.protocol.getAsURLPrefix().equals(this.protocol.getAsURLPrefix());
        }
        return false;
    }

    public boolean requiresNAT() {
        return this.hasPublicAddress() || this.hasPublicPort();
    }

    @Override
    public boolean supportsTLS() {
        return (this.flags & 0x20) != 0;
    }

    boolean isImplicitChannel() {
        return this.implicitChannel;
    }

    boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean supportsHttp() {
        return (this.flags & 0x10) != 0;
    }

    public NetworkAccessPointMBean getConfig() {
        return this.config;
    }

    @Override
    public final String getAddress() {
        return this.address;
    }

    public final String getResolvedAddress() {
        if (this.resolvedAddress == null) {
            if (this.isLocal) {
                if (this.inetAddress == null) {
                    InetAddress ia = AddressUtils.getIPForLocalHost();
                    this.resolvedAddress = ia.getHostAddress();
                } else {
                    this.resolvedAddress = this.inetAddress.getHostAddress();
                }
            } else {
                this.resolvedAddress = this.address == null ? this.publicAddress : this.address;
            }
        }
        return this.resolvedAddress;
    }

    @Override
    public String getPublicAddressResolvedIfNeeded() {
        if (!this.getResolveDNSName()) {
            return this.getPublicAddress();
        }
        if (!this.isT3ProtocolFamily()) {
            return this.getPublicAddress();
        }
        if (this.resolvedPublicAddr != null) {
            return this.resolvedPublicAddr;
        }
        if (this.hasPublicAddress() && this.publicAddress != null) {
            try {
                this.resolvedPublicAddr = InetAddress.getByName(this.publicAddress).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            this.resolvedPublicAddr = this.getResolvedAddress();
        }
        return this.resolvedPublicAddr;
    }

    private boolean isT3ProtocolFamily() {
        Protocol p = this.protocol;
        if (this.protocol.getProtocolName().equalsIgnoreCase(PROTOCOL_ADMIN)) {
            p = ProtocolManager.getRealProtocol(this.protocol);
        }
        return p.getProtocolName().equalsIgnoreCase(PROTOCOL_T3) || p.getProtocolName().equalsIgnoreCase(PROTOCOL_T3S);
    }

    public final int getRawAddress() {
        return this.rawAddress;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    public int getChannelWeight() {
        return this.weight;
    }

    @Override
    public String getPublicAddress() {
        return this.publicAddress != null ? this.publicAddress : this.getAddress();
    }

    @Override
    public int getPublicPort() {
        return this.hasPublicPort() ? this.publicPort : this.listenPort;
    }

    @Override
    public int getPort() {
        return this.listenPort;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getProtocolPrefix() {
        return this.protocol.getAsURLPrefix();
    }

    public String getProtocolName() {
        return this.protocol.getProtocolName();
    }

    @Deprecated
    public final InetAddress address() {
        return this.getInetAddress();
    }

    @Override
    public InetSocketAddress getPublicInetAddress() {
        return this.inSockAddress;
    }

    @Override
    public final String getClusterAddress() {
        String ca = this.getConfig().getClusterAddress();
        return ca == null ? this.getPublicAddress() : ca;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public String getListenerKey() {
        return this.getResolvedAddress().toLowerCase() + this.getPort();
    }

    @Override
    public boolean hasPublicAddress() {
        return (this.flags & 1) != 0;
    }

    protected void setPublicAddress(String addr) {
        if (addr != null && addr.length() > 0 && !addr.equals(this.address)) {
            this.publicAddress = addr;
            this.flags = (byte)(this.flags | 1);
        }
    }

    protected boolean hasListenAddress() {
        return (this.flags & 8) != 0;
    }

    protected void setListenAddress(String la) {
        if (la != null && la.length() > 0) {
            this.address = la;
            this.flags = (byte)(this.flags | 8);
        }
    }

    protected boolean hasListenPort() {
        return (this.flags & 2) != 0;
    }

    protected void setListenPort(int port) {
        if (port != -1) {
            this.listenPort = port;
            this.flags = (byte)(this.flags | 2);
        }
    }

    protected boolean hasPublicPort() {
        return (this.flags & 4) != 0;
    }

    protected void setPublicPort(int port) {
        if (port != -1 && port != this.listenPort) {
            this.publicPort = port;
            this.flags = (byte)(this.flags | 4);
        }
    }

    @Override
    public boolean isSDPEnabled() {
        return (this.flags & 0x40) != 0;
    }

    protected void setSDPEnabled(boolean enable) {
        this.flags = enable ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.channelName);
        b.append(':').append(this.getProtocol().getProtocolName()).append('(').append(this.getProtocol().getAsURLPrefix()).append(')');
        b.append(':').append(this.address);
        b.append(":" + this.listenPort);
        b.append(':').append(this.publicAddress);
        b.append(":" + this.publicPort);
        return b.toString();
    }

    public int compareTo(Object o) {
        boolean b;
        BasicServerChannelImpl other = (BasicServerChannelImpl)o;
        int d = this.priority - other.priority;
        if (d == 0 && this.isImplicitChannel() != other.isImplicitChannel()) {
            int n = d = this.isImplicitChannel() ? 1 : -1;
        }
        if (d == 0) {
            NetworkAccessPointMBean otherConfig = other.getConfig();
            if (this.config.isOutboundEnabled() && !otherConfig.isOutboundEnabled()) {
                d = -1;
            } else if (!this.config.isOutboundEnabled() && otherConfig.isOutboundEnabled()) {
                d = 1;
            }
        }
        if (d == 0 && (b = this.getChannelName().startsWith("Default")) != other.getChannelName().startsWith("Default")) {
            int n = d = b ? -1 : 1;
        }
        if (d == 0 && (b = this.requiresNAT()) != other.requiresNAT()) {
            int n = d = b ? 1 : -1;
        }
        if (d == 0 && (b = this.address() != null && this.address().isLoopbackAddress()) != (other.address() != null && other.address().isLoopbackAddress())) {
            int n = d = b ? 1 : -1;
        }
        if (d == 0) {
            d = this.getChannelName().compareTo(other.getChannelName());
        }
        return d;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.flags);
        out.writeUTF(this.channelName);
        if (this.hasListenAddress()) {
            if (this.getResolveDNSName() && this.isT3ProtocolFamily()) {
                out.writeUTF(this.getResolvedAddress());
            } else {
                out.writeUTF(this.address);
            }
        }
        out.writeInt(this.rawAddress);
        out.writeObject(this.protocol);
        out.writeInt(this.priority);
        out.writeInt(this.weight);
        if (this.hasPublicAddress() || !this.hasListenAddress()) {
            out.writeUTF(this.getPublicAddressResolvedIfNeeded());
        }
        if (this.hasListenPort()) {
            out.writeInt(this.listenPort);
        }
        if (this.hasPublicPort()) {
            out.writeInt(this.publicPort);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flags = in.readByte();
        this.channelName = in.readUTF();
        if (this.hasListenAddress()) {
            this.address = in.readUTF();
        }
        this.rawAddress = in.readInt();
        this.protocol = (Protocol)in.readObject();
        this.priority = in.readInt();
        this.weight = in.readInt();
        if (this.hasPublicAddress() || !this.hasListenAddress()) {
            this.publicAddress = in.readUTF();
        }
        if (this.hasListenPort()) {
            this.listenPort = in.readInt();
        }
        if (this.hasPublicPort()) {
            this.publicPort = in.readInt();
        }
        if (this.getPublicPort() >= 0) {
            this.inSockAddress = new InetSocketAddress(this.getPublicAddress(), this.getPublicPort());
        }
    }

    BasicServerChannelImpl(NetworkAccessPointMBean napMbean, ServerIdentity id) throws UnknownHostException, UnknownProtocolException {
        this(napMbean, ProtocolManager.findProtocol(napMbean.getProtocol()), napMbean.getName(), id, null);
    }

    public BasicServerChannelImpl(NetworkAccessPointMBean napMbean, Protocol protocol, ServerIdentity id) throws UnknownHostException {
        this(napMbean, protocol, BasicServerChannelImpl.encodeName(protocol, napMbean.getName()), id, null);
        this.displayName = napMbean.getName();
    }

    protected static final String encodeName(Protocol protocol, String name) {
        return name + "[" + protocol.getAsURLPrefix() + "]";
    }

    String getRealName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.channelName;
    }

    @Override
    public String getAssociatedVirtualTargetName() {
        return this.associatedVirtualTargetName;
    }

    protected BasicServerChannelImpl(NetworkAccessPointMBean napMbean, Protocol protocol, String channelName, ServerIdentity id, String address) throws UnknownHostException {
        if (protocol.isSecure()) {
            this.flags = (byte)(this.flags | 0x20);
        }
        if (!protocol.getProtocolName().equalsIgnoreCase(napMbean.getProtocol())) {
            this.implicitChannel = true;
        }
        this.protocol = protocol;
        this.priority = protocol.getHandler().getPriority();
        this.channelName = channelName;
        this.config = napMbean;
        this.setListenAddress(address);
        this.update(id);
    }

    public static ServerChannel createBootstrapChannel(String protocol) throws UnknownHostException {
        SocketRuntimeFactory scs = (SocketRuntimeFactory)GlobalServiceLocator.getServiceLocator().getService(SocketRuntimeFactory.class, new Annotation[0]);
        if (scs == null) {
            throw new RuntimeException("Implementation of ServerChannelService not found in classpath");
        }
        return scs.createBootstrapChannel(protocol);
    }

    private boolean isSecure(NetworkAccessPointMBean nap) {
        byte qos = ProtocolManager.getProtocolByName(nap.getProtocol()).getQOS();
        return qos == 102 || qos == 103;
    }

    private int findListenPort(NetworkAccessPointMBean nap) {
        int listenPort = nap.getListenPort();
        if (nap instanceof NetworkAccessPointMBeanStub) {
            if (!nap.isEnabled()) {
                return PORT_VALUE_NEED_TO_HANDLE;
            }
            return listenPort;
        }
        if (listenPort == PORT_VALUE_NEED_TO_HANDLE) {
            ServerTemplateMBean parent = (ServerTemplateMBean)nap.getParent();
            listenPort = this.isSecure(nap) ? parent.getSSL().getListenPort() : parent.getListenPort();
        }
        return listenPort;
    }

    private int findPublicPort(NetworkAccessPointMBean nap) {
        int publicPort = nap.getPublicPort();
        if (nap instanceof NetworkAccessPointMBeanStub) {
            if (!nap.isEnabled()) {
                return PORT_VALUE_NEED_TO_HANDLE;
            }
            return publicPort;
        }
        if (publicPort == PORT_VALUE_NEED_TO_HANDLE) {
            publicPort = this.findListenPort(nap);
        }
        return publicPort;
    }

    void update(ServerIdentity id) throws UnknownHostException {
        this.setListenAddress(this.config.getListenAddress());
        InetAddress ia = null;
        this.setListenPort(this.findListenPort(this.config));
        this.setPublicPort(this.findPublicPort(this.config));
        this.setPublicAddress(this.config.getPublicAddress());
        this.setSDPEnabled(this.config.isSDPEnabled());
        this.flags = this.config.isHttpEnabledForThisProtocol() || this.config.isTunnelingEnabled() ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        if (id != null && id.isLocal()) {
            this.isLocal = true;
            if (this.address == null) {
                ia = AddressUtils.getIPForLocalHost();
                if (!this.hasPublicAddress()) {
                    this.publicAddress = ia.getHostAddress();
                }
            } else {
                this.inetAddress = ia = InetAddress.getByName(this.address);
                if (this.address.indexOf(":") != -1) {
                    this.address = "[" + this.inetAddress.getHostAddress() + "]";
                }
            }
        } else {
            String pa = this.getPublicAddress();
            if (pa == null) {
                if (id instanceof Channel) {
                    pa = ((Channel)((Object)id)).getPublicAddress();
                }
                if (pa == null) {
                    throw new UnknownHostException("Couldn't determine usable host address for remote channel: " + this.config.getName());
                }
                this.setPublicAddress(pa);
            }
            this.inetAddress = ia = InetAddress.getByName(pa);
        }
        byte[] buf = ia.getAddress();
        this.rawAddress = ((buf[0] & 0xFF) << 24) + ((buf[1] & 0xFF) << 16) + ((buf[2] & 0xFF) << 8) + ((buf[3] & 0xFF) << 0);
        if (this.getPublicPort() >= 0) {
            this.inSockAddress = new InetSocketAddress(this.getPublicAddress(), this.getPublicPort());
        }
        this.weight = this.config.getChannelWeight();
    }

    void update() {
        this.weight = this.config.getChannelWeight();
        if (this.address != null) {
            this.setPublicAddress(this.config.getPublicAddress());
        }
        this.setPublicPort(this.findPublicPort(this.config));
    }

    protected BasicServerChannelImpl(BasicServerChannelImpl channel, Protocol protocol) {
        this.flags = channel.flags;
        this.displayName = channel.displayName;
        this.associatedVirtualTargetName = channel.associatedVirtualTargetName;
        this.listenPort = channel.listenPort;
        this.publicPort = channel.publicPort;
        this.weight = channel.weight;
        this.config = channel.config;
        this.publicAddress = channel.publicAddress;
        this.address = channel.address;
        this.inetAddress = channel.inetAddress;
        this.rawAddress = channel.rawAddress;
        this.inSockAddress = channel.inSockAddress;
        this.implicitChannel = true;
        this.protocol = protocol;
        this.isLocal = channel.isLocal;
        this.priority = protocol.getHandler().getPriority();
        if (this.displayName == null) {
            this.displayName = channel.channelName;
        }
        this.channelName = BasicServerChannelImpl.encodeName(protocol, this.displayName);
    }

    private static void p(String s) {
        System.out.println("<BasicServerChannelImpl>: " + s);
    }

    public static ServerChannel createDefaultServerChannel(Protocol protocol) {
        try {
            return new BasicServerChannelImpl(new NetworkAccessPointMBeanStub(protocol.getProtocolName()), protocol, LocalServerIdentity.getIdentity());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    @Override
    public String getConfiguredProtocol() {
        return this.config.getProtocol();
    }

    @Override
    public int getAcceptBacklog() {
        return this.config.getAcceptBacklog();
    }

    @Override
    public int getCompleteMessageTimeout() {
        return this.config.getCompleteMessageTimeout();
    }

    @Override
    public int getConnectTimeout() {
        return this.config.getConnectTimeout();
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.config.getIdleConnectionTimeout();
    }

    @Override
    public int getLoginTimeoutMillis() {
        return this.config.getLoginTimeoutMillis();
    }

    @Override
    public int getMaxBackoffBetweenFailures() {
        return this.config.getMaxBackoffBetweenFailures();
    }

    @Override
    public int getMaxConnectedClients() {
        return this.config.getMaxConnectedClients();
    }

    @Override
    public int getMaxMessageSize() {
        return this.config.getMaxMessageSize();
    }

    @Override
    public String getProxyAddress() {
        return this.config.getProxyAddress();
    }

    @Override
    public int getProxyPort() {
        return this.config.getProxyPort();
    }

    @Override
    public boolean getTimeoutConnectionWithPendingResponses() {
        return this.config.getTimeoutConnectionWithPendingResponses();
    }

    @Override
    public int getTunnelingClientPingSecs() {
        return this.config.getTunnelingClientPingSecs();
    }

    @Override
    public int getTunnelingClientTimeoutSecs() {
        return this.config.getTunnelingClientTimeoutSecs();
    }

    @Override
    public boolean getUseFastSerialization() {
        return this.config.getUseFastSerialization();
    }

    @Override
    public boolean isClientCertificateEnforced() {
        return this.config.isClientCertificateEnforced();
    }

    @Override
    public boolean isHttpEnabledForThisProtocol() {
        return this.config.isHttpEnabledForThisProtocol();
    }

    @Override
    public boolean isOutboundEnabled() {
        return this.config.isOutboundEnabled();
    }

    @Override
    public boolean isOutboundPrivateKeyEnabled() {
        return this.config.isOutboundPrivateKeyEnabled();
    }

    @Override
    public boolean isTunnelingEnabled() {
        return this.config.isTunnelingEnabled();
    }

    @Override
    public boolean isTwoWaySSLEnabled() {
        return this.config.isTwoWaySSLEnabled();
    }

    @Override
    public boolean isT3SenderQueueDisabled() {
        return this.t3SenderQueueDisabled;
    }

    void setT3SenderQueueDisabled(boolean enable) {
        this.t3SenderQueueDisabled = enable;
    }

    @Override
    public boolean getResolveDNSName() {
        return this.getConfig() != null && this.getConfig().getResolveDNSName();
    }

    @Override
    public boolean isHostnameVerificationIgnored() {
        return this.config.isHostnameVerificationIgnored();
    }

    @Override
    public String getHostnameVerifier() {
        return this.config.getHostnameVerifier();
    }

    @Override
    public String[] getCiphersuites() {
        return this.config.getCiphersuites();
    }

    @Override
    public String[] getExcludedCiphersuites() {
        return this.config.getExcludedCiphersuites();
    }

    @Override
    public boolean isAllowUnencryptedNullCipher() {
        return this.config.isAllowUnencryptedNullCipher();
    }

    @Override
    public String getInboundCertificateValidation() {
        return this.config.getInboundCertificateValidation();
    }

    @Override
    public String getOutboundCertificateValidation() {
        return this.config.getOutboundCertificateValidation();
    }

    @Override
    public String getMinimumTLSProtocolVersion() {
        return this.config.getMinimumTLSProtocolVersion();
    }

    @Override
    public boolean isSSLv2HelloEnabled() {
        return this.config.isSSLv2HelloEnabled();
    }

    @Override
    public boolean isClientInitSecureRenegotiationAccepted() {
        return this.config.isClientInitSecureRenegotiationAccepted();
    }

    @Override
    public String getAllowListViolationAction() {
        return this.config.getAllowListViolationAction();
    }

    @Override
    public void setAllowListViolationAction(String AllowListViolationAction) {
        this.allowListViolationAction = AllowListViolationAction;
    }
}

