/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import weblogic.security.utils.Factory;
import weblogic.utils.collections.CircularQueue;

public final class Pool {
    private static boolean DEBUG = false;
    public static final String PROP_IDLE_TIMEOUT = "weblogic.security.pool.idle.timeout";
    private static final long NO_IDLE_TIMEOUT = -1L;
    private static final long DEFAULT_IDLE_TIMEOUT = 500000L;
    private static long idleTimeout = -1L;
    private final Factory factory;
    private final CircularQueue queue;
    private final Delegate delegate;

    private static void debug(String message) {
        System.out.println("" + new Date() + ", DEBUG 25192833: " + message);
    }

    public Pool(Factory factory, int size) {
        this.factory = factory;
        this.queue = new CircularQueue(size, size);
        Delegate delegate = this.delegate = idleTimeout == -1L ? new NoIdleTimeoutDelegate() : new IdleTimeoutDelegate();
        if (DEBUG) {
            Pool.debug("Pool created " + this);
        }
    }

    public int getCapacity() {
        return this.queue.capacity();
    }

    public Object getInstance() throws InvocationTargetException {
        Object o = this.delegate.getValidInstanceFromQueue();
        if (o != null) {
            return o;
        }
        return this.newInstance();
    }

    public Object newInstance() throws InvocationTargetException {
        return this.factory.newInstance();
    }

    public void returnInstance(Object object) {
        if (!this.delegate.returnInstanceToQueue(object)) {
            this.destroyInstance(object);
        }
    }

    public void destroyInstance(Object object) {
        this.factory.destroyInstance(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Delegate delegate = this.delegate;
        synchronized (delegate) {
            Object obj = this.delegate.getInstanceFromQueue();
            while (obj != null) {
                this.destroyInstance(obj);
                obj = this.delegate.getInstanceFromQueue();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        idleTimeout = Long.getLong(PROP_IDLE_TIMEOUT, -1L);
        if (DEBUG) {
            Pool.debug("ldap connection idle timeout is " + idleTimeout + " milliseconds.");
        }
    }

    private class Wrapper {
        private long timestamp;
        private Object obj;

        Wrapper(Object obj) {
            this.obj = obj;
            this.timestamp = System.currentTimeMillis();
        }

        Object getObject() {
            return this.obj;
        }

        boolean expired() {
            if (idleTimeout == -1L) {
                return false;
            }
            long curentTimestamp = System.currentTimeMillis();
            return curentTimestamp - this.timestamp > idleTimeout;
        }

        public String toString() {
            return "Object " + this.obj + ", timestamp " + new Date(this.timestamp);
        }
    }

    private class NoIdleTimeoutDelegate
    implements Delegate {
        private NoIdleTimeoutDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getInstanceFromQueue() {
            Object o;
            NoIdleTimeoutDelegate noIdleTimeoutDelegate = this;
            synchronized (noIdleTimeoutDelegate) {
                o = Pool.this.queue.remove();
            }
            return o;
        }

        @Override
        public Object getValidInstanceFromQueue() {
            return this.getInstanceFromQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean returnInstanceToQueue(Object object) {
            NoIdleTimeoutDelegate noIdleTimeoutDelegate = this;
            synchronized (noIdleTimeoutDelegate) {
                if (Pool.this.queue.add(object)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class IdleTimeoutDelegate
    implements Delegate {
        private IdleTimeoutDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getInstanceFromQueue() {
            Wrapper w = null;
            IdleTimeoutDelegate idleTimeoutDelegate = this;
            synchronized (idleTimeoutDelegate) {
                w = (Wrapper)Pool.this.queue.remove();
            }
            if (w != null) {
                return w.getObject();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValidInstanceFromQueue() {
            Wrapper w = null;
            IdleTimeoutDelegate idleTimeoutDelegate = this;
            synchronized (idleTimeoutDelegate) {
                w = (Wrapper)Pool.this.queue.remove();
            }
            while (w != null && w.expired()) {
                if (DEBUG) {
                    Pool.debug("Destroy " + w + " Pool: " + Pool.this);
                }
                Pool.this.destroyInstance(w.getObject());
                idleTimeoutDelegate = this;
                synchronized (idleTimeoutDelegate) {
                    w = (Wrapper)Pool.this.queue.remove();
                }
            }
            if (w != null) {
                if (DEBUG) {
                    Pool.debug("Found " + w + " Pool: " + Pool.this);
                }
                return w.getObject();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean returnInstanceToQueue(Object object) {
            IdleTimeoutDelegate idleTimeoutDelegate = this;
            synchronized (idleTimeoutDelegate) {
                if (Pool.this.queue.add(new Wrapper(object))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static interface Delegate {
        public Object getInstanceFromQueue();

        public Object getValidInstanceFromQueue();

        public boolean returnInstanceToQueue(Object var1);
    }
}

