/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import com.bea.core.security.logger.Logger;
import com.bea.core.security.managers.SubjectManagerFactory;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectProxy;
import weblogic.security.subject.SubjectStack;

public abstract class SubjectManager
implements SubjectStack {
    public static final String KERNEL_USERNAME = "<WLS Kernel>";
    public static final String ANONYMOUS_USERNAME = SubjectManager.initAnonymousUsername();
    private static final String DEFAULT_ANONYMOUS_USERNAME = "<anonymous>";
    private static final GetKernelIdentityAction THE_ONE = new GetKernelIdentityAction();
    protected static final Permission KERNEL_PERM = new RuntimePermission("weblogic.kernelPermission");
    private static final boolean ceClient = "true".equalsIgnoreCase(System.getProperty("com.bea.core.internal.client", "false"));
    private static final Object ceSubjectManagerLock = new Object();
    private static SubjectManager ceSubjectManager;

    public static synchronized void ensureInitialized() {
        if (ceSubjectManager != null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SubjectManager.installCESubjectManager(SubjectManagerFactory.getInstance().getSubjectManager());
                return null;
            }
        });
    }

    public static final PrivilegedAction getKernelIdentityAction() {
        return THE_ONE;
    }

    public static final Permission getKernelPermission() {
        return KERNEL_PERM;
    }

    public void checkKernelPermission() {
        AccessController.checkPermission(KERNEL_PERM);
    }

    public boolean isKernelIdentity(AbstractSubject s) {
        boolean retVal;
        boolean bl = retVal = s == this.getCachedKernelIdentity();
        if (Logger.isDebugEnabled() && !retVal) {
            Logger.logger().debug("bad kernel id s=" + s + " cache=" + this.getCachedKernelIdentity(), new Exception());
        }
        return retVal;
    }

    private AbstractSubject getCachedKernelIdentity() {
        return KernelIdentityMaker.KERNEL_ID;
    }

    public void checkKernelIdentity(AbstractSubject s) {
        if (!this.isKernelIdentity(s)) {
            throw new SecurityException("Subject '" + (s == null ? "<null>" : s.toString()) + "' is not the kernel identity");
        }
    }

    protected abstract AbstractSubject getKernelIdentity();

    public static final SubjectManager getSubjectManagerNoWait() {
        return ceSubjectManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SubjectManager getSubjectManager() {
        Object object = ceSubjectManagerLock;
        synchronized (object) {
            while (ceSubjectManager == null) {
                if (ceClient) {
                    ceSubjectManager = SubjectManagerFactory.getInstance().getSubjectManager();
                    return ceSubjectManager;
                }
                try {
                    ceSubjectManagerLock.wait();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return ceSubjectManager;
        }
    }

    protected static final boolean subjectManagerInstalled() {
        return ceSubjectManager != null;
    }

    public static final void setSubjectManager(SubjectManager manager) {
        if (Logger.isDebugEnabled()) {
            Logger.logger().debug("An attempt has been made to install SubjectManager " + manager, new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void installCESubjectManager(SubjectManager manager) {
        Object object = ceSubjectManagerLock;
        synchronized (object) {
            ceSubjectManager = manager;
            ceSubjectManagerLock.notifyAll();
        }
        if (Logger.isDebugEnabled()) {
            Logger.logger().debug("CE subject manager has been installed: " + manager);
        }
    }

    public static final PrivilegedAction setSubjectManagerAction(SubjectManager manager) {
        return new SetSubjectManagerAction(manager);
    }

    public Object runAs(Subject userIdentity, PrivilegedAction action) {
        if (userIdentity == null) {
            throw new SecurityException("Null user identity");
        }
        return this.getAbstractSubject(userIdentity).doAs(this.getCachedKernelIdentity(), action);
    }

    public Object runAs(Subject userIdentity, PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (userIdentity == null) {
            throw new SecurityException("Null user identity");
        }
        return this.getAbstractSubject(userIdentity).doAs(this.getCachedKernelIdentity(), action);
    }

    protected abstract AbstractSubject createAbstractSubject(Subject var1);

    private final AbstractSubject getAbstractSubject(final Subject subject) {
        return (AbstractSubject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object obj : subject.getPrivateCredentials()) {
                    if (!(obj instanceof AbstractSubject)) continue;
                    return obj;
                }
                return SubjectManager.this.createAbstractSubject(subject);
            }
        });
    }

    public String getSubjectName(AbstractSubject subject) {
        if (subject == null) {
            throw new AssertionError((Object)"subject is null");
        }
        if (this.isKernelIdentity(subject)) {
            return KERNEL_USERNAME;
        }
        Principal user = SubjectManager.getOnePrincipal(subject, SubjectProxy.class);
        if (user == null) {
            return ANONYMOUS_USERNAME;
        }
        return user.getName();
    }

    public static Principal getOnePrincipal(AbstractSubject subject, Class type) {
        return SubjectManager.getOnePrincipalClass(subject.getPrincipals(), type);
    }

    public static Principal getOnePrincipalClass(Set principals, Class type) {
        for (Principal p : principals) {
            if (!type.isAssignableFrom(p.getClass())) continue;
            return p;
        }
        return null;
    }

    private static String initAnonymousUsername() {
        try {
            return System.getProperty("weblogic.security.anonymousUserName", DEFAULT_ANONYMOUS_USERNAME);
        }
        catch (Exception ignore) {
            return DEFAULT_ANONYMOUS_USERNAME;
        }
    }

    public abstract AbstractSubject getAnonymousSubject();

    private static final class SetSubjectManagerAction
    implements PrivilegedAction {
        private final SubjectManager manager;

        private SetSubjectManagerAction(SubjectManager manager) {
            this.manager = manager;
        }

        public final Object run() {
            SubjectManager.setSubjectManager(this.manager);
            return null;
        }
    }

    private static final class GetKernelIdentityAction
    implements PrivilegedAction {
        private GetKernelIdentityAction() {
        }

        public final Object run() {
            return SubjectManager.getSubjectManager().getKernelIdentity();
        }
    }

    private static class KernelIdentityMaker {
        private static AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());

        private KernelIdentityMaker() {
        }
    }
}

