/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.security.spi.Resource;
import weblogic.security.spi.SelfDescribingResourceV2;
import weblogic.utils.collections.SecondChanceCacheMap;

public abstract class ResourceBase
implements SelfDescribingResourceV2 {
    private static final long FACTOR = 31L;
    private static final char[] SPECIAL_CHARS = new char[]{',', '{', '}', '\\'};
    private static Pattern SPECIAL_CHARS_PATTERN = Pattern.compile("[,{}\\\\]");
    private static final String SCOPE_RESOURCE_ACTION_PROPERTY = "weblogic.security.scopeResourceAction";
    protected static final boolean SCOPE_RESOURCE_ACTION;
    private static final String RESOURCE_CACHE_SIZE_PROPERTY = "weblogic.security.service.resourceCacheSize";
    private static final String DISABLE_ESCAPING_PROPERTY = "weblogic.security.service.disableEscaping";
    private static final boolean DISABLE_ESCAPING;
    private static SecondChanceCacheMap resCache;
    private static int cacheResStringLengthLimit;
    protected static final Resource NO_PARENT;
    protected Resource parent = null;
    protected String resStr = null;
    protected String[] values = null;
    protected int length = 0;
    protected long id = 0L;

    public ResourceBase() {
        this.init(null, 0, 0L);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceBase)) {
            return false;
        }
        ResourceBase rsrc = (ResourceBase)obj;
        if (this.id != rsrc.id || this.length != rsrc.length || !this.getType().equals(rsrc.getType())) {
            return false;
        }
        if (this.values != rsrc.values) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.values[i] == null ? rsrc.values[i] != null : !this.values[i].equals(rsrc.values[i]))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.resStr == null) {
            ResourceBase entry = (ResourceBase)resCache.get(this);
            if (entry != null && entry.resStr != null) {
                this.resStr = entry.resStr;
            } else {
                StringBuffer buf = new StringBuffer(256);
                this.writeResourceString(buf);
                this.resStr = buf.toString();
                if (entry == null) {
                    if (this.resStr.length() <= cacheResStringLengthLimit) {
                        resCache.put(this, this);
                    }
                } else if (this.resStr.length() <= cacheResStringLengthLimit) {
                    entry.resStr = this.resStr;
                }
            }
            if (entry != null) {
                if (entry.parent != null) {
                    this.parent = entry.parent;
                } else if (this.parent != null) {
                    entry.parent = this.parent;
                }
            }
        }
        return this.resStr;
    }

    protected void writeResourceString(StringBuffer buf) {
        buf.append("type=").append(this.getType());
        String[] keys = this.getKeys();
        for (int i = 0; i < this.length; ++i) {
            if (this.values[i] == null && this.isTransitiveField(keys[i])) continue;
            buf.append(", ").append(keys[i]).append('=');
            ResourceBase.appendValue(buf, this.values[i]);
        }
    }

    @Override
    public Resource getParentResource() {
        if (this.parent == null) {
            ResourceBase entry = (ResourceBase)resCache.get(this);
            if (entry != null && entry.parent != null) {
                this.parent = entry.parent;
            } else {
                this.parent = this.makeParent();
                if (this.parent == null) {
                    this.parent = NO_PARENT;
                }
                if (entry == null) {
                    if (this.toString().length() <= cacheResStringLengthLimit) {
                        resCache.put(this, this);
                    }
                } else {
                    entry.parent = this.parent;
                }
            }
            if (entry != null) {
                if (entry.resStr != null) {
                    this.resStr = entry.resStr;
                } else if (this.resStr != null) {
                    entry.resStr = this.resStr;
                }
            }
        }
        return this.parent == NO_PARENT ? null : this.parent;
    }

    protected Resource makeParent() {
        return null;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    @Override
    public abstract String[] getKeys();

    @Override
    public int getFieldType(String fieldName) {
        return 1;
    }

    @Override
    public int getRepeatingFieldIndex() {
        return -1;
    }

    @Override
    public int getRepeatingFieldTerminatingIndex() {
        return this.getKeys().length;
    }

    @Override
    public boolean isTransitiveField(String fieldName) {
        return false;
    }

    @Override
    public String[] getValues() {
        String[] result = new String[this.length];
        if (this.length > 0) {
            System.arraycopy(this.values, 0, result, 0, this.length);
        }
        return result;
    }

    protected static StringBuffer appendValue(StringBuffer buf, String value) {
        if (value == null) {
            return buf;
        }
        if (DISABLE_ESCAPING) {
            return buf.append(value);
        }
        Matcher matcher = SPECIAL_CHARS_PATTERN.matcher(value);
        while (matcher.find()) {
            matcher.appendReplacement(buf, "");
            buf.append("\\" + matcher.group());
        }
        matcher.appendTail(buf);
        return buf;
    }

    protected static StringBuffer appendArrayValue(StringBuffer buf, String[] values, int len) {
        buf.append('{');
        if (len > 0) {
            ResourceBase.appendValue(buf, values[0]);
            for (int i = 1; i < len; ++i) {
                buf.append(',');
                ResourceBase.appendValue(buf, values[i]);
            }
        }
        buf.append('}');
        return buf;
    }

    protected void init(String[] values, long seed) {
        this.init(values, values.length, seed);
    }

    protected void init(String[] values, int len, long seed) {
        this.values = values;
        while (len > 0 && values[len - 1] == null) {
            --len;
        }
        this.length = len;
        long hash = 31L * seed + (long)this.getType().hashCode();
        for (int i = 0; i < len; ++i) {
            hash *= 31L;
            if (values[i] == null) continue;
            hash += (long)(1 + values[i].hashCode());
        }
        this.id = hash;
    }

    static {
        resCache = null;
        int resCacheSize = 2048;
        boolean scopeResAction = false;
        boolean disableEscaping = false;
        try {
            String sra = System.getProperty(SCOPE_RESOURCE_ACTION_PROPERTY, "false");
            scopeResAction = sra.length() == 0 || sra.equals("true");
            String rcs = System.getProperty(RESOURCE_CACHE_SIZE_PROPERTY);
            if (rcs != null) {
                try {
                    resCacheSize = Integer.parseInt(rcs);
                    if (resCacheSize < 0) {
                        resCacheSize = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            cacheResStringLengthLimit = Integer.getInteger("weblogic.security.cacheResourceLengthLimit", 1000);
            disableEscaping = Boolean.getBoolean(DISABLE_ESCAPING_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SCOPE_RESOURCE_ACTION = scopeResAction;
        resCache = new SecondChanceCacheMap(resCacheSize);
        DISABLE_ESCAPING = disableEscaping;
        NO_PARENT = new ResourceBase(){

            @Override
            public String[] getKeys() {
                return null;
            }

            @Override
            public String getType() {
                return "";
            }
        };
    }
}

