/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth.login;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import weblogic.jndi.Environment;
import weblogic.security.SecurityLogger;
import weblogic.security.auth.Authenticate;
import weblogic.security.auth.callback.URLCallback;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.subject.SubjectManager;

public class UsernamePasswordLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private static LoggerWrapper log;
    private String url = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username = null;
    private String password = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.subject = subject;
        if (options != null) {
            Object val = options.get("debug");
            if (val != null && ((String)val).equalsIgnoreCase("true")) {
                this.log("UsernamePasswordLoginModule.initialize(), debug enabled");
            }
            if ((val = options.get("URL")) != null) {
                this.url = (String)val;
                this.log("UsernamePasswordLoginModule.initialize(), URL " + this.url);
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            this.log("UsernamePasswordLoginModule.login(), no callback handler specifed");
            throw new LoginException(SecurityLogger.getNoCallbackHandlerSpecified());
        }
        Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false), new URLCallback("URL: ")};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            if (log.isDebugEnabled()) {
                if (this.username == null) {
                    this.log("UsernamePasswordLoginModule.login(), No username");
                } else {
                    this.log("UsernamePasswordLoginModule.login(), username " + this.username);
                }
            }
            if (this.username == null) {
                throw new LoginException(SecurityLogger.getNoUsernameSpecified());
            }
            char[] charPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (charPassword == null) {
                charPassword = new char[]{};
            }
            this.password = new String(charPassword);
            String callbackURL = ((URLCallback)callbacks[2]).getURL();
            if (callbackURL != null) {
                this.url = callbackURL;
            }
            if (log.isDebugEnabled()) {
                if (this.url == null) {
                    this.log("UsernamePasswordLoginModule.login(), No URL");
                } else {
                    this.log("UsernamePasswordLoginModule.login(), URL " + this.url);
                }
            }
            if (this.url == null) {
                this.url = "";
            }
        }
        catch (IOException ioe) {
            this.log("UsernamePasswordLoginModule CallbackHandler Error: " + ioe.getMessage());
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            this.log("UsernamePasswordLoginModule CallbackHandler Error: " + uce.getMessage());
            throw new LoginException(SecurityLogger.getErrorCallbackNotAvailable(uce.getCallback().toString()));
        }
        if (this.url != null) {
            Environment env = new Environment();
            env.setProviderUrl(this.url);
            env.setSecurityPrincipal(this.username);
            env.setSecurityCredentials(this.password);
            try {
                Authenticate.authenticate(env, this.subject);
            }
            catch (RemoteException re) {
                this.log("UsernamePasswordLoginModule Error: Remote Exception on authenticate, " + re.getMessage());
                throw new LoginException(re.toString());
            }
            catch (IOException ioe) {
                this.log("UsernamePasswordLoginModule Error: IO Exception on authenticate, " + ioe.getMessage());
                throw new LoginException(ioe.toString());
            }
            catch (LoginException le) {
                this.log("UsernamePasswordLoginModule Error: Login Exception on authenticate, " + le.getMessage());
                throw new LoginException(le.toString());
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.succeeded) {
            final PasswordCredential passwordCred = new PasswordCredential(this.username, this.password);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UsernamePasswordLoginModule.this.subject.getPrivateCredentials().add(passwordCred);
                    return null;
                }
            });
            this.url = null;
            this.commitSucceeded = true;
            return true;
        }
        this.username = null;
        this.password = null;
        this.url = null;
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.url = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.succeeded = false;
        this.commitSucceeded = false;
        this.username = null;
        this.password = null;
        this.url = null;
        try {
            Authenticate.logout(this.subject);
        }
        catch (LoginException loginException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void log(String msg) {
        if (log != null) {
            log.debug(msg);
        } else {
            System.out.println(msg);
        }
    }

    static {
        SubjectManager.ensureInitialized();
        log = LoggerWrapper.getInstance("SecurityAtn");
    }
}

