/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth.callback;

import weblogic.security.auth.callback.IdentityDomainNames;

public class IdentityDomainNamesEncoder {
    public static final String IDD_USER_GRP_NAME_PREFIX = "_#NAM#_";
    public static final String IDD_DOMAIN_NAME_PREFIX = "_#IDD#_";
    private static final String IDD_NULL_NAME = "_#NULL#_";
    private static final int IDD_USER_GRP_NAME_LEN = "_#NAM#_".length();
    private static final int IDD_DOMAIN_NAME_LEN = "_#IDD#_".length();

    public static String encodeNames(String name, String identityDomain) throws IllegalArgumentException {
        String localName = name == null ? IDD_NULL_NAME : name;
        String localIdd = identityDomain == null ? IDD_NULL_NAME : identityDomain;
        return IDD_USER_GRP_NAME_PREFIX + localName + IDD_DOMAIN_NAME_PREFIX + localIdd;
    }

    public static IdentityDomainNames decodeNames(String encodedNames) throws IllegalArgumentException {
        IdentityDomainNamesEncoder.validate(encodedNames);
        if (!IdentityDomainNamesEncoder.isEncodedNames(encodedNames)) {
            throw new IllegalArgumentException("no encoded names");
        }
        String name = null;
        String iddName = null;
        int iddDomainInx = encodedNames.indexOf(IDD_DOMAIN_NAME_PREFIX, IDD_USER_GRP_NAME_LEN);
        if (iddDomainInx == -1) {
            throw new IllegalArgumentException("improperly encoded names");
        }
        name = encodedNames.substring(IDD_USER_GRP_NAME_LEN, iddDomainInx);
        iddName = encodedNames.substring(iddDomainInx + IDD_DOMAIN_NAME_LEN);
        name = name.equals(IDD_NULL_NAME) ? null : name;
        iddName = iddName.equals(IDD_NULL_NAME) ? null : iddName;
        return new IdentityDomainNames(name, iddName);
    }

    public static boolean isEncodedNames(String test) throws IllegalArgumentException {
        IdentityDomainNamesEncoder.validate(test);
        return test.startsWith(IDD_USER_GRP_NAME_PREFIX);
    }

    private static void validate(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("String cannot be null or empty");
        }
    }
}

