/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.net.InetAddress;
import weblogic.security.HMAC;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;

public class AuthenticatedUser
implements UserInfo {
    private static final long serialVersionUID = 6699361079932480379L;
    public static final String REALM_NAME = "wl_realm";
    private long timeStamp;
    private String name;
    private byte[] signature;
    private byte qos = (byte)101;
    private InetAddress inetAddress = null;
    private InetAddress localAddress = null;
    private int localPort = -1;
    private transient Object sslCertificate = null;

    public AuthenticatedUser() {
    }

    public AuthenticatedUser(String n, String secret) {
        this.timeStamp = System.currentTimeMillis();
        this.name = n;
        if (secret != null) {
            this.signature = HMAC.digest(this.name.getBytes(), secret.getBytes(), String.valueOf(this.timeStamp).getBytes());
        }
    }

    public AuthenticatedUser(String n, String secret, long tmStamp) {
        this.timeStamp = tmStamp;
        this.name = n;
        if (secret != null) {
            this.signature = HMAC.digest(this.name.getBytes(), secret.getBytes(), String.valueOf(this.timeStamp).getBytes());
        }
    }

    public AuthenticatedUser(String name, byte[] signature, byte[] salt) {
        this.name = name;
        this.signature = signature;
        this.timeStamp = Long.parseLong(new String(salt));
    }

    public AuthenticatedUser(AuthenticatedUser au) {
        this.timeStamp = au.timeStamp;
        this.name = au.name;
        this.signature = au.signature;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRealmName() {
        return REALM_NAME;
    }

    public final boolean verify(String secret) {
        Class<?> ourClass = this.getClass();
        if (ourClass.equals(AuthenticatedSubject.class)) {
            return true;
        }
        return ourClass.equals(AuthenticatedUser.class) && secret != null && HMAC.verify(this.signature, this.name.getBytes(), secret.getBytes(), String.valueOf(this.timeStamp).getBytes());
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof AuthenticatedUser)) {
            return false;
        }
        AuthenticatedUser other = (AuthenticatedUser)o;
        if (this.signature == null) {
            if (other.signature != null) {
                return false;
            }
        } else {
            if (other.signature == null) {
                return false;
            }
            if (this.signature.length != other.signature.length) {
                return false;
            }
            for (int x = 0; x < this.signature.length; ++x) {
                if (this.signature[x] == other.signature[x]) continue;
                return false;
            }
        }
        return this.name.equals(other.name) && this.qos == other.qos && (this.inetAddress == null ? other.inetAddress == null : this.inetAddress.equals(other.inetAddress)) && (this.localAddress == null ? other.localAddress == null : this.localAddress.equals(other.localAddress)) && this.localPort == other.localPort && (this.sslCertificate == null ? other.sslCertificate == null : this.sslCertificate.equals(other.sslCertificate));
    }

    @Override
    public int hashCode() {
        try {
            return this.name.hashCode() ^ this.qos ^ this.localPort;
        }
        catch (NullPointerException e) {
            throw new RuntimeException(SecurityLogger.getNPEInAUHashCode("" + this.getClass()));
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getSalt() {
        return String.valueOf(this.timeStamp).getBytes();
    }

    public byte getQOS() {
        return this.qos;
    }

    public void setQOS(byte qos) {
        this.qos = qos;
    }
}

