/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.Principal;
import weblogic.security.SimplePrincipal;
import weblogic.security.subject.SubjectManager;

public class WLSPrincipals {
    private static final String USERS_GROUPNAME = "users";
    private static final String ADMINISTRATORS_GROUPNAME = "Administrators";
    private static final String EVERYONE_GROUPNAME = "everyone";
    private static final String ANONYMOUS_ROLENAME = "Anonymous";
    private static final Principal ANONYMOUS_USER_PRINCIPAL = new SimplePrincipal(SubjectManager.ANONYMOUS_USERNAME);

    public static String getAnonymousUsername() {
        return SubjectManager.ANONYMOUS_USERNAME;
    }

    public static String getAdministratorsGroupname() {
        return ADMINISTRATORS_GROUPNAME;
    }

    public static String getUsersGroupname() {
        return USERS_GROUPNAME;
    }

    public static String getEveryoneGroupname() {
        return EVERYONE_GROUPNAME;
    }

    public static String getAnonymousRolename() {
        return ANONYMOUS_ROLENAME;
    }

    public static String getKernelUsername() {
        return "<WLS Kernel>";
    }

    public static Principal getAnonymousUserPrincipal() {
        return ANONYMOUS_USER_PRINCIPAL;
    }

    public static boolean isAnonymousPrincipal(Principal principal) {
        if (principal == null) {
            return true;
        }
        return ANONYMOUS_USER_PRINCIPAL.equals(principal);
    }

    public static boolean isSpecialGroupname(String groupname) {
        return EVERYONE_GROUPNAME.equals(groupname) || USERS_GROUPNAME.equals(groupname);
    }

    public static boolean isAnonymousRolename(String rolename) {
        return ANONYMOUS_ROLENAME.equals(rolename);
    }

    public static boolean isSpecialUsername(String username) {
        return SubjectManager.ANONYMOUS_USERNAME.equals(username) || "<WLS Kernel>".equals(username);
    }

    public static boolean isKernelUsername(String username) {
        return "<WLS Kernel>".equals(username);
    }

    public static boolean isAnonymousUsername(String username) {
        return SubjectManager.ANONYMOUS_USERNAME.equals(username);
    }
}

