/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMAC {
    public static final String HMAC_ALGORITHM = "HmacSHA256";

    public static boolean verify(byte[] signature, byte[] data, byte[] secret, byte[] salt) {
        return Arrays.equals(HMAC.digest(data, secret, salt), signature);
    }

    public static byte[] digest(byte[] data, byte[] secret, byte[] salt) {
        byte[] hmacResult = null;
        try {
            SecretKeySpec key = new SecretKeySpec(secret, HMAC_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(key);
            mac.update(data);
            mac.update(salt);
            hmacResult = mac.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new IllegalStateException(exception);
        }
        return hmacResult;
    }
}

