/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.utils.io;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.PortableServer.Servant;
import weblogic.common.internal.PeerInfo;
import weblogic.rmi.SupportsInterfaceBasedCallByReference;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.ActivatableRemoteReference;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.extensions.server.ClusterAwareRemoteReference;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.SmartStubInfo;
import weblogic.rmi.extensions.server.StubDelegateInfo;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.utils.io.InteropObjectReplacer;
import weblogic.rmi.utils.io.RemoteReplacer;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.io.Replacer;

public final class RemoteObjectReplacer
implements RemoteReplacer {
    private static Replacer REPLACER = new RemoteObjectReplacer();
    private Replacer nextReplacer;

    private RemoteObjectReplacer() {
    }

    public static Replacer getReplacer() {
        return REPLACER;
    }

    public static Replacer getReplacer(PeerInfo info) {
        return new InteropObjectReplacer(info);
    }

    @Override
    public void insertReplacer(Replacer replacer) {
        replacer.insertReplacer(this.nextReplacer);
        this.nextReplacer = replacer;
    }

    private static boolean isRemote(java.lang.Object o) {
        return o instanceof Remote || o instanceof Object && (!(o instanceof IDLEntity) || o instanceof Servant || o instanceof InvokeHandler);
    }

    @Override
    public java.lang.Object replaceObject(java.lang.Object o) throws IOException {
        java.lang.Object replacement = o == null ? null : (o instanceof Proxy ? o : (o instanceof SmartStubInfo ? RemoteObjectReplacer.replaceSmartStubInfo(o) : (RemoteObjectReplacer.isRemote(o) ? RemoteObjectReplacer.replaceRemote(o) : (o instanceof Throwable ? RemoteObjectReplacer.replaceThrowable(o) : (this.nextReplacer == null ? o : this.nextReplacer.replaceObject(o))))));
        return replacement;
    }

    private static java.lang.Object replaceSmartStubInfo(java.lang.Object o) throws RemoteException {
        java.lang.Object obj = StubFactory.getStub(OIDManager.getInstance().getReplacement(o));
        return ((SmartStubInfo)o).getSmartStub(obj);
    }

    private static StubReference replaceRemote(java.lang.Object o) throws RemoteException {
        if (o instanceof StubInfoIntf) {
            return ((StubInfoIntf)o).getStubInfo();
        }
        return OIDManager.getInstance().getReplacement(o);
    }

    private static java.lang.Object replaceThrowable(java.lang.Object o) {
        if (o instanceof NamingException) {
            NamingException ne = (NamingException)o;
            java.lang.Object nested = ne.getResolvedObj();
            if (nested != null && !(nested instanceof Serializable)) {
                nested = nested.toString();
            }
            ne.setResolvedObj(nested);
        }
        return o;
    }

    @Override
    public java.lang.Object resolveObject(java.lang.Object o) throws IOException {
        java.lang.Object resolved = o;
        if (o == null) {
            resolved = o;
        } else if (o instanceof StubDelegateInfo) {
            resolved = RemoteObjectReplacer.resolveStubDelegateInfo(o);
        }
        return this.nextReplacer == null ? resolved : this.nextReplacer.resolveObject(resolved);
    }

    private static java.lang.Object resolveStubDelegateInfo(java.lang.Object o) {
        StubDelegateInfo smartStub = (StubDelegateInfo)o;
        java.lang.Object impl = smartStub.getStubDelegate();
        if (impl instanceof StubInfoIntf) {
            return o;
        }
        return impl;
    }

    @Override
    public java.lang.Object resolveStub(StubReference reference) throws RemoteException {
        return RemoteObjectReplacer.resolveStubInfo(reference);
    }

    public static java.lang.Object resolveStubInfo(StubReference o) throws RemoteException {
        StubInfo info = (StubInfo)o;
        RemoteReference ror = info.getRemoteRef();
        if (ror.getObjectID() == -1) {
            return StubFactory.getStub(info);
        }
        if (!ror.getHostID().isLocal()) {
            return StubFactory.getStub(info);
        }
        ServerReference serverRef = OIDManager.getInstance().getServerReference(ror.getObjectID());
        RuntimeDescriptor desc = serverRef.getDescriptor();
        if (RemoteObjectReplacer.isFromDifferentApp(serverRef) || desc.getEnableServerSideStubs() || desc.hasCustomMethodDescriptors()) {
            if (ror instanceof ClusterAwareRemoteReference) {
                info.setRemoteRef(((ClusterAwareServerReference)serverRef).getGenericReplicaAwareRemoteRef());
            }
            return StubFactory.getStub(info);
        }
        java.lang.Object resolved = serverRef instanceof ActivatableServerReference ? ((ActivatableServerReference)serverRef).getImplementation(((ActivatableRemoteReference)ror).getActivationID()) : serverRef.getImplementation();
        if (desc.getEnforceCallByValue()) {
            return CBVWrapper.getCBVWrapper(desc, resolved);
        }
        return resolved;
    }

    private static boolean isFromDifferentApp(ServerReference ref) {
        if (ref.getObjectID() < 256) {
            return false;
        }
        ClassLoader implCL = ref.getApplicationClassLoader();
        if (implCL == null) {
            return false;
        }
        ClassLoader callerCL = Thread.currentThread().getContextClassLoader();
        if (callerCL == ClassLoader.getSystemClassLoader() && implCL == ClassLoader.getSystemClassLoader()) {
            return false;
        }
        while (callerCL != null) {
            if (callerCL == implCL) {
                return false;
            }
            callerCL = callerCL.getParent();
        }
        if (ref.getImplementation() instanceof SupportsInterfaceBasedCallByReference) {
            java.lang.Object instance = ((SupportsInterfaceBasedCallByReference)ref.getImplementation()).getInstance();
            return !RemoteObjectReplacer.isCallerParentOfImpl(instance) || !RemoteObjectReplacer.isCallerLoadedAllTheInterfaces(instance);
        }
        return true;
    }

    private static boolean isCallerParentOfImpl(java.lang.Object instance) {
        ClassLoader callerCL = Thread.currentThread().getContextClassLoader();
        for (ClassLoader implCL = instance.getClass().getClassLoader(); implCL != null; implCL = implCL.getParent()) {
            if (callerCL != implCL) continue;
            return true;
        }
        return false;
    }

    private static boolean isInterfaceLoadedByApplicationLoader(Class interfaceClass) {
        Annotation annotation;
        ClassLoader interfaceCL;
        return interfaceClass != null && (interfaceCL = interfaceClass.getClassLoader()) instanceof GenericClassLoader && (annotation = ((GenericClassLoader)interfaceCL).getAnnotation()) != null && annotation.getApplicationName() != null && annotation.getModuleName() == null;
    }

    private static boolean isCallerLoadedAllTheInterfaces(java.lang.Object instance) {
        Class<?>[] interfaces;
        ClassLoader callerCL = Thread.currentThread().getContextClassLoader();
        for (Class<?> anInterface : interfaces = instance.getClass().getInterfaces()) {
            if (!RemoteObjectReplacer.isInterfaceLoadedByApplicationLoader(anInterface)) {
                return false;
            }
            ClassLoader current = callerCL;
            ClassLoader interfaceCL = anInterface.getClassLoader();
            while (current != null && current != interfaceCL) {
                if ((current = current.getParent()) != null) continue;
                return false;
            }
        }
        return true;
    }
}

