/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.utils.enumerations;

import java.util.Enumeration;
import weblogic.rmi.extensions.server.SmartStubInfo;
import weblogic.rmi.utils.enumerations.Batch;
import weblogic.rmi.utils.enumerations.RemoteBatchingEnumeration;

public abstract class BatchingEnumerationBase
implements Enumeration,
RemoteBatchingEnumeration,
SmartStubInfo {
    private Object[] batch = null;
    private RuntimeException pendingException;
    private int defaultBatchSize;

    @Override
    public abstract Object getSmartStub(Object var1);

    @Override
    public abstract boolean hasMoreElements();

    public abstract Object nextElement();

    @Override
    public Enumeration nextBatch(int batchSize) {
        if (this.pendingException != null) {
            throw this.pendingException;
        }
        int index = 0;
        if (this.batch == null || this.batch.length < batchSize) {
            this.batch = new Object[batchSize];
        }
        try {
            while (this.hasMoreElements() && index < batchSize) {
                this.batch[index] = this.nextElement();
                ++index;
            }
        }
        catch (RuntimeException e) {
            if (index > 0) {
                this.pendingException = e;
            }
            throw e;
        }
        batchSize = index;
        while (index < this.batch.length) {
            this.batch[index] = null;
            ++index;
        }
        return new Batch(this.batch, batchSize);
    }
}

