/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.omg.CORBA.Object;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.Remote;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.utils.WLRMIClassLoaderDelegate;
import weblogic.utils.NestedError;
import weblogic.utils.annotation.BeaSynthetic;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.reflect.MethodSignatureBuilder;
import weblogic.utils.reflect.UniqueMethod;

public final class Utilities {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";
    private static Class[] stringExceptionExceptionConstructorSig = new Class[2];
    private static Class[] stringExceptionConstructorSig = new Class[1];
    private static Class[] stringStringExceptionConstructorSig = new Class[2];
    private static Class[] stringErrorExceptionConstructorSig = new Class[2];
    private static Class[] stringThrowableExceptionConstructorSig = new Class[2];
    private static Class alreadyBoundEx;
    private static Class noSuchObjectEx;
    private static Class notBoundEx;
    private static Class serverNotActiveEx;
    private static Class skeletonMismatchEx;
    private static Class rmiSecurityEx;
    private static Class serverErr;
    private static Class theOtherRemote;
    private static ClassLoader classLoader;

    public static void setClassLoader(ClassLoader cl) {
        classLoader = cl;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static Throwable theOtherException(RemoteException re) {
        Class<?> mapableClass;
        for (mapableClass = re.getClass(); mapableClass != null && !mapableClass.getName().startsWith("java.rmi"); mapableClass = mapableClass.getSuperclass()) {
        }
        while (mapableClass != null) {
            if (mapableClass.getName().startsWith("java.rmi.")) {
                try {
                    String newClassName = "weblogic." + mapableClass.getName().substring("java.".length());
                    Class newClass = Utilities.classForName(newClassName, re.getClass());
                    if (newClass.equals(alreadyBoundEx) || newClass.equals(noSuchObjectEx) || newClass.equals(notBoundEx) || newClass.equals(serverNotActiveEx) || newClass.equals(skeletonMismatchEx)) {
                        Constructor constructor = newClass.getConstructor(stringExceptionConstructorSig);
                        java.lang.Object[] parameters = new java.lang.Object[]{"WebLogic RemoteException(" + re.getClass().getName() + ") remapped from:" + re.toString()};
                        return (Throwable)constructor.newInstance(parameters);
                    }
                    if (newClass.equals(rmiSecurityEx)) {
                        Constructor constructor = newClass.getConstructor(stringStringExceptionConstructorSig);
                        java.lang.Object[] parameters = new java.lang.Object[]{"WebLogic RemoteException(" + re.getClass().getName() + ") remapped from:" + re.toString(), null};
                        return (Throwable)constructor.newInstance(parameters);
                    }
                    if (newClass.equals(serverErr)) {
                        Constructor constructor = newClass.getConstructor(stringErrorExceptionConstructorSig);
                        java.lang.Object[] parameters = new java.lang.Object[]{"WebLogic RemoteException(" + re.getClass().getName() + ") remapped from:" + re.toString(), re.detail instanceof Error ? re : new NestedError(re)};
                        return (Throwable)constructor.newInstance(parameters);
                    }
                    Constructor constructor = newClass.getConstructor(stringExceptionExceptionConstructorSig);
                    java.lang.Object[] parameters = new java.lang.Object[]{"WebLogic RemoteException(" + re.getClass().getName() + ") remapped from:" + re.toString(), re};
                    return (Throwable)constructor.newInstance(parameters);
                }
                catch (ClassNotFoundException newClassName) {
                }
                catch (IllegalArgumentException newClassName) {
                }
                catch (InvocationTargetException newClassName) {
                }
                catch (IllegalAccessException newClassName) {
                }
                catch (NoSuchMethodException newClassName) {
                }
                catch (InstantiationException newClassName) {
                    // empty catch block
                }
            }
            mapableClass = mapableClass.getSuperclass();
        }
        try {
            Class newClass = Utilities.classForName("weblogic.rmi.RemoteException", null);
            Constructor constructor = newClass.getConstructor(stringThrowableExceptionConstructorSig);
            java.lang.Object[] parameters = new java.lang.Object[]{"WebLogic RemoteException(" + re.getClass().getName() + ") remapped from:" + re.toString(), re};
            return (Throwable)constructor.newInstance(parameters);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return re;
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        return Utilities.classForName(className, null);
    }

    public static Class classForName(String className, Class parent) throws ClassNotFoundException {
        ClassLoader loader = parent != null ? parent.getClassLoader() : null;
        try {
            return loader == null ? Class.forName(className) : loader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (classLoader != null) {
                return classLoader.loadClass(className);
            }
            throw cnfe;
        }
    }

    public static boolean isARemote(Class c) {
        boolean result = true;
        result = java.rmi.Remote.class.equals((java.lang.Object)c) || Remote.class.equals((java.lang.Object)c) ? false : java.rmi.Remote.class.isAssignableFrom(c) || Object.class.isAssignableFrom(c);
        return result;
    }

    public static boolean areEquivalent(Method a, Method b) {
        Class<?>[] bParams;
        Class<?>[] aParams;
        if (a.getName().equals(b.getName()) && (aParams = a.getParameterTypes()).length == (bParams = b.getParameterTypes()).length) {
            for (int i = 0; i < aParams.length; ++i) {
                if (aParams[i] == bParams[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final Class loadClass(String className, String annotation, String remoteCodebase, ClassLoader loadingContext) throws ClassNotFoundException {
        if (KernelStatus.isApplet()) {
            return Class.forName(className);
        }
        if (loadingContext == null && KernelStatus.isServer() && annotation != null) {
            loadingContext = WLRMIClassLoaderDelegate.getInstance().findClassLoader(annotation);
        }
        if (loadingContext == null) {
            loadingContext = Thread.currentThread().getContextClassLoader();
        }
        if (loadingContext == null) {
            loadingContext = Utilities.class.getClassLoader();
        }
        String codebaseURL = null;
        if (remoteCodebase != null) {
            codebaseURL = remoteCodebase;
            if (annotation != null && annotation.length() > 0) {
                codebaseURL = remoteCodebase + annotation;
            }
        } else if (annotation != null && annotation.length() > 0) {
            codebaseURL = annotation;
        }
        GenericClassLoader gcl = AugmentableClassLoaderManager.getAugmentableClassLoader(loadingContext);
        try {
            return WLRMIClassLoaderDelegate.getInstance().loadClass(codebaseURL, className, gcl);
        }
        catch (MalformedURLException mue) {
            throw new ClassNotFoundException("Failed to load class " + className + " from " + remoteCodebase, mue);
        }
        catch (ClassNotFoundException cnfe) {
            if (annotation != null && annotation.length() > 0) {
                WLRMIClassLoaderDelegate.getInstance();
                return WLRMIClassLoaderDelegate.loadClass(codebaseURL, annotation, className, gcl);
            }
            throw cnfe;
        }
    }

    public static String getAnnotationString(java.lang.Object o) {
        ClassLoader cl = o.getClass().getClassLoader();
        if (cl instanceof GenericClassLoader) {
            return ((GenericClassLoader)cl).getAnnotation().getAnnotationString();
        }
        return null;
    }

    public static final Class loadClass(String className, String remoteCodebase, ClassLoader loadingContext) throws ClassNotFoundException {
        return Utilities.loadClass(className, null, remoteCodebase, loadingContext);
    }

    public static final Class loadClass(String className, String remoteCodebase) throws ClassNotFoundException {
        return Utilities.loadClass(className, null, remoteCodebase, null);
    }

    public static final Class loadClass(String className, String annotation, String remoteCodebase) throws ClassNotFoundException {
        return Utilities.loadClass(className, annotation, remoteCodebase, null);
    }

    public static Method[] getRemoteRMIMethods(Class[] interfaces) {
        Map<String, Method> map = Utilities.getRemoteMethodsAndSignatures(interfaces, Object.class);
        Method[] methods = new Method[map.size()];
        return map.values().toArray(methods);
    }

    public static Map<String, Method> getRemoteMethodsAndSignatures(Class[] interfaces) {
        return Utilities.getRemoteMethodsAndSignatures(interfaces, null);
    }

    public static Map<String, Method> getRemoteMethodsAndSignatures(Class[] interfaces, Class ignoreThis) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class c : interfaces) {
            Method[] mArray;
            if (c == StubInfoIntf.class || c == ignoreThis) continue;
            for (Method m : mArray = c.getMethods()) {
                if (BeaSynthetic.Helper.isBeaSyntheticMethod(m) || m.getDeclaringClass() == ignoreThis) continue;
                methods.add(UniqueMethod.intern(m));
            }
        }
        TreeMap<String, Method> sigMap = new TreeMap<String, Method>();
        for (Method m : methods) {
            String signature = MethodSignatureBuilder.compute(m);
            sigMap.put(signature, m);
        }
        return sigMap;
    }

    public static String[] getRemoteInterfaceNames(Class remoteClass) {
        return Utilities.getRemoteInterfaceNames(Utilities.getRemoteInterfaces(remoteClass));
    }

    public static String[] getRemoteInterfaceNames(Class[] remoteInterfaces) {
        String[] interfaceNames = new String[remoteInterfaces.length + 1];
        for (int i = 0; i < remoteInterfaces.length; ++i) {
            interfaceNames[i] = remoteInterfaces[i].getName();
        }
        interfaceNames[remoteInterfaces.length] = StubInfoIntf.class.getName();
        return interfaceNames;
    }

    public static Class[] getRemoteInterfaces(Class remoteClass) {
        if (null == remoteClass) {
            return new Class[0];
        }
        ArrayList s = new ArrayList();
        if (remoteClass.isInterface()) {
            s.add(remoteClass);
        }
        for (Class c = remoteClass; c != null; c = c.getSuperclass()) {
            Utilities.addSuperRemoteInterfaces(c, s);
        }
        return s.toArray(new Class[s.size()]);
    }

    private static void addSuperRemoteInterfaces(Class c, ArrayList s) {
        Class<?>[] is = c.getInterfaces();
        for (int i = 0; i < is.length; ++i) {
            if (!Utilities.isARemote(is[i])) continue;
            if (!s.contains(is[i])) {
                s.add(is[i]);
            }
            Utilities.addSuperRemoteInterfaces(is[i], s);
        }
    }

    static {
        classLoader = null;
        Utilities.stringExceptionExceptionConstructorSig[0] = String.class;
        Utilities.stringExceptionExceptionConstructorSig[1] = Exception.class;
        Utilities.stringExceptionConstructorSig[0] = String.class;
        Utilities.stringStringExceptionConstructorSig[0] = String.class;
        Utilities.stringStringExceptionConstructorSig[1] = String.class;
        Utilities.stringErrorExceptionConstructorSig[0] = String.class;
        Utilities.stringErrorExceptionConstructorSig[1] = Error.class;
        Utilities.stringThrowableExceptionConstructorSig[0] = String.class;
        Utilities.stringThrowableExceptionConstructorSig[1] = Throwable.class;
        try {
            theOtherRemote = Class.forName("weblogic.rmi.Remote");
        }
        catch (Exception e) {
            throw new Error(e);
        }
        try {
            alreadyBoundEx = Class.forName("weblogic.rmi.AlreadyBoundException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            noSuchObjectEx = Class.forName("weblogic.rmi.NoSuchObjectException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            notBoundEx = Class.forName("weblogic.rmi.NotBoundException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverNotActiveEx = Class.forName("weblogic.rmi.server.ServerNotActiveException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            skeletonMismatchEx = Class.forName("weblogic.rmi.server.SkeletonMismatchException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            rmiSecurityEx = Class.forName("weblogic.rmi.RMISecurityException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverErr = Class.forName("weblogic.rmi.ServerError");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

