/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.registry;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.protocol.ServerURL;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rmi.JndiInfo;
import weblogic.rmi.JndiNamingInfo;
import weblogic.rmi.ProviderUrlInfo;

public final class LocateRegistry
implements Registry {
    private ProviderUrlInfo providerUrlInfo;

    private LocateRegistry(ServerURL url) throws NamingException {
        this.providerUrlInfo = (ProviderUrlInfo)JndiInfo.parse(url, true);
    }

    private LocateRegistry() throws NamingException {
        this(ServerURL.DEFAULT_URL);
    }

    private LocateRegistry(int i) throws MalformedURLException, NamingException {
        this(new ServerURL(RJVMEnvironment.getEnvironment().getDefaultProtocolName(), ServerURL.DEFAULT_URL.getHost(), i, ""));
    }

    private LocateRegistry(String name, int i) throws MalformedURLException, NamingException {
        this(new ServerURL(RJVMEnvironment.getEnvironment().getDefaultProtocolName(), name, i, ""));
    }

    private LocateRegistry(String name) throws MalformedURLException, NamingException {
        this(LocateRegistry.getServerURL(name));
    }

    @Override
    public Remote lookup(String name) throws RemoteException, NotBoundException {
        Remote o;
        try {
            JndiNamingInfo bindInfo = this.providerUrlInfo.parse(name);
            Context context = bindInfo.getContext();
            o = (Remote)context.lookup(bindInfo.getPath());
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Bad url in lookup for " + name, mue);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            if (ne instanceof NameNotFoundException) {
                throw new NotBoundException(name);
            }
            throw new UnknownHostException("Failed lookup for " + name, ne);
        }
        return o;
    }

    @Override
    public void bind(String name, Remote o) throws RemoteException, AlreadyBoundException {
        try {
            JndiNamingInfo bindInfo = this.providerUrlInfo.parse(name);
            bindInfo.getContext().bind(bindInfo.getPath(), (Object)o);
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Bad url in bind for " + name, mue);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            if (ne instanceof NameAlreadyBoundException) {
                throw new AlreadyBoundException(name);
            }
            throw new UnknownHostException("Failed bind for " + name, ne);
        }
    }

    @Override
    public void unbind(String name) throws RemoteException, NotBoundException {
        try {
            JndiNamingInfo bindInfo = this.providerUrlInfo.parse(name);
            bindInfo.getContext().unbind(bindInfo.getPath());
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Bad url in unbind for " + name, mue);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            if (ne instanceof NameNotFoundException) {
                throw new NotBoundException(name);
            }
            throw new UnknownHostException("Failed unbind for " + name, ne);
        }
    }

    @Override
    public void rebind(String name, Remote o) throws RemoteException {
        try {
            JndiNamingInfo bindInfo = this.providerUrlInfo.parse(name);
            bindInfo.getContext().rebind(bindInfo.getPath(), (Object)o);
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Bad url in rebind for " + name, mue);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Failed rebind for " + name, ne);
        }
    }

    @Override
    public String[] list() throws RemoteException {
        String[] results = new String[]{};
        try {
            ArrayList<String> set = new ArrayList<String>();
            NamingEnumeration<NameClassPair> e = this.providerUrlInfo.getContext().list("");
            while (e.hasMore()) {
                String binding_name = e.next().getName();
                set.add(this.providerUrlInfo.getFullURL(binding_name));
            }
            if (set.size() == 0) {
                return results;
            }
            results = new String[set.size()];
            set.toArray(results);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Failed list for [weblogic.rmi]", ne);
        }
        return results;
    }

    public static Registry getRegistry() throws RemoteException {
        try {
            return new LocateRegistry();
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Bad URL for " + ServerURL.DEFAULT_URL, ne);
        }
    }

    public static Registry getRegistry(int port) throws RemoteException {
        try {
            return new LocateRegistry(port);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Could not connect to localhost at port " + port, ne);
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Could not connect to port " + port + " on local host", mue);
        }
    }

    public static Registry getRegistry(String name) throws RemoteException {
        try {
            return new LocateRegistry(name);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Could not connect to " + name, ne);
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Could not connect to " + name + " on local host", mue);
        }
    }

    public static Registry getRegistry(String name, int port) throws RemoteException {
        try {
            return new LocateRegistry(name, port);
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Could not connect to " + name + " at port " + port, ne);
        }
        catch (MalformedURLException mue) {
            throw new UnknownHostException("Could not connect to port " + port + " on local host", mue);
        }
    }

    public static Registry createRegistry(int port) throws RemoteException {
        try {
            return new LocateRegistry();
        }
        catch (NamingException ne) {
            if (ne.getRootCause() != null && ne.getRootCause() instanceof RemoteException) {
                throw (RemoteException)ne.getRootCause();
            }
            throw new UnknownHostException("Could not connect to port " + port + " on local host", ne);
        }
    }

    public static String getURL(ServerURL url) {
        if (url.getQuery().equals("")) {
            return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        }
        return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getQuery();
    }

    public static ServerURL getServerURL(String name) throws MalformedURLException {
        if (name.startsWith("rmi://")) {
            return new ServerURL(ServerURL.DEFAULT_URL, RJVMEnvironment.getEnvironment().getDefaultProtocolName() + name.substring(3));
        }
        if (name.startsWith("rmis://")) {
            return new ServerURL(ServerURL.DEFAULT_URL, RJVMEnvironment.getEnvironment().getDefaultProtocolName() + name.substring(4));
        }
        if (name.startsWith("//")) {
            return new ServerURL(ServerURL.DEFAULT_URL, RJVMEnvironment.getEnvironment().getDefaultProtocolName() + ":" + name);
        }
        if (!name.contains(":/")) {
            return new ServerURL(ServerURL.DEFAULT_URL, RJVMEnvironment.getEnvironment().getDefaultProtocolName() + ":" + name);
        }
        return new ServerURL(ServerURL.DEFAULT_URL, name);
    }
}

