/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.wls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.jndi.Environment;
import weblogic.kernel.Kernel;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.CBVInput;
import weblogic.rmi.internal.CBVOutput;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.DefaultCBVInput;
import weblogic.rmi.internal.DefaultCBVOutput;
import weblogic.rmi.internal.DefaultExecuteRequest;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.wls.CEReferenceHelperImpl;
import weblogic.rmi.internal.wls.ClientRMIBehavior;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.XXEUtils;
import weblogic.work.Work;

public class WLSClientRMIEnvironment
extends RMIEnvironment {
    private static final String WLS_STUB_VERSION;
    private static final String DEFAULT_STUB_VERSION;
    private static final String DEFAULT_SYSTEM_SECURITY = "supported";
    private static final int DEFAULT_TRAN_TIMEOUT = 30000;
    private static final boolean SECURITY_MANAGER_ENABLED;

    public WLSClientRMIEnvironment() {
        ReferenceHelper.setReferenceHelper(new CEReferenceHelperImpl());
    }

    @Override
    public long getTimedOutRefIsolationTime() {
        return Kernel.getConfig().getTimedOutRefIsolationTime();
    }

    @Override
    public boolean isTracingEnabled() {
        return Kernel.isTracingEnabled();
    }

    @Override
    public String getIIOPSystemSecurity() {
        return DEFAULT_SYSTEM_SECURITY;
    }

    @Override
    public boolean isLogRemoteExceptions() {
        return Kernel.getConfig().isLogRemoteExceptionsEnabled();
    }

    @Override
    public int getHeartbeatPeriodLength() {
        return Kernel.getConfig().getPeriodLength();
    }

    @Override
    public boolean isRefreshClientRuntimeDescriptor() {
        return Kernel.getConfig().getRefreshClientRuntimeDescriptor();
    }

    @Override
    public int getDGCIdlePeriodsUntilTimeout() {
        return Kernel.getConfig().getDGCIdlePeriodsUntilTimeout();
    }

    @Override
    public boolean isInstrumentStackTrace() {
        return Kernel.getConfig().isInstrumentStackTraceEnabled();
    }

    @Override
    public boolean isNetworkClassLoadingEnabled() {
        ClientRMIBehavior clientRMIBehavior = SECURITY_MANAGER_ENABLED ? ClientRMIBehavior.WITH_SECURITY_MANAGER : ClientRMIBehavior.WITHOUT_SECURITY_MANAGER;
        return clientRMIBehavior.isNetworkClassLoadingEnabled();
    }

    @Override
    public boolean printExceptionStackTrace() {
        return true;
    }

    @Override
    public int getTransactionTimeoutMillis() {
        return 30000;
    }

    @Override
    public String getStubVersion() {
        return DEFAULT_STUB_VERSION;
    }

    @Override
    public CBVInput getCBVInput(CBVInputStream cbv, InputStream in) throws IOException {
        return new DefaultCBVInput(cbv, in);
    }

    @Override
    public CBVOutput getCBVOutput(CBVOutputStream cbv, OutputStream out) throws IOException {
        return new DefaultCBVOutput(cbv, out);
    }

    @Override
    @Deprecated
    public Parser getSAXParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = XXEUtils.createSAXParserFactoryInstance();
        factory.setValidating(true);
        SAXParser parser = factory.newSAXParser();
        Parser ret = parser.getParser();
        ret.setEntityResolver(new DefaultRMIEntityResolver());
        ret.setErrorHandler(new DefaultErrorHandler());
        return ret;
    }

    @Override
    public Work createExecuteRequest(BasicServerRef ref, InboundRequest ir, RuntimeMethodDescriptor currentMD, InvokeHandler invoker, AuthenticatedSubject as) {
        return new DefaultExecuteRequest(ref, ir, currentMD, invoker, as);
    }

    @Override
    public ClusterAwareServerReference createClusteredServerRef(InvokableServerReference ref) {
        throw new AssertionError((Object)"Clustering not supported");
    }

    @Override
    public String getIIOPMangledName(Method method, Class klass) {
        throw new AssertionError((Object)"RMI over IIOP not supported");
    }

    @Override
    public boolean isIIOPResponse(Object obj) {
        return false;
    }

    @Override
    public Object replaceSpecialCBVObject(Object obj) {
        return null;
    }

    @Override
    public ClassLoader getDescriptorClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean isIIOPHostID(HostID hostID) {
        return false;
    }

    @Override
    public Context getContext(Object env) throws NamingException {
        return ((Environment)env).getContext(null);
    }

    @Override
    public boolean isIIOPVendorInfoCluster(ReplicaList replicaList) {
        return false;
    }

    @Override
    public boolean isIIOPInboundRequest(InboundRequest request) {
        return false;
    }

    @Override
    public Object newEnvironment() {
        try {
            Class<?> c = Class.forName("weblogic.jndi.Environment");
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            return constructor.newInstance(null);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Object threadEnvironmentGet() {
        try {
            Class<?> c = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Method method = c.getMethod("get", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Object threadEnvironmentGetProperties() {
        try {
            Class<?> c = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Method method = c.getMethod("getEnvironmentProperties", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Object threadEnvironmentPop() {
        try {
            Class<?> c = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Method method = c.getMethod("pop", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void threadEnvironmentPush(Object env) {
        try {
            Class<?> c = Class.forName("weblogic.jndi.internal.ThreadEnvironment");
            Class<?> classEnvironment = Class.forName("weblogic.jndi.Environment");
            Class[] argTypes = new Class[]{classEnvironment};
            Method method = c.getMethod("push", argTypes);
            Object[] args = new Object[]{env};
            method.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Hashtable getProperties(Object env) {
        return ((Environment)env).getProperties();
    }

    @Override
    public boolean isAdminModeAccessException(NamingException ne) {
        return false;
    }

    @Override
    public String getClusterDefaultLoadAlgorithm() {
        return "round-robin";
    }

    @Override
    public boolean isMigratableActivatingException(RemoteException re) {
        return false;
    }

    @Override
    public boolean isMigratableInactiveException(RemoteException re) {
        return false;
    }

    @Override
    public boolean isServerInCluster() {
        return false;
    }

    @Override
    public AuthenticatedSubject getCurrentSubjectForWire(AuthenticatedSubject kernelID) {
        return SecurityServiceManager.getCurrentSubjectForWire(kernelID);
    }

    @Override
    public boolean rmiShutdownAcceptRequest(int oid, AuthenticatedSubject subject) {
        return true;
    }

    @Override
    public boolean nonTxRmiShutdownAcceptRequest(int oid, AuthenticatedSubject subject, Object obj) {
        return true;
    }

    @Override
    public Hashtable getFromThreadLocalMap() {
        try {
            Class<?> c = Class.forName("weblogic.jndi.ThreadLocalMap");
            Method method = c.getMethod("get", null);
            return (Hashtable)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Hashtable popFromThreadLocalMap() {
        try {
            Class<?> c = Class.forName("weblogic.jndi.ThreadLocalMap");
            Method method = c.getMethod("pop", null);
            return (Hashtable)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void pushIntoThreadLocalMap(Hashtable env) {
        try {
            Class<?> c = Class.forName("weblogic.jndi.ThreadLocalMap");
            Class<?> classEnvironment = Class.forName("java.util.Hashtable");
            Class[] argTypes = new Class[]{classEnvironment};
            Method method = c.getMethod("push", argTypes);
            Object[] args = new Object[]{env};
            method.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Object doInteropWriteReplace(Object me, PeerInfo info, int oid, Object activationID) throws RemoteException {
        if (info.getMajor() == 6 && info.getMinor() == 1) {
            throw new AssertionError((Object)"Release 6.1 is not supported");
        }
        return me;
    }

    @Override
    public boolean isRemoteDomain(String url) throws IOException, RemoteException {
        throw new AssertionError((Object)"It is not supported in the thin client");
    }

    @Override
    public void certificateValidate(InboundRequest request, int oid) throws RemoteException {
    }

    @Override
    public boolean isRemoteAnonymousRMIT3Enabled() {
        return true;
    }

    @Override
    public void validateAuthenticatedUser(Object user) {
    }

    @Override
    public String createSignature(String name, String salt) {
        return null;
    }

    @Override
    public boolean verifySignature(String name, String salt, String signature) {
        return false;
    }

    static {
        DEFAULT_STUB_VERSION = WLS_STUB_VERSION = "_" + VersionInfoFactory.getPeerInfo().getMajor() + VersionInfoFactory.getPeerInfo().getMinor() + VersionInfoFactory.getPeerInfo().getServicePack() + VersionInfoFactory.getPeerInfo().getRollingPatch() + "_WLStub";
        SECURITY_MANAGER_ENABLED = System.getSecurityManager() != null;
    }

    private static final class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }

    private static final class DefaultRMIEntityResolver
    implements EntityResolver {
        private DefaultRMIEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputStream in;
            int last = systemId.lastIndexOf(47);
            String lastPart = last >= 0 ? systemId.substring(last + 1) : systemId;
            if (lastPart != null && lastPart.equals("rmi.dtd") && (in = this.getClass().getClassLoader().getResourceAsStream("weblogic/rmi/internal/rmi.dtd")) != null) {
                return new InputSource(in);
            }
            return null;
        }
    }
}

