/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.wls;

import java.security.AccessController;
import java.security.PrivilegedAction;

enum ClientRMIBehavior {
    WITHOUT_SECURITY_MANAGER{

        @Override
        boolean isNetworkClassLoadingEnabled() {
            return this.getNetworkClassLoadingEnabledValue();
        }
    }
    ,
    WITH_SECURITY_MANAGER{

        @Override
        boolean isNetworkClassLoadingEnabled() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return this.getNetworkClassLoadingEnabledValue();
                }
            });
        }
    };

    private static final String NETWORK_CLASS_LOADING_PROP = "weblogic.rmi.networkclassloadingenabled";
    private static final boolean DEFAULT_NETWORK_CLASS_LOADING = false;

    static ClientRMIBehavior create() {
        return System.getSecurityManager() == null ? WITHOUT_SECURITY_MANAGER : WITH_SECURITY_MANAGER;
    }

    abstract boolean isNetworkClassLoadingEnabled();

    boolean getNetworkClassLoadingEnabledValue() {
        if (System.getProperty(NETWORK_CLASS_LOADING_PROP) == null) {
            return false;
        }
        return Boolean.getBoolean(NETWORK_CLASS_LOADING_PROP);
    }
}

