/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.dgc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ProtocolStack;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.InitialReferenceConstants;
import weblogic.rmi.internal.MethodDescriptor;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.internal.dgc.DGCClientHelper;
import weblogic.rmi.internal.dgc.DGCReferenceCounter;
import weblogic.rmi.internal.dgc.DGCServer;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.NestedException;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class DGCClientImpl
implements NakedTimerListener,
InitialReferenceConstants {
    private static DGCClientImpl theDGCClientImpl = null;
    private static Method renewMethod = null;
    private static final Class[] params = new Class[]{int[].class};
    private Map remoteHostIDMap;
    private static final RuntimeMethodDescriptor renewMD;
    private int periodLengthMillis = this.getPeriodLengthMillis();
    private static final DebugLogger debugDgcEnrollment;
    private static final boolean forceGC;

    public static void initialize() {
        DGCClientImpl.getDGCClientImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DGCClientImpl getDGCClientImpl() {
        if (theDGCClientImpl != null) return theDGCClientImpl;
        Class<DGCClientImpl> clazz = DGCClientImpl.class;
        synchronized (DGCClientImpl.class) {
            if (theDGCClientImpl != null) return theDGCClientImpl;
            theDGCClientImpl = new DGCClientImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theDGCClientImpl;
        }
    }

    private DGCClientImpl() {
        this.remoteHostIDMap = new HashMap();
        TimerManagerFactory.getTimerManagerFactory().getTimerManager("DGCClientImpl", "weblogic.kernel.System").schedule((TimerListener)this, this.periodLengthMillis, (long)this.periodLengthMillis);
    }

    private int getPeriodLengthMillis() {
        int period = RMIEnvironment.getEnvironment().getHeartbeatPeriodLength();
        if (period == 0) {
            period = 60000;
        }
        return this.getTimePeriodToSendGCNotice(period);
    }

    private int getTimePeriodToSendGCNotice(int period) {
        period = RJVMEnvironment.getEnvironment().getRjvmIdleTimeout() > 0 ? (period *= RMIEnvironment.getEnvironment().getDGCIdlePeriodsUntilTimeout()) : (period -= 100);
        return period;
    }

    @Override
    public void timerExpired(Timer t) {
        try {
            long before = 0L;
            if (KernelStatus.DEBUG && debugDgcEnrollment.isDebugEnabled()) {
                before = System.currentTimeMillis();
            }
            if (forceGC) {
                System.gc();
            }
            this.mark();
            if (KernelStatus.DEBUG && debugDgcEnrollment.isDebugEnabled()) {
                long after = System.currentTimeMillis();
                RMILogger.logDebug("Marked in: " + (after - before) + " ms");
            }
        }
        catch (Exception e) {
            RMILogger.logNotMarked(e);
        }
    }

    private void mark() {
        DGCClientHelper.mark(this.remoteHostIDMap);
        Vector heartBeats = DGCClientHelper.getHeartBeats();
        if (heartBeats.size() == 0) {
            return;
        }
        Enumeration e = heartBeats.elements();
        while (e.hasMoreElements()) {
            BasicRemoteRef ref;
            Vector ds = (Vector)e.nextElement();
            if (ds.isEmpty()) continue;
            DGCReferenceCounter counter = (DGCReferenceCounter)ds.elementAt(0);
            HostID hostID = counter.getHostID();
            if (this.remoteHostIDMap.get(hostID) == null) {
                ref = new BasicRemoteRef(2, hostID);
                this.remoteHostIDMap.put(hostID, ref);
            } else {
                ref = (BasicRemoteRef)this.remoteHostIDMap.get(hostID);
            }
            HeartBeat hb = new HeartBeat(ds, KernelStatus.DEBUG && debugDgcEnrollment.isDebugEnabled(), renewMethod, renewMD, ref);
            WorkManagerFactory.getInstance().getSystem().schedule(hb);
        }
    }

    static {
        try {
            renewMethod = DGCServer.class.getMethod("renewLease", params);
        }
        catch (NoSuchMethodException nsoe) {
            throw new AssertionError("Impossible to throw this exception", nsoe);
        }
        renewMD = new MethodDescriptor(renewMethod, DGCServer.class, true, false, false, false, 0, 2, false, "");
        debugDgcEnrollment = DebugLogger.getDebugLogger("DebugDGCEnrollment");
        forceGC = KernelStatus.DEBUG && DebugLogger.getDebugLogger("ForceGCEachDGCPeriod").isDebugEnabled();
    }

    static class InvokeReference
    implements PrivilegedExceptionAction {
        private RemoteReference ref;
        private RuntimeMethodDescriptor md;
        private Object[] args;
        private Method m;
        private String partitionName;

        public InvokeReference(RemoteReference ref, RuntimeMethodDescriptor md, Object[] args, Method m, String partitionName) {
            this.ref = ref;
            this.md = md;
            this.args = args;
            this.m = m;
            this.partitionName = partitionName;
        }

        public Object run() throws Exception {
            try {
                this.ref.invoke(new DGCStub(this.partitionName), this.md, this.args, this.m);
            }
            catch (Throwable t) {
                throw new NestedException(t);
            }
            return null;
        }

        private class DGCStub
        implements Remote,
        StubInfoIntf {
            private String partitionName;

            DGCStub(String partitionName) {
                this.partitionName = partitionName;
            }

            @Override
            public StubInfo getStubInfo() {
                RemoteReference dummyRef = (RemoteReference)Proxy.newProxyInstance(DGCStub.class.getClassLoader(), new Class[]{RemoteReference.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().contains("getHostID")) {
                            return LocalServerIdentity.getIdentity();
                        }
                        return null;
                    }
                });
                return new StubInfo(dummyRef, null, null, null, null, this.partitionName);
            }
        }
    }

    static class HeartBeat
    extends WorkAdapter {
        final Vector acks;
        final Method renewMethod;
        final RuntimeMethodDescriptor renewMD;
        final boolean debug;
        final BasicRemoteRef ref;
        private final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

        HeartBeat(Vector acks, boolean debug, Method m, RuntimeMethodDescriptor md, BasicRemoteRef ref) {
            this.acks = acks;
            this.debug = debug;
            this.ref = ref;
            this.renewMethod = m;
            this.renewMD = md;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HostID hostID = this.ref.getHostID();
            if (this.debug) {
                RMILogger.logDebug("Renewing lease for: " + this.acks.size() + " objects hosted by: " + hostID);
            }
            if (this.ref.getEndPoint() == null || this.ref.getEndPoint().isDead()) {
                RMILogger.logNoConnection(hostID.toString());
                return;
            }
            int[] refs = new int[this.acks.size()];
            int end = this.acks.size();
            for (int i = 0; i < end; ++i) {
                DGCReferenceCounter counter = (DGCReferenceCounter)this.acks.elementAt(i);
                refs[i] = counter.getOID();
                if (this.debug) {
                    RMILogger.logDebug("Renewing lease for: " + counter);
                }
                if (!counter.leaseRenewed()) continue;
                counter.renewLease(false);
            }
            Object[] params = new Object[]{refs};
            String partitionName = ((DGCReferenceCounter)this.acks.elementAt(0)).getPartitionName();
            try {
                Channel channel = this.ref.getChannel();
                String protocolName = channel != null ? channel.getProtocolPrefix() : null;
                Protocol protocol = protocolName != null ? ProtocolManager.getProtocolByName(protocolName) : ProtocolManager.getDefaultProtocol();
                boolean secure = protocol.isSecure();
                ProtocolStack.push(protocol);
                AuthenticatedSubject subject = SubjectUtils.getAnonymousSubject();
                if (secure) {
                    subject = KernelStatus.isServer() ? this.kernelId : RMIEnvironment.getEnvironment().getCurrentSubjectForWire(this.kernelId);
                }
                SecurityManager.runAs(this.kernelId, subject, new InvokeReference(this.ref, this.renewMD, params, this.renewMethod, partitionName));
            }
            catch (Throwable t) {
                if (this.debug) {
                    RMILogger.logFailedRenew(refs.length, hostID.toString());
                }
            }
            finally {
                ProtocolStack.pop();
            }
            if (this.debug) {
                RMILogger.logDebug("Renewed lease for: " + refs.length + " objects hosted by: " + hostID);
            }
        }
    }
}

