/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.activation;

import java.io.IOException;
import java.io.ObjectStreamException;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.extensions.server.ActivatableRemoteReference;
import weblogic.rmi.extensions.server.CollocatedRemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.ServerRequest;
import weblogic.rmi.internal.activation.ActivatableServerRef;
import weblogic.rmi.spi.OutboundRequest;

final class ActivatableCollocatedRef
extends BasicRemoteRef
implements ActivatableRemoteReference,
CollocatedRemoteReference {
    private static final long serialVersionUID = 5777536927492434313L;
    private final ActivatableServerRef sor;
    private final Object aid;

    public ActivatableCollocatedRef(ActivatableServerRef sor, Object aid) {
        super(sor.getObjectID(), LocalServerIdentity.getIdentity());
        this.sor = sor;
        this.aid = aid;
    }

    @Override
    public ServerReference getServerReference() {
        return this.sor;
    }

    @Override
    public Object getActivationID() {
        return this.aid;
    }

    @Override
    public String toString() {
        return super.toString() + " aid " + this.aid;
    }

    @Override
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionName, String partitionURL) throws IOException {
        return this.getOutboundRequest(md, partitionURL);
    }

    @Override
    @Deprecated
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionURL) throws IOException {
        OIDManager.getInstance().getServerReference(this.getObjectID());
        ServerRequest request = new ServerRequest(this.sor, md, partitionURL);
        request.setActivationID(this.aid);
        return request;
    }

    public Object writeReplace() throws ObjectStreamException {
        OIDManager.getInstance().ensureExported(this.sor);
        return this.sor.getActivatableRef(this.getActivationID());
    }
}

