/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.common.internal.CodeBaseInfo;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ServerURL;
import weblogic.rjvm.ProxyManager;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.ActivatableRemoteReference;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.extensions.server.CollocatedRemoteReference;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.facades.RmiInvocationFacade;
import weblogic.rmi.internal.BasicRuntimeDescriptor;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.rmi.internal.ClientMethodDescriptor;
import weblogic.rmi.internal.ClientRuntimeDescriptor;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.MethodDescriptor;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.Stub;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.reflect.MethodSignatureBuilder;

public class StubInfo
implements Serializable,
StubReference {
    private static final boolean debug = false;
    static final long serialVersionUID = 1386046997462080210L;
    private static final Class DEFAULT_STUB_BASE = Stub.class;
    private ClientRuntimeDescriptor desc;
    private RemoteReference ref;
    private String stubName;
    private transient String repositoryId;
    private String stubBaseName;
    private static final transient boolean refreshClientRuntimeDescriptor = KernelStatus.isApplet() ? false : RMIEnvironment.getEnvironment().isRefreshClientRuntimeDescriptor();
    private transient int jndiSpecifiedTimeout = -1;
    private transient String providerURL;
    private transient ServerURL sURL;
    private final String partitionName;
    private static final String JNDI_RESPONSE_READ_TIMEOUT = "weblogic.jndi.responseReadTimeout";
    private static final String JNDI_RESPONSE_READ_TIMEOUT_DEPRECATED = "weblogic.rmi.clientTimeout";
    private static final String JNDI_PROVIDER_URL = "java.naming.provider.url";
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ComponentInvocationContextManager CICM = null;

    public StubInfo(RemoteReference ref, ClientRuntimeDescriptor crd, String stubName) {
        this(ref, crd, stubName, null);
    }

    public StubInfo(RemoteReference ref, ClientRuntimeDescriptor crd, String stubName, String stubBaseName) {
        this(ref, crd, stubName, stubBaseName, null, KernelStatus.isServer() ? RmiInvocationFacade.getCurrentPartitionName(KERNEL_ID) : "DOMAIN");
    }

    public StubInfo(RemoteReference ref, ClientRuntimeDescriptor crd, String stubName, String stubBaseName, String providerURL, String partitionName) {
        if (partitionName == null && providerURL == null) {
            throw new IllegalStateException("Can't have both pName && pURL as NULL");
        }
        if (partitionName != null && providerURL != null) {
            throw new IllegalStateException("Can't have both pName && pURL as NON-NULL; Remove pURL");
        }
        this.ref = ref;
        this.checkRef();
        this.desc = crd == null ? null : crd.intern();
        this.stubName = stubName;
        this.stubBaseName = stubBaseName;
        this.partitionName = partitionName;
        this.providerURL = providerURL;
    }

    StubInfo(StubInfo stubInfo) {
        this.ref = stubInfo.ref;
        this.checkRef();
        this.desc = stubInfo.desc;
        this.stubName = stubInfo.stubName;
        this.stubBaseName = stubInfo.stubBaseName;
        this.repositoryId = stubInfo.repositoryId;
        this.partitionName = stubInfo.getPartitionName();
        this.providerURL = stubInfo.providerURL;
    }

    public Class[] getInterfaces() {
        return this.desc.getInterfaces();
    }

    public ClassLoader getClassLoader() {
        return this.desc.getClassLoader();
    }

    public Map<String, ClientMethodDescriptor> getDescriptorBySignature() {
        return this.desc.getDescriptorBySignature();
    }

    public ClientMethodDescriptor getDefaultClientMethodDescriptor() {
        return this.desc.getDefaultClientMethodDescriptor();
    }

    @Override
    public String getStubName() {
        if (this.stubName == null) {
            this.stubName = this.desc.getInterfaceNames()[0] + "_WLStub";
        }
        return this.stubName;
    }

    @Override
    public String getStubBaseClassName() {
        if (this.stubBaseName == null) {
            return DEFAULT_STUB_BASE.getName();
        }
        return this.stubBaseName;
    }

    @Override
    public RemoteReference getRemoteRef() {
        return this.ref;
    }

    public int getTimeOut(Method method) {
        String signature = MethodSignatureBuilder.compute(method);
        return this.getTimeOut(signature);
    }

    public int getTimeOut(String signature) {
        ClientMethodDescriptor cmd;
        int timeout = 0;
        Map<String, ClientMethodDescriptor> mdMap = this.getDescriptorBySignature();
        if (mdMap != null && (cmd = mdMap.get(signature)) != null) {
            timeout = cmd.getTimeOut();
        }
        if (timeout > 0) {
            return timeout;
        }
        if (timeout == 0) {
            timeout = this.getJndiSpecifiedTimeout();
            if (timeout > 0) {
                return timeout;
            }
            ClientMethodDescriptor defaultCMD = this.getDefaultClientMethodDescriptor();
            if (defaultCMD != null) {
                timeout = defaultCMD.getTimeOut();
            }
        }
        return timeout;
    }

    public String getRemoteExceptionWrapperClassName(Method method) {
        String signature;
        ClientMethodDescriptor cmd;
        String exceptionWrapperClassName = null;
        Map<String, ClientMethodDescriptor> mdMap = this.getDescriptorBySignature();
        if (mdMap != null && (cmd = mdMap.get(signature = MethodSignatureBuilder.compute(method))) != null) {
            exceptionWrapperClassName = cmd.getRemoteExceptionWrapperClassName();
        }
        return exceptionWrapperClassName;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getApplicationName() {
        return this.desc.getApplicationName();
    }

    public String[] getInterfaceNames() {
        return this.desc.getInterfaceNames();
    }

    public MethodDescriptor describe(Method m) {
        return this.desc.describe(m);
    }

    public void setRemoteRef(RemoteReference ref) {
        this.ref = ref;
        this.checkRef();
    }

    private void checkRef() {
        if (this.ref == null) {
            throw new AssertionError((Object)"StubInfo with null reference");
        }
        if (this.ref.getHostID() == null) {
            throw new AssertionError((Object)("StubInfo reference has no HostID: " + this.ref.getClass().getName() + ": " + this.ref));
        }
    }

    @Override
    public ClientRuntimeDescriptor getDescriptor() {
        return this.desc;
    }

    public String toString() {
        return this.ref.toString();
    }

    public StubInfo getReplaceableInfo() {
        return new ReplaceableStubInfo(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Hashtable props;
        in.defaultReadObject();
        String url = null;
        if (in instanceof CodeBaseInfo) {
            url = ((CodeBaseInfo)((Object)in)).getCodebase();
        }
        if (this.stubName == null) {
            this.stubName = this.desc.getInterfaceNames()[0] + "_WLStub";
        }
        if (this.desc != null) {
            this.desc.setStubName(this.stubName);
            this.desc.setCodebase(url);
            this.desc = this.desc.intern();
        }
        this.checkRef();
        this.setEnvQueriedJNDITimeout();
        if (!(this.ref instanceof CollocatedRemoteReference) && (props = RMIEnvironment.getEnvironment().getFromThreadLocalMap()) != null) {
            this.providerURL = (String)props.get(JNDI_PROVIDER_URL);
        }
    }

    public void setEnvQueriedJNDITimeout() {
        this.setJndiSpecifiedTimeout(this.getEnvQueriedJNDITimeout());
    }

    private int getEnvQueriedJNDITimeout() {
        int timeout = 0;
        Hashtable props = RMIEnvironment.getEnvironment().getFromThreadLocalMap();
        if (props == null) {
            return timeout;
        }
        Object o = props.get(JNDI_RESPONSE_READ_TIMEOUT);
        if (o == null) {
            o = props.get(JNDI_RESPONSE_READ_TIMEOUT_DEPRECATED);
        }
        if (o != null) {
            timeout = o instanceof String ? Integer.parseInt((String)o) : ((Long)o).intValue();
        }
        return timeout;
    }

    private Object readResolve() throws IOException {
        return KernelStatus.isApplet() ? this.loadStub() : this.resolveObject();
    }

    private Object loadStub() {
        Class stubClass;
        block6: {
            try {
                stubClass = Class.forName(this.stubName);
            }
            catch (LinkageError le) {
                stubClass = this.loadStubClassWithLocalVer();
                if (stubClass == null) {
                    throw le;
                }
            }
            catch (ClassNotFoundException cnfe) {
                stubClass = this.loadStubClassWithLocalVer();
                if (stubClass != null) break block6;
                throw new AssertionError((Object)cnfe);
            }
        }
        try {
            Constructor con = stubClass.getConstructor(StubInfo.class);
            return con.newInstance(this);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private Class loadStubClassWithLocalVer() {
        String newName;
        if (!this.stubName.endsWith(ServerHelper.getWlsStubVersion()) && (newName = this.getStubNameWithLocalVer(this.stubName)) != null) {
            this.stubName = newName;
            if (this.desc != null) {
                this.desc.setStubName(newName);
                this.desc = this.desc.intern();
            }
            try {
                return Class.forName(newName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError((Object)cnfe);
            }
        }
        return null;
    }

    private String getStubNameWithLocalVer(String name) {
        try {
            Matcher matcher = Pattern.compile("_[0-9]{3,}_WLStub$").matcher(name);
            if (matcher.find()) {
                return matcher.replaceFirst(ServerHelper.getWlsStubVersion());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Object resolveObject() throws NoSuchObjectException {
        if (!this.ref.getHostID().isLocal()) {
            return StubFactory.getStub(this);
        }
        try {
            ServerReference serverRef;
            try {
                serverRef = OIDManager.getInstance().getServerReference(this.ref.getObjectID());
            }
            catch (NoSuchObjectException e) {
                if (StubInfo.couldBeNonLocalOnNoSuchObjectException(this.partitionName)) {
                    return StubFactory.getStub(this);
                }
                throw e;
            }
            RuntimeDescriptor rtd = serverRef.getDescriptor();
            if (StubInfo.isFromDifferentApp(serverRef) || rtd.getEnableServerSideStubs()) {
                return StubFactory.getStub(this);
            }
            Object resolved = serverRef instanceof ActivatableServerReference ? ((ActivatableServerReference)serverRef).getImplementation(((ActivatableRemoteReference)this.ref).getActivationID()) : serverRef.getImplementation();
            if (rtd.getEnforceCallByValue()) {
                return CBVWrapper.getCBVWrapper(rtd, resolved);
            }
            return resolved;
        }
        catch (RemoteException nsoe) {
            throw new AssertionError((Object)nsoe);
        }
    }

    private static boolean isFromDifferentApp(ServerReference ref) {
        if (ref.getObjectID() < 256) {
            return true;
        }
        ClassLoader implCL = ref.getApplicationClassLoader();
        if (implCL == null) {
            return false;
        }
        ClassLoader callerCL = Thread.currentThread().getContextClassLoader();
        if (callerCL == ClassLoader.getSystemClassLoader() && implCL == ClassLoader.getSystemClassLoader()) {
            return false;
        }
        while (callerCL != null) {
            if (callerCL == implCL) {
                return false;
            }
            callerCL = callerCL.getParent();
        }
        return true;
    }

    void refreshClientRuntimeDescriptor(ClassLoader classLoader) {
        if (StubInfo.isRefreshEnabled()) {
            if (this.stubName == null) {
                return;
            }
            String remoteClassName = BasicRuntimeDescriptor.getRemoteClassNameFromStubName(this.stubName);
            if (remoteClassName == null) {
                return;
            }
            String descFileName = remoteClassName.replace('.', '/') + "RTD.xml";
            try {
                RuntimeDescriptor rd = DescriptorManager.createRuntimeDescriptor(classLoader.getResourceAsStream(descFileName), remoteClassName, this.getInterfaces());
                this.overrideDescriptor(rd);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    void overrideDescriptor(RuntimeDescriptor rd) {
        if (rd != null) {
            this.desc.setDefaultClientMethodDescriptor(rd.getDefaultClientMethodDescriptor());
            this.desc.setDescriptorBySignature(rd.getClientMethodDescriptors());
            this.desc.intern();
        }
    }

    private static boolean isRefreshEnabled() {
        return refreshClientRuntimeDescriptor;
    }

    public void setDefaultClientMethodDescriptor(ClientMethodDescriptor defaultMethodDescriptor) {
        this.desc.setDefaultClientMethodDescriptor(defaultMethodDescriptor);
    }

    public synchronized void setJndiSpecifiedTimeout(int timeout) {
        this.jndiSpecifiedTimeout = timeout;
    }

    public synchronized int getJndiSpecifiedTimeout() {
        if (this.jndiSpecifiedTimeout > -1) {
            return this.jndiSpecifiedTimeout;
        }
        this.jndiSpecifiedTimeout = this.getEnvQueriedJNDITimeout();
        return this.jndiSpecifiedTimeout;
    }

    public String getPartitionURL() {
        InetAddress hostInetAdd;
        URI host;
        if (this.providerURL != null && this.providerURL.indexOf(44) == -1) {
            return this.providerURL;
        }
        String hostURI = this.ref.getHostID().getHostURI().toLowerCase();
        if (hostURI.indexOf("-1", hostURI.lastIndexOf(58) + 1) != -1) {
            return this.partitionName != null ? "/?partitionName=" + this.partitionName : null;
        }
        try {
            host = new URI(hostURI);
        }
        catch (URISyntaxException e) {
            return this.partitionName != null ? "/?partitionName=" + this.partitionName : null;
        }
        if (this.sURL == null) {
            if (this.providerURL != null) {
                try {
                    this.sURL = new ServerURL(this.providerURL);
                }
                catch (MalformedURLException e) {
                    this.sURL = ServerURL.DEFAULT_CONTEXT;
                }
            } else {
                this.sURL = ServerURL.DEFAULT_CONTEXT;
            }
        }
        try {
            hostInetAdd = InetAddress.getByName(host.getHost());
        }
        catch (UnknownHostException uhe) {
            if (ProxyManager.getProxyManager().shouldUseProxy(host.getHost())) {
                return hostURI;
            }
            throw new RuntimeException(uhe);
        }
        if (this.sURL != ServerURL.DEFAULT_CONTEXT) {
            for (int i = 0; i < this.sURL.getAddressCount(); ++i) {
                if (host.getPort() != this.sURL.getPort(i)) continue;
                if (host.getHost().equals(this.sURL.getLowerCaseHost(i))) {
                    return this.sURL.getUrlString(i);
                }
                InetAddress sHost = this.sURL.getInetAddress(i);
                if (sHost == null || !hostInetAdd.equals(sHost) && (!hostInetAdd.isLoopbackAddress() || !sHost.isLoopbackAddress())) continue;
                return this.sURL.getUrlString(i);
            }
        }
        return "/?partitionName=" + (this.partitionName == null ? "DOMAIN" : this.partitionName);
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    static boolean couldBeNonLocalOnNoSuchObjectException(String objPartitionName) {
        String thrPartitionName;
        if (CICM == null) {
            return false;
        }
        if (!StubInfo.isValidNonGlobalPartitionName(objPartitionName)) {
            return false;
        }
        ComponentInvocationContext cic = CICM.getCurrentComponentInvocationContext();
        String string = thrPartitionName = cic == null ? null : cic.getPartitionName();
        if (!StubInfo.isValidNonGlobalPartitionName(thrPartitionName)) {
            return false;
        }
        return thrPartitionName.equals(objPartitionName);
    }

    static boolean isValidNonGlobalPartitionName(String pname) {
        return pname != null && !pname.equals("") && !pname.equals("~") && !pname.equals("DOMAIN");
    }

    static {
        if (KernelStatus.isServer()) {
            try {
                CICM = ComponentInvocationContextManager.getInstance(KERNEL_ID);
            }
            catch (Throwable t) {
                CICM = null;
            }
        } else {
            CICM = null;
        }
    }

    private class ReplaceableStubInfo
    extends StubInfo
    implements InteropWriteReplaceable {
        static final long serialVersionUID = -9072149440278394014L;
        private StubInfo originalInfo;

        private ReplaceableStubInfo(StubInfo info) {
            super(info);
            this.originalInfo = info;
        }

        @Override
        public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
            if (this.getRemoteRef().getHostID().isLocal()) {
                try {
                    Object newobj;
                    ServerReference serverRef = OIDManager.getInstance().getServerReference(this.getRemoteRef().getObjectID());
                    Object obj = serverRef.getImplementation();
                    if (obj instanceof InteropWriteReplaceable && (newobj = ((InteropWriteReplaceable)obj).interopWriteReplace(peerInfo)) != obj) {
                        obj = RemoteObjectReplacer.getReplacer().replaceObject(newobj);
                        if (!(obj instanceof StubInfo)) {
                            throw new IllegalArgumentException("StubInfo was no longer Remote after interopWriteReplace()");
                        }
                        StubInfo info = (StubInfo)obj;
                        info.getDescriptor().intern();
                        return info;
                    }
                }
                catch (NoSuchObjectException e) {
                    throw new AssertionError((Object)e);
                }
            }
            throw new AssertionError((Object)"ReplaceableStubInfo must always be local");
        }

        public Object writeReplace() throws ObjectStreamException {
            return this.originalInfo;
        }
    }
}

