/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.Context;
import weblogic.rmi.extensions.server.ClusterAwareRemoteReference;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.Debug;

public final class RedeployableRef
implements RemoteReference {
    private RemoteReference delegate;
    private transient boolean DEBUG = false;
    private Context context = null;
    private String jndiName = null;

    public void setContext(Context context) {
        this.context = context;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public RedeployableRef(RemoteReference ref, Context context, String jndiName) {
        this.delegate = ref instanceof ClusterAwareRemoteReference ? ((ClusterAwareRemoteReference)ref).getPrimaryRef() : ref;
        this.context = context;
        this.jndiName = jndiName;
    }

    @Override
    public Object invoke(Remote stub, RuntimeMethodDescriptor md, Object[] params, Method m) throws Throwable {
        try {
            return this.delegate.invoke(stub, md, params, m);
        }
        catch (RemoteException re) {
            RemoteReference ref;
            if (this.DEBUG) {
                Debug.say("--- redeployable --- got exception during invoke " + re);
            }
            if ((ref = this.getFailOverRef()) != null) {
                this.delegate = ref;
                if (this.DEBUG) {
                    Debug.say("--- redeployable --- Retrying with new delegate " + this.delegate);
                }
                return this.delegate.invoke(stub, md, params, m);
            }
            throw re;
        }
    }

    @Override
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionName, String partitionURL) throws IOException {
        return this.delegate.getOutboundRequest(md, partitionName, partitionURL);
    }

    @Override
    @Deprecated
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionURL) throws IOException {
        return this.delegate.getOutboundRequest(md, partitionURL);
    }

    private RemoteReference getFailOverRef() {
        if (this.context != null && this.jndiName != null) {
            try {
                Object obj = this.context.lookup(this.jndiName);
                if (this.DEBUG) {
                    Debug.say("--- redeployable --- looked up new object " + obj);
                }
                if (obj == null) {
                    return null;
                }
                Object stubInfo = RemoteObjectReplacer.getReplacer().replaceObject(obj);
                if (this.DEBUG) {
                    Debug.say("--- redeployable --- Got failover stubinfo " + stubInfo);
                }
                return ((StubInfo)stubInfo).getRemoteRef();
            }
            catch (Throwable th) {
                return null;
            }
        }
        return null;
    }

    @Override
    public int getObjectID() {
        return this.delegate.getObjectID();
    }

    @Override
    public HostID getHostID() {
        return this.delegate.getHostID();
    }

    @Override
    public Channel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public String getCodebase() {
        return this.delegate.getCodebase();
    }

    @Override
    public void setRequestTimedOut(boolean flag) {
    }

    @Override
    public boolean hasRequestTimedOut() {
        return false;
    }
}

