/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import weblogic.rmi.annotation.LoadAlgorithmType;
import weblogic.rmi.annotation.Rmi;
import weblogic.rmi.annotation.RmiMethod;
import weblogic.rmi.annotation.internal.DgcPolicy;
import weblogic.rmi.annotation.internal.DispatchContext;
import weblogic.rmi.annotation.internal.RmiInternal;
import weblogic.rmi.annotation.internal.RmiMethodInternal;
import weblogic.rmi.annotation.internal.Security;
import weblogic.rmi.internal.DescriptorConstants;
import weblogic.utils.collections.ArrayMap;
import weblogic.utils.reflect.MethodSignatureBuilder;

public class RMIAnnotationProcessor
implements DescriptorConstants {
    private static final Map<LoadAlgorithmType, String> loadAlgorithms = new HashMap<LoadAlgorithmType, String>();
    private static final Map<Security, String> securityOptions = new HashMap<Security, String>();
    private static final Map<DgcPolicy, String> dgcPolicies = new HashMap<DgcPolicy, String>();
    private static final Map<DispatchContext, String> dispatchContexts = new HashMap<DispatchContext, String>();

    static ArrayMap getDescriptorAsMap(Class<?> c) throws IOException {
        RmiInternal rmiInternal = c.getAnnotation(RmiInternal.class);
        if (rmiInternal != null) {
            if (!RMIAnnotationProcessor.checkValidRemoteInterfaces(c, rmiInternal.remoteInterfaces())) {
                throw new IOException(c + " doesnt implement all interfaces as specified in the remoteInterfaces annotation");
            }
            return RMIAnnotationProcessor.processRMIInternalAnnotation(rmiInternal, c);
        }
        Rmi rmi = c.getAnnotation(Rmi.class);
        if (rmi != null) {
            if (!RMIAnnotationProcessor.checkValidRemoteInterfaces(c, rmi.remoteInterfaces())) {
                throw new IOException(c + " does not implement all interfaces as specified in the remoteInterfaces annotation");
            }
            return RMIAnnotationProcessor.processRMIAnnotation(rmi, c);
        }
        return null;
    }

    private static ArrayMap processRMIInternalAnnotation(RmiInternal rmiInternal, Class<?> c) throws IOException {
        ArrayMap<String, String> rmiDescriptorMap = new ArrayMap<String, String>();
        rmiDescriptorMap.put("name", c.getName());
        if (rmiInternal.useServerSideStubs()) {
            rmiDescriptorMap.put("use-server-side-stubs", Boolean.toString(rmiInternal.useServerSideStubs()));
        }
        if (!rmiInternal.enableCallByReference()) {
            rmiDescriptorMap.put("enable-call-by-reference", Boolean.toString(rmiInternal.enableCallByReference()));
        }
        if (!rmiInternal.remoteRefClassname().equals("")) {
            rmiDescriptorMap.put("remote-ref-classname", rmiInternal.remoteRefClassname());
        }
        if (!rmiInternal.serverRefClassname().equals("")) {
            rmiDescriptorMap.put("server-ref-classname", rmiInternal.serverRefClassname());
        }
        if (rmiInternal.initialReference() > -1) {
            rmiDescriptorMap.put("initial-reference", Integer.toString(rmiInternal.initialReference()));
        }
        if (!rmiInternal.networkAccessPoint().equals("")) {
            rmiDescriptorMap.put("network-access-point", rmiInternal.networkAccessPoint());
        }
        ArrayMap<String, String> clusterDescriptorMap = new ArrayMap<String, String>();
        if (rmiInternal.clusterable()) {
            clusterDescriptorMap.put("clusterable", Boolean.toString(rmiInternal.clusterable()));
        }
        if (rmiInternal.loadAlgorithm() != LoadAlgorithmType.DEFAULT) {
            clusterDescriptorMap.put("load-algorithm", loadAlgorithms.get((Object)rmiInternal.loadAlgorithm()));
        }
        if (!rmiInternal.replicaHandlerClassname().equals("")) {
            clusterDescriptorMap.put("replica-handler-classname", rmiInternal.replicaHandlerClassname());
        }
        if (!rmiInternal.callRouterClassname().equals("")) {
            clusterDescriptorMap.put("call-router-classname", rmiInternal.callRouterClassname());
        }
        if (rmiInternal.stickToFirstServer()) {
            clusterDescriptorMap.put("stick-to-first-server", Boolean.toString(rmiInternal.stickToFirstServer()));
        }
        if (rmiInternal.propagateEnvironment()) {
            clusterDescriptorMap.put("propagate-environment", Boolean.toString(rmiInternal.propagateEnvironment()));
        }
        ArrayMap<String, String> lifecycleDescriptorMap = new ArrayMap<String, String>();
        if (rmiInternal.dgcPolicy() != DgcPolicy.DEFAULT) {
            lifecycleDescriptorMap.put("dgc-policy", dgcPolicies.get((Object)rmiInternal.dgcPolicy()));
        }
        ArrayMap<String, String> securityDescriptorMap = new ArrayMap<String, String>();
        if (rmiInternal.confidentiality() != Security.DEFAULT) {
            securityDescriptorMap.put("confidentiality", securityOptions.get((Object)rmiInternal.confidentiality()));
        }
        if (rmiInternal.integrity() != Security.DEFAULT) {
            securityDescriptorMap.put("integrity", securityOptions.get((Object)rmiInternal.integrity()));
        }
        if (rmiInternal.clientAuthentication() != Security.DEFAULT) {
            securityDescriptorMap.put("client-authentication", securityOptions.get((Object)rmiInternal.clientAuthentication()));
        }
        if (rmiInternal.clientCertAuthentication() != Security.DEFAULT) {
            securityDescriptorMap.put("client-cert-authentication", securityOptions.get((Object)rmiInternal.clientCertAuthentication()));
        }
        if (rmiInternal.identityAssertion() != Security.DEFAULT) {
            securityDescriptorMap.put("identity-assertion", securityOptions.get((Object)rmiInternal.identityAssertion()));
        }
        if (rmiInternal.statefulAuthentication()) {
            securityDescriptorMap.put("stateful-authentication", Boolean.toString(rmiInternal.statefulAuthentication()));
        }
        if (!rmiInternal.activationIdentifierClassname().equals("")) {
            lifecycleDescriptorMap.put("activation-identifier-classname", rmiInternal.activationIdentifierClassname());
        }
        if (rmiInternal.isActivatable()) {
            rmiDescriptorMap.put("remote-ref-classname", "weblogic.rmi.internal.activation.ActivatableRemoteRef");
            rmiDescriptorMap.put("server-ref-classname", "weblogic.rmi.internal.activation.ActivatableServerRef");
            lifecycleDescriptorMap.put("dgc-policy", dgcPolicies.get((Object)DgcPolicy.MANAGED));
        }
        ArrayMap rmiMethodDescriptorMap = RMIAnnotationProcessor.getRMIInternalMethodDescriptors(rmiInternal, c);
        ArrayMap<String, ArrayMap> result = new ArrayMap<String, ArrayMap>();
        if (!rmiDescriptorMap.isEmpty()) {
            result.put("rmidescriptor", rmiDescriptorMap);
        }
        if (!clusterDescriptorMap.isEmpty()) {
            result.put("clusterdescriptor", clusterDescriptorMap);
        }
        if (!lifecycleDescriptorMap.isEmpty()) {
            result.put("lifecycledescriptor", lifecycleDescriptorMap);
        }
        if (!securityDescriptorMap.isEmpty()) {
            result.put("securitydescriptor", securityDescriptorMap);
        }
        if (rmiMethodDescriptorMap != null && !rmiMethodDescriptorMap.isEmpty()) {
            result.put("methoddescriptor", rmiMethodDescriptorMap);
        }
        return result;
    }

    private static ArrayMap getRMIInternalMethodDescriptors(RmiInternal rmiInternal, Class<?> c) throws IOException {
        ArrayMap globalMethodDescriptor;
        ArrayMap<String, ArrayMap> methodDescriptorMap = new ArrayMap<String, ArrayMap>();
        RmiMethodInternal classLevelAnnotation = rmiInternal.defaultRMIMethodParams();
        if (classLevelAnnotation != null && (globalMethodDescriptor = RMIAnnotationProcessor.processRMIMethodInternalAnnotation(classLevelAnnotation, c)) != null) {
            String key = MethodSignatureBuilder.compute("*");
            methodDescriptorMap.put(key, globalMethodDescriptor);
        }
        for (Method m : c.getMethods()) {
            ArrayMap methodDescriptor;
            RmiMethodInternal methodAnnotation = m.getAnnotation(RmiMethodInternal.class);
            if (methodAnnotation == null || (methodDescriptor = RMIAnnotationProcessor.processRMIMethodInternalAnnotation(methodAnnotation, c)) == null) continue;
            String key = MethodSignatureBuilder.compute(m);
            methodDescriptorMap.put(key, methodDescriptor);
        }
        return methodDescriptorMap;
    }

    private static ArrayMap processRMIMethodInternalAnnotation(RmiMethodInternal rmiMethodInternal, Class<?> c) throws IOException {
        Class remoteExceptionWrapper;
        boolean async;
        String dispatchPolicy;
        ArrayMap<String, String> methodDescriptor = new ArrayMap<String, String>();
        if (rmiMethodInternal.future()) {
            methodDescriptor.put("future", Boolean.toString(rmiMethodInternal.future()));
        }
        if ((dispatchPolicy = rmiMethodInternal.dispatchPolicy()) != null && dispatchPolicy.length() > 0) {
            methodDescriptor.put("dispatch-policy", rmiMethodInternal.dispatchPolicy());
        }
        if (rmiMethodInternal.dispatchContext() != DispatchContext.NONE) {
            methodDescriptor.put("dispatch-context", dispatchContexts.get((Object)rmiMethodInternal.dispatchContext()));
        }
        if (!rmiMethodInternal.transactional()) {
            methodDescriptor.put("transactional", Boolean.toString(rmiMethodInternal.transactional()));
        }
        if (rmiMethodInternal.requiresTransaction()) {
            methodDescriptor.put("requires-transaction", Boolean.toString(rmiMethodInternal.requiresTransaction()));
        }
        if (rmiMethodInternal.oneway()) {
            methodDescriptor.put("oneway", Boolean.toString(rmiMethodInternal.oneway()));
        }
        if (async = rmiMethodInternal.asynchronousResult()) {
            methodDescriptor.put("asynchronous", Boolean.toString(async));
        }
        if (rmiMethodInternal.onewayTransactionalRequest()) {
            methodDescriptor.put("oneway-transactional-request", Boolean.toString(rmiMethodInternal.onewayTransactionalRequest()));
        }
        if (rmiMethodInternal.onewayTransactionalResponse()) {
            methodDescriptor.put("oneway-transactional-response", Boolean.toString(rmiMethodInternal.onewayTransactionalResponse()));
        }
        if (rmiMethodInternal.timeout() > 0) {
            methodDescriptor.put("timeout", Integer.toString(rmiMethodInternal.timeout()));
        }
        if (rmiMethodInternal.idempotent()) {
            methodDescriptor.put("idempotent", Boolean.toString(rmiMethodInternal.idempotent()));
        }
        if ((remoteExceptionWrapper = rmiMethodInternal.remoteExceptionWrapper()) != null && remoteExceptionWrapper != Exception.class) {
            if (!RMIAnnotationProcessor.checkValidRemoteExceptionWrapperClass(remoteExceptionWrapper)) {
                throw new IOException("remoteExceptionWrapper " + remoteExceptionWrapper + " must be a RuntimeException in " + c);
            }
            methodDescriptor.put("remote-exception-wrapper-classname", rmiMethodInternal.remoteExceptionWrapper().getName());
        }
        if (methodDescriptor.keySet().size() > 0) {
            return methodDescriptor;
        }
        return null;
    }

    private static ArrayMap processRMIAnnotation(Rmi rmi, Class<?> c) throws IOException {
        ArrayMap rmiDescriptorMap = new ArrayMap();
        ArrayMap<String, String> clusterDescriptorMap = new ArrayMap<String, String>();
        if (rmi.clusterable()) {
            clusterDescriptorMap.put("clusterable", Boolean.toString(rmi.clusterable()));
        }
        if (rmi.loadAlgorithm() != LoadAlgorithmType.DEFAULT) {
            clusterDescriptorMap.put("load-algorithm", loadAlgorithms.get((Object)rmi.loadAlgorithm()));
        }
        if (!rmi.callRouterClassname().equals("")) {
            clusterDescriptorMap.put("call-router-classname", rmi.callRouterClassname());
        }
        if (rmi.stickToFirstServer()) {
            clusterDescriptorMap.put("stick-to-first-server", Boolean.toString(rmi.stickToFirstServer()));
        }
        ArrayMap lifecycleDescriptorMap = new ArrayMap();
        ArrayMap securityDescriptorMap = new ArrayMap();
        ArrayMap rmiMethodDescriptorMap = RMIAnnotationProcessor.getRMIMethodDescriptors(rmi, c);
        ArrayMap<String, ArrayMap> result = new ArrayMap<String, ArrayMap>();
        result.put("rmidescriptor", rmiDescriptorMap);
        result.put("clusterdescriptor", clusterDescriptorMap);
        result.put("lifecycledescriptor", lifecycleDescriptorMap);
        result.put("securitydescriptor", securityDescriptorMap);
        if (rmiMethodDescriptorMap != null && !rmiMethodDescriptorMap.isEmpty()) {
            result.put("methoddescriptor", rmiMethodDescriptorMap);
        }
        return result;
    }

    private static ArrayMap getRMIMethodDescriptors(Rmi rmi, Class<?> c) throws IOException {
        ArrayMap globalMethodDescriptor;
        ArrayMap<String, ArrayMap> methodDescriptorMap = new ArrayMap<String, ArrayMap>();
        RmiMethod classLevelAnnotation = rmi.defaultRMIMethodParams();
        if (classLevelAnnotation != null && (globalMethodDescriptor = RMIAnnotationProcessor.processRMIMethodAnnotation(classLevelAnnotation, c)) != null) {
            String key = MethodSignatureBuilder.compute("*");
            methodDescriptorMap.put(key, globalMethodDescriptor);
        }
        for (Method m : c.getMethods()) {
            ArrayMap methodDescriptor;
            RmiMethod methodAnnotation = m.getAnnotation(RmiMethod.class);
            if (methodAnnotation == null || (methodDescriptor = RMIAnnotationProcessor.processRMIMethodAnnotation(methodAnnotation, c)) == null) continue;
            String key = MethodSignatureBuilder.compute(m);
            methodDescriptorMap.put(key, methodDescriptor);
        }
        return methodDescriptorMap;
    }

    private static ArrayMap processRMIMethodAnnotation(RmiMethod rmiMethod, Class c) throws IOException {
        boolean async;
        ArrayMap<String, String> methodDescriptor = new ArrayMap<String, String>();
        String dispatchPolicy = rmiMethod.dispatchPolicy();
        if (dispatchPolicy != null && dispatchPolicy.length() > 0) {
            methodDescriptor.put("dispatch-policy", rmiMethod.dispatchPolicy());
        }
        methodDescriptor.put("transactional", Boolean.toString(rmiMethod.transactional()));
        if (rmiMethod.oneway()) {
            methodDescriptor.put("oneway", Boolean.toString(rmiMethod.oneway()));
        }
        if (async = rmiMethod.asynchronousResult()) {
            methodDescriptor.put("asynchronous", Boolean.toString(async));
        }
        if (rmiMethod.timeout() > 0) {
            methodDescriptor.put("timeout", Integer.toString(rmiMethod.timeout()));
        }
        if (rmiMethod.idempotent()) {
            methodDescriptor.put("idempotent", Boolean.toString(rmiMethod.idempotent()));
        }
        if (methodDescriptor.keySet().size() > 0) {
            return methodDescriptor;
        }
        return null;
    }

    private static boolean checkValidRemoteExceptionWrapperClass(Class c) {
        return RuntimeException.class.isAssignableFrom(c);
    }

    private static boolean checkValidRemoteInterfaces(Class c, Class[] remoteInterfaces) {
        if (remoteInterfaces != null && remoteInterfaces.length > 0) {
            LinkedHashSet implementedInterfaces = new LinkedHashSet();
            implementedInterfaces.addAll(RMIAnnotationProcessor.getInterfaces(c, implementedInterfaces));
            while (c.getSuperclass() != null) {
                c = c.getSuperclass();
                implementedInterfaces.addAll(RMIAnnotationProcessor.getInterfaces(c, implementedInterfaces));
            }
            for (int i = 0; i < remoteInterfaces.length; ++i) {
                if (implementedInterfaces.contains(remoteInterfaces[i])) continue;
                return false;
            }
        }
        return true;
    }

    private static Set getInterfaces(Class c, Set s) {
        Class<?>[] implementedInterfaces = c.getInterfaces();
        for (int i = 0; i < implementedInterfaces.length; ++i) {
            s.add(implementedInterfaces[i]);
            s.addAll(RMIAnnotationProcessor.getInterfaces(implementedInterfaces[i], s));
        }
        return s;
    }

    static {
        loadAlgorithms.put(LoadAlgorithmType.RANDOM, "random");
        loadAlgorithms.put(LoadAlgorithmType.ROUND_ROBIN, "round-robin");
        loadAlgorithms.put(LoadAlgorithmType.WEIGHT_BASED, "weight-based");
        loadAlgorithms.put(LoadAlgorithmType.SERVER_AFFINITY, "server-affinity");
        loadAlgorithms.put(LoadAlgorithmType.ROUND_ROBIN_AFFINITY, "round-robin-affinity");
        loadAlgorithms.put(LoadAlgorithmType.RANDOM_AFFINITY, "random-affinity");
        loadAlgorithms.put(LoadAlgorithmType.WEIGHT_BASED_AFFINITY, "weight-based-affinity");
        loadAlgorithms.put(LoadAlgorithmType.DEFAULT, "default");
        securityOptions.put(Security.NONE, "none");
        securityOptions.put(Security.SUPPORTED, "supported");
        securityOptions.put(Security.REQUIRED, "required");
        securityOptions.put(Security.CONFIG, "config");
        dgcPolicies.put(DgcPolicy.DEFAULT, "");
        dgcPolicies.put(DgcPolicy.LEASED, "leased");
        dgcPolicies.put(DgcPolicy.REFERENCE_COUNTED, "referenceCounted");
        dgcPolicies.put(DgcPolicy.MANAGED, "managed");
        dgcPolicies.put(DgcPolicy.USE_IT_OR_LOSE_IT, "useItOrLoseIt");
        dgcPolicies.put(DgcPolicy.DEACTIVATE_ON_METHOD_BOUNDARIES, "deactivateOnMethodBoundaries");
        dispatchContexts.put(DispatchContext.NONE, "none");
        dispatchContexts.put(DispatchContext.FUTURE, "future");
        dispatchContexts.put(DispatchContext.REQUEST, "request");
    }
}

