/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.rmi.MarshalException;
import java.rmi.RemoteException;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.rmi.extensions.server.HeartbeatHelper;
import weblogic.rmi.internal.Insecure;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public class HeartbeatHelperImpl
implements HeartbeatHelper,
Insecure {
    public static HeartbeatHelper getHeartbeatHelper() {
        return SingletonMaker.singleton;
    }

    @Override
    public void ping() throws RemoteException {
    }

    public void ping(FutureResponse response) throws RemoteException {
        ScheduledResponse sr = new ScheduledResponse(response);
        TimerManagerFactory factory = TimerManagerFactory.getTimerManagerFactory();
        factory.getDefaultTimerManager().schedule((TimerListener)sr, this.min(60000, RMIEnvironment.getEnvironment().getHeartbeatPeriodLength()));
    }

    private int min(int a, int b) {
        return a < b ? a : b;
    }

    private class ScheduledResponse
    implements NakedTimerListener {
        private final FutureResponse response;

        ScheduledResponse(FutureResponse response) {
            this.response = response;
        }

        @Override
        public final void timerExpired(Timer t) {
            WorkAdapter work = new WorkAdapter(){

                @Override
                public void run() {
                    try {
                        ScheduledResponse.this.response.send();
                    }
                    catch (MarshalException e) {
                        RMILogger.logHeartbeatPeerClosed();
                    }
                    catch (Exception e) {
                        ScheduledResponse.this.response.sendThrowable(e);
                    }
                }
            };
            WorkManagerFactory.getInstance().getSystem().schedule(work);
        }
    }

    private static class SingletonMaker {
        private static HeartbeatHelperImpl singleton = new HeartbeatHelperImpl();

        private SingletonMaker() {
        }
    }
}

