/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.ColocatedStream;
import weblogic.rmi.internal.CBVInput;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInput;
import weblogic.utils.io.DelegatingInputStream;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.StringInput;

public class DefaultCBVInput
extends ObjectInputStream
implements CBVInput,
StringInput,
ChunkInput,
ColocatedStream {
    private CBVInputStream cbv;
    private DelegatingInputStream delegate;
    private Replacer replacer;

    public DefaultCBVInput(CBVInputStream cbv, InputStream is) throws IOException {
        this(new DelegatingInputStream(is));
        this.cbv = cbv;
    }

    private DefaultCBVInput(DelegatingInputStream dis) throws IOException {
        super(dis);
        this.delegate = dis;
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void setDelegate(CBVInputStream cbv, InputStream in) {
        this.cbv = cbv;
        this.delegate.setDelegate(in);
    }

    @Override
    public void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (this.replacer == null) {
            return obj;
        }
        return this.replacer.resolveObject(obj);
    }

    @Override
    public String readUTF() throws IOException {
        return (String)this.cbv.readObjectSpecial();
    }

    @Override
    public String readASCII() throws IOException {
        return this.readUTF();
    }

    @Override
    public String readUTF8() throws IOException {
        return this.readUTF();
    }

    @Override
    public Chunk readChunks() throws IOException {
        return (Chunk)this.cbv.readObjectSpecial();
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException {
        return (ObjectStreamClass)this.cbv.readObjectSpecial();
    }

    public Object readImmutable() throws IOException {
        return this.cbv.readObjectSpecial();
    }
}

